# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Copulas."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _model_copula
else:
    import _model_copula

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _model_copula.delete_SwigPyIterator

    def value(self):
        return _model_copula.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _model_copula.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _model_copula.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _model_copula.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _model_copula.SwigPyIterator_equal(self, x)

    def copy(self):
        return _model_copula.SwigPyIterator_copy(self)

    def next(self):
        return _model_copula.SwigPyIterator_next(self)

    def __next__(self):
        return _model_copula.SwigPyIterator___next__(self)

    def previous(self):
        return _model_copula.SwigPyIterator_previous(self)

    def advance(self, n):
        return _model_copula.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _model_copula.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _model_copula.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _model_copula.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _model_copula.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _model_copula.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _model_copula.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _model_copula:
_model_copula.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
class DistributionImplementation(openturns.common.PersistentObject):
    r"""
    Base class for probability distributions.

    Notes
    -----
    In OpenTURNS a :class:`~openturns.Distribution` maps the concept of *probability distribution*.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.DistributionImplementation_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.DistributionImplementation___eq__(self, *args)

    def __ne__(self, *args):
        return _model_copula.DistributionImplementation___ne__(self, *args)

    def __truediv__(self, *args):
        return _model_copula.DistributionImplementation___truediv__(self, *args)
    __div__ = __truediv__



    def cos(self):
        r"""
        Transform distribution by cosine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_cos(self)

    def sin(self):
        r"""
        Transform distribution by sine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_sin(self)

    def tan(self):
        r"""
        Transform distribution by tangent function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_tan(self)

    def acos(self):
        r"""
        Transform distribution by arccosine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_acos(self)

    def asin(self):
        r"""
        Transform distribution by arcsine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_asin(self)

    def atan(self):
        r"""
        Transform distribution by arctangent function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_atan(self)

    def cosh(self):
        r"""
        Transform distribution by cosh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_cosh(self)

    def sinh(self):
        r"""
        Transform distribution by sinh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_sinh(self)

    def tanh(self):
        r"""
        Transform distribution by tanh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_tanh(self)

    def acosh(self):
        r"""
        Transform distribution by acosh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_acosh(self)

    def asinh(self):
        r"""
        Transform distribution by asinh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_asinh(self)

    def atanh(self):
        r"""
        Transform distribution by atanh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_atanh(self)

    def exp(self):
        r"""
        Transform distribution by exponential function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_exp(self)

    def log(self):
        r"""
        Transform distribution by natural logarithm function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_log(self)

    def ln(self):
        r"""
        Transform distribution by natural logarithm function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_ln(self)

    def inverse(self):
        r"""
        Transform distribution by inverse function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_inverse(self)

    def sqr(self):
        r"""
        Transform distribution by square function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_sqr(self)

    def sqrt(self):
        r"""
        Transform distribution by square root function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_sqrt(self)

    def cbrt(self):
        r"""
        Transform distribution by cubic root function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_cbrt(self)

    def abs(self):
        r"""
        Transform distribution by absolute value function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.DistributionImplementation_abs(self)

    def __repr__(self):
        return _model_copula.DistributionImplementation___repr__(self)

    def __str__(self, *args):
        return _model_copula.DistributionImplementation___str__(self, *args)

    def _repr_html_(self):
        return _model_copula.DistributionImplementation__repr_html_(self)

    def __repr_markdown__(self):
        return _model_copula.DistributionImplementation___repr_markdown__(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the distribution.

        Returns
        -------
        n : int
            The number of components in the distribution.
        """
        return _model_copula.DistributionImplementation_getDimension(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.DistributionImplementation_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.DistributionImplementation_getSample(self, size)

    def getSampleByInversion(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution based on conditional quantiles.

        See Also
        --------
        openturns.Distribution.getRealization
        openturns.RandomGenerator
        openturns.Distribution.getSample
        openturns.Distribution.getSampleByQMC
        """
        return _model_copula.DistributionImplementation_getSampleByInversion(self, size)

    def getSampleByQMC(self, size):
        r"""
        Accessor to a low discrepancy sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A low discrepancy sample of the distribution based on Sobol's sequences
            and conditional quantiles.

        See Also
        --------
        openturns.Distribution.getRealization
        openturns.RandomGenerator
        openturns.Distribution.getSample
        openturns.Distribution.getSampleByInversion
        """
        return _model_copula.DistributionImplementation_getSampleByQMC(self, size)

    def getPDF(self):
        r"""
        Return the PDF as a :class:`~openturns.Function`.

        Returns
        -------
        PDF : :class:`~openturns.Function`
            The PDF of the distribution as a :class:`~openturns.Function` wrapping a copy of the distribution.
        """
        return _model_copula.DistributionImplementation_getPDF(self)

    def getLogPDF(self):
        r"""
        Return the logarithm of the PDF as a :class:`~openturns.Function`.

        Returns
        -------
        logPDF : :class:`~openturns.Function`
            The logarithm of the PDF of the distribution as a :class:`~openturns.Function` wrapping a copy of the distribution.
        """
        return _model_copula.DistributionImplementation_getLogPDF(self)

    def getCDF(self):
        r"""
        Return the CDF as a :class:`~openturns.Function`.

        Returns
        -------
        CDF : :class:`~openturns.FunctionImplementation`
            The CDF of the distribution as a :class:`~openturns.Function` wrapping a copy of the distribution.
        """
        return _model_copula.DistributionImplementation_getCDF(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.DistributionImplementation_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.DistributionImplementation_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _model_copula.DistributionImplementation_computeLogPDF(self, *args)

    def computeInverseSurvivalFunction(self, point):
        r"""
        Compute the inverse survival function.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            Value of the survival function.

        Returns
        -------
        x : :class:`~openturns.Point`
            Point :math:`\vect{x}` such that :math:`S_{\vect{X}}(\vect{x}) = p` with iso-quantile components.

        Notes
        -----
        Among the points :math:`\vect{x}` that satisfy :math:`S_{\vect{X}}(\vect{x}) = p`,
        the method returns the one which also satisfies
        :math:`\Prob{X_1 > x_1}   =  \dots = \Prob{X_d > x_d}`.

        See Also
        --------
        computeQuantile, computeSurvivalFunction
        """
        return _model_copula.DistributionImplementation_computeInverseSurvivalFunction(self, point)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula.DistributionImplementation_computeSurvivalFunction(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.DistributionImplementation_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _model_copula.DistributionImplementation_computeComplementaryCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula.DistributionImplementation_computeProbability(self, interval)

    def computeCharacteristicFunction(self, *args):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _model_copula.DistributionImplementation_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _model_copula.DistributionImplementation_computeLogCharacteristicFunction(self, *args)

    def computeGeneratingFunction(self, *args):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input *z*.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _model_copula.DistributionImplementation_computeGeneratingFunction(self, *args)

    def computeLogGeneratingFunction(self, *args):
        r"""
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input *z*.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _model_copula.DistributionImplementation_computeLogGeneratingFunction(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.DistributionImplementation_computeEntropy(self)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.DistributionImplementation_computePDFGradient(self, *args)

    def computeLogPDFGradient(self, *args):
        r"""
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input *x*.
        """
        return _model_copula.DistributionImplementation_computeLogPDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.DistributionImplementation_computeCDFGradient(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _model_copula.DistributionImplementation_computeScalarQuantile(self, prob, tail)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.DistributionImplementation_computeQuantile(self, *args)

    def computeMinimumVolumeInterval(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu` with density function :math:`p`. 

        The minimum volume confidence interval :math:`I^*_{\alpha}` is the Cartesian product
        :math:`I^*_{\alpha} = [a_1, b_1] \times \dots \times [a_d, b_d]` where
        :math:`[a_i, b_i]   = \argmin_{I \in \Rset \, | \, \mu_i(I) = \beta} \lambda_i(I)`
        and :math:`\mu(I^*_{\alpha})  =  \alpha` with :math:`\lambda` is the Lebesgue measure on :math:`\Rset^d`.

        This problem resorts to solving :math:`d` univariate non linear equations: for a fixed value :math:`\beta`, we find each intervals :math:`[a_i, b_i]` such that:

        .. math::
            :nowrap:

            \begin{eqnarray*}
            F_i(b_i) - F_i(a_i) & = & \beta \\
            p_i(b_i) & = & p_i(a_i)
            \end{eqnarray*}

        which consists of finding the bound :math:`a_i` such that:

        .. math::

            p_i(a_i) =  p_i(F_i^{-1}(\beta + F_i(a_i)))

        To find :math:`\beta`, we use the Brent algorithm:  :math:`\mu([\vect{a}(\beta); \vect{b}(\beta)] = g(\beta) = \alpha` with :math:`g` a non linear function.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt = paramDist.computeMinimumVolumeInterval(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula.DistributionImplementation_computeMinimumVolumeInterval(self, prob)

    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula.DistributionImplementation_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)

    def computeBilateralConfidenceInterval(self, prob):
        r"""
        Compute a bilateral confidence interval.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu` with density function :math:`p`. 

        The bilateral confidence interval :math:`I^*_{\alpha}` is the Cartesian product
        :math:`I^*_{\alpha} = [a_1, b_1] \times \dots \times [a_d, b_d]`
        such that there exists :math:`\beta \in [0,1]` which satisfies the equations :math:`a_i = F_i^{-1}((1 - \beta) / 2)` and :math:`b_i = F_i^{-1}((1 + \beta) / 2)`
        for all :math:`i` and :math:`\mu(I^*_{\alpha}) = \alpha`.

        Examples
        --------
        We consider a Normal(2) distribution with zero mean, unit standard deviation and independent components.
        We note :math:`\Phi_2` its cdf. Due to
        symetries of the distribution, the bilateral confidence interval is :math:`I^*_{\alpha} = [-a, a] \times \times [-a, a]`
        where :math:`a = \Phi^{-1}((1+\beta)/2)` where :math:`\Phi` is the marginal cdf of each component. Then :math:`\beta` is such that
        :math:`\Phi_2(I^*_{\alpha}) = \alpha`. As :math:`\Phi_2(I^*_{\alpha}) = (2\Phi(a) - 1)^2 = \beta^2`,
        then, :math:`\beta` is equal to :math:`\beta = \sqrt{\alpha} \simeq 0.9486`
        and :math:`a \simeq -1.9488`.

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> confInt = dist.computeBilateralConfidenceInterval(0.9)
        """
        return _model_copula.DistributionImplementation_computeBilateralConfidenceInterval(self, prob)

    def computeBilateralConfidenceIntervalWithMarginalProbability(self, prob):
        r"""
        Compute a bilateral confidence interval.

        Refer to :func:`computeBilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *\alpha*.
        beta : float
            The probability :math:`\beta`.

        Examples
        --------
        We consider a Normal(2) distribution with zero mean, unit standard deviation and independent components.
        We note :math:`\Phi_2` its cdf. Due to
        symetries of the distribution, the bilateral confidence interval is :math:`I^*_{\alpha} = [-a, a] \times [-a, a]`
        where :math:`a = \Phi^{-1}((1 + \beta) / 2)` where :math:`\Phi` is the marginal cdf of each 1D marginal standard Gaussian component. Then :math:`\beta` is such that
        :math:`\Phi_2(I^*_{\alpha}) = \alpha`. As :math:`\Phi_2(I^*_{\alpha}) = (2\Phi(a) - 1)^2 = \beta^2`,
        then, :math:`\beta` is equal to :math:`\beta = \sqrt{\alpha} = 0.9486`
        and :math:`a = -1.9488` with 4 significant digits.

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> confInt, beta = dist.computeBilateralConfidenceIntervalWithMarginalProbability(0.9)
        """
        return _model_copula.DistributionImplementation_computeBilateralConfidenceIntervalWithMarginalProbability(self, prob)

    def computeUnilateralConfidenceInterval(self, prob, tail=False):
        r"""
        Compute a unilateral confidence interval.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.
        tail : bool
            `True` indicates the interval is bounded by an lower value.
            `False` indicates the interval is bounded by an upper value.
            Default value is `False`.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The unilateral confidence interval of level :math:`\alpha`.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu`.

        The left unilateral confidence interval :math:`I^*_{\alpha}` is the cartesian product :math:`I^*_{\alpha} = ]-\infty, b_1] \times \dots \times ]-\infty, b_d]` where :math:`b_i = F_i^{-1}(\beta)` for all :math:`i` and which verifies :math:`\mu(I^*_{\alpha}) = \alpha`. 
        It means that :math:`\vect{b}` is the quantile of level :math:`\alpha` of the measure :math:`\mu`, with iso-quantile components.

        The right unilateral confidence interval :math:`I^*_{\alpha}` is the cartesian product :math:`I^*_{\alpha} = ]a_1; +\infty[ \times \dots \times ]a_d; +\infty[` where :math:`a_i = F_i^{-1}(1-\beta)` for all :math:`i` and which verifies :math:`\mu(I^*_{\alpha}) = \alpha`. 
        It means that :math:`S_{\mu}^{-1}(\vect{a}) = \alpha` with iso-quantile components, where :math:`S_{\mu}` is the survival function of the measure :math:`\mu`.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution: 

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the right unilateral confidence interval at level 0.9:

        >>> confInt = paramDist.computeUnilateralConfidenceInterval(0.9)

        Determine the left unilateral confidence interval at level 0.9:

        >>> confInt = paramDist.computeUnilateralConfidenceInterval(0.9, True)

        """
        return _model_copula.DistributionImplementation_computeUnilateralConfidenceInterval(self, prob, tail)

    def computeUnilateralConfidenceIntervalWithMarginalProbability(self, prob, tail):
        r"""
        Compute a unilateral confidence interval.

        Refer to :func:`computeUnilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.
        tail : bool
            `True` indicates the interval is bounded by an lower value.
            `False` indicates the interval is bounded by an upper value.
            Default value is `False`.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The unilateral confidence interval of level *alpha*.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution: 

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the right unilateral confidence interval at level 0.9:

        >>> confInt, marginalProb = paramDist.computeUnilateralConfidenceIntervalWithMarginalProbability(0.9, False)

        Determine the left unilateral confidence interval at level 0.9:

        >>> confInt, marginalProb = paramDist.computeUnilateralConfidenceIntervalWithMarginalProbability(0.9, True)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula.DistributionImplementation_computeUnilateralConfidenceIntervalWithMarginalProbability(self, prob, tail)

    def computeMinimumVolumeLevelSet(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu` with density function :math:`p`. 

        The minimum volume confidence domain :math:`A^*_{\alpha}` is the set of minimum volume and which measure is at least :math:`\alpha`. It is defined by:

        .. math::

            A^*_{\alpha} = \argmin_{A \in \Rset^d\, | \, \mu(A) \geq \alpha} \lambda(A)


        where :math:`\lambda` is the Lebesgue measure on :math:`\Rset^d`. Under some general conditions on :math:`\mu` (for example, no flat regions), the set  :math:`A^*_{\alpha}` is unique and realises the minimum: :math:`\mu(A^*_{\alpha}) = \alpha`. We show that :math:`A^*_{\alpha}` writes:

        .. math::

            A^*_{\alpha} = \{ \vect{x} \in \Rset^d \, | \, p(\vect{x}) \geq p_{\alpha} \}

        for a certain :math:`p_{\alpha} >0`.

        If we consider the random variable :math:`Y = p(\vect{X})`, with cumulative distribution function :math:`F_Y`, then :math:`p_{\alpha}` is defined by:

        .. math::

            1-F_Y(p_{\alpha}) = \alpha


        Thus the minimum volume domain of confidence :math:`\alpha` is the interior of the domain which frontier is the :math:`1-\alpha` quantile of :math:`Y`. It can be determined with simulations of :math:`Y`.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9:

        >>> levelSet = paramDist.computeMinimumVolumeLevelSet(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula.DistributionImplementation_computeMinimumVolumeLevelSet(self, prob)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _model_copula.DistributionImplementation_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def getRange(self):
        r"""
        Accessor to the range of the distribution.

        Returns
        -------
        range : :class:`~openturns.Interval`
            Range of the distribution.

        Notes
        -----
        The *mathematical* range is the smallest closed interval outside of which the
        PDF is zero. The *numerical* range is the interval outside of which the PDF is
        rounded to zero in double precision.

        See Also
        --------
        getSupport
        """
        return _model_copula.DistributionImplementation_getRange(self)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _model_copula.DistributionImplementation_getRoughness(self)

    def getMean(self):
        r"""
        Accessor to the mean.

        Returns
        -------
        k : :class:`~openturns.Point`
            Mean.

        Notes
        -----
        The mean is the first-order moment:

        .. math::

            \vect{\mu} = \Tr{\left(\Expect{X_i}, \quad i = 1, \ldots, n\right)}
        """
        return _model_copula.DistributionImplementation_getMean(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _model_copula.DistributionImplementation_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _model_copula.DistributionImplementation_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _model_copula.DistributionImplementation_getKurtosis(self)

    def getMoment(self, n):
        r"""
        Accessor to the componentwise moments.

        Parameters
        ----------
        k : int
            The order of the moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise moment of order *k*.

        Notes
        -----
        The componentwise moment of order :math:`k` is defined as:

        .. math::

            \vect{m}^{(k)} = \Tr{\left(\Expect{X_i^k}, \quad i = 1, \ldots, d\right)}
        """
        return _model_copula.DistributionImplementation_getMoment(self, n)

    def getCentralMoment(self, n):
        r"""
        Accessor to the componentwise central moments.

        Parameters
        ----------
        k : int
            The order of the central moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise central moment of order *k*.

        Notes
        -----
        Central moments are centered with respect to the first-order moment:

        .. math::

            \vect{m}^{(k)}_0 = \Tr{\left(\Expect{\left(X_i - \mu_i\right)^k},
                                         \quad i = 1, \ldots, n\right)}

        See Also
        --------
        getMoment
        """
        return _model_copula.DistributionImplementation_getCentralMoment(self, n)

    def getShiftedMoment(self, n, shift):
        r"""
        Accessor to the componentwise shifted moments.

        Parameters
        ----------
        k : int
            The order of the shifted moment.
        shift : sequence of float
            The shift of the moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise central moment of order *k*.

        Notes
        -----
        The moments are centered with respect to the given shift :math:`\vect{s}`:

        .. math::

            \vect{m}^{(k)}_0 = \Tr{\left(\Expect{\left(X_i - s_i\right)^k},
                                         \quad i = 1, \ldots, n\right)}

        See Also
        --------
        getMoment, getCentralMoment
        """
        return _model_copula.DistributionImplementation_getShiftedMoment(self, n, shift)

    def getCovariance(self):
        r"""
        Accessor to the covariance matrix.

        Returns
        -------
        Sigma : :class:`~openturns.CovarianceMatrix`
            Covariance matrix.

        Notes
        -----
        The covariance is the second-order central moment. It is defined as:

        .. math::

            \mat{\Sigma} & = \Cov{\vect{X}} \\
                         & = \Expect{\left(\vect{X} - \vect{\mu}\right)
                                     \Tr{\left(\vect{X} - \vect{\mu}\right)}}
        """
        return _model_copula.DistributionImplementation_getCovariance(self)

    def getCorrelation(self):
        r"""
         Accessor to the correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            The correlation matrix of the distribution.

        Notes
        -----

        .. math::

           R_{ij} = \dfrac{C_{ij}}{\sigma_i\sigma_j}

        where the :math:`(\sigma_i)` are the margin standard deviations
        and :math:`(C_{ij})` the covariance coefficients.

        """
        return _model_copula.DistributionImplementation_getCorrelation(self)

    def getPearsonCorrelation(self):
        r"""
        Accessor to the Pearson correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Pearson's correlation matrix.

        See Also
        --------
        getCovariance

        Notes
        -----
        Pearson's correlation is defined as the normalized covariance matrix:

        .. math::

            \mat{\rho} & = \left[\frac{\Cov{X_i, X_j}}{\sqrt{\Var{X_i}\Var{X_j}}},
                                 \quad i,j = 1, \ldots, d\right] \\
                       & = \left[\frac{\Sigma_{i,j}}{\sqrt{\Sigma_{i,i}\Sigma_{j,j}}},
                                 \quad i,j = 1, \ldots, d\right]
        """
        return _model_copula.DistributionImplementation_getPearsonCorrelation(self)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _model_copula.DistributionImplementation_getSpearmanCorrelation(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.DistributionImplementation_getKendallTau(self)

    def getShapeMatrix(self):
        r"""
        Accessor to the shape matrix of the underlying copula if it is elliptical.

        Returns
        -------
        shape : :class:`~openturns.CorrelationMatrix`
            Shape matrix of the elliptical copula of a distribution.

        Notes
        -----
        This is not the Pearson correlation matrix.

        See Also
        --------
        getPearsonCorrelation
        """
        return _model_copula.DistributionImplementation_getShapeMatrix(self)

    def getCholesky(self):
        r"""
        Accessor to the Cholesky factor of the covariance matrix.

        Returns
        -------
        L : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix.

        See Also
        --------
        getCovariance
        """
        return _model_copula.DistributionImplementation_getCholesky(self)

    def getInverseCholesky(self):
        r"""
        Accessor to the inverse Cholesky factor of the covariance matrix.

        Returns
        -------
        Linv : :class:`~openturns.TriangularMatrix`
            Inverse Cholesky factor of the covariance matrix.

        See also
        --------
        openturns.Distribution.getCholesky
        """
        return _model_copula.DistributionImplementation_getInverseCholesky(self)

    def isCopula(self):
        r"""
        Test whether the distribution is a copula or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A copula is a distribution with uniform margins on [0; 1].
        """
        return _model_copula.DistributionImplementation_isCopula(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _model_copula.DistributionImplementation_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.DistributionImplementation_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.DistributionImplementation_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.DistributionImplementation_isIntegral(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.DistributionImplementation_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.DistributionImplementation_hasIndependentCopula(self)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _model_copula.DistributionImplementation_getSupport(self, *args)

    def getProbabilities(self):
        r"""
        Accessor to the discrete probability levels.

        Returns
        -------
        probabilities : :class:`~openturns.Point`
            The probability levels of a discrete distribution.
        """
        return _model_copula.DistributionImplementation_getProbabilities(self)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities
        (i.e. discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _model_copula.DistributionImplementation_getSingularities(self)

    def computeRadialDistributionCDF(self, radius, tail=False):
        r"""
        Compute the cumulative distribution function of the squared radius.

        For the underlying standard spherical distribution (for elliptical
        distributions only).

        Parameters
        ----------
        r2 : float, :math:`0 \leq R^2`
            Squared radius.

        Returns
        -------
        F : float
            CDF value at input *r2*.

        Notes
        -----
        This is the CDF of the sum of the squared independent, standard, identically
        distributed components:

        .. math::

            R^2 = \sqrt{\sum\limits_{i=1}^n U_i^2}
        """
        return _model_copula.DistributionImplementation_computeRadialDistributionCDF(self, radius, tail)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.DistributionImplementation_getMarginal(self, *args)

    def getCopula(self):
        r"""
        Accessor to the copula of the distribution.

        Returns
        -------
        C : :class:`~openturns.Distribution`
            Copula of the distribution.

        See Also
        --------
        openturns.JointDistribution
        """
        return _model_copula.DistributionImplementation_getCopula(self)

    def computeConditionalDDF(self, x, y):
        r"""
        Compute the conditional derivative density function of the last component.

        With respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        ddf : float,
            Conditional DDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional derivative density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d^2}{d\,x_j^2}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it reduces to :math:`\dfrac{d^2}{d\,x_1^2}F_{X_1}(x_1)`, ie the DDF of
        the first component at :math:`x_1`.

        See Also
        --------
        computeDDF, computeConditionalCDF
        """
        return _model_copula.DistributionImplementation_computeConditionalDDF(self, x, y)

    def computeSequentialConditionalDDF(self, x):
        r"""
        Compute the sequential conditional derivative density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the DDF.

        Returns
        -------
        ddf : sequence of float
            Conditional DDF values at *x*.

        Notes
        -----
        The sequential conditional derivative density function is defined by:

        .. math::

            \left(\dfrac{d^2}{d\,x_j^2}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})
            \right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d^2}{d\,x_1^2}F_{X_1}(x_1)`.
        """
        return _model_copula.DistributionImplementation_computeSequentialConditionalDDF(self, x)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _model_copula.DistributionImplementation_computeSequentialConditionalPDF(self, x)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula.DistributionImplementation_computeConditionalPDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.DistributionImplementation_computeSequentialConditionalCDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.DistributionImplementation_computeConditionalCDF(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        p : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Sequence of conditional quantiles values at *p*

        Notes
        -----
        The sequential conditional quantile function is defined by:

        .. math::

            \left(F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p_j; x_1, \dots, x_{j-1})\right)_{i=1,\ldots,d}

        where :math:`F^{-1}` is the quantile function and
        where :math:`x_1,\ldots,x_{j-1}` are defined recursively as :math:`x_1=F_1^{-1}(p_1)` and for :math:`2\leq j \leq d`,
        :math:`x_j=F_{X_j}^{-1}(p_j|X_1=x_1,\ldots,X_{j-1}=x_{j-1})`: the conditioning part is the set of already
        computed conditional quantiles.
        """
        return _model_copula.DistributionImplementation_computeSequentialConditionalQuantile(self, q)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.DistributionImplementation_computeConditionalQuantile(self, *args)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.DistributionImplementation_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.DistributionImplementation_getInverseIsoProbabilisticTransformation(self)

    def getStandardDistribution(self):
        r"""
        Accessor to the standard distribution.

        Returns
        -------
        standard_distribution : :class:`~openturns.Distribution`
            Standard distribution.

        Notes
        -----
        The standard distribution is determined according to the distribution
        properties. This is the target distribution achieved by the iso-probabilistic
        transformation.

        See Also
        --------
        getIsoProbabilisticTransformation
        """
        return _model_copula.DistributionImplementation_getStandardDistribution(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _model_copula.DistributionImplementation_getStandardRepresentative(self)

    def getIntegrationNodesNumber(self):
        r"""
        Accessor to the number of Gauss integration points.

        Returns
        -------
        N : int
            Number of integration points.
        """
        return _model_copula.DistributionImplementation_getIntegrationNodesNumber(self)

    def setIntegrationNodesNumber(self, integrationNodesNumber):
        r"""
        Accessor to the number of Gauss integration points.

        Parameters
        ----------
        N : int
            Number of integration points.
        """
        return _model_copula.DistributionImplementation_setIntegrationNodesNumber(self, integrationNodesNumber)

    def drawMarginal1DPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the probability density function of a margin.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale.
            Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the PDF of the requested margin.

        See Also
        --------
        openturns.Distribution.computePDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DPDF(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.DistributionImplementation_drawMarginal1DPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawPDF(self, *args):
        r"""
        Draw the graph or of iso-lines of probability density function.

        Available constructors:
            drawPDF(*x_min, x_max, pointNumber, logScale*)

            drawPDF(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawPDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the PDF or its iso_lines.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computePDF

        Examples
        --------
        View the PDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawPDF()
        >>> graph.setLegends(['normal pdf'])

        View the iso-lines PDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawPDF()
        >>> graph2.setLegends(['iso- normal pdf'])
        >>> graph3 = dist.drawPDF([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula.DistributionImplementation_drawPDF(self, *args)

    def drawMarginal2DPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the probability density function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the first margin of interest.
        j : int, :math:`1 \leq i \neq j \leq d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal PDF of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computePDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DPDF(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.DistributionImplementation_drawMarginal2DPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawMarginal1DLogPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the log-probability density function of a margin.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the log-PDF of the requested margin.

        See Also
        --------
        openturns.Distribution.computeLogPDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DLogPDF(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.DistributionImplementation_drawMarginal1DLogPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawLogPDF(self, *args):
        r"""
        Draw the graph or of iso-lines of log-probability density function.

        Available constructors:
            drawLogPDF(*x_min, x_max, pointNumber, logScale*)

            drawLogPDF(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawLogPDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the log-PDF or its iso_lines.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computeLogPDF
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------
        View the log-PDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawLogPDF()
        >>> graph.setLegends(['normal log-pdf'])

        View the iso-lines log-PDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawLogPDF()
        >>> graph2.setLegends(['iso- normal pdf'])
        >>> graph3 = dist.drawLogPDF([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula.DistributionImplementation_drawLogPDF(self, *args)

    def drawMarginal2DLogPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the log-probability density function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the first margin of interest.
        j : int, :math:`1 \leq i \neq j \leq d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal log-PDF of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computeLogPDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DLogPDF(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.DistributionImplementation_drawMarginal2DLogPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawCDF(self, *args):
        r"""
        Draw the cumulative distribution function.

        Available constructors:
            drawCDF(*x_min, x_max, pointNumber, logScale*)

            drawCDF(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawCDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the CDF.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computeCDF
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------
        View the CDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawCDF()
        >>> graph.setLegends(['normal cdf'])

        View the iso-lines CDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawCDF()
        >>> graph2.setLegends(['iso- normal cdf'])
        >>> graph3 = dist.drawCDF([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula.DistributionImplementation_drawCDF(self, *args)

    def drawMarginal1DCDF(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the cumulative distribution function of a margin.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the CDF of the requested margin.

        See Also
        --------
        openturns.Distribution.computeCDF
        openturns.Distribution.getMarginal
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------

        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DCDF(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.DistributionImplementation_drawMarginal1DCDF(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawMarginal2DCDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the cumulative distribution function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the first margin of interest.
        j : int, :math:`1 \leq i \neq j \leq d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal CDF of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computeCDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DCDF(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.DistributionImplementation_drawMarginal2DCDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawSurvivalFunction(self, *args):
        r"""
        Draw the cumulative distribution function.

        Available constructors:
            drawSurvivalFunction(*x_min, x_max, pointNumber, logScale*)

            drawSurvivalFunction(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawSurvivalFunction(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the SurvivalFunction.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computeSurvivalFunction

        Examples
        --------
        View the SurvivalFunction of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawSurvivalFunction()
        >>> graph.setLegends(['normal cdf'])

        View the iso-lines SurvivalFunction of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawSurvivalFunction()
        >>> graph2.setLegends(['iso- normal cdf'])
        >>> graph3 = dist.drawSurvivalFunction([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula.DistributionImplementation_drawSurvivalFunction(self, *args)

    def drawMarginal1DSurvivalFunction(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the cumulative distribution function of a margin.

        Parameters
        ----------
        i : int, :math:`0 \leq i < d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the SurvivalFunction of the requested margin.

        See Also
        --------
        openturns.Distribution.computeSurvivalFunction
        openturns.Distribution.getMarginal
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------

        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DSurvivalFunction(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.DistributionImplementation_drawMarginal1DSurvivalFunction(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawMarginal2DSurvivalFunction(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the cumulative distribution function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`0 \leq i < d`
            The index of the first margin of interest.
        j : int, :math:`0 \leq i \neq j < d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal SurvivalFunction of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computeSurvivalFunction
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DSurvivalFunction(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.DistributionImplementation_drawMarginal2DSurvivalFunction(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawQuantile(self, *args):
        r"""
        Draw the quantile function.

        Parameters
        ----------
        qmin : float, in :math:`[0,1]`
            The min value of the mesh of the x-axis.
        qmax : float, in :math:`[0,1]`
            The max value of the mesh of the x-axis.
        nPoints : int, optional
            The number of points that is used for meshing the quantile curve.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the quantile function.

        Notes
        -----
        This is implemented for univariate and bivariate distributions only.
        In the case of bivariate distributions, defined by its CDF :math:`F` and its marginals :math:`(F_1, F_2)`, the quantile of order :math:`q` is the point :math:`(F_1(u),F_2(u))` defined by

        .. math::

            F(F_1(u), F_2(u)) = q


        See Also
        --------
        openturns.Distribution.computeQuantile
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal()
        >>> graph = distribution.drawQuantile()
        >>> view = View(graph)
        >>> view.show()
        >>> distribution = ot.JointDistribution([ot.Normal(), ot.Exponential(1.0)], ot.ClaytonCopula(0.5))
        >>> graph = distribution.drawQuantile()
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.DistributionImplementation_drawQuantile(self, *args)

    def computeUpperTailDependenceMatrix(self):
        r"""
        Compute the upper tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper tail dependence matrix is :math:`(\chi^{ij})_{1 \leq i, j \leq d}` where :math:`\chi^{ij}` is
        the upper tail dependence coefficient of the bivariate distribution :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi^{ij} = \lim_{u \to 1} \chi^{ij}(u)

        where  :math:`u \mapsto \chi^{ij}(u)` is the upper tail dependence function of the bivariate distribution
        :math:`(X_i, X_j)` defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chi = copula.computeUpperTailDependenceMatrix()[1, 0]
        """
        return _model_copula.DistributionImplementation_computeUpperTailDependenceMatrix(self)

    def computeUpperExtremalDependenceMatrix(self):
        r"""
        Compute the upper extremal dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper extremal dependence matrix is :math:`(\bar{\chi}^{ij})_{1 \leq i, j \leq d}` where
        :math:`\bar{\chi}^{ij}` is the upper extremal dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \bar{\chi}^{ij} = \lim_{u \to 1} \bar{\chi}^{ij}(u)

        where  :math:`u \mapsto \bar{\chi}^{ij}(u)` is the upper extremal dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \bar{\chi}(u) = \frac{2 \log 1-u}{\log \bar{C}(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chib = copula.computeUpperExtremalDependenceMatrix()[1, 0]
        """
        return _model_copula.DistributionImplementation_computeUpperExtremalDependenceMatrix(self)

    def computeLowerTailDependenceMatrix(self):
        r"""
        Compute the lower tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower tail dependence matrix is :math:`(\chi_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\chi_L^{ij}` is the lower tail dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi_L^{ij} = \lim_{u \to 0} \chi_L^{ij}(u)

        where  :math:`u \mapsto \chi_L^{ij}(u)` is the lower tail dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiL = copula.computeLowerTailDependenceMatrix()[1, 0]
        """
        return _model_copula.DistributionImplementation_computeLowerTailDependenceMatrix(self)

    def computeLowerExtremalDependenceMatrix(self):
        r"""
        Compute the lower extremal dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower extremal dependence matrix is :math:`(\bar{\chi}_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\\bar{\chi}_L^{ij}` is the lower extremal dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \bar{\chi}_L^{ij} = \lim_{u \to 0} \bar{\chi}_L^{ij}(u)

        where  :math:`u \mapsto \bar{\chi}_L^{ij}(u)` is the lower extremal dependence function
        of the bivariate distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \bar{\chi}_L(u) = \frac{2 \log u}{\log C(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiLb = copula.computeLowerExtremalDependenceMatrix()[1, 0]
        """
        return _model_copula.DistributionImplementation_computeLowerExtremalDependenceMatrix(self)

    def drawUpperTailDependenceFunction(self):
        r"""
        Draw the upper tail dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The upper tail dependence function :math:`u \mapsto \chi(u)` is defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of the function :math:`u \mapsto \chi(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawUpperTailDependenceFunction()
        """
        return _model_copula.DistributionImplementation_drawUpperTailDependenceFunction(self)

    def drawUpperExtremalDependenceFunction(self):
        r"""
        Draw the upper extremal dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The upper extremal dependence function :math:`u \mapsto \bar{\chi}(u)` is defined by:

        .. math::

            \bar{\chi}(u) = \frac{2 \log 1-u}{\log \bar{C}(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of the function :math:`u \mapsto \bar{\chi}(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawUpperExtremalDependenceFunction()
        """
        return _model_copula.DistributionImplementation_drawUpperExtremalDependenceFunction(self)

    def drawLowerTailDependenceFunction(self):
        r"""
        Draw the lower tail dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The lower tail dependence  function :math:`u \mapsto \chi_L(u)` is defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of the function :math:`u \mapsto \chi_L(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawLowerTailDependenceFunction()
        """
        return _model_copula.DistributionImplementation_drawLowerTailDependenceFunction(self)

    def drawLowerExtremalDependenceFunction(self):
        r"""
        Draw the lower extremal dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The lower extremal dependence function :math:`u \mapsto \bar{\chi}(u)` is defined by:

        .. math::

            \bar{\chi}_L(u) = \frac{2 \log u}{\log C(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of the function :math:`u \mapsto \bar{\chi}_L(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawLowerExtremalDependenceFunction()
        """
        return _model_copula.DistributionImplementation_drawLowerExtremalDependenceFunction(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.DistributionImplementation_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.DistributionImplementation_setParametersCollection(self, *args)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.DistributionImplementation_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.DistributionImplementation_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.DistributionImplementation_getParameterDescription(self)

    def getParameterDimension(self):
        r"""
        Accessor to the number of parameters in the distribution.

        Returns
        -------
        n_parameters : int
            Number of parameters in the distribution.

        See Also
        --------
        getParametersCollection
        """
        return _model_copula.DistributionImplementation_getParameterDimension(self)

    def setDescription(self, description):
        r"""
        Accessor to the componentwise description.

        Parameters
        ----------
        description : sequence of str
            Description of the components of the distribution.
        """
        return _model_copula.DistributionImplementation_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the componentwise description.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the components of the distribution.

        See Also
        --------
        setDescription
        """
        return _model_copula.DistributionImplementation_getDescription(self)

    def getPDFEpsilon(self):
        r"""
        Accessor to the PDF computation precision.

        Returns
        -------
        PDFEpsilon : float
            PDF computation precision.
        """
        return _model_copula.DistributionImplementation_getPDFEpsilon(self)

    def getCDFEpsilon(self):
        r"""
        Accessor to the CDF computation precision.

        Returns
        -------
        CDFEpsilon : float
            CDF computation precision.
        """
        return _model_copula.DistributionImplementation_getCDFEpsilon(self)

    def getPositionIndicator(self):
        r"""
        Position indicator accessor.

        Defines a generic metric of the position. When the mean is not defined it falls
        back to the median.
        Available only for 1-d distributions.

        Returns
        -------
        position : float
            Mean or median of the distribution.
        """
        return _model_copula.DistributionImplementation_getPositionIndicator(self)

    def getDispersionIndicator(self):
        r"""
        Dispersion indicator accessor.

        Defines a generic metric of the dispersion. When the standard deviation is not
        defined it falls back to the interquartile.
        Only available for 1-d distributions.

        Returns
        -------
        dispersion : float
            Standard deviation or interquartile.
        """
        return _model_copula.DistributionImplementation_getDispersionIndicator(self)

    def setSupportEpsilon(self, epsilon):
        r"""
        Accessor to the support tolerance for discrete distributions.

        Parameters
        ----------
        epsilon : float
            The support tolerance.
        """
        return _model_copula.DistributionImplementation_setSupportEpsilon(self, epsilon)

    def getSupportEpsilon(self):
        r"""
        Accessor to the support tolerance for discrete distributions.

        Returns
        -------
        epsilon : float
            The support tolerance.
        """
        return _model_copula.DistributionImplementation_getSupportEpsilon(self)

    def __init__(self, *args):
        _model_copula.DistributionImplementation_swiginit(self, _model_copula.new_DistributionImplementation(*args))

    def __rtruediv__(self, s):
        return _model_copula.DistributionImplementation___rtruediv__(self, s)

    def __rdiv__(self, s):
        return _model_copula.DistributionImplementation___rdiv__(self, s)

    def __pow__(self, s):
        return _model_copula.DistributionImplementation___pow__(self, s)

    def __sub__(self, *args):
        return _model_copula.DistributionImplementation___sub__(self, *args)

    def __rsub__(self, s):
        return _model_copula.DistributionImplementation___rsub__(self, s)

    def __neg__(self):
        return _model_copula.DistributionImplementation___neg__(self)

    def __add__(self, *args):
        return _model_copula.DistributionImplementation___add__(self, *args)

    def __radd__(self, s):
        return _model_copula.DistributionImplementation___radd__(self, s)

    def __mul__(self, *args):
        return _model_copula.DistributionImplementation___mul__(self, *args)

    def __rmul__(self, s):
        return _model_copula.DistributionImplementation___rmul__(self, s)
    __swig_destroy__ = _model_copula.delete_DistributionImplementation

# Register DistributionImplementation in _model_copula:
_model_copula.DistributionImplementation_swigregister(DistributionImplementation)

def maximum(*args):
    return _model_copula.maximum(*args)
class _DistributionImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _model_copula._DistributionImplementationTypedInterfaceObject_swiginit(self, _model_copula.new__DistributionImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _model_copula._DistributionImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _model_copula._DistributionImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _model_copula._DistributionImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _model_copula._DistributionImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _model_copula._DistributionImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _model_copula.delete__DistributionImplementationTypedInterfaceObject

# Register _DistributionImplementationTypedInterfaceObject in _model_copula:
_model_copula._DistributionImplementationTypedInterfaceObject_swigregister(_DistributionImplementationTypedInterfaceObject)
class DistributionCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _model_copula.delete_DistributionCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _model_copula.DistributionCollection_clear(self)

    def __len__(self):
        return _model_copula.DistributionCollection___len__(self)

    def __eq__(self, rhs):
        return _model_copula.DistributionCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _model_copula.DistributionCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _model_copula.DistributionCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _model_copula.DistributionCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _model_copula.DistributionCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _model_copula.DistributionCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _model_copula.DistributionCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _model_copula.DistributionCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _model_copula.DistributionCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _model_copula.DistributionCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _model_copula.DistributionCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _model_copula.DistributionCollection_find(self, val)

    def __repr__(self):
        return _model_copula.DistributionCollection___repr__(self)

    def __str__(self, *args):
        return _model_copula.DistributionCollection___str__(self, *args)

    def __init__(self, *args):
        _model_copula.DistributionCollection_swiginit(self, _model_copula.new_DistributionCollection(*args))

# Register DistributionCollection in _model_copula:
_model_copula.DistributionCollection_swigregister(DistributionCollection)
class Distribution(_DistributionImplementationTypedInterfaceObject):
    r"""
    Base class for probability distributions.

    Notes
    -----
    In OpenTURNS a :class:`~openturns.Distribution` maps the concept of *probability distribution*.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.Distribution_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.Distribution___eq__(self, *args)

    def __ne__(self, *args):
        return _model_copula.Distribution___ne__(self, *args)

    def __truediv__(self, *args):
        return _model_copula.Distribution___truediv__(self, *args)
    __div__ = __truediv__



    def cos(self):
        r"""
        Transform distribution by cosine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_cos(self)

    def sin(self):
        r"""
        Transform distribution by sine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_sin(self)

    def tan(self):
        r"""
        Transform distribution by tangent function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_tan(self)

    def acos(self):
        r"""
        Transform distribution by arccosine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_acos(self)

    def asin(self):
        r"""
        Transform distribution by arcsine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_asin(self)

    def atan(self):
        r"""
        Transform distribution by arctangent function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_atan(self)

    def cosh(self):
        r"""
        Transform distribution by cosh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_cosh(self)

    def sinh(self):
        r"""
        Transform distribution by sinh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_sinh(self)

    def tanh(self):
        r"""
        Transform distribution by tanh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_tanh(self)

    def acosh(self):
        r"""
        Transform distribution by acosh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_acosh(self)

    def asinh(self):
        r"""
        Transform distribution by asinh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_asinh(self)

    def atanh(self):
        r"""
        Transform distribution by atanh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_atanh(self)

    def exp(self):
        r"""
        Transform distribution by exponential function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_exp(self)

    def log(self):
        r"""
        Transform distribution by natural logarithm function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_log(self)

    def ln(self):
        r"""
        Transform distribution by natural logarithm function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_ln(self)

    def inverse(self):
        r"""
        Transform distribution by inverse function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_inverse(self)

    def sqr(self):
        r"""
        Transform distribution by square function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_sqr(self)

    def sqrt(self):
        r"""
        Transform distribution by square root function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_sqrt(self)

    def cbrt(self):
        r"""
        Transform distribution by cubic root function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_cbrt(self)

    def abs(self):
        r"""
        Transform distribution by absolute value function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula.Distribution_abs(self)

    def __repr__(self):
        return _model_copula.Distribution___repr__(self)

    def __str__(self, *args):
        return _model_copula.Distribution___str__(self, *args)

    def _repr_html_(self):
        return _model_copula.Distribution__repr_html_(self)

    def __repr_markdown__(self):
        return _model_copula.Distribution___repr_markdown__(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the distribution.

        Returns
        -------
        n : int
            The number of components in the distribution.
        """
        return _model_copula.Distribution_getDimension(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.Distribution_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.Distribution_getSample(self, size)

    def getSampleByInversion(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution based on conditional quantiles.

        See Also
        --------
        openturns.Distribution.getRealization
        openturns.RandomGenerator
        openturns.Distribution.getSample
        openturns.Distribution.getSampleByQMC
        """
        return _model_copula.Distribution_getSampleByInversion(self, size)

    def getSampleByQMC(self, size):
        r"""
        Accessor to a low discrepancy sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A low discrepancy sample of the distribution based on Sobol's sequences
            and conditional quantiles.

        See Also
        --------
        openturns.Distribution.getRealization
        openturns.RandomGenerator
        openturns.Distribution.getSample
        openturns.Distribution.getSampleByInversion
        """
        return _model_copula.Distribution_getSampleByQMC(self, size)

    def getPDF(self):
        r"""
        Return the PDF as a :class:`~openturns.Function`.

        Returns
        -------
        PDF : :class:`~openturns.Function`
            The PDF of the distribution as a :class:`~openturns.Function` wrapping a copy of the distribution.
        """
        return _model_copula.Distribution_getPDF(self)

    def getLogPDF(self):
        r"""
        Return the logarithm of the PDF as a :class:`~openturns.Function`.

        Returns
        -------
        logPDF : :class:`~openturns.Function`
            The logarithm of the PDF of the distribution as a :class:`~openturns.Function` wrapping a copy of the distribution.
        """
        return _model_copula.Distribution_getLogPDF(self)

    def getCDF(self):
        r"""
        Return the CDF as a :class:`~openturns.Function`.

        Returns
        -------
        CDF : :class:`~openturns.FunctionImplementation`
            The CDF of the distribution as a :class:`~openturns.Function` wrapping a copy of the distribution.
        """
        return _model_copula.Distribution_getCDF(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.Distribution_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.Distribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _model_copula.Distribution_computeLogPDF(self, *args)

    def computeInverseSurvivalFunction(self, prob):
        r"""
        Compute the inverse survival function.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            Value of the survival function.

        Returns
        -------
        x : :class:`~openturns.Point`
            Point :math:`\vect{x}` such that :math:`S_{\vect{X}}(\vect{x}) = p` with iso-quantile components.

        Notes
        -----
        Among the points :math:`\vect{x}` that satisfy :math:`S_{\vect{X}}(\vect{x}) = p`,
        the method returns the one which also satisfies
        :math:`\Prob{X_1 > x_1}   =  \dots = \Prob{X_d > x_d}`.

        See Also
        --------
        computeQuantile, computeSurvivalFunction
        """
        return _model_copula.Distribution_computeInverseSurvivalFunction(self, prob)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula.Distribution_computeSurvivalFunction(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.Distribution_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _model_copula.Distribution_computeComplementaryCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula.Distribution_computeProbability(self, interval)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _model_copula.Distribution_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _model_copula.Distribution_computeLogCharacteristicFunction(self, x)

    def computeGeneratingFunction(self, *args):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input *z*.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _model_copula.Distribution_computeGeneratingFunction(self, *args)

    def computeLogGeneratingFunction(self, *args):
        r"""
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input *z*.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _model_copula.Distribution_computeLogGeneratingFunction(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.Distribution_computeEntropy(self)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.Distribution_computePDFGradient(self, *args)

    def computeLogPDFGradient(self, *args):
        r"""
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input *x*.
        """
        return _model_copula.Distribution_computeLogPDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.Distribution_computeCDFGradient(self, *args)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.Distribution_computeQuantile(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _model_copula.Distribution_computeScalarQuantile(self, prob, tail)

    def computeMinimumVolumeInterval(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu` with density function :math:`p`. 

        The minimum volume confidence interval :math:`I^*_{\alpha}` is the Cartesian product
        :math:`I^*_{\alpha} = [a_1, b_1] \times \dots \times [a_d, b_d]` where
        :math:`[a_i, b_i]   = \argmin_{I \in \Rset \, | \, \mu_i(I) = \beta} \lambda_i(I)`
        and :math:`\mu(I^*_{\alpha})  =  \alpha` with :math:`\lambda` is the Lebesgue measure on :math:`\Rset^d`.

        This problem resorts to solving :math:`d` univariate non linear equations: for a fixed value :math:`\beta`, we find each intervals :math:`[a_i, b_i]` such that:

        .. math::
            :nowrap:

            \begin{eqnarray*}
            F_i(b_i) - F_i(a_i) & = & \beta \\
            p_i(b_i) & = & p_i(a_i)
            \end{eqnarray*}

        which consists of finding the bound :math:`a_i` such that:

        .. math::

            p_i(a_i) =  p_i(F_i^{-1}(\beta + F_i(a_i)))

        To find :math:`\beta`, we use the Brent algorithm:  :math:`\mu([\vect{a}(\beta); \vect{b}(\beta)] = g(\beta) = \alpha` with :math:`g` a non linear function.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt = paramDist.computeMinimumVolumeInterval(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula.Distribution_computeMinimumVolumeInterval(self, prob)

    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula.Distribution_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)

    def computeBilateralConfidenceInterval(self, prob):
        r"""
        Compute a bilateral confidence interval.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu` with density function :math:`p`. 

        The bilateral confidence interval :math:`I^*_{\alpha}` is the Cartesian product
        :math:`I^*_{\alpha} = [a_1, b_1] \times \dots \times [a_d, b_d]`
        such that there exists :math:`\beta \in [0,1]` which satisfies the equations :math:`a_i = F_i^{-1}((1 - \beta) / 2)` and :math:`b_i = F_i^{-1}((1 + \beta) / 2)`
        for all :math:`i` and :math:`\mu(I^*_{\alpha}) = \alpha`.

        Examples
        --------
        We consider a Normal(2) distribution with zero mean, unit standard deviation and independent components.
        We note :math:`\Phi_2` its cdf. Due to
        symetries of the distribution, the bilateral confidence interval is :math:`I^*_{\alpha} = [-a, a] \times \times [-a, a]`
        where :math:`a = \Phi^{-1}((1+\beta)/2)` where :math:`\Phi` is the marginal cdf of each component. Then :math:`\beta` is such that
        :math:`\Phi_2(I^*_{\alpha}) = \alpha`. As :math:`\Phi_2(I^*_{\alpha}) = (2\Phi(a) - 1)^2 = \beta^2`,
        then, :math:`\beta` is equal to :math:`\beta = \sqrt{\alpha} \simeq 0.9486`
        and :math:`a \simeq -1.9488`.

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> confInt = dist.computeBilateralConfidenceInterval(0.9)
        """
        return _model_copula.Distribution_computeBilateralConfidenceInterval(self, prob)

    def computeBilateralConfidenceIntervalWithMarginalProbability(self, prob):
        r"""
        Compute a bilateral confidence interval.

        Refer to :func:`computeBilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *\alpha*.
        beta : float
            The probability :math:`\beta`.

        Examples
        --------
        We consider a Normal(2) distribution with zero mean, unit standard deviation and independent components.
        We note :math:`\Phi_2` its cdf. Due to
        symetries of the distribution, the bilateral confidence interval is :math:`I^*_{\alpha} = [-a, a] \times [-a, a]`
        where :math:`a = \Phi^{-1}((1 + \beta) / 2)` where :math:`\Phi` is the marginal cdf of each 1D marginal standard Gaussian component. Then :math:`\beta` is such that
        :math:`\Phi_2(I^*_{\alpha}) = \alpha`. As :math:`\Phi_2(I^*_{\alpha}) = (2\Phi(a) - 1)^2 = \beta^2`,
        then, :math:`\beta` is equal to :math:`\beta = \sqrt{\alpha} = 0.9486`
        and :math:`a = -1.9488` with 4 significant digits.

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> confInt, beta = dist.computeBilateralConfidenceIntervalWithMarginalProbability(0.9)
        """
        return _model_copula.Distribution_computeBilateralConfidenceIntervalWithMarginalProbability(self, prob)

    def computeUnilateralConfidenceInterval(self, prob, tail=False):
        r"""
        Compute a unilateral confidence interval.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.
        tail : bool
            `True` indicates the interval is bounded by an lower value.
            `False` indicates the interval is bounded by an upper value.
            Default value is `False`.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The unilateral confidence interval of level :math:`\alpha`.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu`.

        The left unilateral confidence interval :math:`I^*_{\alpha}` is the cartesian product :math:`I^*_{\alpha} = ]-\infty, b_1] \times \dots \times ]-\infty, b_d]` where :math:`b_i = F_i^{-1}(\beta)` for all :math:`i` and which verifies :math:`\mu(I^*_{\alpha}) = \alpha`. 
        It means that :math:`\vect{b}` is the quantile of level :math:`\alpha` of the measure :math:`\mu`, with iso-quantile components.

        The right unilateral confidence interval :math:`I^*_{\alpha}` is the cartesian product :math:`I^*_{\alpha} = ]a_1; +\infty[ \times \dots \times ]a_d; +\infty[` where :math:`a_i = F_i^{-1}(1-\beta)` for all :math:`i` and which verifies :math:`\mu(I^*_{\alpha}) = \alpha`. 
        It means that :math:`S_{\mu}^{-1}(\vect{a}) = \alpha` with iso-quantile components, where :math:`S_{\mu}` is the survival function of the measure :math:`\mu`.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution: 

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the right unilateral confidence interval at level 0.9:

        >>> confInt = paramDist.computeUnilateralConfidenceInterval(0.9)

        Determine the left unilateral confidence interval at level 0.9:

        >>> confInt = paramDist.computeUnilateralConfidenceInterval(0.9, True)

        """
        return _model_copula.Distribution_computeUnilateralConfidenceInterval(self, prob, tail)

    def computeUnilateralConfidenceIntervalWithMarginalProbability(self, prob, tail):
        r"""
        Compute a unilateral confidence interval.

        Refer to :func:`computeUnilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.
        tail : bool
            `True` indicates the interval is bounded by an lower value.
            `False` indicates the interval is bounded by an upper value.
            Default value is `False`.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The unilateral confidence interval of level *alpha*.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution: 

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the right unilateral confidence interval at level 0.9:

        >>> confInt, marginalProb = paramDist.computeUnilateralConfidenceIntervalWithMarginalProbability(0.9, False)

        Determine the left unilateral confidence interval at level 0.9:

        >>> confInt, marginalProb = paramDist.computeUnilateralConfidenceIntervalWithMarginalProbability(0.9, True)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula.Distribution_computeUnilateralConfidenceIntervalWithMarginalProbability(self, prob, tail)

    def computeMinimumVolumeLevelSet(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu` with density function :math:`p`. 

        The minimum volume confidence domain :math:`A^*_{\alpha}` is the set of minimum volume and which measure is at least :math:`\alpha`. It is defined by:

        .. math::

            A^*_{\alpha} = \argmin_{A \in \Rset^d\, | \, \mu(A) \geq \alpha} \lambda(A)


        where :math:`\lambda` is the Lebesgue measure on :math:`\Rset^d`. Under some general conditions on :math:`\mu` (for example, no flat regions), the set  :math:`A^*_{\alpha}` is unique and realises the minimum: :math:`\mu(A^*_{\alpha}) = \alpha`. We show that :math:`A^*_{\alpha}` writes:

        .. math::

            A^*_{\alpha} = \{ \vect{x} \in \Rset^d \, | \, p(\vect{x}) \geq p_{\alpha} \}

        for a certain :math:`p_{\alpha} >0`.

        If we consider the random variable :math:`Y = p(\vect{X})`, with cumulative distribution function :math:`F_Y`, then :math:`p_{\alpha}` is defined by:

        .. math::

            1-F_Y(p_{\alpha}) = \alpha


        Thus the minimum volume domain of confidence :math:`\alpha` is the interior of the domain which frontier is the :math:`1-\alpha` quantile of :math:`Y`. It can be determined with simulations of :math:`Y`.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9:

        >>> levelSet = paramDist.computeMinimumVolumeLevelSet(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula.Distribution_computeMinimumVolumeLevelSet(self, prob)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _model_copula.Distribution_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def getRange(self):
        r"""
        Accessor to the range of the distribution.

        Returns
        -------
        range : :class:`~openturns.Interval`
            Range of the distribution.

        Notes
        -----
        The *mathematical* range is the smallest closed interval outside of which the
        PDF is zero. The *numerical* range is the interval outside of which the PDF is
        rounded to zero in double precision.

        See Also
        --------
        getSupport
        """
        return _model_copula.Distribution_getRange(self)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _model_copula.Distribution_getRoughness(self)

    def getMean(self):
        r"""
        Accessor to the mean.

        Returns
        -------
        k : :class:`~openturns.Point`
            Mean.

        Notes
        -----
        The mean is the first-order moment:

        .. math::

            \vect{\mu} = \Tr{\left(\Expect{X_i}, \quad i = 1, \ldots, n\right)}
        """
        return _model_copula.Distribution_getMean(self)

    def getCovariance(self):
        r"""
        Accessor to the covariance matrix.

        Returns
        -------
        Sigma : :class:`~openturns.CovarianceMatrix`
            Covariance matrix.

        Notes
        -----
        The covariance is the second-order central moment. It is defined as:

        .. math::

            \mat{\Sigma} & = \Cov{\vect{X}} \\
                         & = \Expect{\left(\vect{X} - \vect{\mu}\right)
                                     \Tr{\left(\vect{X} - \vect{\mu}\right)}}
        """
        return _model_copula.Distribution_getCovariance(self)

    def getCholesky(self):
        r"""
        Accessor to the Cholesky factor of the covariance matrix.

        Returns
        -------
        L : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix.

        See Also
        --------
        getCovariance
        """
        return _model_copula.Distribution_getCholesky(self)

    def getMoment(self, n):
        r"""
        Accessor to the componentwise moments.

        Parameters
        ----------
        k : int
            The order of the moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise moment of order *k*.

        Notes
        -----
        The componentwise moment of order :math:`k` is defined as:

        .. math::

            \vect{m}^{(k)} = \Tr{\left(\Expect{X_i^k}, \quad i = 1, \ldots, d\right)}
        """
        return _model_copula.Distribution_getMoment(self, n)

    def getCentralMoment(self, n):
        r"""
        Accessor to the componentwise central moments.

        Parameters
        ----------
        k : int
            The order of the central moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise central moment of order *k*.

        Notes
        -----
        Central moments are centered with respect to the first-order moment:

        .. math::

            \vect{m}^{(k)}_0 = \Tr{\left(\Expect{\left(X_i - \mu_i\right)^k},
                                         \quad i = 1, \ldots, n\right)}

        See Also
        --------
        getMoment
        """
        return _model_copula.Distribution_getCentralMoment(self, n)

    def getShiftedMoment(self, n, shift):
        r"""
        Accessor to the componentwise shifted moments.

        Parameters
        ----------
        k : int
            The order of the shifted moment.
        shift : sequence of float
            The shift of the moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise central moment of order *k*.

        Notes
        -----
        The moments are centered with respect to the given shift :math:`\vect{s}`:

        .. math::

            \vect{m}^{(k)}_0 = \Tr{\left(\Expect{\left(X_i - s_i\right)^k},
                                         \quad i = 1, \ldots, n\right)}

        See Also
        --------
        getMoment, getCentralMoment
        """
        return _model_copula.Distribution_getShiftedMoment(self, n, shift)

    def getInverseCholesky(self):
        r"""
        Accessor to the inverse Cholesky factor of the covariance matrix.

        Returns
        -------
        Linv : :class:`~openturns.TriangularMatrix`
            Inverse Cholesky factor of the covariance matrix.

        See also
        --------
        openturns.Distribution.getCholesky
        """
        return _model_copula.Distribution_getInverseCholesky(self)

    def getCorrelation(self):
        r"""
         Accessor to the correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            The correlation matrix of the distribution.

        Notes
        -----

        .. math::

           R_{ij} = \dfrac{C_{ij}}{\sigma_i\sigma_j}

        where the :math:`(\sigma_i)` are the margin standard deviations
        and :math:`(C_{ij})` the covariance coefficients.

        """
        return _model_copula.Distribution_getCorrelation(self)

    def getPearsonCorrelation(self):
        r"""
        Accessor to the Pearson correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Pearson's correlation matrix.

        See Also
        --------
        getCovariance

        Notes
        -----
        Pearson's correlation is defined as the normalized covariance matrix:

        .. math::

            \mat{\rho} & = \left[\frac{\Cov{X_i, X_j}}{\sqrt{\Var{X_i}\Var{X_j}}},
                                 \quad i,j = 1, \ldots, d\right] \\
                       & = \left[\frac{\Sigma_{i,j}}{\sqrt{\Sigma_{i,i}\Sigma_{j,j}}},
                                 \quad i,j = 1, \ldots, d\right]
        """
        return _model_copula.Distribution_getPearsonCorrelation(self)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _model_copula.Distribution_getSpearmanCorrelation(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.Distribution_getKendallTau(self)

    def getShapeMatrix(self):
        r"""
        Accessor to the shape matrix of the underlying copula if it is elliptical.

        Returns
        -------
        shape : :class:`~openturns.CorrelationMatrix`
            Shape matrix of the elliptical copula of a distribution.

        Notes
        -----
        This is not the Pearson correlation matrix.

        See Also
        --------
        getPearsonCorrelation
        """
        return _model_copula.Distribution_getShapeMatrix(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _model_copula.Distribution_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _model_copula.Distribution_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _model_copula.Distribution_getKurtosis(self)

    def isCopula(self):
        r"""
        Test whether the distribution is a copula or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A copula is a distribution with uniform margins on [0; 1].
        """
        return _model_copula.Distribution_isCopula(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _model_copula.Distribution_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.Distribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.Distribution_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.Distribution_isIntegral(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.Distribution_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.Distribution_hasIndependentCopula(self)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _model_copula.Distribution_getSupport(self, *args)

    def getProbabilities(self):
        r"""
        Accessor to the discrete probability levels.

        Returns
        -------
        probabilities : :class:`~openturns.Point`
            The probability levels of a discrete distribution.
        """
        return _model_copula.Distribution_getProbabilities(self)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities
        (i.e. discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _model_copula.Distribution_getSingularities(self)

    def computeRadialDistributionCDF(self, radius, tail=False):
        r"""
        Compute the cumulative distribution function of the squared radius.

        For the underlying standard spherical distribution (for elliptical
        distributions only).

        Parameters
        ----------
        r2 : float, :math:`0 \leq R^2`
            Squared radius.

        Returns
        -------
        F : float
            CDF value at input *r2*.

        Notes
        -----
        This is the CDF of the sum of the squared independent, standard, identically
        distributed components:

        .. math::

            R^2 = \sqrt{\sum\limits_{i=1}^n U_i^2}
        """
        return _model_copula.Distribution_computeRadialDistributionCDF(self, radius, tail)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.Distribution_getMarginal(self, *args)

    def getCopula(self):
        r"""
        Accessor to the copula of the distribution.

        Returns
        -------
        C : :class:`~openturns.Distribution`
            Copula of the distribution.

        See Also
        --------
        openturns.JointDistribution
        """
        return _model_copula.Distribution_getCopula(self)

    def computeConditionalDDF(self, x, y):
        r"""
        Compute the conditional derivative density function of the last component.

        With respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        ddf : float,
            Conditional DDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional derivative density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d^2}{d\,x_j^2}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it reduces to :math:`\dfrac{d^2}{d\,x_1^2}F_{X_1}(x_1)`, ie the DDF of
        the first component at :math:`x_1`.

        See Also
        --------
        computeDDF, computeConditionalCDF
        """
        return _model_copula.Distribution_computeConditionalDDF(self, x, y)

    def computeSequentialConditionalDDF(self, x):
        r"""
        Compute the sequential conditional derivative density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the DDF.

        Returns
        -------
        ddf : sequence of float
            Conditional DDF values at *x*.

        Notes
        -----
        The sequential conditional derivative density function is defined by:

        .. math::

            \left(\dfrac{d^2}{d\,x_j^2}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})
            \right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d^2}{d\,x_1^2}F_{X_1}(x_1)`.
        """
        return _model_copula.Distribution_computeSequentialConditionalDDF(self, x)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _model_copula.Distribution_computeSequentialConditionalPDF(self, x)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula.Distribution_computeConditionalPDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.Distribution_computeSequentialConditionalCDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.Distribution_computeConditionalCDF(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        p : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Sequence of conditional quantiles values at *p*

        Notes
        -----
        The sequential conditional quantile function is defined by:

        .. math::

            \left(F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p_j; x_1, \dots, x_{j-1})\right)_{i=1,\ldots,d}

        where :math:`F^{-1}` is the quantile function and
        where :math:`x_1,\ldots,x_{j-1}` are defined recursively as :math:`x_1=F_1^{-1}(p_1)` and for :math:`2\leq j \leq d`,
        :math:`x_j=F_{X_j}^{-1}(p_j|X_1=x_1,\ldots,X_{j-1}=x_{j-1})`: the conditioning part is the set of already
        computed conditional quantiles.
        """
        return _model_copula.Distribution_computeSequentialConditionalQuantile(self, q)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.Distribution_computeConditionalQuantile(self, *args)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.Distribution_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.Distribution_getInverseIsoProbabilisticTransformation(self)

    def getStandardDistribution(self):
        r"""
        Accessor to the standard distribution.

        Returns
        -------
        standard_distribution : :class:`~openturns.Distribution`
            Standard distribution.

        Notes
        -----
        The standard distribution is determined according to the distribution
        properties. This is the target distribution achieved by the iso-probabilistic
        transformation.

        See Also
        --------
        getIsoProbabilisticTransformation
        """
        return _model_copula.Distribution_getStandardDistribution(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _model_copula.Distribution_getStandardRepresentative(self)

    def drawMarginal1DPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the probability density function of a margin.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale.
            Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the PDF of the requested margin.

        See Also
        --------
        openturns.Distribution.computePDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DPDF(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.Distribution_drawMarginal1DPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawPDF(self, *args):
        r"""
        Draw the graph or of iso-lines of probability density function.

        Available constructors:
            drawPDF(*x_min, x_max, pointNumber, logScale*)

            drawPDF(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawPDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the PDF or its iso_lines.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computePDF

        Examples
        --------
        View the PDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawPDF()
        >>> graph.setLegends(['normal pdf'])

        View the iso-lines PDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawPDF()
        >>> graph2.setLegends(['iso- normal pdf'])
        >>> graph3 = dist.drawPDF([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula.Distribution_drawPDF(self, *args)

    def drawMarginal2DPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the probability density function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the first margin of interest.
        j : int, :math:`1 \leq i \neq j \leq d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal PDF of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computePDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DPDF(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.Distribution_drawMarginal2DPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawMarginal1DLogPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the log-probability density function of a margin.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the log-PDF of the requested margin.

        See Also
        --------
        openturns.Distribution.computeLogPDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DLogPDF(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.Distribution_drawMarginal1DLogPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawLogPDF(self, *args):
        r"""
        Draw the graph or of iso-lines of log-probability density function.

        Available constructors:
            drawLogPDF(*x_min, x_max, pointNumber, logScale*)

            drawLogPDF(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawLogPDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the log-PDF or its iso_lines.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computeLogPDF
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------
        View the log-PDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawLogPDF()
        >>> graph.setLegends(['normal log-pdf'])

        View the iso-lines log-PDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawLogPDF()
        >>> graph2.setLegends(['iso- normal pdf'])
        >>> graph3 = dist.drawLogPDF([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula.Distribution_drawLogPDF(self, *args)

    def drawMarginal2DLogPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the log-probability density function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the first margin of interest.
        j : int, :math:`1 \leq i \neq j \leq d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal log-PDF of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computeLogPDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DLogPDF(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.Distribution_drawMarginal2DLogPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawCDF(self, *args):
        r"""
        Draw the cumulative distribution function.

        Available constructors:
            drawCDF(*x_min, x_max, pointNumber, logScale*)

            drawCDF(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawCDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the CDF.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computeCDF
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------
        View the CDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawCDF()
        >>> graph.setLegends(['normal cdf'])

        View the iso-lines CDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawCDF()
        >>> graph2.setLegends(['iso- normal cdf'])
        >>> graph3 = dist.drawCDF([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula.Distribution_drawCDF(self, *args)

    def drawMarginal1DCDF(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the cumulative distribution function of a margin.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the CDF of the requested margin.

        See Also
        --------
        openturns.Distribution.computeCDF
        openturns.Distribution.getMarginal
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------

        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DCDF(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.Distribution_drawMarginal1DCDF(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawMarginal2DCDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the cumulative distribution function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the first margin of interest.
        j : int, :math:`1 \leq i \neq j \leq d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal CDF of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computeCDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DCDF(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.Distribution_drawMarginal2DCDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawSurvivalFunction(self, *args):
        r"""
        Draw the cumulative distribution function.

        Available constructors:
            drawSurvivalFunction(*x_min, x_max, pointNumber, logScale*)

            drawSurvivalFunction(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawSurvivalFunction(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the SurvivalFunction.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computeSurvivalFunction

        Examples
        --------
        View the SurvivalFunction of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawSurvivalFunction()
        >>> graph.setLegends(['normal cdf'])

        View the iso-lines SurvivalFunction of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawSurvivalFunction()
        >>> graph2.setLegends(['iso- normal cdf'])
        >>> graph3 = dist.drawSurvivalFunction([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula.Distribution_drawSurvivalFunction(self, *args)

    def drawMarginal1DSurvivalFunction(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the cumulative distribution function of a margin.

        Parameters
        ----------
        i : int, :math:`0 \leq i < d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the SurvivalFunction of the requested margin.

        See Also
        --------
        openturns.Distribution.computeSurvivalFunction
        openturns.Distribution.getMarginal
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------

        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DSurvivalFunction(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.Distribution_drawMarginal1DSurvivalFunction(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawMarginal2DSurvivalFunction(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the cumulative distribution function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`0 \leq i < d`
            The index of the first margin of interest.
        j : int, :math:`0 \leq i \neq j < d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal SurvivalFunction of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computeSurvivalFunction
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DSurvivalFunction(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.Distribution_drawMarginal2DSurvivalFunction(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawQuantile(self, *args):
        r"""
        Draw the quantile function.

        Parameters
        ----------
        qmin : float, in :math:`[0,1]`
            The min value of the mesh of the x-axis.
        qmax : float, in :math:`[0,1]`
            The max value of the mesh of the x-axis.
        nPoints : int, optional
            The number of points that is used for meshing the quantile curve.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the quantile function.

        Notes
        -----
        This is implemented for univariate and bivariate distributions only.
        In the case of bivariate distributions, defined by its CDF :math:`F` and its marginals :math:`(F_1, F_2)`, the quantile of order :math:`q` is the point :math:`(F_1(u),F_2(u))` defined by

        .. math::

            F(F_1(u), F_2(u)) = q


        See Also
        --------
        openturns.Distribution.computeQuantile
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal()
        >>> graph = distribution.drawQuantile()
        >>> view = View(graph)
        >>> view.show()
        >>> distribution = ot.JointDistribution([ot.Normal(), ot.Exponential(1.0)], ot.ClaytonCopula(0.5))
        >>> graph = distribution.drawQuantile()
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula.Distribution_drawQuantile(self, *args)

    def computeUpperTailDependenceMatrix(self):
        r"""
        Compute the upper tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper tail dependence matrix is :math:`(\chi^{ij})_{1 \leq i, j \leq d}` where :math:`\chi^{ij}` is
        the upper tail dependence coefficient of the bivariate distribution :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi^{ij} = \lim_{u \to 1} \chi^{ij}(u)

        where  :math:`u \mapsto \chi^{ij}(u)` is the upper tail dependence function of the bivariate distribution
        :math:`(X_i, X_j)` defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chi = copula.computeUpperTailDependenceMatrix()[1, 0]
        """
        return _model_copula.Distribution_computeUpperTailDependenceMatrix(self)

    def computeUpperExtremalDependenceMatrix(self):
        r"""
        Compute the upper extremal dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper extremal dependence matrix is :math:`(\bar{\chi}^{ij})_{1 \leq i, j \leq d}` where
        :math:`\bar{\chi}^{ij}` is the upper extremal dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \bar{\chi}^{ij} = \lim_{u \to 1} \bar{\chi}^{ij}(u)

        where  :math:`u \mapsto \bar{\chi}^{ij}(u)` is the upper extremal dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \bar{\chi}(u) = \frac{2 \log 1-u}{\log \bar{C}(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chib = copula.computeUpperExtremalDependenceMatrix()[1, 0]
        """
        return _model_copula.Distribution_computeUpperExtremalDependenceMatrix(self)

    def computeLowerTailDependenceMatrix(self):
        r"""
        Compute the lower tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower tail dependence matrix is :math:`(\chi_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\chi_L^{ij}` is the lower tail dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi_L^{ij} = \lim_{u \to 0} \chi_L^{ij}(u)

        where  :math:`u \mapsto \chi_L^{ij}(u)` is the lower tail dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiL = copula.computeLowerTailDependenceMatrix()[1, 0]
        """
        return _model_copula.Distribution_computeLowerTailDependenceMatrix(self)

    def computeLowerExtremalDependenceMatrix(self):
        r"""
        Compute the lower extremal dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower extremal dependence matrix is :math:`(\bar{\chi}_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\\bar{\chi}_L^{ij}` is the lower extremal dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \bar{\chi}_L^{ij} = \lim_{u \to 0} \bar{\chi}_L^{ij}(u)

        where  :math:`u \mapsto \bar{\chi}_L^{ij}(u)` is the lower extremal dependence function
        of the bivariate distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \bar{\chi}_L(u) = \frac{2 \log u}{\log C(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiLb = copula.computeLowerExtremalDependenceMatrix()[1, 0]
        """
        return _model_copula.Distribution_computeLowerExtremalDependenceMatrix(self)

    def drawUpperTailDependenceFunction(self):
        r"""
        Draw the upper tail dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The upper tail dependence function :math:`u \mapsto \chi(u)` is defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of the function :math:`u \mapsto \chi(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawUpperTailDependenceFunction()
        """
        return _model_copula.Distribution_drawUpperTailDependenceFunction(self)

    def drawUpperExtremalDependenceFunction(self):
        r"""
        Draw the upper extremal dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The upper extremal dependence function :math:`u \mapsto \bar{\chi}(u)` is defined by:

        .. math::

            \bar{\chi}(u) = \frac{2 \log 1-u}{\log \bar{C}(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of the function :math:`u \mapsto \bar{\chi}(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawUpperExtremalDependenceFunction()
        """
        return _model_copula.Distribution_drawUpperExtremalDependenceFunction(self)

    def drawLowerTailDependenceFunction(self):
        r"""
        Draw the lower tail dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The lower tail dependence  function :math:`u \mapsto \chi_L(u)` is defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of the function :math:`u \mapsto \chi_L(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawLowerTailDependenceFunction()
        """
        return _model_copula.Distribution_drawLowerTailDependenceFunction(self)

    def drawLowerExtremalDependenceFunction(self):
        r"""
        Draw the lower extremal dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The lower extremal dependence function :math:`u \mapsto \bar{\chi}(u)` is defined by:

        .. math::

            \bar{\chi}_L(u) = \frac{2 \log u}{\log C(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of the function :math:`u \mapsto \bar{\chi}_L(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawLowerExtremalDependenceFunction()
        """
        return _model_copula.Distribution_drawLowerExtremalDependenceFunction(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.Distribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.Distribution_setParametersCollection(self, *args)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.Distribution_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.Distribution_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.Distribution_getParameterDescription(self)

    def getParameterDimension(self):
        r"""
        Accessor to the number of parameters in the distribution.

        Returns
        -------
        n_parameters : int
            Number of parameters in the distribution.

        See Also
        --------
        getParametersCollection
        """
        return _model_copula.Distribution_getParameterDimension(self)

    def setDescription(self, description):
        r"""
        Accessor to the componentwise description.

        Parameters
        ----------
        description : sequence of str
            Description of the components of the distribution.
        """
        return _model_copula.Distribution_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the componentwise description.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the components of the distribution.

        See Also
        --------
        setDescription
        """
        return _model_copula.Distribution_getDescription(self)

    def getPDFEpsilon(self):
        r"""
        Accessor to the PDF computation precision.

        Returns
        -------
        PDFEpsilon : float
            PDF computation precision.
        """
        return _model_copula.Distribution_getPDFEpsilon(self)

    def getCDFEpsilon(self):
        r"""
        Accessor to the CDF computation precision.

        Returns
        -------
        CDFEpsilon : float
            CDF computation precision.
        """
        return _model_copula.Distribution_getCDFEpsilon(self)

    def getPositionIndicator(self):
        r"""
        Position indicator accessor.

        Defines a generic metric of the position. When the mean is not defined it falls
        back to the median.
        Available only for 1-d distributions.

        Returns
        -------
        position : float
            Mean or median of the distribution.
        """
        return _model_copula.Distribution_getPositionIndicator(self)

    def getDispersionIndicator(self):
        r"""
        Dispersion indicator accessor.

        Defines a generic metric of the dispersion. When the standard deviation is not
        defined it falls back to the interquartile.
        Only available for 1-d distributions.

        Returns
        -------
        dispersion : float
            Standard deviation or interquartile.
        """
        return _model_copula.Distribution_getDispersionIndicator(self)

    def __init__(self, *args):
        _model_copula.Distribution_swiginit(self, _model_copula.new_Distribution(*args))

    def __add__(self, *args):
        return _model_copula.Distribution___add__(self, *args)

    def __radd__(self, s):
        return _model_copula.Distribution___radd__(self, s)

    def __sub__(self, *args):
        return _model_copula.Distribution___sub__(self, *args)

    def __rsub__(self, s):
        return _model_copula.Distribution___rsub__(self, s)

    def __neg__(self):
        return _model_copula.Distribution___neg__(self)

    def __mul__(self, *args):
        return _model_copula.Distribution___mul__(self, *args)

    def __rmul__(self, s):
        return _model_copula.Distribution___rmul__(self, s)

    def __div__(self, s):
        return _model_copula.Distribution___div__(self, s)

    def __pow__(self, s):
        return _model_copula.Distribution___pow__(self, s)

    def __rdiv__(self, s):
        return _model_copula.Distribution___rdiv__(self, s)

    def __rtruediv__(self, s):
        return _model_copula.Distribution___rtruediv__(self, s)
    __swig_destroy__ = _model_copula.delete_Distribution

# Register Distribution in _model_copula:
_model_copula.Distribution_swigregister(Distribution)

from openturns.typ import Interval
import math

class PythonDistribution:
    """
    Allow one to override Distribution from Python.

    Parameters
    ----------
    dim : positive int
        the distribution dimension

    Examples
    --------
    Not useful on its own, see the examples section on how to inherit from it.
    """
    def __init__(self, dim=0):
        """
        Constructor.
        """
        self.__dim = dim

    def __str__(self):
        return 'PythonDistribution -> #%d' % self.__dim

    def __repr__(self):
        return self.__str__()

    def getDimension(self):
        """
        Dimension accessor.
        """
        return self.__dim

    def computeCDF(self, X):
        """
        CDF accessor.
        """
        raise RuntimeError('You must define a method computeCDF(x) -> cdf, where cdf is a float')


class SciPyDistribution(PythonDistribution):
    """
    Allow one to override Distribution from a scipy distribution.

    Parameters
    ----------
    dist : a scipy.stats distribution
        The distribution to wrap

    Examples
    --------
    >>> import openturns as ot
    >>> import scipy.stats as st  # doctest: +SKIP
    >>> scipy_dist = st.johnsonsu(2.55, 2.25)  # doctest: +SKIP
    >>> distribution = ot.Distribution(ot.SciPyDistribution(scipy_dist))  # doctest: +SKIP
    >>> distribution.getRealization()  # doctest: +SKIP
    """
    def __init__(self, dist):
        super(SciPyDistribution, self).__init__(1)
        if dist.__class__.__name__ not in ('rv_frozen', 'rv_continuous_frozen', 'rv_histogram', 'rv_discrete_frozen'):
            raise TypeError('Argument is not a scipy 1D distribution')
        self._dist = dist

# compute range
        from openturns import ResourceMap
        cdf_epsilon = ResourceMap.GetAsScalar('Distribution-DefaultCDFEpsilon')
        lb, ub = dist.support()
        flb = lb != float('-inf')
        fub = ub != float('+inf')
        if not flb:
            lb = dist.ppf(cdf_epsilon)
        if not fub:
            ub = dist.ppf(0.5 + (0.5 - cdf_epsilon))
        self.__range = Interval([lb], [ub])
        self.__range.setFiniteLowerBound([int(flb)])
        self.__range.setFiniteUpperBound([int(fub)])

    def getRange(self):
        return self.__range

    def getSupport(self, interval):
# assume discrete distributions are integral
        intersection = self.getRange().intersect(interval)
        kMin = math.ceil(intersection.getLowerBound()[0])
        kMax = math.floor(intersection.getUpperBound()[0])
        return [[k] for k in range(kMin, kMax + 1)]

    def getRealization(self):
        rvs = self._dist.rvs()
        return [rvs]

    def getSample(self, size):
        rvs = self._dist.rvs(size)
        return rvs.reshape(size, 1)

    def computePDF(self, X):
        x0 = float(X[0])
        if self.isContinuous():
            pdf = self._dist.pdf(x0)
        else:
            if x0.is_integer():
                pdf = self._dist.pmf(x0)
            else:
# newer scipy pmf is a continuous function
                pdf = 0.0
        return pdf

    def computeCDF(self, X):
        cdf = self._dist.cdf(X[0])
        return cdf

    def getMean(self):
        mean = float(self._dist.stats('m'))
        return [mean]

    def getStandardDeviation(self):
        var = float(self._dist.stats('v'))
        std = var ** 0.5
        return [std]

    def getSkewness(self):
        skewness = float(self._dist.stats('s'))
        return [skewness]

    def getKurtosis(self):
        kurtosis = float(self._dist.stats('k')) + 3.0
        return [kurtosis]

    def getMoment(self, n):
        moment = self._dist.moment(n)
        return [moment]

    def isContinuous(self):
        return hasattr(self._dist.dist, 'pdf')

    def isDiscrete(self):
        return not self.isContinuous()

    def isIntegral(self):
# assume discrete distributions are integral
        return self.isDiscrete()

    def computeScalarQuantile(self, p, tail=False):
        q = self._dist.ppf(1.0 - p if tail else p)
        return q

    def computeQuantile(self, prob, tail=False):
        p = 1.0 - prob if tail else prob
        q = self._dist.ppf(p)
        return [q]

    def getParameter(self):
        return self._dist.args

    def setParameter(self, params):
        size = len(self._dist.args)
        if len(params) != size:
            raise ValueError('Parameter must be of size %d' % size)
        self._dist.args = params

    def getParameterDescription(self):
        size = len(self._dist.args)
        return ['parameter' + str(i + 1) for i in range(size)]


class ChaospyDistribution(PythonDistribution):
    """
    Allow one to override Distribution from a chaospy distribution.

    Parameters
    ----------
    dist : a chaospy distribution
        The distribution to wrap. It is currently limited to stochastically
        independent distributions as chaopy distributions doesn't implement CDF
        computation for dependencies.

    Examples
    --------
    >>> import openturns as ot
    >>> import chaospy as cp  # doctest: +SKIP
    >>> chaospy_dist = cp.J(cp.Triangular(1.0, 2.0, 3.0), cp.F(4.0, 5.0))  # doctest: +SKIP
    >>> distribution = ot.Distribution(ot.ChaospyDistribution(chaospy_dist))  # doctest: +SKIP
    >>> distribution.getRealization()  # doctest: +SKIP
    """
    def __init__(self, dist):
        super(ChaospyDistribution, self).__init__(len(dist))
        from chaospy import Iid, J, __version__
        independent = len(dist) == 1
        independent |= isinstance(dist, Iid)
        if __version__ < '4.0.0':
            from chaospy import get_dependencies
            independent |= isinstance(dist, J) and not get_dependencies(*dist)
        else:
            independent |= not dist.stochastic_dependent
        if not independent:
            raise Exception(
                "Dependent chaospy distributions doesn't implement CDF computation")
        self._dist = dist
        self.__range = Interval(dist.lower, dist.upper)

    def getRange(self):
        return self.__range

    def getRealization(self):
        rvs = self._dist.sample(1).flatten()
        return rvs

    def getSample(self, size):
        rvs = self._dist.sample(size).T
        return rvs.reshape(size, len(self._dist))

    def computePDF(self, X):
        pdf = self._dist.pdf(X)
        return pdf

    def computeCDF(self, X):
        cdf = self._dist.cdf(X)
        return cdf

    def getMean(self):
        import chaospy as cp
        mean = cp.E(self._dist).reshape([len(self._dist)])
        return mean

    def getStandardDeviation(self):
        import chaospy as cp
        std = cp.Std(self._dist).reshape([len(self._dist)])
        return std

    def getSkewness(self):
        import chaospy as cp
        skewness = cp.Skew(self._dist).reshape([len(self._dist)])
        return skewness

    def getKurtosis(self):
        import chaospy as cp
        kurtosis = cp.Kurt(self._dist).reshape([len(self._dist)]) + 3.0
        return kurtosis

    def getMoment(self, n):
        moment = self._dist.mom([n] * len(self._dist))
        return moment

    def computeScalarQuantile(self, p, tail=False):
        if len(self._dist) > 1:
            raise Exception(
                "Multivariate distribution doesn't implement scalar quantile")
        q = self._dist.inv(1 - p if tail else p)
        return float(q)

    def computeQuantile(self, prob, tail=False):
        p = 1.0 - prob if tail else prob
        q = self._dist.inv(p).flatten()
        return q

class DistributionFactoryResult(openturns.common.PersistentObject):
    r"""
    Results of distribution estimation.

    This class is the result of a distribution estimation through a
    :class:`~openturns.DistributionFactory`.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The estimated distribution.
    parameterDistribution : :class:`~openturns.Distribution`
        The distribution of the parameter.


    See also
    --------
    DistributionFactory


    Examples
    --------
    We demonstrate the method on a Beta Distribution.

    Create a sample from a Beta distribution:

    >>> import openturns as ot
    >>> sample = ot.Beta().getSample(10)
    >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

    Fit a Beta distribution and create a :class:`~openturns.DistributionFactory`: 

    >>> fittedRes = ot.BetaFactory().buildEstimator(sample)

    Get the fitted Beta distribution and its parameters:

    >>> fittedBeta =  fittedRes.getDistribution()

    Get the asymptotic parameters distribution: 

    >>> paramDist = fittedRes.getParameterDistribution()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.DistributionFactoryResult_getClassName(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the estimated distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            The estimated distribution.
        """
        return _model_copula.DistributionFactoryResult_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the estimated distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The estimated distribution.
        """
        return _model_copula.DistributionFactoryResult_getDistribution(self)

    def setParameterDistribution(self, parameterDistribution):
        r"""
        Accessor to the distribution of the parameter.

        Parameters
        ----------
        parameterDistribution : :class:`~openturns.Distribution`
            The distribution of the parameter.
        """
        return _model_copula.DistributionFactoryResult_setParameterDistribution(self, parameterDistribution)

    def getParameterDistribution(self):
        r"""
        Accessor to the distribution of the parameter.

        Returns
        -------
        parameterDistribution : :class:`~openturns.Distribution`
            The distribution of the parameter.
        """
        return _model_copula.DistributionFactoryResult_getParameterDistribution(self)

    def __repr__(self):
        return _model_copula.DistributionFactoryResult___repr__(self)

    def __init__(self, *args):
        _model_copula.DistributionFactoryResult_swiginit(self, _model_copula.new_DistributionFactoryResult(*args))
    __swig_destroy__ = _model_copula.delete_DistributionFactoryResult

# Register DistributionFactoryResult in _model_copula:
_model_copula.DistributionFactoryResult_swigregister(DistributionFactoryResult)
class DistributionParametersImplementation(openturns.common.PersistentObject):
    r"""
    Define a distribution with particular parameters.

    This class enables to create a set of non-native parameters in order to
    define distribution.

    A *DistributionParameters* object can be used through its derived classes:

    - :class:`~openturns.ArcsineMuSigma`
    - :class:`~openturns.BetaMuSigma`
    - :class:`~openturns.GammaMuSigma`
    - :class:`~openturns.GumbelMuSigma`
    - :class:`~openturns.GumbelLambdaGamma`
    - :class:`~openturns.LogNormalMuSigma`
    - :class:`~openturns.LogNormalMuSigmaOverMu`
    - :class:`~openturns.WeibullMinMuSigma`

    See also
    --------
    ParametrizedDistribution, Distribution
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.DistributionParametersImplementation_getClassName(self)

    def __repr__(self):
        return _model_copula.DistributionParametersImplementation___repr__(self)

    def __str__(self, *args):
        return _model_copula.DistributionParametersImplementation___str__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _model_copula.DistributionParametersImplementation_getDistribution(self)

    def evaluate(self):
        r"""
        Compute native parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            The native parameter values.
        """
        return _model_copula.DistributionParametersImplementation_evaluate(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _model_copula.DistributionParametersImplementation_gradient(self)

    def __call__(self, inP):
        return _model_copula.DistributionParametersImplementation___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _model_copula.DistributionParametersImplementation_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _model_copula.DistributionParametersImplementation_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _model_copula.DistributionParametersImplementation_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _model_copula.DistributionParametersImplementation_getDescription(self)

    def __init__(self, *args):
        _model_copula.DistributionParametersImplementation_swiginit(self, _model_copula.new_DistributionParametersImplementation(*args))
    __swig_destroy__ = _model_copula.delete_DistributionParametersImplementation

# Register DistributionParametersImplementation in _model_copula:
_model_copula.DistributionParametersImplementation_swigregister(DistributionParametersImplementation)
class _DistributionParametersImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _model_copula._DistributionParametersImplementationTypedInterfaceObject_swiginit(self, _model_copula.new__DistributionParametersImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _model_copula._DistributionParametersImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _model_copula._DistributionParametersImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _model_copula._DistributionParametersImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _model_copula._DistributionParametersImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _model_copula._DistributionParametersImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _model_copula.delete__DistributionParametersImplementationTypedInterfaceObject

# Register _DistributionParametersImplementationTypedInterfaceObject in _model_copula:
_model_copula._DistributionParametersImplementationTypedInterfaceObject_swigregister(_DistributionParametersImplementationTypedInterfaceObject)
class DistributionParameters(_DistributionParametersImplementationTypedInterfaceObject):
    r"""
    Define a distribution with particular parameters.

    This class enables to create a set of non-native parameters in order to
    define distribution.

    A *DistributionParameters* object can be used through its derived classes:

    - :class:`~openturns.ArcsineMuSigma`
    - :class:`~openturns.BetaMuSigma`
    - :class:`~openturns.GammaMuSigma`
    - :class:`~openturns.GumbelMuSigma`
    - :class:`~openturns.GumbelLambdaGamma`
    - :class:`~openturns.LogNormalMuSigma`
    - :class:`~openturns.LogNormalMuSigmaOverMu`
    - :class:`~openturns.WeibullMinMuSigma`

    See also
    --------
    ParametrizedDistribution, Distribution
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.DistributionParameters_getClassName(self)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _model_copula.DistributionParameters_getDistribution(self)

    def evaluate(self):
        r"""
        Compute native parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            The native parameter values.
        """
        return _model_copula.DistributionParameters_evaluate(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _model_copula.DistributionParameters_gradient(self)

    def __call__(self, inP):
        return _model_copula.DistributionParameters___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _model_copula.DistributionParameters_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _model_copula.DistributionParameters_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _model_copula.DistributionParameters_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _model_copula.DistributionParameters_getDescription(self)

    def __repr__(self):
        return _model_copula.DistributionParameters___repr__(self)

    def __str__(self, *args):
        return _model_copula.DistributionParameters___str__(self, *args)

    def __init__(self, *args):
        _model_copula.DistributionParameters_swiginit(self, _model_copula.new_DistributionParameters(*args))
    __swig_destroy__ = _model_copula.delete_DistributionParameters

# Register DistributionParameters in _model_copula:
_model_copula.DistributionParameters_swigregister(DistributionParameters)
class DistributionFactoryImplementation(openturns.common.PersistentObject):
    r"""
    Base class for probability distribution factories.

    Notes
    -----
    This class generally describes the factory mechanism of each OpenTURNS
    distribution. Refer to :ref:`parametric_estimation` for information on the specific
    estimators used for each distribution.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.DistributionFactoryImplementation_getClassName(self)

    def __repr__(self):
        return _model_copula.DistributionFactoryImplementation___repr__(self)

    def __str__(self, *args):
        return _model_copula.DistributionFactoryImplementation___str__(self, *args)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula.DistributionFactoryImplementation_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _model_copula.DistributionFactoryImplementation_buildEstimator(self, *args)

    def getBootstrapSize(self):
        r"""
        Accessor to the bootstrap size.

        Returns
        -------
        size : int
            Size of the bootstrap.
        """
        return _model_copula.DistributionFactoryImplementation_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Accessor to the bootstrap size.

        Parameters
        ----------
        size : int
            The size of the bootstrap.
        """
        return _model_copula.DistributionFactoryImplementation_setBootstrapSize(self, bootstrapSize)

    def setKnownParameter(self, values, positions):
        r"""
        Accessor to the known parameters.

        Parameters
        ----------
        values : sequence of float
            Values of known parameters.
        positions : sequence of int
            Indices of known parameters.

        Examples
        --------
        When a subset of the parameter vector is known, the other parameters only have to be estimated 
        from data. 

        In the following example, we consider a sample and want to fit 
        a :class:`~openturns.Beta` distribution.  
        We assume that the :math:`a` and :math:`b` parameters are known beforehand. 
        In this case, we set the third parameter (at index 2) to -1 
        and the fourth parameter (at index 3) to 1. 

        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Beta(2.3, 2.2, -1.0, 1.0)
        >>> sample = distribution.getSample(10)
        >>> factory = ot.BetaFactory()
        >>> # set (a,b) out of (r, t, a, b)
        >>> factory.setKnownParameter([-1.0, 1.0], [2, 3])
        >>> inf_distribution = factory.build(sample)
        """
        return _model_copula.DistributionFactoryImplementation_setKnownParameter(self, values, positions)

    def getKnownParameterValues(self):
        r"""
        Accessor to the known parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            Values of known parameters.
        """
        return _model_copula.DistributionFactoryImplementation_getKnownParameterValues(self)

    def getKnownParameterIndices(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of the known parameters.
        """
        return _model_copula.DistributionFactoryImplementation_getKnownParameterIndices(self)

    def __init__(self, *args):
        _model_copula.DistributionFactoryImplementation_swiginit(self, _model_copula.new_DistributionFactoryImplementation(*args))
    __swig_destroy__ = _model_copula.delete_DistributionFactoryImplementation

# Register DistributionFactoryImplementation in _model_copula:
_model_copula.DistributionFactoryImplementation_swigregister(DistributionFactoryImplementation)
class _DistributionFactoryImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _model_copula._DistributionFactoryImplementationTypedInterfaceObject_swiginit(self, _model_copula.new__DistributionFactoryImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _model_copula._DistributionFactoryImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _model_copula._DistributionFactoryImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _model_copula._DistributionFactoryImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _model_copula._DistributionFactoryImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _model_copula._DistributionFactoryImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _model_copula.delete__DistributionFactoryImplementationTypedInterfaceObject

# Register _DistributionFactoryImplementationTypedInterfaceObject in _model_copula:
_model_copula._DistributionFactoryImplementationTypedInterfaceObject_swigregister(_DistributionFactoryImplementationTypedInterfaceObject)
class DistributionFactoryCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _model_copula.delete_DistributionFactoryCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _model_copula.DistributionFactoryCollection_clear(self)

    def __len__(self):
        return _model_copula.DistributionFactoryCollection___len__(self)

    def __eq__(self, rhs):
        return _model_copula.DistributionFactoryCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _model_copula.DistributionFactoryCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _model_copula.DistributionFactoryCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _model_copula.DistributionFactoryCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _model_copula.DistributionFactoryCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _model_copula.DistributionFactoryCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _model_copula.DistributionFactoryCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _model_copula.DistributionFactoryCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _model_copula.DistributionFactoryCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _model_copula.DistributionFactoryCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _model_copula.DistributionFactoryCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _model_copula.DistributionFactoryCollection_find(self, val)

    def __repr__(self):
        return _model_copula.DistributionFactoryCollection___repr__(self)

    def __str__(self, *args):
        return _model_copula.DistributionFactoryCollection___str__(self, *args)

    def __init__(self, *args):
        _model_copula.DistributionFactoryCollection_swiginit(self, _model_copula.new_DistributionFactoryCollection(*args))

# Register DistributionFactoryCollection in _model_copula:
_model_copula.DistributionFactoryCollection_swigregister(DistributionFactoryCollection)
class DistributionFactory(_DistributionFactoryImplementationTypedInterfaceObject):
    r"""
    Base class for probability distribution factories.

    Notes
    -----
    This class generally describes the factory mechanism of each OpenTURNS
    distribution. Refer to :ref:`parametric_estimation` for information on the specific
    estimators used for each distribution.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.DistributionFactory_getClassName(self)

    def __init__(self, *args):
        _model_copula.DistributionFactory_swiginit(self, _model_copula.new_DistributionFactory(*args))

    def __repr__(self):
        return _model_copula.DistributionFactory___repr__(self)

    def __str__(self, *args):
        return _model_copula.DistributionFactory___str__(self, *args)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula.DistributionFactory_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _model_copula.DistributionFactory_buildEstimator(self, *args)

    def setKnownParameter(self, values, positions):
        r"""
        Accessor to the known parameters.

        Parameters
        ----------
        values : sequence of float
            Values of known parameters.
        positions : sequence of int
            Indices of known parameters.

        Examples
        --------
        When a subset of the parameter vector is known, the other parameters only have to be estimated 
        from data. 

        In the following example, we consider a sample and want to fit 
        a :class:`~openturns.Beta` distribution.  
        We assume that the :math:`a` and :math:`b` parameters are known beforehand. 
        In this case, we set the third parameter (at index 2) to -1 
        and the fourth parameter (at index 3) to 1. 

        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Beta(2.3, 2.2, -1.0, 1.0)
        >>> sample = distribution.getSample(10)
        >>> factory = ot.BetaFactory()
        >>> # set (a,b) out of (r, t, a, b)
        >>> factory.setKnownParameter([-1.0, 1.0], [2, 3])
        >>> inf_distribution = factory.build(sample)
        """
        return _model_copula.DistributionFactory_setKnownParameter(self, values, positions)

    def getKnownParameterValues(self):
        r"""
        Accessor to the known parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            Values of known parameters.
        """
        return _model_copula.DistributionFactory_getKnownParameterValues(self)

    def getKnownParameterIndices(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of the known parameters.
        """
        return _model_copula.DistributionFactory_getKnownParameterIndices(self)

    @staticmethod
    def GetContinuousUniVariateFactories():
        r"""
        Accessor to the list of continuous univariate factories.

        Returns
        -------
        listFactories : collection of :class:`~openturns.DistributionFactory`
            All the valid continuous univariate factories.
        """
        return _model_copula.DistributionFactory_GetContinuousUniVariateFactories()

    @staticmethod
    def GetContinuousMultiVariateFactories():
        r"""
        Accessor to the list of continuous multivariate factories.

        Returns
        -------
        listFactories : collection of :class:`~openturns.DistributionFactory`
            All the valid continuous multivariate factories.
        """
        return _model_copula.DistributionFactory_GetContinuousMultiVariateFactories()

    @staticmethod
    def GetDiscreteUniVariateFactories():
        r"""
        Accessor to the list of discrete univariate factories.

        Returns
        -------
        listFactories : collection of :class:`~openturns.DistributionFactory`
            All the valid discrete univariate factories.
        """
        return _model_copula.DistributionFactory_GetDiscreteUniVariateFactories()

    @staticmethod
    def GetDiscreteMultiVariateFactories():
        r"""
        Accessor to the list of discrete multivariate factories.

        Returns
        -------
        listFactories : collection of :class:`~openturns.DistributionFactory`
            All the valid discrete multivariate factories.
        """
        return _model_copula.DistributionFactory_GetDiscreteMultiVariateFactories()

    @staticmethod
    def GetUniVariateFactories():
        r"""
        Accessor to the list of univariate factories.

        Returns
        -------
        listFactories : collection of :class:`~openturns.DistributionFactory`
            All the valid univariate factories.
        """
        return _model_copula.DistributionFactory_GetUniVariateFactories()

    @staticmethod
    def GetMultiVariateFactories():
        r"""
        Accessor to the list of multivariate factories.

        Returns
        -------
        listFactories : collection of :class:`~openturns.DistributionFactory`
            All the valid multivariate factories.
        """
        return _model_copula.DistributionFactory_GetMultiVariateFactories()

    @staticmethod
    def GetByName(name):
        r"""
        Instantiate a distribution factory.

        Parameters
        ----------
        name : str
            Factory name

        Returns
        -------
        factory : :class:`~openturns.DistributionFactory`
            An instance of the desired class.
        """
        return _model_copula.DistributionFactory_GetByName(name)
    __swig_destroy__ = _model_copula.delete_DistributionFactory

# Register DistributionFactory in _model_copula:
_model_copula.DistributionFactory_swigregister(DistributionFactory)
class EllipticalDistribution(DistributionImplementation):
    r"""
    Base class for elliptical distributions.

    Notes
    -----
    The class :class:`~openturns.EllipticalDistribution` maps the concept of elliptical distributions.

    The distribution of the random vector :math:`\vect{X}` is elliptical if its characteristic function is defined by:

    .. math::
        :label: shapeMatrix1

        \phi_{\vect{X} - \vect{\mu}}(\vect{t}) = g(\Tr{\vect{t}}\mat{\Sigma}\vect{t})

    where :math:`\vect{\mu}` is a location vector, :math:`\mat{\Sigma}` a nonnegative-definite matrix called the *shape
    matrix* and :math:`g` a scalar function.

    The probability density function is defined as:

    .. math::
      :label: generator

      f_{\vect{X}}(\vect{x}) = \varphi \left( \Tr{(\vect{x} - \vect{\mu})} \mat{\Sigma}^{-1} (\vect{x} - \vect{\mu})\right)

    The fonction :math:`\varphi` is called the *density generator*.

    We can define the matrix :math:`\mat{R}` as: 

    .. math::
      :label: shapeMatrix2

      \mat{\Sigma} = \diag (\vect{\sigma}) \mat{R} \diag (\vect{\sigma})

    When the distribution has a mean, then it is :math:`\vect{\mu}`.

    When the distribution has a covariance matrix, then it is proportional to  :math:`\mat{\Sigma}`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.EllipticalDistribution_getClassName(self)

    def __repr__(self):
        return _model_copula.EllipticalDistribution___repr__(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _model_copula.EllipticalDistribution_isElliptical(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.EllipticalDistribution_hasEllipticalCopula(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.EllipticalDistribution_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.EllipticalDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _model_copula.EllipticalDistribution_computeLogPDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.EllipticalDistribution_computePDFGradient(self, *args)

    def computeDensityGenerator(self, betaSquare):
        r"""
        Compute the density generator.

        Parameters
        ----------
        y : float
            Input.

        Returns
        -------
        p : float
            Value :math:`\varphi(y)`.

        Notes
        -----
        The density generator is the function :math:`\varphi` such that the probability density function
        of the elliptical distribution rewrites:

        .. math::

            f_{\vect{X}}(\vect{x}) =
                \varphi\left(\Tr{\left(\vect{x} - \vect{\mu}\right)}
                              \mat{\Sigma}^{-1}
                              \left(\vect{x} - \vect{\mu}\right)
                    \right),
                \quad \vect{x} \in \supp{\vect{X}}

        The density generator only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computePDF
        """
        return _model_copula.EllipticalDistribution_computeDensityGenerator(self, betaSquare)

    def computeLogDensityGenerator(self, betaSquare):
        r"""
        Computes the log of the density generator.

        Parameters
        ----------
        y : float
            Input.

        Returns
        -------
        p : float
            Value :math:`\log \varphi(y)`.

        Notes
        -----
        The density generator  :math:`\varphi` is defined in :eq:`generator`.

        See Also
        --------
        isElliptical, computePDF
        """
        return _model_copula.EllipticalDistribution_computeLogDensityGenerator(self, betaSquare)

    def computeDensityGeneratorDerivative(self, betaSquare):
        r"""
        Compute the first-order derivative of the probability density function.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Value :math:`\dfrac{d\varphi}{d\,t}(y)`.

        Notes
        -----
        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computeDensityGenerator
        """
        return _model_copula.EllipticalDistribution_computeDensityGeneratorDerivative(self, betaSquare)

    def computeDensityGeneratorSecondDerivative(self, betaSquare):
        r"""
        Compute the second-order derivative of the probability density function.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Value :math:`\dfrac{d^2\varphi}{d\,t^2}(y)`.

        Notes
        -----
        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computeDensityGenerator
        """
        return _model_copula.EllipticalDistribution_computeDensityGeneratorSecondDerivative(self, betaSquare)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula.EllipticalDistribution_computeSurvivalFunction(self, *args)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _model_copula.EllipticalDistribution_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def setMu(self, mu):
        r"""
        Accessor to the location parameter :math:`\vect{\mu}`.

        Parameters
        ----------
        mu : sequence of float
            The location parameter :math:`\vect{\mu}`.
        """
        return _model_copula.EllipticalDistribution_setMu(self, mu)

    def getMu(self):
        r"""
        Accessor to the location parameter :math:`\vect{\mu}`.

        Parameters
        ----------
        mu : sequence of float
            The location parameter :math:`\vect{\mu}`.
        """
        return _model_copula.EllipticalDistribution_getMu(self)

    def setSigma(self, sigma):
        r"""
        Accessor to the scale parameter :math:`\vect{\sigma}`.

        Parameters
        ----------
        sigma : float or sequence of positive float
            The scale parameter :math:`\vect{\sigma}`.

        Notes
        -----
        The scale parameter :math:`\vect{\sigma}` is defined in :eq:`shapeMatrix2`.
        """
        return _model_copula.EllipticalDistribution_setSigma(self, sigma)

    def getSigma(self):
        r"""
        Accessor to the scale parameter :math:`\vect{\sigma}`.

        Returns
        -------
        sigma : float or sequence of positive float
            The scale parameter :math:`\vect{\sigma}`.

        Notes
        -----
        The scale parameter :math:`\vect{\sigma}` is defined in :eq:`shapeMatrix2`.

        """
        return _model_copula.EllipticalDistribution_getSigma(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _model_copula.EllipticalDistribution_getStandardDeviation(self)

    def setR(self, R):
        r"""
        Accessor to the :math:`\mat{R}` matrix.

        Parameters
        ----------
        R : sequence of positive float
            The matrix :math:`\mat{R}`.

        Notes
        -----
        The :math:`\mat{R}` matrix is defined in :eq:`shapeMatrix2`.
        """
        return _model_copula.EllipticalDistribution_setR(self, R)

    def getR(self):
        r"""
        Accessor to the :math:`\mat{R}` matrix.

        Returns
        -------
        R : :class:`openturns.CorrelationMatrix`
            The matrix :math:`\mat{R}`.

        Notes
        -----
        The :math:`\mat{R}` matrix is defined in :eq:`shapeMatrix2`.
        """
        return _model_copula.EllipticalDistribution_getR(self)

    def getCholesky(self):
        r"""
        Accessor to the Cholesky factor of the covariance matrix.

        Returns
        -------
        L : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix.

        See Also
        --------
        getCovariance
        """
        return _model_copula.EllipticalDistribution_getCholesky(self)

    def getInverseCholesky(self):
        r"""
        Accessor to the inverse Cholesky factor of the covariance matrix.

        Returns
        -------
        Linv : :class:`~openturns.TriangularMatrix`
            Inverse Cholesky factor of the covariance matrix.

        See also
        --------
        openturns.Distribution.getCholesky
        """
        return _model_copula.EllipticalDistribution_getInverseCholesky(self)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.EllipticalDistribution_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.EllipticalDistribution_getInverseIsoProbabilisticTransformation(self)

    def getStandardDistribution(self):
        r"""
        Accessor to the standard distribution.

        Returns
        -------
        standard_distribution : :class:`~openturns.Distribution`
            Standard distribution.

        Notes
        -----
        The standard distribution is determined according to the distribution
        properties. This is the target distribution achieved by the iso-probabilistic
        transformation.

        See Also
        --------
        getIsoProbabilisticTransformation
        """
        return _model_copula.EllipticalDistribution_getStandardDistribution(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.EllipticalDistribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.EllipticalDistribution_setParametersCollection(self, *args)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.EllipticalDistribution_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.EllipticalDistribution_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.EllipticalDistribution_getParameterDescription(self)

    def __init__(self, *args):
        _model_copula.EllipticalDistribution_swiginit(self, _model_copula.new_EllipticalDistribution(*args))
    __swig_destroy__ = _model_copula.delete_EllipticalDistribution

# Register EllipticalDistribution in _model_copula:
_model_copula.EllipticalDistribution_swigregister(EllipticalDistribution)
class ArchimedeanCopula(DistributionImplementation):
    r"""
    Base class for bivariate Archimedean copulas.

    Notes
    -----
    The bivariate Archimedean copulas are defined by:

    .. math::

        C(u_1, u_2; \theta) = \varphi^{-1}(\varphi(u_1; \theta) + \varphi(u_2; \theta); \theta)

    where :math:`\varphi` is the generator of the copula, a continuous, strictly
    decreasing and convex function from :math:`[0, 1]\times \theta` to
    :math:`[0, \infty)` such that :math:`\varphi(1; \theta)=0`. :math:`\varphi^{-1}`
    is the pseudo-inverse of the generator function defined by:

    .. math::

        \varphi^{-1}(t; \theta) = \left\{
                          \begin{array}{ll}
                          \displaystyle \varphi^{-1}(t; \theta)
                              & \text{ if } 0 \leq t \leq \varphi(0; \theta)\\
                          \displaystyle 0 & \text{ if } \varphi(0; \theta) \leq t \leq \infty
                          \end{array}
                                  \right.


    An ArchimedeanCopula object can be used only through its derived classes:

    - :class:`~openturns.AliMikhailHaqCopula`
    - :class:`~openturns.ClaytonCopula`
    - :class:`~openturns.FrankCopula`
    - :class:`~openturns.GumbelCopula`

    See also
    --------
    Distribution
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.ArchimedeanCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.ArchimedeanCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.ArchimedeanCopula___repr__(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.ArchimedeanCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.ArchimedeanCopula_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _model_copula.ArchimedeanCopula_computeComplementaryCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula.ArchimedeanCopula_computeProbability(self, interval)

    def computeConditionalPDF(self, x, y):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula.ArchimedeanCopula_computeConditionalPDF(self, x, y)

    def computeArchimedeanGenerator(self, t):
        r"""
        Compute the Archimedean generator :math:`\varphi`.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The Archimedean generator :math:`\varphi`.
        """
        return _model_copula.ArchimedeanCopula_computeArchimedeanGenerator(self, t)

    def computeInverseArchimedeanGenerator(self, t):
        r"""
        Compute the inverse of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
             :math:`\varphi^{-1}` the inverse of the Archimedean generator.
        """
        return _model_copula.ArchimedeanCopula_computeInverseArchimedeanGenerator(self, t)

    def computeArchimedeanGeneratorDerivative(self, t):
        r"""
        Compute the derivative of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The derivative of the Archimedean generator :math:`\varphi`.
        """
        return _model_copula.ArchimedeanCopula_computeArchimedeanGeneratorDerivative(self, t)

    def computeArchimedeanGeneratorSecondDerivative(self, t):
        r"""
        Compute the seconde derivative of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The seconde derivative of the Archimedean generator :math:`\varphi`.
        """
        return _model_copula.ArchimedeanCopula_computeArchimedeanGeneratorSecondDerivative(self, t)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.ArchimedeanCopula_getMarginal(self, *args)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.ArchimedeanCopula_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.ArchimedeanCopula_hasIndependentCopula(self)

    def __init__(self, *args):
        _model_copula.ArchimedeanCopula_swiginit(self, _model_copula.new_ArchimedeanCopula(*args))
    __swig_destroy__ = _model_copula.delete_ArchimedeanCopula

# Register ArchimedeanCopula in _model_copula:
_model_copula.ArchimedeanCopula_swigregister(ArchimedeanCopula)
class SklarCopula(DistributionImplementation):
    r"""
    Sklar copula.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution, whatever its type : UsualDistribution, JointDistribution,
        KernelMixture, Mixture, RandomMixture, ...).

    Notes
    -----
    The Sklar copula is obtained directly from the expression of the
    :math:`n`-dimensional distribution which cumulative distribution function is
    :math:`F` with :math:`F_i` its marginals :

    .. math::

        C(u_1, \cdots, u_n) = F(F_1^{-1}(u_1), \cdots, F_n^{-1}(u_n))

    for :math:`u_i \in [0, 1]`

    See also
    --------
    MaximumEntropyOrderStatisticsCopula

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> R = ot.CorrelationMatrix(3)
    >>> R[0, 1] = 0.25
    >>> R[1, 2] = 0.25
    >>> copula = ot.SklarCopula(ot.Normal([1.0, 2.0, 3.0], [2.0, 3.0, 1.0], R))

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.SklarCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.SklarCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.SklarCopula___repr__(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.SklarCopula_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.SklarCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.SklarCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.SklarCopula_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula.SklarCopula_computeProbability(self, interval)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula.SklarCopula_computeSurvivalFunction(self, *args)

    def computePDFGradient(self, point):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.SklarCopula_computePDFGradient(self, point)

    def computeCDFGradient(self, point):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.SklarCopula_computeCDFGradient(self, point)

    def computeQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.SklarCopula_computeQuantile(self, prob, tail)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula.SklarCopula_computeConditionalPDF(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.SklarCopula_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.SklarCopula_computeConditionalQuantile(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.SklarCopula_getMarginal(self, *args)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.SklarCopula_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.SklarCopula_getInverseIsoProbabilisticTransformation(self)

    def getStandardDistribution(self):
        r"""
        Accessor to the standard distribution.

        Returns
        -------
        standard_distribution : :class:`~openturns.Distribution`
            Standard distribution.

        Notes
        -----
        The standard distribution is determined according to the distribution
        properties. This is the target distribution achieved by the iso-probabilistic
        transformation.

        See Also
        --------
        getIsoProbabilisticTransformation
        """
        return _model_copula.SklarCopula_getStandardDistribution(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.SklarCopula_getParametersCollection(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.SklarCopula_setParameter(self, parameters)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.SklarCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.SklarCopula_getParameterDescription(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.SklarCopula_hasIndependentCopula(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.SklarCopula_hasEllipticalCopula(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.SklarCopula_getKendallTau(self)

    def setDistribution(self, distribution):
        r"""
        Set the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            A distribution, whatever its type : UsualDistribution,
            JointDistribution, KernelMixture, Mixture, RandomMixture, ...)
            from which the copula is built.
        """
        return _model_copula.SklarCopula_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Get the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The distribution from which the copula is built.
        """
        return _model_copula.SklarCopula_getDistribution(self)

    def __init__(self, *args):
        _model_copula.SklarCopula_swiginit(self, _model_copula.new_SklarCopula(*args))
    __swig_destroy__ = _model_copula.delete_SklarCopula

# Register SklarCopula in _model_copula:
_model_copula.SklarCopula_swigregister(SklarCopula)
class AliMikhailHaqCopula(ArchimedeanCopula):
    r"""
    AliMikhailHaq copula.

    Parameters
    ----------
    theta : float
        Parameter :math:`\theta`, :math:`-1 \leq \theta \leq 1`.

        Default value is 0.5.

    Notes
    -----
    The AliMikhailHaq copula is a bivariate Archimedean copula defined by:

    .. math::

        C(u_1, u_2) = \frac{u_1 u_2}{1- \theta (1 - u_1)(1 - u_2)}

    for :math:`(u_1, u_2) \in [0, 1]^2`

    And its generator is:

    .. math::

        \varphi(t) = \log \left( \frac{1-\theta(1-t)}{t} \right)

    See also
    --------
    ArchimedeanCopula

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.AliMikhailHaqCopula(0.5)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.AliMikhailHaqCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.AliMikhailHaqCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.AliMikhailHaqCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.AliMikhailHaqCopula___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.AliMikhailHaqCopula_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.AliMikhailHaqCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.AliMikhailHaqCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.AliMikhailHaqCopula_computeCDF(self, *args)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.AliMikhailHaqCopula_getKendallTau(self)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _model_copula.AliMikhailHaqCopula_getSpearmanCorrelation(self)

    def computePDFGradient(self, point):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.AliMikhailHaqCopula_computePDFGradient(self, point)

    def computeCDFGradient(self, point):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.AliMikhailHaqCopula_computeCDFGradient(self, point)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.AliMikhailHaqCopula_computeQuantile(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.AliMikhailHaqCopula_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.AliMikhailHaqCopula_computeConditionalQuantile(self, *args)

    def computeArchimedeanGenerator(self, t):
        r"""
        Compute the Archimedean generator :math:`\varphi`.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The Archimedean generator :math:`\varphi`.
        """
        return _model_copula.AliMikhailHaqCopula_computeArchimedeanGenerator(self, t)

    def computeInverseArchimedeanGenerator(self, t):
        r"""
        Compute the inverse of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
             :math:`\varphi^{-1}` the inverse of the Archimedean generator.
        """
        return _model_copula.AliMikhailHaqCopula_computeInverseArchimedeanGenerator(self, t)

    def computeArchimedeanGeneratorDerivative(self, t):
        r"""
        Compute the derivative of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The derivative of the Archimedean generator :math:`\varphi`.
        """
        return _model_copula.AliMikhailHaqCopula_computeArchimedeanGeneratorDerivative(self, t)

    def computeArchimedeanGeneratorSecondDerivative(self, t):
        r"""
        Compute the seconde derivative of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The seconde derivative of the Archimedean generator :math:`\varphi`.
        """
        return _model_copula.AliMikhailHaqCopula_computeArchimedeanGeneratorSecondDerivative(self, t)

    def computeUpperTailDependenceMatrix(self):
        r"""
        Compute the upper tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper tail dependence matrix is :math:`(\chi^{ij})_{1 \leq i, j \leq d}` where :math:`\chi^{ij}` is
        the upper tail dependence coefficient of the bivariate distribution :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi^{ij} = \lim_{u \to 1} \chi^{ij}(u)

        where  :math:`u \mapsto \chi^{ij}(u)` is the upper tail dependence function of the bivariate distribution
        :math:`(X_i, X_j)` defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chi = copula.computeUpperTailDependenceMatrix()[1, 0]
        """
        return _model_copula.AliMikhailHaqCopula_computeUpperTailDependenceMatrix(self)

    def computeLowerTailDependenceMatrix(self):
        r"""
        Compute the lower tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower tail dependence matrix is :math:`(\chi_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\chi_L^{ij}` is the lower tail dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi_L^{ij} = \lim_{u \to 0} \chi_L^{ij}(u)

        where  :math:`u \mapsto \chi_L^{ij}(u)` is the lower tail dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiL = copula.computeLowerTailDependenceMatrix()[1, 0]
        """
        return _model_copula.AliMikhailHaqCopula_computeLowerTailDependenceMatrix(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.AliMikhailHaqCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.AliMikhailHaqCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.AliMikhailHaqCopula_getParameterDescription(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.AliMikhailHaqCopula_hasIndependentCopula(self)

    def setTheta(self, theta):
        r"""
        Set the parameter :math:`\theta`.

        Parameters
        ----------
        theta : float, :math:`-1 \leq \theta \leq 1`
            Parameter :math:`\theta` of the copula.
        """
        return _model_copula.AliMikhailHaqCopula_setTheta(self, theta)

    def getTheta(self):
        r"""
        Get the parameter :math:`\theta`.

        Returns
        -------
        theta : float
            Parameter :math:`\theta` of the copula.
        """
        return _model_copula.AliMikhailHaqCopula_getTheta(self)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.AliMikhailHaqCopula_computeEntropy(self)

    def __init__(self, *args):
        _model_copula.AliMikhailHaqCopula_swiginit(self, _model_copula.new_AliMikhailHaqCopula(*args))
    __swig_destroy__ = _model_copula.delete_AliMikhailHaqCopula

# Register AliMikhailHaqCopula in _model_copula:
_model_copula.AliMikhailHaqCopula_swigregister(AliMikhailHaqCopula)
class AliMikhailHaqCopulaFactory(DistributionFactoryImplementation):
    r"""
    AliMikhailHaq copula factory.

    Notes
    -----
    We note :math:`\Hat{\tau}_n` the Kendall-\ :math:`\tau` of the sample.

    The parameter :math:`\Hat{\theta}_n` is solution of:

    .. math::

        \displaystyle \Hat{\tau}_n = \displaystyle \frac{3\theta-2}{3\theta} - \frac{2(1-\theta)^2\ln(1-\theta)}{3\theta^2}

    See also
    --------
    DistributionFactory, AliMikhailHaqCopula
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.AliMikhailHaqCopulaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula.AliMikhailHaqCopulaFactory_build(self, *args)

    def buildAsAliMikhailHaqCopula(self, *args):
        r"""
        Estimate the copula as native copula.

        **Available usages**:

            buildAsAliMikhailHaqCopula()

            buildAsAliMikhailHaqCopula(*sample*)

            buildAsAliMikhailHaqCopula(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data of dimension 2.
        param : sequence of float of size 1
           The parameter :math:`\theta`.

        Returns
        -------
        copula : :class:`~openturns.AliMikhailHaqCopula`
            The estimated copula as an AliMikhailHaq copula.

            In the first usage, the default AliMikhailHaq copula is built.
        """
        return _model_copula.AliMikhailHaqCopulaFactory_buildAsAliMikhailHaqCopula(self, *args)

    def __init__(self, *args):
        _model_copula.AliMikhailHaqCopulaFactory_swiginit(self, _model_copula.new_AliMikhailHaqCopulaFactory(*args))
    __swig_destroy__ = _model_copula.delete_AliMikhailHaqCopulaFactory

# Register AliMikhailHaqCopulaFactory in _model_copula:
_model_copula.AliMikhailHaqCopulaFactory_swigregister(AliMikhailHaqCopulaFactory)
class IndependentCopula(DistributionImplementation):
    r"""
    Independent copula.

    Parameters
    ----------
    n : int
        Dimension of the copula, :math:`n \geq 1`.

        Default value is 2.

    Notes
    -----
    The Independent copula is defined by :

    .. math::

        C(u_1, \cdots, u_n) = \prod_{i=1}^n u_i

    for :math:`u_i \in [0, 1]`

    See also
    --------
    Distribution

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.IndependentCopula(3)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.IndependentCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.IndependentCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.IndependentCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.IndependentCopula___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.IndependentCopula_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.IndependentCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.IndependentCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.IndependentCopula_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula.IndependentCopula_computeProbability(self, interval)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula.IndependentCopula_computeSurvivalFunction(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.IndependentCopula_computeEntropy(self)

    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula.IndependentCopula_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)

    def computeBilateralConfidenceIntervalWithMarginalProbability(self, prob):
        r"""
        Compute a bilateral confidence interval.

        Refer to :func:`computeBilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *\alpha*.
        beta : float
            The probability :math:`\beta`.

        Examples
        --------
        We consider a Normal(2) distribution with zero mean, unit standard deviation and independent components.
        We note :math:`\Phi_2` its cdf. Due to
        symetries of the distribution, the bilateral confidence interval is :math:`I^*_{\alpha} = [-a, a] \times [-a, a]`
        where :math:`a = \Phi^{-1}((1 + \beta) / 2)` where :math:`\Phi` is the marginal cdf of each 1D marginal standard Gaussian component. Then :math:`\beta` is such that
        :math:`\Phi_2(I^*_{\alpha}) = \alpha`. As :math:`\Phi_2(I^*_{\alpha}) = (2\Phi(a) - 1)^2 = \beta^2`,
        then, :math:`\beta` is equal to :math:`\beta = \sqrt{\alpha} = 0.9486`
        and :math:`a = -1.9488` with 4 significant digits.

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> confInt, beta = dist.computeBilateralConfidenceIntervalWithMarginalProbability(0.9)
        """
        return _model_copula.IndependentCopula_computeBilateralConfidenceIntervalWithMarginalProbability(self, prob)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _model_copula.IndependentCopula_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def computePDFGradient(self, point):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.IndependentCopula_computePDFGradient(self, point)

    def computeCDFGradient(self, point):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.IndependentCopula_computeCDFGradient(self, point)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.IndependentCopula_computeQuantile(self, *args)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.IndependentCopula_getKendallTau(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.IndependentCopula_getMarginal(self, *args)

    def computeConditionalDDF(self, x, y):
        r"""
        Compute the conditional derivative density function of the last component.

        With respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        ddf : float,
            Conditional DDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional derivative density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d^2}{d\,x_j^2}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it reduces to :math:`\dfrac{d^2}{d\,x_1^2}F_{X_1}(x_1)`, ie the DDF of
        the first component at :math:`x_1`.

        See Also
        --------
        computeDDF, computeConditionalCDF
        """
        return _model_copula.IndependentCopula_computeConditionalDDF(self, x, y)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula.IndependentCopula_computeConditionalPDF(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.IndependentCopula_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.IndependentCopula_computeConditionalQuantile(self, *args)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.IndependentCopula_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.IndependentCopula_getInverseIsoProbabilisticTransformation(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _model_copula.IndependentCopula_isElliptical(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.IndependentCopula_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.IndependentCopula_hasIndependentCopula(self)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.IndependentCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.IndependentCopula_getParameterDescription(self)

    def __init__(self, *args):
        _model_copula.IndependentCopula_swiginit(self, _model_copula.new_IndependentCopula(*args))
    __swig_destroy__ = _model_copula.delete_IndependentCopula

# Register IndependentCopula in _model_copula:
_model_copula.IndependentCopula_swigregister(IndependentCopula)
class IndependentCopulaFactory(DistributionFactoryImplementation):
    r"""
    Independent Copula factory.


    See also
    --------
    DistributionFactory, IndependentCopula
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.IndependentCopulaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula.IndependentCopulaFactory_build(self, *args)

    def buildAsIndependentCopula(self, *args):
        r"""
        Build the independent copula.

        **Available usages**:

            buildAsIndependentCopula()

            buildAsIndependentCopula(*sample*)

            buildAsIndependentCopula(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension :math:`d`
            The sample of size :math:`n>0` from which the copula is estimated.
        param : sequence of float
            The dimension of the IndependentCopula.

        Returns
        -------
        copula : :class:`~openturns.IndependentCopula`
            The estimated copula as an independent copula.

        """
        return _model_copula.IndependentCopulaFactory_buildAsIndependentCopula(self, *args)

    def __init__(self, *args):
        _model_copula.IndependentCopulaFactory_swiginit(self, _model_copula.new_IndependentCopulaFactory(*args))
    __swig_destroy__ = _model_copula.delete_IndependentCopulaFactory

# Register IndependentCopulaFactory in _model_copula:
_model_copula.IndependentCopulaFactory_swigregister(IndependentCopulaFactory)
class MinCopula(DistributionImplementation):
    r"""
    MinCopula.

    Parameters
    ----------
    n : int
        Dimension of the copula, :math:`n \geq 1`.

        Default value is 2.

    Notes
    -----
    The Min Copula is defined by:

    .. math::

        C(u_1, \cdots, u_n) = \min_{i=1, \cdots, n} u_i

    for :math:`u_i \in [0, 1]`

    See also
    --------
    Distribution

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.MinCopula(2)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.MinCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.MinCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.MinCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.MinCopula___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.MinCopula_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.MinCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.MinCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.MinCopula_computeCDF(self, *args)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.MinCopula_computeQuantile(self, *args)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula.MinCopula_computeSurvivalFunction(self, *args)

    def computeInverseSurvivalFunction(self, prob):
        r"""
        Compute the inverse survival function.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            Value of the survival function.

        Returns
        -------
        x : :class:`~openturns.Point`
            Point :math:`\vect{x}` such that :math:`S_{\vect{X}}(\vect{x}) = p` with iso-quantile components.

        Notes
        -----
        Among the points :math:`\vect{x}` that satisfy :math:`S_{\vect{X}}(\vect{x}) = p`,
        the method returns the one which also satisfies
        :math:`\Prob{X_1 > x_1}   =  \dots = \Prob{X_d > x_d}`.

        See Also
        --------
        computeQuantile, computeSurvivalFunction
        """
        return _model_copula.MinCopula_computeInverseSurvivalFunction(self, prob)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.MinCopula_computeEntropy(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.MinCopula_getKendallTau(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.MinCopula_getMarginal(self, *args)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.MinCopula_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.MinCopula_getInverseIsoProbabilisticTransformation(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _model_copula.MinCopula_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.MinCopula_isContinuous(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.MinCopula_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.MinCopula_hasIndependentCopula(self)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.MinCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.MinCopula_getParameterDescription(self)

    def __init__(self, *args):
        _model_copula.MinCopula_swiginit(self, _model_copula.new_MinCopula(*args))
    __swig_destroy__ = _model_copula.delete_MinCopula

# Register MinCopula in _model_copula:
_model_copula.MinCopula_swigregister(MinCopula)
class NormalCopula(DistributionImplementation):
    r"""
    Normal copula.

    Available constructor:
        NormalCopula(*n*)

        NormalCopula(*R*)

    Parameters
    ----------
    n : int, :math:`n \geq 1`
        Dimension of the copula.

        Default value is 2.
    R : :class:`~openturns.CorrelationMatrix`
        Shape matrix :math:`\mat{R}` of the copula, ie the correlation matrix of
        any normal distribution with this copula (it is not the Kendall nor the
        Spearman rank correlation matrix of the distribution).

        Default value is the identity matrix.

    Notes
    -----
    The Normal copula is defined by :

    .. math::

        C(u_1, \cdots, u_n) = \Phi_{\mat{R}}^n(\Phi^{-1}(u_1), \cdots, \Phi^{-1}(u_n))

    where :math:`\Phi_{\mat{R}}^n` is the cumulative distribution function of the
    normal distribution with zero mean, unit marginal variances and correlation :math:`R`:

    .. math::

        \Phi_{\mat{R}}^n(\vect{x}) = \int_{-\infty}^{x_1} \ldots
                                       \int_{-\infty}^{x_n}
                                       \frac{1}
                                            {{(2\pi\det{\mat{R}})}^{\frac{n}{2}}}
                                     \exp \left(-\frac{\Tr{\vect{u}}\mat{R}\vect{u}}{2} \right)\di{\vect{u}}

    with :math:`\Phi` given by:

    .. math::

          \Phi(x) = \int_{-\infty}^x \frac{1}{\sqrt{2\pi}} e^{-\frac{t^2}{2}}\di{t}

    The correlation matrix :math:`\mat{R}` is linked to the Spearman correlation
    and the Kendall concordance through the following relations:      

    - From the Spearman correlation matrix:

      .. math ::

          \mat{R}_{ij} = 2 \sin \left( \frac{\pi}{6}\rho_{ij}^S \right)

      where :math:`\rho_{ij}^S = \rho^S(X_i,X_j) = \rho^P(F_{X_i}(X_i),F_{X_j}(X_j))`

    - From the Kendall concordance matrix:

      .. math::

          \mat{R}_{ij} = \sin \left( \frac{\pi}{2} \tau_{ij} \right)

      with

      .. math::

          \tau_{ij} = \tau(X_i,X_j)
                    = \Prob{(X_{i_1} - X_{i_2})(X_{j_1} - X_{j_2}) > 0} -
                      \Prob{(X_{i_1} - X_{i_2})(X_{j_1} - X_{j_2}) < 0}

      where :math:`(X_{i_1},X_{j_1}` and :math:`(X_{i_2},X_{j_2})` follow the
      distribution of :math:`(X_i,X_j)`.

    See also
    --------
    Distribution

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> R = ot.CorrelationMatrix(3)
    >>> R[0, 1] = 0.25
    >>> R[1, 2] = 0.25
    >>> copula = ot.NormalCopula(R)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.NormalCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.NormalCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.NormalCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.NormalCopula___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.NormalCopula_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.NormalCopula_getSample(self, size)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.NormalCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.NormalCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.NormalCopula_computeCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula.NormalCopula_computeSurvivalFunction(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula.NormalCopula_computeProbability(self, interval)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.NormalCopula_computeEntropy(self)

    def getShapeMatrix(self):
        r"""
        Accessor to the shape matrix of the underlying copula if it is elliptical.

        Returns
        -------
        shape : :class:`~openturns.CorrelationMatrix`
            Shape matrix of the elliptical copula of a distribution.

        Notes
        -----
        This is not the Pearson correlation matrix.

        See Also
        --------
        getPearsonCorrelation
        """
        return _model_copula.NormalCopula_getShapeMatrix(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.NormalCopula_getKendallTau(self)

    def computePDFGradient(self, point):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.NormalCopula_computePDFGradient(self, point)

    def computeCDFGradient(self, point):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.NormalCopula_computeCDFGradient(self, point)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula.NormalCopula_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _model_copula.NormalCopula_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.NormalCopula_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.NormalCopula_computeSequentialConditionalCDF(self, x)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.NormalCopula_computeConditionalQuantile(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        p : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Sequence of conditional quantiles values at *p*

        Notes
        -----
        The sequential conditional quantile function is defined by:

        .. math::

            \left(F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p_j; x_1, \dots, x_{j-1})\right)_{i=1,\ldots,d}

        where :math:`F^{-1}` is the quantile function and
        where :math:`x_1,\ldots,x_{j-1}` are defined recursively as :math:`x_1=F_1^{-1}(p_1)` and for :math:`2\leq j \leq d`,
        :math:`x_j=F_{X_j}^{-1}(p_j|X_1=x_1,\ldots,X_{j-1}=x_{j-1})`: the conditioning part is the set of already
        computed conditional quantiles.
        """
        return _model_copula.NormalCopula_computeSequentialConditionalQuantile(self, q)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.NormalCopula_getMarginal(self, *args)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.NormalCopula_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.NormalCopula_getInverseIsoProbabilisticTransformation(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.NormalCopula_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.NormalCopula_hasIndependentCopula(self)

    def computeUpperTailDependenceMatrix(self):
        r"""
        Compute the upper tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper tail dependence matrix is :math:`(\chi^{ij})_{1 \leq i, j \leq d}` where :math:`\chi^{ij}` is
        the upper tail dependence coefficient of the bivariate distribution :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi^{ij} = \lim_{u \to 1} \chi^{ij}(u)

        where  :math:`u \mapsto \chi^{ij}(u)` is the upper tail dependence function of the bivariate distribution
        :math:`(X_i, X_j)` defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chi = copula.computeUpperTailDependenceMatrix()[1, 0]
        """
        return _model_copula.NormalCopula_computeUpperTailDependenceMatrix(self)

    def computeLowerTailDependenceMatrix(self):
        r"""
        Compute the lower tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower tail dependence matrix is :math:`(\chi_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\chi_L^{ij}` is the lower tail dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi_L^{ij} = \lim_{u \to 0} \chi_L^{ij}(u)

        where  :math:`u \mapsto \chi_L^{ij}(u)` is the lower tail dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiL = copula.computeLowerTailDependenceMatrix()[1, 0]
        """
        return _model_copula.NormalCopula_computeLowerTailDependenceMatrix(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.NormalCopula_setParametersCollection(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.NormalCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.NormalCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.NormalCopula_getParameterDescription(self)

    @staticmethod
    def GetCorrelationFromSpearmanCorrelation(matrix):
        r"""
        Get the correlation matrix from the Spearman correlation matrix.

        Parameters
        ----------
        S : :class:`~openturns.CorrelationMatrix`
            Spearman correlation matrix :math:`S` of the considered random vector.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R}` of the normal copula evaluated from
            the Spearman correlation matrix :math:`S`.
        """
        return _model_copula.NormalCopula_GetCorrelationFromSpearmanCorrelation(matrix)

    @staticmethod
    def GetCorrelationFromKendallCorrelation(matrix):
        r"""
        Get the correlation matrix from the Kendall correlation matrix.

        Parameters
        ----------
        K : :class:`~openturns.CorrelationMatrix`
            Kendall correlation matrix of the considered random vector.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R}` of the normal copula evaluated from
            the Kendall correlation matrix :math:`K`.
        """
        return _model_copula.NormalCopula_GetCorrelationFromKendallCorrelation(matrix)

    def __init__(self, *args):
        _model_copula.NormalCopula_swiginit(self, _model_copula.new_NormalCopula(*args))
    __swig_destroy__ = _model_copula.delete_NormalCopula

# Register NormalCopula in _model_copula:
_model_copula.NormalCopula_swigregister(NormalCopula)
class NormalCopulaFactory(DistributionFactoryImplementation):
    r"""
    Normal Copula factory.

    Notes
    -----
    We note :math:`\Hat{\tau}_n` the Kendall-\ :math:`\tau` of the sample.

    The correlation matrix :math:`\mat{R}_n` is first estimated using Kendall's tau by:

    .. math::

        R_{n,ij} = \sin\left(\frac{\pi}{2}\Hat{\tau}_{n,ij}\right)_{\strut}

    and if it fails, using Spearman's correlation:

    .. math::

        R_{n,ij} = 2\sin\left(\frac{\pi}{6}\Hat{\rho}_{n,ij}\right)_{\strut}


    See also
    --------
    DistributionFactory, NormalCopula
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.NormalCopulaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula.NormalCopulaFactory_build(self, *args)

    def buildAsNormalCopula(self, *args):
        r"""
        Estimate the copula as native copula.

        **Available usages**:

            buildAsNormalCopula()

            buildAsNormalCopula(*sample*)

            buildAsNormalCopula(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
           The parameters of the :class:`~openturns.NormalCopula`.

        Returns
        -------
        copula : :class:`~openturns.NormalCopula`
            The estimated copula as a Normal copula.

            In the first usage, the default Normal copula is built.
        """
        return _model_copula.NormalCopulaFactory_buildAsNormalCopula(self, *args)

    def __init__(self, *args):
        _model_copula.NormalCopulaFactory_swiginit(self, _model_copula.new_NormalCopulaFactory(*args))
    __swig_destroy__ = _model_copula.delete_NormalCopulaFactory

# Register NormalCopulaFactory in _model_copula:
_model_copula.NormalCopulaFactory_swigregister(NormalCopulaFactory)
class FarlieGumbelMorgensternCopula(DistributionImplementation):
    r"""
    FarlieGumbelMorgenstern copula.

    Parameters
    ----------
    theta : float
        Parameter :math:`\theta`, :math:`-1 \leq \theta \leq 1`.

        Default value is 0.5.

    Notes
    -----
    The FarlieGumbelMorgenstern copula is defined by:

    .. math::

        C(u_1, u_2) = u_1 u_2 (1 + \theta (1 - u_1)(1 - u_2))

    for :math:`(u_1, u_2) \in [0, 1]^2`

    See also
    --------
    Distribution

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.FarlieGumbelMorgensternCopula(0.7)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.FarlieGumbelMorgensternCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.FarlieGumbelMorgensternCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.FarlieGumbelMorgensternCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.FarlieGumbelMorgensternCopula___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.FarlieGumbelMorgensternCopula_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.FarlieGumbelMorgensternCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.FarlieGumbelMorgensternCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.FarlieGumbelMorgensternCopula_computeCDF(self, *args)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.FarlieGumbelMorgensternCopula_getKendallTau(self)

    def computePDFGradient(self, point):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.FarlieGumbelMorgensternCopula_computePDFGradient(self, point)

    def computeCDFGradient(self, point):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.FarlieGumbelMorgensternCopula_computeCDFGradient(self, point)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.FarlieGumbelMorgensternCopula_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.FarlieGumbelMorgensternCopula_computeConditionalQuantile(self, *args)

    def computeUpperTailDependenceMatrix(self):
        r"""
        Compute the upper tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper tail dependence matrix is :math:`(\chi^{ij})_{1 \leq i, j \leq d}` where :math:`\chi^{ij}` is
        the upper tail dependence coefficient of the bivariate distribution :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi^{ij} = \lim_{u \to 1} \chi^{ij}(u)

        where  :math:`u \mapsto \chi^{ij}(u)` is the upper tail dependence function of the bivariate distribution
        :math:`(X_i, X_j)` defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chi = copula.computeUpperTailDependenceMatrix()[1, 0]
        """
        return _model_copula.FarlieGumbelMorgensternCopula_computeUpperTailDependenceMatrix(self)

    def computeLowerTailDependenceMatrix(self):
        r"""
        Compute the lower tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower tail dependence matrix is :math:`(\chi_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\chi_L^{ij}` is the lower tail dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi_L^{ij} = \lim_{u \to 0} \chi_L^{ij}(u)

        where  :math:`u \mapsto \chi_L^{ij}(u)` is the lower tail dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiL = copula.computeLowerTailDependenceMatrix()[1, 0]
        """
        return _model_copula.FarlieGumbelMorgensternCopula_computeLowerTailDependenceMatrix(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.FarlieGumbelMorgensternCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.FarlieGumbelMorgensternCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.FarlieGumbelMorgensternCopula_getParameterDescription(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.FarlieGumbelMorgensternCopula_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.FarlieGumbelMorgensternCopula_hasIndependentCopula(self)

    def setTheta(self, theta):
        r"""
        Accessor to the :math:`theta` parameter.

        Parameters
        ----------
        theta : float
            The :math:`\theta` parameter, :math:`-1 \leq \theta \leq 1`.
        """
        return _model_copula.FarlieGumbelMorgensternCopula_setTheta(self, theta)

    def getTheta(self):
        r"""
        Accessor to the :math:`theta` parameter.

        Returns
        -------
        theta : float
            The :math:`\theta` parameter .
        """
        return _model_copula.FarlieGumbelMorgensternCopula_getTheta(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.FarlieGumbelMorgensternCopula_getMarginal(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.FarlieGumbelMorgensternCopula_computeEntropy(self)

    def __init__(self, *args):
        _model_copula.FarlieGumbelMorgensternCopula_swiginit(self, _model_copula.new_FarlieGumbelMorgensternCopula(*args))
    __swig_destroy__ = _model_copula.delete_FarlieGumbelMorgensternCopula

# Register FarlieGumbelMorgensternCopula in _model_copula:
_model_copula.FarlieGumbelMorgensternCopula_swigregister(FarlieGumbelMorgensternCopula)
class FarlieGumbelMorgensternCopulaFactory(DistributionFactoryImplementation):
    r"""
    Farlie Gumbel Morgenstern Copula factory.

    Notes
    -----
    We note :math:`\Hat{\tau}_n` the Kendall-\ :math:`\tau` of the sample
    and :math:`\Hat{\rho}_n` its Spearman correlation coefficient.

    We use the following estimators:

    .. math::

        \Hat{\theta}_n = \displaystyle \frac{9}{2}\Hat{\tau}_n^{\strut}` 

    if :math:`|\Hat{\theta}_n|<1`.

    Otherwise

    .. math::

        \Hat{\theta}_n = \displaystyle 3\Hat{\rho}_n^{\strut}`

    if :math:`|\Hat{\theta}_n|<1`.

    Otherwise, the estimation is not possible.


    See also
    --------
    DistributionFactory, FarlieGumbelMorgensternCopula
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.FarlieGumbelMorgensternCopulaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula.FarlieGumbelMorgensternCopulaFactory_build(self, *args)

    def buildAsFarlieGumbelMorgensternCopula(self, *args):
        r"""
        Estimate the copula as native copula.

        **Available usages**:

            buildAsFarlieGumbelMorgensternCopula()

            buildAsFarlieGumbelMorgensternCopula(*sample*)

            buildAsFarlieGumbelMorgensternCopula(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data of dimension 2.
        param : sequence of float
           The parameter :math:`\theta`.

        Returns
        -------
        copula : :class:`~openturns.FarlieGumbelMorgensternCopula`
            The estimated copula as a FarlieGumbelMorgenstern copula.

            In the first usage, the default FarlieGumbelMorgenstern copula is built.
        """
        return _model_copula.FarlieGumbelMorgensternCopulaFactory_buildAsFarlieGumbelMorgensternCopula(self, *args)

    def __init__(self, *args):
        _model_copula.FarlieGumbelMorgensternCopulaFactory_swiginit(self, _model_copula.new_FarlieGumbelMorgensternCopulaFactory(*args))
    __swig_destroy__ = _model_copula.delete_FarlieGumbelMorgensternCopulaFactory

# Register FarlieGumbelMorgensternCopulaFactory in _model_copula:
_model_copula.FarlieGumbelMorgensternCopulaFactory_swigregister(FarlieGumbelMorgensternCopulaFactory)
class FrankCopula(ArchimedeanCopula):
    r"""
    Frank copula.

    Parameters
    ----------
    theta : float
        Parameter :math:`\theta`, :math:`\theta \in \Rset`.

        Default value is 2.0.

    Notes
    -----
    The Frank copula is a bivariate symmetric Archimedean copula defined by:

    .. math::

        C(u_1, u_2) = -\frac{1}{\theta}
                      log \left( 1 +
                                 \frac{(e^{-\theta u_1} - 1)(e^{-\theta u_2} - 1)}
                                      {e^{-\theta} - 1}
                          \right)

    for :math:`(u_1, u_2) \in [0, 1]^2`

    And its generator is:

    .. math::

        \varphi(t) = -\log \left( \frac{e^{-\theta t}-1}{e^{-\theta}-1} \right)

    See also
    --------
    ArchimedeanCopula

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.FrankCopula(2.5)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.FrankCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.FrankCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.FrankCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.FrankCopula___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.FrankCopula_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.FrankCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.FrankCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.FrankCopula_computeCDF(self, *args)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _model_copula.FrankCopula_getSpearmanCorrelation(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.FrankCopula_getKendallTau(self)

    def computePDFGradient(self, point):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.FrankCopula_computePDFGradient(self, point)

    def computeCDFGradient(self, point):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.FrankCopula_computeCDFGradient(self, point)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.FrankCopula_computeQuantile(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.FrankCopula_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.FrankCopula_computeConditionalQuantile(self, *args)

    def computeArchimedeanGenerator(self, t):
        r"""
        Compute the Archimedean generator :math:`\varphi`.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The Archimedean generator :math:`\varphi`.
        """
        return _model_copula.FrankCopula_computeArchimedeanGenerator(self, t)

    def computeInverseArchimedeanGenerator(self, t):
        r"""
        Compute the inverse of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
             :math:`\varphi^{-1}` the inverse of the Archimedean generator.
        """
        return _model_copula.FrankCopula_computeInverseArchimedeanGenerator(self, t)

    def computeArchimedeanGeneratorDerivative(self, t):
        r"""
        Compute the derivative of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The derivative of the Archimedean generator :math:`\varphi`.
        """
        return _model_copula.FrankCopula_computeArchimedeanGeneratorDerivative(self, t)

    def computeArchimedeanGeneratorSecondDerivative(self, t):
        r"""
        Compute the seconde derivative of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The seconde derivative of the Archimedean generator :math:`\varphi`.
        """
        return _model_copula.FrankCopula_computeArchimedeanGeneratorSecondDerivative(self, t)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.FrankCopula_hasIndependentCopula(self)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.FrankCopula_computeEntropy(self)

    def computeUpperTailDependenceMatrix(self):
        r"""
        Compute the upper tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper tail dependence matrix is :math:`(\chi^{ij})_{1 \leq i, j \leq d}` where :math:`\chi^{ij}` is
        the upper tail dependence coefficient of the bivariate distribution :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi^{ij} = \lim_{u \to 1} \chi^{ij}(u)

        where  :math:`u \mapsto \chi^{ij}(u)` is the upper tail dependence function of the bivariate distribution
        :math:`(X_i, X_j)` defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chi = copula.computeUpperTailDependenceMatrix()[1, 0]
        """
        return _model_copula.FrankCopula_computeUpperTailDependenceMatrix(self)

    def computeLowerTailDependenceMatrix(self):
        r"""
        Compute the lower tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower tail dependence matrix is :math:`(\chi_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\chi_L^{ij}` is the lower tail dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi_L^{ij} = \lim_{u \to 0} \chi_L^{ij}(u)

        where  :math:`u \mapsto \chi_L^{ij}(u)` is the lower tail dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiL = copula.computeLowerTailDependenceMatrix()[1, 0]
        """
        return _model_copula.FrankCopula_computeLowerTailDependenceMatrix(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.FrankCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.FrankCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.FrankCopula_getParameterDescription(self)

    def setTheta(self, theta):
        r"""
        Set the parameter :math:`\theta`.

        Parameters
        ----------
        theta : float
            Parameter :math:`\theta` of the copula.
        """
        return _model_copula.FrankCopula_setTheta(self, theta)

    def getTheta(self):
        r"""
        Get the parameter :math:`\theta`.

        Returns
        -------
        theta : float
            Parameter :math:`\theta` of the copula.
        """
        return _model_copula.FrankCopula_getTheta(self)

    def __init__(self, *args):
        _model_copula.FrankCopula_swiginit(self, _model_copula.new_FrankCopula(*args))
    __swig_destroy__ = _model_copula.delete_FrankCopula

# Register FrankCopula in _model_copula:
_model_copula.FrankCopula_swigregister(FrankCopula)
class FrankCopulaFactory(DistributionFactoryImplementation):
    r"""
    Frank Copula factory.

    Notes
    -----
    The parameters are estimated using the following equations:

    :math:`\Hat{\theta}_n` is solution of

    .. math::

        \displaystyle \Hat{\tau}_n = 1-4\left( \frac{1-D(\Hat{\theta}_n, 1)^{\strut}}{\theta} \right)

    where :math:`D` is the Debye function defined as

    .. math::

        \displaystyle D(x, n)=\frac{n}{x^n}\int_0^x \frac{t^n}{e^t-1_{\strut}} dt

    See also
    --------
    DistributionFactory, FrankCopula
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.FrankCopulaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula.FrankCopulaFactory_build(self, *args)

    def buildAsFrankCopula(self, *args):
        r"""
        Estimate the copula as native copula.

        **Available usages**:

            buildAsFrankCopula()

            buildAsFrankCopula(*sample*)

            buildAsFrankCopula(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data of dimension 2.
        param : sequence of float of size 1
           The parameter :math:`\theta`.

        Returns
        -------
        copula : :class:`~openturns.FrankCopula`
            The estimated copula as a Frank copula.

            In the first usage, the default Frank copula is built.
        """
        return _model_copula.FrankCopulaFactory_buildAsFrankCopula(self, *args)

    def __init__(self, *args):
        _model_copula.FrankCopulaFactory_swiginit(self, _model_copula.new_FrankCopulaFactory(*args))
    __swig_destroy__ = _model_copula.delete_FrankCopulaFactory

# Register FrankCopulaFactory in _model_copula:
_model_copula.FrankCopulaFactory_swigregister(FrankCopulaFactory)
class ClaytonCopula(ArchimedeanCopula):
    r"""
    Clayton copula.

    Parameters
    ----------
    theta : float
        Parameter :math:`\theta`, :math:`\theta \geq -1`.

        Default value is 2.0.

    Notes
    -----
    The Clayton copula is a bivariate asymmmetric Archimedean copula, exhibiting
    greater dependence in the negative tail than in the positive. It is defined by:

    .. math::

        C(u_1, u_2) = (u_1^{-\theta} + u_2^{-\theta} - 1)^{-1/\theta}

    for :math:`(u_1, u_2) \in [0, 1]^2`

    And its generator is:

    .. math::

        \varphi(t) = \frac{1}{\theta} (t^{-\theta} - 1)

    The support of the copula is :math:`\{ (u,v)\in [0,1]^2, u^{-\theta} +  v^{-\theta} \geq 1 \}`. 

    If :math:`\theta <0`, the support is strictly included in :math:`[0,1]^2` and the frontier defined by :math:`\{ (u,v)\in [0,1]^2, u^{-\theta} +  v^{-\theta} = 1 \}` has a mass not equal to zero. In that case, the copula is a non strict archimedean copula.

    See also
    --------
    ArchimedeanCopula

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.ClaytonCopula(2.5)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.ClaytonCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.ClaytonCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.ClaytonCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.ClaytonCopula___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.ClaytonCopula_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.ClaytonCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.ClaytonCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.ClaytonCopula_computeCDF(self, *args)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.ClaytonCopula_getKendallTau(self)

    def computePDFGradient(self, point):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.ClaytonCopula_computePDFGradient(self, point)

    def computeCDFGradient(self, point):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.ClaytonCopula_computeCDFGradient(self, point)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.ClaytonCopula_computeQuantile(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.ClaytonCopula_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.ClaytonCopula_computeConditionalQuantile(self, *args)

    def computeArchimedeanGenerator(self, t):
        r"""
        Compute the Archimedean generator :math:`\varphi`.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The Archimedean generator :math:`\varphi`.
        """
        return _model_copula.ClaytonCopula_computeArchimedeanGenerator(self, t)

    def computeInverseArchimedeanGenerator(self, t):
        r"""
        Compute the inverse of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
             :math:`\varphi^{-1}` the inverse of the Archimedean generator.
        """
        return _model_copula.ClaytonCopula_computeInverseArchimedeanGenerator(self, t)

    def computeArchimedeanGeneratorDerivative(self, t):
        r"""
        Compute the derivative of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The derivative of the Archimedean generator :math:`\varphi`.
        """
        return _model_copula.ClaytonCopula_computeArchimedeanGeneratorDerivative(self, t)

    def computeArchimedeanGeneratorSecondDerivative(self, t):
        r"""
        Compute the seconde derivative of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The seconde derivative of the Archimedean generator :math:`\varphi`.
        """
        return _model_copula.ClaytonCopula_computeArchimedeanGeneratorSecondDerivative(self, t)

    def computeUpperTailDependenceMatrix(self):
        r"""
        Compute the upper tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper tail dependence matrix is :math:`(\chi^{ij})_{1 \leq i, j \leq d}` where :math:`\chi^{ij}` is
        the upper tail dependence coefficient of the bivariate distribution :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi^{ij} = \lim_{u \to 1} \chi^{ij}(u)

        where  :math:`u \mapsto \chi^{ij}(u)` is the upper tail dependence function of the bivariate distribution
        :math:`(X_i, X_j)` defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chi = copula.computeUpperTailDependenceMatrix()[1, 0]
        """
        return _model_copula.ClaytonCopula_computeUpperTailDependenceMatrix(self)

    def computeLowerTailDependenceMatrix(self):
        r"""
        Compute the lower tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower tail dependence matrix is :math:`(\chi_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\chi_L^{ij}` is the lower tail dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi_L^{ij} = \lim_{u \to 0} \chi_L^{ij}(u)

        where  :math:`u \mapsto \chi_L^{ij}(u)` is the lower tail dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiL = copula.computeLowerTailDependenceMatrix()[1, 0]
        """
        return _model_copula.ClaytonCopula_computeLowerTailDependenceMatrix(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.ClaytonCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.ClaytonCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.ClaytonCopula_getParameterDescription(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.ClaytonCopula_hasIndependentCopula(self)

    def setTheta(self, theta):
        r"""
        Set the parameter :math:`\theta`.

        Parameters
        ----------
        theta : float
            Parameter :math:`\theta` of the copula.
        """
        return _model_copula.ClaytonCopula_setTheta(self, theta)

    def getTheta(self):
        r"""
        Get the parameter :math:`\theta`.

        Returns
        -------
        theta : float
            Parameter :math:`\theta` of the copula.
        """
        return _model_copula.ClaytonCopula_getTheta(self)

    def __init__(self, *args):
        _model_copula.ClaytonCopula_swiginit(self, _model_copula.new_ClaytonCopula(*args))
    __swig_destroy__ = _model_copula.delete_ClaytonCopula

# Register ClaytonCopula in _model_copula:
_model_copula.ClaytonCopula_swigregister(ClaytonCopula)
class ClaytonCopulaFactory(DistributionFactoryImplementation):
    r"""
    Clayton Copula factory.

    Notes
    -----
    We use the following estimator:

    .. math::

        \displaystyle\Hat{\theta}_n=\frac{2\Hat{\tau}_n^{\strut}}{1_{\strut} - \Hat{\tau}_n}

    See also
    --------
    DistributionFactory, ClaytonCopula
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.ClaytonCopulaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula.ClaytonCopulaFactory_build(self, *args)

    def buildAsClaytonCopula(self, *args):
        r"""
        Estimate the copula as native copula.

        **Available usages**:

            buildAsClaytonCopula()

            buildAsClaytonCopula(*sample*)

            buildAsClaytonCopula(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data of dimension 2.
        param : sequence of float of size 1
           The parameter :math:`\theta`.

        Returns
        -------
        copula : :class:`~openturns.ClaytonCopula`
            The estimated copula as a Clayton copula.

            In the first usage, the default Clayton copula is built.
        """
        return _model_copula.ClaytonCopulaFactory_buildAsClaytonCopula(self, *args)

    def __init__(self, *args):
        _model_copula.ClaytonCopulaFactory_swiginit(self, _model_copula.new_ClaytonCopulaFactory(*args))
    __swig_destroy__ = _model_copula.delete_ClaytonCopulaFactory

# Register ClaytonCopulaFactory in _model_copula:
_model_copula.ClaytonCopulaFactory_swigregister(ClaytonCopulaFactory)
class GumbelCopula(ArchimedeanCopula):
    r"""
    Gumbel copula.

    Parameters
    ----------
    theta : float
        Parameter :math:`\theta`, :math:`\theta \geq 1`.

        Default value is 2.0.

    Notes
    -----
    The Gumbel copula is a bivariate asymmetric Archimedean copula, exhibiting
    greater dependence in the positive tail than in the negative. It is defined by:

    .. math::

        C(u_1, u_2) = \exp(-((-log(u_1))^{\theta} + (-log(u_2))^{\theta}))^{1/\theta})

    for :math:`(u_1, u_2) \in [0, 1]^2`

    And its generator is:

    .. math::

        \varphi(t) = (-\log(t))^{\theta}

    See also
    --------
    ArchimedeanCopula

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.GumbelCopula(2.5)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.GumbelCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.GumbelCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.GumbelCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.GumbelCopula___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.GumbelCopula_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.GumbelCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.GumbelCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.GumbelCopula_computeCDF(self, *args)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.GumbelCopula_getKendallTau(self)

    def computePDFGradient(self, point):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.GumbelCopula_computePDFGradient(self, point)

    def computeCDFGradient(self, point):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.GumbelCopula_computeCDFGradient(self, point)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.GumbelCopula_computeQuantile(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.GumbelCopula_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.GumbelCopula_computeConditionalQuantile(self, *args)

    def computeArchimedeanGenerator(self, t):
        r"""
        Compute the Archimedean generator :math:`\varphi`.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The Archimedean generator :math:`\varphi`.
        """
        return _model_copula.GumbelCopula_computeArchimedeanGenerator(self, t)

    def computeInverseArchimedeanGenerator(self, t):
        r"""
        Compute the inverse of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
             :math:`\varphi^{-1}` the inverse of the Archimedean generator.
        """
        return _model_copula.GumbelCopula_computeInverseArchimedeanGenerator(self, t)

    def computeArchimedeanGeneratorDerivative(self, t):
        r"""
        Compute the derivative of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The derivative of the Archimedean generator :math:`\varphi`.
        """
        return _model_copula.GumbelCopula_computeArchimedeanGeneratorDerivative(self, t)

    def computeArchimedeanGeneratorSecondDerivative(self, t):
        r"""
        Compute the seconde derivative of the Archimedean generator.

        Parameters
        ----------
        t : float

        Returns
        -------
        result : float
            The seconde derivative of the Archimedean generator :math:`\varphi`.
        """
        return _model_copula.GumbelCopula_computeArchimedeanGeneratorSecondDerivative(self, t)

    def computeUpperTailDependenceMatrix(self):
        r"""
        Compute the upper tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper tail dependence matrix is :math:`(\chi^{ij})_{1 \leq i, j \leq d}` where :math:`\chi^{ij}` is
        the upper tail dependence coefficient of the bivariate distribution :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi^{ij} = \lim_{u \to 1} \chi^{ij}(u)

        where  :math:`u \mapsto \chi^{ij}(u)` is the upper tail dependence function of the bivariate distribution
        :math:`(X_i, X_j)` defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chi = copula.computeUpperTailDependenceMatrix()[1, 0]
        """
        return _model_copula.GumbelCopula_computeUpperTailDependenceMatrix(self)

    def computeLowerTailDependenceMatrix(self):
        r"""
        Compute the lower tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower tail dependence matrix is :math:`(\chi_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\chi_L^{ij}` is the lower tail dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi_L^{ij} = \lim_{u \to 0} \chi_L^{ij}(u)

        where  :math:`u \mapsto \chi_L^{ij}(u)` is the lower tail dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiL = copula.computeLowerTailDependenceMatrix()[1, 0]
        """
        return _model_copula.GumbelCopula_computeLowerTailDependenceMatrix(self)

    def computeLowerExtremalDependenceMatrix(self):
        r"""
        Compute the lower extremal dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower extremal dependence matrix is :math:`(\bar{\chi}_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\\bar{\chi}_L^{ij}` is the lower extremal dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \bar{\chi}_L^{ij} = \lim_{u \to 0} \bar{\chi}_L^{ij}(u)

        where  :math:`u \mapsto \bar{\chi}_L^{ij}(u)` is the lower extremal dependence function
        of the bivariate distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \bar{\chi}_L(u) = \frac{2 \log u}{\log C(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiLb = copula.computeLowerExtremalDependenceMatrix()[1, 0]
        """
        return _model_copula.GumbelCopula_computeLowerExtremalDependenceMatrix(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.GumbelCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.GumbelCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.GumbelCopula_getParameterDescription(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.GumbelCopula_hasIndependentCopula(self)

    def setTheta(self, theta):
        r"""
        Set the parameter :math:`\theta`.

        Parameters
        ----------
        theta : float, :math:`\theta \geq 1`
            Parameter :math:`\theta` of the copula.
        """
        return _model_copula.GumbelCopula_setTheta(self, theta)

    def getTheta(self):
        r"""
        Get the parameter :math:`\theta`.

        Returns
        -------
        theta : float
            Parameter :math:`\theta` of the copula.
        """
        return _model_copula.GumbelCopula_getTheta(self)

    def __init__(self, *args):
        _model_copula.GumbelCopula_swiginit(self, _model_copula.new_GumbelCopula(*args))
    __swig_destroy__ = _model_copula.delete_GumbelCopula

# Register GumbelCopula in _model_copula:
_model_copula.GumbelCopula_swigregister(GumbelCopula)
class GumbelCopulaFactory(DistributionFactoryImplementation):
    r"""
    Gumbel Copula factory.

    Notes
    -----
    We note :math:`\Hat{\tau}_n` the Kendall-\ :math:`\tau` of the sample.

    We use the following estimator:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle \Hat{\theta}_n=\frac{1^{\strut}}{1 - \Hat{\tau}_{n_{\strut}}}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, GumbelCopula
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.GumbelCopulaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula.GumbelCopulaFactory_build(self, *args)

    def buildAsGumbelCopula(self, *args):
        r"""
        Estimate the copula as native copula.

        **Available usages**:

            buildAsGumbelCopula()

            buildAsGumbelCopula(*sample*)

            buildAsGumbelCopula(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float,
            Data of dimension 2.
        param : sequence of float of size 1,
           The parameter :math:`\theta`.

        Returns
        -------
        copula : :class:`~openturns.GumbelCopula`
            The estimated copula as a Gumbel copula.

            In the first usage, the default Gumbel copula is built.
        """
        return _model_copula.GumbelCopulaFactory_buildAsGumbelCopula(self, *args)

    def __init__(self, *args):
        _model_copula.GumbelCopulaFactory_swiginit(self, _model_copula.new_GumbelCopulaFactory(*args))
    __swig_destroy__ = _model_copula.delete_GumbelCopulaFactory

# Register GumbelCopulaFactory in _model_copula:
_model_copula.GumbelCopulaFactory_swigregister(GumbelCopulaFactory)
class BlockIndependentDistribution(DistributionImplementation):
    r"""
    Merge of a collection of independent distributions.

    Parameters
    ----------
    distributions : list of :class:`~openturns.Distribution`.
        The distributions of the independent blocks.

    Notes
    -----
    Let's :math:`X_1\, \dots, X_K`:math:`K` independent random vectors of respective dimension :math:`n_i \geq 1` and cumulative distribution functions :math:`F_1,\dots, F_K`. The :class:`~openturns.BlockIndependentDistribution` is the distribution of the random vector :math:`X` of dimension :math:`d = n_1 + \dots + n_K` of cumulative distribution function :math:`F` defined by:

    .. math::

        F(x_1, \dots, x_K) = F_1(x_1) \dots F_K(x_K)

    where :math:`x_i\in\Rset^{n_1},\dots,x_K\in\Rset^{n_K}`.


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> R = ot.CorrelationMatrix(2)
    >>> R[0, 1] = 0.5
    >>> d1 = ot.JointDistribution([ot.Uniform(), ot.Triangular(1.0, 2.0, 3.0)], ot.NormalCopula(R))
    >>> d2 = ot.Normal(2)
    >>> collection = [d1, d2]
    >>> dist = ot.BlockIndependentDistribution(collection)

    Get a sample:

    >>> sample = dist.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.BlockIndependentDistribution_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.BlockIndependentDistribution___eq__(self, *args)

    def __repr__(self):
        return _model_copula.BlockIndependentDistribution___repr__(self)

    def __str__(self, *args):
        return _model_copula.BlockIndependentDistribution___str__(self, *args)

    def setDistributionCollection(self, coll):
        r"""
        Accessor to the list of the distributions.

        Parameters
        ----------
        distributions : list of distributions
            The collection of distributions to be merged.
        """
        return _model_copula.BlockIndependentDistribution_setDistributionCollection(self, coll)

    def getDistributionCollection(self):
        r"""
        Accessor to the list of the distributions.

        Returns
        -------
        distributions : list of distributions
            The collection of the distributions to be merged.
        """
        return _model_copula.BlockIndependentDistribution_getDistributionCollection(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.BlockIndependentDistribution_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.BlockIndependentDistribution_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.BlockIndependentDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _model_copula.BlockIndependentDistribution_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.BlockIndependentDistribution_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula.BlockIndependentDistribution_computeProbability(self, interval)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula.BlockIndependentDistribution_computeSurvivalFunction(self, *args)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _model_copula.BlockIndependentDistribution_getSpearmanCorrelation(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.BlockIndependentDistribution_getKendallTau(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.BlockIndependentDistribution_getMarginal(self, *args)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula.BlockIndependentDistribution_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _model_copula.BlockIndependentDistribution_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.BlockIndependentDistribution_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.BlockIndependentDistribution_computeSequentialConditionalCDF(self, x)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.BlockIndependentDistribution_computeConditionalQuantile(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        p : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Sequence of conditional quantiles values at *p*

        Notes
        -----
        The sequential conditional quantile function is defined by:

        .. math::

            \left(F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p_j; x_1, \dots, x_{j-1})\right)_{i=1,\ldots,d}

        where :math:`F^{-1}` is the quantile function and
        where :math:`x_1,\ldots,x_{j-1}` are defined recursively as :math:`x_1=F_1^{-1}(p_1)` and for :math:`2\leq j \leq d`,
        :math:`x_j=F_{X_j}^{-1}(p_j|X_1=x_1,\ldots,X_{j-1}=x_{j-1})`: the conditioning part is the set of already
        computed conditional quantiles.
        """
        return _model_copula.BlockIndependentDistribution_computeSequentialConditionalQuantile(self, q)

    def isCopula(self):
        r"""
        Test whether the distribution is a copula or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A copula is a distribution with uniform margins on [0; 1].
        """
        return _model_copula.BlockIndependentDistribution_isCopula(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _model_copula.BlockIndependentDistribution_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.BlockIndependentDistribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.BlockIndependentDistribution_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.BlockIndependentDistribution_isIntegral(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.BlockIndependentDistribution_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.BlockIndependentDistribution_hasIndependentCopula(self)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.BlockIndependentDistribution_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.BlockIndependentDistribution_getInverseIsoProbabilisticTransformation(self)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.BlockIndependentDistribution_computeEntropy(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.BlockIndependentDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.BlockIndependentDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.BlockIndependentDistribution_getParameterDescription(self)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _model_copula.BlockIndependentDistribution_getSupport(self, *args)

    def getShiftedMoment(self, n, shift):
        r"""
        Accessor to the componentwise shifted moments.

        Parameters
        ----------
        k : int
            The order of the shifted moment.
        shift : sequence of float
            The shift of the moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise central moment of order *k*.

        Notes
        -----
        The moments are centered with respect to the given shift :math:`\vect{s}`:

        .. math::

            \vect{m}^{(k)}_0 = \Tr{\left(\Expect{\left(X_i - s_i\right)^k},
                                         \quad i = 1, \ldots, n\right)}

        See Also
        --------
        getMoment, getCentralMoment
        """
        return _model_copula.BlockIndependentDistribution_getShiftedMoment(self, n, shift)

    def __init__(self, *args):
        _model_copula.BlockIndependentDistribution_swiginit(self, _model_copula.new_BlockIndependentDistribution(*args))
    __swig_destroy__ = _model_copula.delete_BlockIndependentDistribution

# Register BlockIndependentDistribution in _model_copula:
_model_copula.BlockIndependentDistribution_swigregister(BlockIndependentDistribution)
class JointDistribution(DistributionImplementation):
    r"""
    Joint distribution.

    Parameters
    ----------
    distributions : list of :class:`~openturns.Distribution`
        List of :math:`\inputDim` scalar distributions
        called the *instrumental marginals*.

        If *core* is a copula, these distributions are the scalar marginal distributions of the
        joint distribution.
    core : :class:`~openturns.Distribution`, optional
        A distribution over :math:`[0,1]^\inputDim`. 

        By default, the :class:`~openturns.IndependentCopula` of dimension :math:`\inputDim`.

    Notes
    -----
    A :class:`~openturns.JointDistribution` is a multivariate distribution of dimension :math:`\inputDim`,
    which is built from:

    - :math:`\inputDim` scalar distributions whose cumulative distribution functions are
      denoted by :math:`(F_1, \dots, F_\inputDim)`, called the  *instrumental marginals*,
    - and a core :math:`K` which is a multivariate distribution of dimension :math:`\inputDim` whose range is
      included in :math:`[0,1]^\inputDim`.

    The cumulative distribution function :math:`F` of the resulting distribution is written as:

    .. math::

        F(x_1, \cdots, x_\inputDim) = K(F_1(x_1), \cdots, F_\inputDim(x_\inputDim))

    If :math:`K` is a copula :math:`C`, then the  instrumental marginals are the marginal distributions
    of the resulting distribution and we get:

    .. math::

        F(x_1, \cdots, x_\inputDim) = C(F_1(x_1), \cdots, F_\inputDim(x_\inputDim))

    See also
    --------
    SklarCopula

    Examples
    --------
    Use a copula:

    >>> import openturns as ot
    >>> copula = ot.GumbelCopula(2.0)
    >>> marginals = [ot.Uniform(1.0, 2.0), ot.Normal(2.0, 3.0)]
    >>> distribution = ot.JointDistribution(marginals, copula)

    Use a non-copula core:

    >>> core = ot.Dirichlet([2.0, 1.5, 2.5])
    >>> instrumental_marginals = [ot.Uniform(1.0, 2.0), ot.Normal(2.0, 3.0)]
    >>> distribution = ot.JointDistribution(instrumental_marginals, core)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.JointDistribution_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.JointDistribution___eq__(self, *args)

    def __repr__(self):
        return _model_copula.JointDistribution___repr__(self)

    def __str__(self, *args):
        return _model_copula.JointDistribution___str__(self, *args)

    def __repr_markdown__(self):
        return _model_copula.JointDistribution___repr_markdown__(self)

    def _repr_html_(self):
        return _model_copula.JointDistribution__repr_html_(self)

    def setDistributionCollection(self, coll):
        r"""
        Set the instrumental marginals of the distribution.

        Parameters
        ----------
        distributions : list of :class:`~openturns.Distribution`
            List of the instrumental marginals of the distribution.

        Notes
        -----
        If the core :math:`K` is a copula, the instrumental marginals are the marginals of
        the resulting distribution.
        """
        return _model_copula.JointDistribution_setDistributionCollection(self, coll)

    def getDistributionCollection(self):
        r"""
        Get the instrumental marginals of the distribution.

        Returns
        -------
        distributions : list of :class:`~openturns.Distribution`
            List of the instrumental marginals of the distribution.

        Notes
        -----
        If the core :math:`K` is a copula, the instrumental marginals are the marginals of
        the resulting distribution.
        """
        return _model_copula.JointDistribution_getDistributionCollection(self)

    def setCore(self, core):
        r"""
        Set the core of the distribution.

        Parameters
        ----------
        core : :class:`~openturns.Distribution`
            Core :math:`K` of the distribution.

        Notes
        -----
        A core is a multivariate distribution whose range is
        included in the unit hypercube :math:`[0, 1]^\inputDim`.
        It is not always the copula of the distribution.

        """
        return _model_copula.JointDistribution_setCore(self, core)

    def getCore(self):
        r"""
        Get the core of the distribution.

        Returns
        -------
        core : :class:`~openturns.Distribution`
            Core :math:`K` of the distribution.

        Notes
        -----
        A core is a multivariate distribution whose range is
        included in the unit hypercube :math:`[0, 1]^\inputDim`.
        It is not always the copula of the distribution.
        """
        return _model_copula.JointDistribution_getCore(self)

    def setCopula(self, copula):
        r"""
        Set the copula of the distribution.

        Parameters
        ----------
        copula : :class:`~openturns.Distribution`
            Copula of the distribution.

        Notes
        -----
        In that case, the core :math:`K` is the specified copula.
        """
        return _model_copula.JointDistribution_setCopula(self, copula)

    def getCopula(self):
        r"""
        Accessor to the copula of the distribution.

        Returns
        -------
        C : :class:`~openturns.Distribution`
            Copula of the distribution.

        See Also
        --------
        openturns.JointDistribution
        """
        return _model_copula.JointDistribution_getCopula(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.JointDistribution_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.JointDistribution_getSample(self, size)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.JointDistribution_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.JointDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _model_copula.JointDistribution_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.JointDistribution_computeCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula.JointDistribution_computeSurvivalFunction(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula.JointDistribution_computeProbability(self, interval)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.JointDistribution_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.JointDistribution_computeCDFGradient(self, *args)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.JointDistribution_computeQuantile(self, *args)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula.JointDistribution_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _model_copula.JointDistribution_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.JointDistribution_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.JointDistribution_computeSequentialConditionalCDF(self, x)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.JointDistribution_computeConditionalQuantile(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        p : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Sequence of conditional quantiles values at *p*

        Notes
        -----
        The sequential conditional quantile function is defined by:

        .. math::

            \left(F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p_j; x_1, \dots, x_{j-1})\right)_{i=1,\ldots,d}

        where :math:`F^{-1}` is the quantile function and
        where :math:`x_1,\ldots,x_{j-1}` are defined recursively as :math:`x_1=F_1^{-1}(p_1)` and for :math:`2\leq j \leq d`,
        :math:`x_j=F_{X_j}^{-1}(p_j|X_1=x_1,\ldots,X_{j-1}=x_{j-1})`: the conditioning part is the set of already
        computed conditional quantiles.
        """
        return _model_copula.JointDistribution_computeSequentialConditionalQuantile(self, q)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.JointDistribution_computeEntropy(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _model_copula.JointDistribution_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _model_copula.JointDistribution_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _model_copula.JointDistribution_getKurtosis(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.JointDistribution_getMarginal(self, *args)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.JointDistribution_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.JointDistribution_getInverseIsoProbabilisticTransformation(self)

    def getStandardDistribution(self):
        r"""
        Accessor to the standard distribution.

        Returns
        -------
        standard_distribution : :class:`~openturns.Distribution`
            Standard distribution.

        Notes
        -----
        The standard distribution is determined according to the distribution
        properties. This is the target distribution achieved by the iso-probabilistic
        transformation.

        See Also
        --------
        getIsoProbabilisticTransformation
        """
        return _model_copula.JointDistribution_getStandardDistribution(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.JointDistribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.JointDistribution_setParametersCollection(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.JointDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.JointDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.JointDistribution_getParameterDescription(self)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _model_copula.JointDistribution_getSupport(self, *args)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.JointDistribution_hasIndependentCopula(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.JointDistribution_hasEllipticalCopula(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _model_copula.JointDistribution_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.JointDistribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.JointDistribution_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.JointDistribution_isIntegral(self)

    def __init__(self, *args):
        _model_copula.JointDistribution_swiginit(self, _model_copula.new_JointDistribution(*args))
    __swig_destroy__ = _model_copula.delete_JointDistribution

# Register JointDistribution in _model_copula:
_model_copula.JointDistribution_swigregister(JointDistribution)
class ComposedDistribution(JointDistribution):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.ComposedDistribution_getClassName(self)

    def __init__(self, *args):
        _model_copula.ComposedDistribution_swiginit(self, _model_copula.new_ComposedDistribution(*args))
    __swig_destroy__ = _model_copula.delete_ComposedDistribution

# Register ComposedDistribution in _model_copula:
_model_copula.ComposedDistribution_swigregister(ComposedDistribution)
class CumulativeDistributionNetwork(DistributionImplementation):
    r"""
    Graphical model joint distribution.

    Parameters
    ----------
    distributions : list of :class:`~openturns.Distribution`
        List of :math:`n` distributions associated to the red nodes of a bipartite graph.
    graph : :class:`~openturns.BipartiteGraph`
        A bipartite graph. It must have :math:`n` red nodes, and the red node :math:`i` must have a clique of size the dimension of the :math:`i` th distribution.

    Notes
    -----
    A cumulative distribution network (CDN) is a :math:`p`-dimensional distribution which cumulative distribution function is given as a product of lower dimensional cumulative distribution functions:

    .. math::

        F(x_1, \cdots, x_p) = \prod_{i=1}^n(F_i(\vect{x}_i))

    Where :math:`\vect{x}_i` is the vector :math:`(x_{j}, j\in J_i)`, :math:`J_i` being the clique of black nodes linked to the red node :math:`i`.

    The dimension :math:`p` is the cardinal of the union of the cliques, ie the number of black nodes in the bipartite graph.

    Examples
    --------
    >>> import openturns as ot
    >>> graph = ot.BipartiteGraph([[0, 1], [1, 2], [2, 0]])
    >>> distribution = ot.CumulativeDistributionNetwork([ot.Normal(2)]*3, graph)

    Compute the CDF:

    >>> print('%.6f' % distribution.computeCDF([1.0, 2.0, -0.5]))
    0.064354
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.CumulativeDistributionNetwork_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.CumulativeDistributionNetwork___eq__(self, *args)

    def __repr__(self):
        return _model_copula.CumulativeDistributionNetwork___repr__(self)

    def __str__(self, *args):
        return _model_copula.CumulativeDistributionNetwork___str__(self, *args)

    def setDistributionCollection(self, coll):
        r"""
        Set the distributions defining the CDN.

        Parameters
        ----------
        distributions : list of :class:`~openturns.Distribution`
            List of the distributions in the CDN.
        """
        return _model_copula.CumulativeDistributionNetwork_setDistributionCollection(self, coll)

    def getDistributionCollection(self):
        r"""
        Get the distributions defining the CDN.

        Returns
        -------
        distributions : list of :class:`~openturns.Distribution`
            List of the distributions in the CDN.
        """
        return _model_copula.CumulativeDistributionNetwork_getDistributionCollection(self)

    def setGraph(self, graph):
        r"""
        Set the bipartite graph defining the CDN.

        Parameters
        ----------
        graph : a :class:`~openturns.BipartiteGraph`
            The bipartite graph defining the CDN.
        """
        return _model_copula.CumulativeDistributionNetwork_setGraph(self, graph)

    def getGraph(self):
        r"""
        Get the bipartite graph defining the CDN.

        Returns
        -------
        graph : a :class:`~openturns.BipartiteGraph`
            The bipartite graph defining the CDN.
        """
        return _model_copula.CumulativeDistributionNetwork_getGraph(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.CumulativeDistributionNetwork_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.CumulativeDistributionNetwork_getSample(self, size)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.CumulativeDistributionNetwork_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.CumulativeDistributionNetwork_computeCDF(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.CumulativeDistributionNetwork_getMarginal(self, *args)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.CumulativeDistributionNetwork_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.CumulativeDistributionNetwork_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.CumulativeDistributionNetwork_isIntegral(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.CumulativeDistributionNetwork_hasIndependentCopula(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.CumulativeDistributionNetwork_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.CumulativeDistributionNetwork_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.CumulativeDistributionNetwork_getParameterDescription(self)

    def __init__(self, *args):
        _model_copula.CumulativeDistributionNetwork_swiginit(self, _model_copula.new_CumulativeDistributionNetwork(*args))
    __swig_destroy__ = _model_copula.delete_CumulativeDistributionNetwork

# Register CumulativeDistributionNetwork in _model_copula:
_model_copula.CumulativeDistributionNetwork_swigregister(CumulativeDistributionNetwork)
class BlockIndependentCopula(DistributionImplementation):
    r"""
    Merge of a collection of independent copulas.

    Parameters
    ----------
    copulas : list of copulas.
        The collection of copulas to be merged.

    Notes
    -----
    Let's :math:`(C_1\, \dots, C_K)` a collection of :math:`K` copulas respectively defined on :math:`[0,1]^{n_i}` with :math:`n_1 + \dots + n_K = d`.

    The  merged copula :math:`C` is defined on :math:`[0,1]^d` by:

    .. math::

        C(u_1, \dots, u_d) = C_1(u_1, \dots, u_{n_1}) C_2(u_{n_1+1}, \dots, u_{n_2}) \dots C_K(u_{n_1+\dots + n_{K-1}+1}, \dots, u_d) 


    It means that the  subvectors :math:`(u_{n_{i-1}+1}, \dots, u_{n_i})_i` are independent.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> R = ot.CorrelationMatrix(3)
    >>> R[0, 1] = 0.5
    >>> R[0, 2] = 0.25
    >>> collection = [ot.FrankCopula(3.0), ot.NormalCopula(R), ot.ClaytonCopula(2.0)]
    >>> copula = ot.BlockIndependentCopula(collection)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.BlockIndependentCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.BlockIndependentCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.BlockIndependentCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.BlockIndependentCopula___str__(self, *args)

    def setCopulaCollection(self, coll):
        r"""
        Accessor to the list of the copulas.

        Parameters
        ----------
        copulas : list of copulas
            The collection of copulas to be merged.
        """
        return _model_copula.BlockIndependentCopula_setCopulaCollection(self, coll)

    def getCopulaCollection(self):
        r"""
        Accessor to the list of the copulas.

        Returns
        -------
        copulas : list of copulas
            The collection of the copulas to be merged.
        """
        return _model_copula.BlockIndependentCopula_getCopulaCollection(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.BlockIndependentCopula_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.BlockIndependentCopula_getSample(self, size)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.BlockIndependentCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.BlockIndependentCopula_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _model_copula.BlockIndependentCopula_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.BlockIndependentCopula_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula.BlockIndependentCopula_computeProbability(self, interval)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula.BlockIndependentCopula_computeSurvivalFunction(self, *args)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.BlockIndependentCopula_getKendallTau(self)

    def getShapeMatrix(self):
        r"""
        Accessor to the shape matrix of the underlying copula if it is elliptical.

        Returns
        -------
        shape : :class:`~openturns.CorrelationMatrix`
            Shape matrix of the elliptical copula of a distribution.

        Notes
        -----
        This is not the Pearson correlation matrix.

        See Also
        --------
        getPearsonCorrelation
        """
        return _model_copula.BlockIndependentCopula_getShapeMatrix(self)

    def computePDFGradient(self, point):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.BlockIndependentCopula_computePDFGradient(self, point)

    def computeCDFGradient(self, point):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.BlockIndependentCopula_computeCDFGradient(self, point)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.BlockIndependentCopula_getMarginal(self, *args)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula.BlockIndependentCopula_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _model_copula.BlockIndependentCopula_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.BlockIndependentCopula_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.BlockIndependentCopula_computeSequentialConditionalCDF(self, x)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.BlockIndependentCopula_computeConditionalQuantile(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        p : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Sequence of conditional quantiles values at *p*

        Notes
        -----
        The sequential conditional quantile function is defined by:

        .. math::

            \left(F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p_j; x_1, \dots, x_{j-1})\right)_{i=1,\ldots,d}

        where :math:`F^{-1}` is the quantile function and
        where :math:`x_1,\ldots,x_{j-1}` are defined recursively as :math:`x_1=F_1^{-1}(p_1)` and for :math:`2\leq j \leq d`,
        :math:`x_j=F_{X_j}^{-1}(p_j|X_1=x_1,\ldots,X_{j-1}=x_{j-1})`: the conditioning part is the set of already
        computed conditional quantiles.
        """
        return _model_copula.BlockIndependentCopula_computeSequentialConditionalQuantile(self, q)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.BlockIndependentCopula_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.BlockIndependentCopula_setParametersCollection(self, *args)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.BlockIndependentCopula_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.BlockIndependentCopula_hasIndependentCopula(self)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.BlockIndependentCopula_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.BlockIndependentCopula_getInverseIsoProbabilisticTransformation(self)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula.BlockIndependentCopula_computeEntropy(self)

    def __init__(self, *args):
        _model_copula.BlockIndependentCopula_swiginit(self, _model_copula.new_BlockIndependentCopula(*args))
    __swig_destroy__ = _model_copula.delete_BlockIndependentCopula

# Register BlockIndependentCopula in _model_copula:
_model_copula.BlockIndependentCopula_swigregister(BlockIndependentCopula)
class ComposedCopula(BlockIndependentCopula):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.ComposedCopula_getClassName(self)

    def __init__(self, *args):
        _model_copula.ComposedCopula_swiginit(self, _model_copula.new_ComposedCopula(*args))
    __swig_destroy__ = _model_copula.delete_ComposedCopula

# Register ComposedCopula in _model_copula:
_model_copula.ComposedCopula_swigregister(ComposedCopula)
class MarshallOlkinCopula(DistributionImplementation):
    r"""
    MarshallOlkin copula.

    Parameters
    ----------
    alpha : float
        Parameter :math:`\alpha`, :math:`0 \leq \alpha \leq 1`.

        Default value is 0.5.

    beta : float
        Parameter :math:`\beta`, :math:`0 \leq \beta \leq 1`.

        Default value is 0.5.

    Notes
    -----
    The MarshallOlkin copula is a bivariate copula defined by:

    .. math::

        C(u_1, u_2) = 
        \begin{cases}
        u_1^{1-\alpha} u_2, \textrm{ if } u_1^\alpha \geq u_2^\beta \\
        u_1 u_2^{1-\beta}, \textrm{ otherwise.}
        \end{cases}

    for :math:`(u_1, u_2) \in [0, 1]^2`. 

    This copula is also known as the generalized Cuadras-Augé copula.

    Independence corresponds to :math:`\alpha = 0` or :math:`\beta = 0`.

    The minimum copula corresponds to :math:`\alpha = \beta = 1`.

    More details on this copula can be found in [nelsen2006]_, 
    chapter 3, section 3.1.1, page 52,
    or in [dobrolowski2014]_.

    Examples
    --------
    Create a Marshall-Olkin copula with default parameters:

    >>> import openturns as ot
    >>> copula = ot.MarshallOlkinCopula()

    Create a Marshall-Olkin copula:

    >>> import openturns as ot
    >>> copula = ot.MarshallOlkinCopula(0.3,0.7)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.MarshallOlkinCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.MarshallOlkinCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.MarshallOlkinCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.MarshallOlkinCopula___str__(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.MarshallOlkinCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.MarshallOlkinCopula_computeCDF(self, *args)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.MarshallOlkinCopula_hasIndependentCopula(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.MarshallOlkinCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.MarshallOlkinCopula_getParameter(self)

    def setAlpha(self, alpha):
        r"""
        Set the parameter :math:`\alpha`.

        Parameters
        ----------
        alpha : float, :math:`0 \leq \alpha \leq 1`
            Parameter :math:`\alpha` of the copula.
        """
        return _model_copula.MarshallOlkinCopula_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Get the parameter :math:`\alpha`.

        Returns
        -------
        alpha : float
            Parameter :math:`\alpha` of the copula.
        """
        return _model_copula.MarshallOlkinCopula_getAlpha(self)

    def setBeta(self, beta):
        r"""
        Set the parameter :math:`\beta`.

        Parameters
        ----------
        beta : float, :math:`0 \leq \beta \leq 1`
            Parameter :math:`\beta` of the copula.
        """
        return _model_copula.MarshallOlkinCopula_setBeta(self, beta)

    def getBeta(self):
        r"""
        Get the parameter :math:`\beta`.

        Returns
        -------
        beta : float
            Parameter :math:`\beta` of the copula.
        """
        return _model_copula.MarshallOlkinCopula_getBeta(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.MarshallOlkinCopula_getKendallTau(self)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _model_copula.MarshallOlkinCopula_getSpearmanCorrelation(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.MarshallOlkinCopula_getRealization(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.MarshallOlkinCopula_isContinuous(self)

    def __init__(self, *args):
        _model_copula.MarshallOlkinCopula_swiginit(self, _model_copula.new_MarshallOlkinCopula(*args))
    __swig_destroy__ = _model_copula.delete_MarshallOlkinCopula

# Register MarshallOlkinCopula in _model_copula:
_model_copula.MarshallOlkinCopula_swigregister(MarshallOlkinCopula)
class OrdinalSumCopula(DistributionImplementation):
    r"""
    Copula built as an ordinal sum of copulas.

    Parameters
    ----------
    collCopula : list of :class:`~openturns.Distribution`
        The collection :math:`(C_1, \dots, C_n)` of :math:`n` copulas of dimension :math:`d`.

    bounds : sequence of float, of size :math:`n-1` and :math:`0 \leq \alpha_1 \leq \dots \leq \alpha_{n-1} \leq 1`
        The bounds :math:`\alpha_i` are such that the copula :math:`C_i` is
        squeezed into :math:`[\alpha_i, \alpha_{i+1}]`.

    Notes
    -----
    The ordinal sum of the :math:`n` copulas :math:`(C_1, \dots, C_n)`, each one
    being squeezed into the interval :math:`[\alpha_i, \alpha_{i+1}], i=1 \dots n-1`,
    writes:

    .. math::

        C(\vect{u}) = \left\{
        \begin{array}{ll}
           \alpha_i+C_i \left( \dfrac{u_1-\alpha_i}{\alpha_{i+1} - \alpha_i}, \dot,  \dfrac{u_d-\alpha_i}{\alpha_{i+1} - \alpha_i} \right)
               & \mbox{ if } \vect{u} \in [\alpha_i, \alpha_{i+1}[^d \\
           M_d(\vect{u}) & \mbox{ else }
        \end{array}
        \right.

    with :math:`M_d` the Min-copula: :math:`M_d(\vect{u}) = \min_{k=1 \dots d} u_k`
    and where, for convenience, we noted :math:`\alpha_0=0` and :math:`\alpha_n=1`.

    Note that if  :math:`\alpha_i=\alpha_{i+1}` then the copula :math:`C_{i+1}` is
    erased from the list, for :math:`i=0 \dots n-1`.

    See also
    --------
    Distribution

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> ordinalSumCop = ot.OrdinalSumCopula([ot.GumbelCopula(2), ot.NormalCopula(2)], [0.3])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.OrdinalSumCopula_getClassName(self)

    def __init__(self, *args):
        _model_copula.OrdinalSumCopula_swiginit(self, _model_copula.new_OrdinalSumCopula(*args))

    def __eq__(self, *args):
        return _model_copula.OrdinalSumCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.OrdinalSumCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.OrdinalSumCopula___str__(self, *args)

    def setCopulaCollection(self, coll):
        r"""
        Accessor to the collection of copulas.

        Parameters
        ----------
        copColl : list of :class:`~openturns.Distribution` with the same dimension
            List of copulas that build the ordinal sum.
        """
        return _model_copula.OrdinalSumCopula_setCopulaCollection(self, coll)

    def getCopulaCollection(self):
        r"""
        Accessor to the collection of copulas.

        Returns
        -------
        copColl : list of :class:`~openturns.Distribution` with the same dimension
            List of copulas that build the ordinal sum.
        """
        return _model_copula.OrdinalSumCopula_getCopulaCollection(self)

    def setBounds(self, bounds):
        r"""
        Accessor to the collection of bounds.

        Parameters
        ----------
        bounds : sequence of float
            Bounds defining the intervals on whch the copulas of the collection are
            squeezed.
        """
        return _model_copula.OrdinalSumCopula_setBounds(self, bounds)

    def getBounds(self):
        r"""
        Accessor to the collection of bounds.

        Returns
        -------
        bounds : :class:`~openturns.Point`
            Bounds defining the intervals on which the copulas of the collection are
            squeezed.
        """
        return _model_copula.OrdinalSumCopula_getBounds(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.OrdinalSumCopula_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula.OrdinalSumCopula_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.OrdinalSumCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.OrdinalSumCopula_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula.OrdinalSumCopula_computeProbability(self, interval)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula.OrdinalSumCopula_getKendallTau(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.OrdinalSumCopula_getMarginal(self, *args)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula.OrdinalSumCopula_computeConditionalPDF(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.OrdinalSumCopula_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.OrdinalSumCopula_computeConditionalQuantile(self, *args)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.OrdinalSumCopula_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula.OrdinalSumCopula_setParametersCollection(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.OrdinalSumCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.OrdinalSumCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.OrdinalSumCopula_getParameterDescription(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula.OrdinalSumCopula_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.OrdinalSumCopula_hasIndependentCopula(self)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula.OrdinalSumCopula_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula.OrdinalSumCopula_getInverseIsoProbabilisticTransformation(self)
    __swig_destroy__ = _model_copula.delete_OrdinalSumCopula

# Register OrdinalSumCopula in _model_copula:
_model_copula.OrdinalSumCopula_swigregister(OrdinalSumCopula)
class PlackettCopula(DistributionImplementation):
    r"""
    Plackett copula.

    Parameters
    ----------
    theta : float
        Parameter :math:`\theta`, :math:`\theta \geq 0`.

        Default value is 2.0.

    Notes
    -----
    The Plackett copula is a bivariate symmetric copula defined by:

    .. math::

        C(u_1, u_2) = \frac{\left[1+(\theta-1)(u_1+u_2)\right]-
                      \sqrt{\left[1+(\theta-1)(u_1+u_2)\right]^2-
                      4u_1u_2\theta(\theta-1)}}{2(\theta-1)}

    for :math:`(u_1, u_2) \in [0, 1]^2`

    This copula is the only copula with constant *odd ratio* :math:`\theta\geq 0`:

    .. math::

       \theta = \frac{\Prob{U_1\leq u_1,U_2\leq u_2}\Prob{U_1>u_1,U_2>u_2}}{\Prob{U_1\leq u_1,U_2>u_2}\Prob{U_1>u_1,U_2\leq u_2}} = \frac{C(u_1,u_2)\left[1-u_1-u_2+C(u_1,u_2)\right]}{\left[u_1-C(u_1,u_2)\right]\left[u_2-C(u_1,u_2)\right]}

    This is a *comprehensive family* of copulas as it contains:

    - the Frechet lower bound :math:`W(u_1,u_2)=\max(0,u_1+u_2-1)=\lim_{\theta\rightarrow\infty}C(u_1,u_2)`,
    - the Frechet upper bound :math:`M(u_1,u_2)=\min(u_1,u_2)=C_0(u_1,u_2)`
    - the independent copula :math:`\Pi(u_1,u_2)=u_1u_2=C_1(u_1,u_2)`.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> copula = ot.PlackettCopula(2.5)

    Draw a sample:

    >>> sample = copula.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.PlackettCopula_getClassName(self)

    def __eq__(self, *args):
        return _model_copula.PlackettCopula___eq__(self, *args)

    def __repr__(self):
        return _model_copula.PlackettCopula___repr__(self)

    def __str__(self, *args):
        return _model_copula.PlackettCopula___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula.PlackettCopula_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.PlackettCopula_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula.PlackettCopula_computeCDF(self, *args)

    def computePDFGradient(self, point):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula.PlackettCopula_computePDFGradient(self, point)

    def computeCDFGradient(self, point):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula.PlackettCopula_computeCDFGradient(self, point)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula.PlackettCopula_computeQuantile(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula.PlackettCopula_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula.PlackettCopula_computeConditionalQuantile(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula.PlackettCopula_getMarginal(self, *args)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula.PlackettCopula_hasIndependentCopula(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula.PlackettCopula_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula.PlackettCopula_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula.PlackettCopula_getParameterDescription(self)

    def setTheta(self, theta):
        r"""
        Set the parameter :math:`\theta`.

        Parameters
        ----------
        theta : float
            Parameter :math:`\theta\geq 0` of the copula.
        """
        return _model_copula.PlackettCopula_setTheta(self, theta)

    def getTheta(self):
        r"""
        Get the parameter :math:`\theta`.

        Returns
        -------
        theta : float
            Parameter :math:`\theta` of the copula.
        """
        return _model_copula.PlackettCopula_getTheta(self)

    def __init__(self, *args):
        _model_copula.PlackettCopula_swiginit(self, _model_copula.new_PlackettCopula(*args))
    __swig_destroy__ = _model_copula.delete_PlackettCopula

# Register PlackettCopula in _model_copula:
_model_copula.PlackettCopula_swigregister(PlackettCopula)
class PlackettCopulaFactory(DistributionFactoryImplementation):
    r"""
    Plackett Copula factory.

    Notes
    -----
    The parameter is estimated using the following equation:

    :math:`\Hat{\theta}_n` is solution of

    .. math::

        \displaystyle \Hat{\tau}_n = \frac{4m_n^2}{(1-2m_n)^2}

    where :math:`m_n` is the value of the empirical CDF :math:`F_n` at the median point :math:`({U_1}_{\lceil n/2 \rceil},{U_2}_{\lceil n/2 \rceil})` of the sample :math:`({U_1}_k,{U_2}_k)_{k\in\{1,\dots,n\}}`.

    See also
    --------
    DistributionFactory, PlackettCopula
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula.PlackettCopulaFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula.PlackettCopulaFactory_build(self, *args)

    def buildAsPlackettCopula(self, *args):
        r"""
        Estimate the copula as native copula.

        **Available usages**:

            buildAsPlackettCopula()

            buildAsPlackettCopula(*sample*)

            buildAsPlackettCopula(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data of dimension 2.
        param : sequence of float of size 1
           The parameter :math:`\theta`.

        Returns
        -------
        copula : :class:`~openturns.PlackettCopula`
            The estimated copula as a Plackett copula.

            In the first usage, the default Plackett copula is built.
        """
        return _model_copula.PlackettCopulaFactory_buildAsPlackettCopula(self, *args)

    def __init__(self, *args):
        _model_copula.PlackettCopulaFactory_swiginit(self, _model_copula.new_PlackettCopulaFactory(*args))
    __swig_destroy__ = _model_copula.delete_PlackettCopulaFactory

# Register PlackettCopulaFactory in _model_copula:
_model_copula.PlackettCopulaFactory_swigregister(PlackettCopulaFactory)
class _DistributionFactoryImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_model_copula._DistributionFactoryImplementationPointer_ptr__get, _model_copula._DistributionFactoryImplementationPointer_ptr__set)

    def __init__(self, *args):
        _model_copula._DistributionFactoryImplementationPointer_swiginit(self, _model_copula.new__DistributionFactoryImplementationPointer(*args))
    __swig_destroy__ = _model_copula.delete__DistributionFactoryImplementationPointer

    def reset(self):
        return _model_copula._DistributionFactoryImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _model_copula._DistributionFactoryImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _model_copula._DistributionFactoryImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _model_copula._DistributionFactoryImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _model_copula._DistributionFactoryImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _model_copula._DistributionFactoryImplementationPointer_get(self)

    def getImplementation(self):
        return _model_copula._DistributionFactoryImplementationPointer_getImplementation(self)

    def unique(self):
        return _model_copula._DistributionFactoryImplementationPointer_unique(self)

    def use_count(self):
        return _model_copula._DistributionFactoryImplementationPointer_use_count(self)

    def swap(self, other):
        return _model_copula._DistributionFactoryImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula._DistributionFactoryImplementationPointer_getClassName(self)

    def __repr__(self):
        return _model_copula._DistributionFactoryImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _model_copula._DistributionFactoryImplementationPointer___str__(self, *args)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _model_copula._DistributionFactoryImplementationPointer_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _model_copula._DistributionFactoryImplementationPointer_buildEstimator(self, *args)

    def getBootstrapSize(self):
        r"""
        Accessor to the bootstrap size.

        Returns
        -------
        size : int
            Size of the bootstrap.
        """
        return _model_copula._DistributionFactoryImplementationPointer_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Accessor to the bootstrap size.

        Parameters
        ----------
        size : int
            The size of the bootstrap.
        """
        return _model_copula._DistributionFactoryImplementationPointer_setBootstrapSize(self, bootstrapSize)

    def setKnownParameter(self, values, positions):
        r"""
        Accessor to the known parameters.

        Parameters
        ----------
        values : sequence of float
            Values of known parameters.
        positions : sequence of int
            Indices of known parameters.

        Examples
        --------
        When a subset of the parameter vector is known, the other parameters only have to be estimated 
        from data. 

        In the following example, we consider a sample and want to fit 
        a :class:`~openturns.Beta` distribution.  
        We assume that the :math:`a` and :math:`b` parameters are known beforehand. 
        In this case, we set the third parameter (at index 2) to -1 
        and the fourth parameter (at index 3) to 1. 

        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Beta(2.3, 2.2, -1.0, 1.0)
        >>> sample = distribution.getSample(10)
        >>> factory = ot.BetaFactory()
        >>> # set (a,b) out of (r, t, a, b)
        >>> factory.setKnownParameter([-1.0, 1.0], [2, 3])
        >>> inf_distribution = factory.build(sample)
        """
        return _model_copula._DistributionFactoryImplementationPointer_setKnownParameter(self, values, positions)

    def getKnownParameterValues(self):
        r"""
        Accessor to the known parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            Values of known parameters.
        """
        return _model_copula._DistributionFactoryImplementationPointer_getKnownParameterValues(self)

    def getKnownParameterIndices(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of the known parameters.
        """
        return _model_copula._DistributionFactoryImplementationPointer_getKnownParameterIndices(self)

    def __eq__(self, other):
        return _model_copula._DistributionFactoryImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _model_copula._DistributionFactoryImplementationPointer___ne__(self, other)

    def __repr_markdown__(self):
        return _model_copula._DistributionFactoryImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _model_copula._DistributionFactoryImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _model_copula._DistributionFactoryImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _model_copula._DistributionFactoryImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _model_copula._DistributionFactoryImplementationPointer_setName(self, name)

# Register _DistributionFactoryImplementationPointer in _model_copula:
_model_copula._DistributionFactoryImplementationPointer_swigregister(_DistributionFactoryImplementationPointer)
class _DistributionImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_model_copula._DistributionImplementationPointer_ptr__get, _model_copula._DistributionImplementationPointer_ptr__set)

    def __init__(self, *args):
        _model_copula._DistributionImplementationPointer_swiginit(self, _model_copula.new__DistributionImplementationPointer(*args))
    __swig_destroy__ = _model_copula.delete__DistributionImplementationPointer

    def reset(self):
        return _model_copula._DistributionImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _model_copula._DistributionImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _model_copula._DistributionImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _model_copula._DistributionImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _model_copula._DistributionImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _model_copula._DistributionImplementationPointer_get(self)

    def getImplementation(self):
        return _model_copula._DistributionImplementationPointer_getImplementation(self)

    def unique(self):
        return _model_copula._DistributionImplementationPointer_unique(self)

    def use_count(self):
        return _model_copula._DistributionImplementationPointer_use_count(self)

    def swap(self, other):
        return _model_copula._DistributionImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_copula._DistributionImplementationPointer_getClassName(self)

    def __eq__(self, *args):
        return _model_copula._DistributionImplementationPointer___eq__(self, *args)

    def __ne__(self, *args):
        return _model_copula._DistributionImplementationPointer___ne__(self, *args)

    def __add__(self, *args):
        return _model_copula._DistributionImplementationPointer___add__(self, *args)

    def __sub__(self, *args):
        return _model_copula._DistributionImplementationPointer___sub__(self, *args)

    def __mul__(self, *args):
        return _model_copula._DistributionImplementationPointer___mul__(self, *args)

    def __truediv__(self, *args):
        return _model_copula._DistributionImplementationPointer___truediv__(self, *args)
    __div__ = __truediv__



    def cos(self):
        r"""
        Transform distribution by cosine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_cos(self)

    def sin(self):
        r"""
        Transform distribution by sine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_sin(self)

    def tan(self):
        r"""
        Transform distribution by tangent function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_tan(self)

    def acos(self):
        r"""
        Transform distribution by arccosine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_acos(self)

    def asin(self):
        r"""
        Transform distribution by arcsine function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_asin(self)

    def atan(self):
        r"""
        Transform distribution by arctangent function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_atan(self)

    def cosh(self):
        r"""
        Transform distribution by cosh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_cosh(self)

    def sinh(self):
        r"""
        Transform distribution by sinh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_sinh(self)

    def tanh(self):
        r"""
        Transform distribution by tanh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_tanh(self)

    def acosh(self):
        r"""
        Transform distribution by acosh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_acosh(self)

    def asinh(self):
        r"""
        Transform distribution by asinh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_asinh(self)

    def atanh(self):
        r"""
        Transform distribution by atanh function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_atanh(self)

    def exp(self):
        r"""
        Transform distribution by exponential function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_exp(self)

    def log(self):
        r"""
        Transform distribution by natural logarithm function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_log(self)

    def ln(self):
        r"""
        Transform distribution by natural logarithm function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_ln(self)

    def inverse(self):
        r"""
        Transform distribution by inverse function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_inverse(self)

    def sqr(self):
        r"""
        Transform distribution by square function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_sqr(self)

    def sqrt(self):
        r"""
        Transform distribution by square root function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_sqrt(self)

    def cbrt(self):
        r"""
        Transform distribution by cubic root function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_cbrt(self)

    def abs(self):
        r"""
        Transform distribution by absolute value function.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The transformed distribution.
        """
        return _model_copula._DistributionImplementationPointer_abs(self)

    def __repr__(self):
        return _model_copula._DistributionImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _model_copula._DistributionImplementationPointer___str__(self, *args)

    def _repr_html_(self):
        return _model_copula._DistributionImplementationPointer__repr_html_(self)

    def __repr_markdown__(self):
        return _model_copula._DistributionImplementationPointer___repr_markdown__(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the distribution.

        Returns
        -------
        n : int
            The number of components in the distribution.
        """
        return _model_copula._DistributionImplementationPointer_getDimension(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC
        """
        return _model_copula._DistributionImplementationPointer_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, getSampleByInversion, getSampleByQMC
        """
        return _model_copula._DistributionImplementationPointer_getSample(self, size)

    def getSampleByInversion(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution based on conditional quantiles.

        See Also
        --------
        openturns.Distribution.getRealization
        openturns.RandomGenerator
        openturns.Distribution.getSample
        openturns.Distribution.getSampleByQMC
        """
        return _model_copula._DistributionImplementationPointer_getSampleByInversion(self, size)

    def getSampleByQMC(self, size):
        r"""
        Accessor to a low discrepancy sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A low discrepancy sample of the distribution based on Sobol's sequences
            and conditional quantiles.

        See Also
        --------
        openturns.Distribution.getRealization
        openturns.RandomGenerator
        openturns.Distribution.getSample
        openturns.Distribution.getSampleByInversion
        """
        return _model_copula._DistributionImplementationPointer_getSampleByQMC(self, size)

    def getPDF(self):
        r"""
        Return the PDF as a :class:`~openturns.Function`.

        Returns
        -------
        PDF : :class:`~openturns.Function`
            The PDF of the distribution as a :class:`~openturns.Function` wrapping a copy of the distribution.
        """
        return _model_copula._DistributionImplementationPointer_getPDF(self)

    def getLogPDF(self):
        r"""
        Return the logarithm of the PDF as a :class:`~openturns.Function`.

        Returns
        -------
        logPDF : :class:`~openturns.Function`
            The logarithm of the PDF of the distribution as a :class:`~openturns.Function` wrapping a copy of the distribution.
        """
        return _model_copula._DistributionImplementationPointer_getLogPDF(self)

    def getCDF(self):
        r"""
        Return the CDF as a :class:`~openturns.Function`.

        Returns
        -------
        CDF : :class:`~openturns.FunctionImplementation`
            The CDF of the distribution as a :class:`~openturns.Function` wrapping a copy of the distribution.
        """
        return _model_copula._DistributionImplementationPointer_getCDF(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            The input value where the conditional derivative density function must be evaluated.

        Returns
        -------
        ddf : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value at *x*.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_1},
                         \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_d}\right)},
                \quad \vect{x} \in \Rset^d
        """
        return _model_copula._DistributionImplementationPointer_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value at *x*.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^d F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^d \partial x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula._DistributionImplementationPointer_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d` such that the PDF at this point is non equal to 0.

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF at *x*.
        """
        return _model_copula._DistributionImplementationPointer_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value at *x*.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \Rset^d
        """
        return _model_copula._DistributionImplementationPointer_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value at *x*.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i = 1}^d \left\{X_i \leq x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::
            The complementary CDF is different from the survival function (except for scalar distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _model_copula._DistributionImplementationPointer_computeComplementaryCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        s : float, :class:`~openturns.Point`
            Value of the survival function at point *x*.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` of dimension :math:`d` is defined as follows:

        .. math::

            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i = 1}^d \left\{X_i > x_i \right\}}, \qquad \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function except for
            scalar distributions.

        See Also
        --------
        computeComplementaryCDF
        """
        return _model_copula._DistributionImplementationPointer_computeSurvivalFunction(self, *args)

    def computeInverseSurvivalFunction(self, point):
        r"""
        Compute the inverse survival function.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            Value of the survival function.

        Returns
        -------
        x : :class:`~openturns.Point`
            Point :math:`\vect{x}` such that :math:`S_{\vect{X}}(\vect{x}) = p` with iso-quantile components.

        Notes
        -----
        Among the points :math:`\vect{x}` that satisfy :math:`S_{\vect{X}}(\vect{x}) = p`,
        the method returns the one which also satisfies
        :math:`\Prob{X_1 > x_1}   =  \dots = \Prob{X_d > x_d}`.

        See Also
        --------
        computeQuantile, computeSurvivalFunction
        """
        return _model_copula._DistributionImplementationPointer_computeInverseSurvivalFunction(self, point)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval in :math:`\Rset^d`.

        Returns
        -------
        p : float
            The probability of *interval*.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in :math:`interval`.

        If the interval is rectangular, i.e. if :math:`I = \bigcap\limits_{i=1}^d [a_i, b_i]`, then we have:

        .. math::

            \Prob{\vect{X} \in I} = \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^d` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, d)}` with :math:`c_i \in \{a_i, b_i\}`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _model_copula._DistributionImplementationPointer_computeProbability(self, interval)

    def computeCharacteristicFunction(self, *args):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input *t*.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _model_copula._DistributionImplementationPointer_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input *t*.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _model_copula._DistributionImplementationPointer_computeLogCharacteristicFunction(self, *args)

    def computeGeneratingFunction(self, *args):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input *z*.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _model_copula._DistributionImplementationPointer_computeGeneratingFunction(self, *args)

    def computeLogGeneratingFunction(self, *args):
        r"""
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input *z*.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _model_copula._DistributionImplementationPointer_computeLogGeneratingFunction(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _model_copula._DistributionImplementationPointer_computeEntropy(self)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input *x*.

        Notes
        -----
        Let :math:`\vect{\theta}` be the vector of parameters of the distribution. Then
        the gradient of the probability density function :math:`f_{\vect{X}}` is defined by:

        .. math::

            \left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_1}, \dots, \frac{\partial f_{\vect{X}}(\vect{x})}{\partial \theta_d}\right)
        """
        return _model_copula._DistributionImplementationPointer_computePDFGradient(self, *args)

    def computeLogPDFGradient(self, *args):
        r"""
        Compute the gradient of the log probability density function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the logPDF with respect to the distribution
            parameters at input *x*.
        """
        return _model_copula._DistributionImplementationPointer_computeLogPDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        x : sequence of float
            Point in :math:`\Rset^d`.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at *x*.
        """
        return _model_copula._DistributionImplementationPointer_computeCDFGradient(self, *args)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`p \in [0, 1]`
            A probability.
        tail : bool, optional
            `True` indicates that the order considered is :math:`1-p`.
            Default value is `False`.

        Returns
        -------
        xp : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            If `tail=False`, the quantile of order :math:`p`.
            If `tail=True`, the quantile of order  :math:`1-p`.

        Notes
        -----
        If the underlying variable :math:`X` is scalar, then the quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

             x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset\, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is scalar and discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x) = 0 \}.

        If the underlying variable :math:`\vect{X} = (X_1, \dots, X_d)` is of dimension :math:`d>1`, then
        the quantile of order :math:`p`, denoted by :math:`\vect{x}_p \in \Rset^d`, is such that:

        .. math::

            \begin{aligned}
                F_{\vect{X}}(\vect{x}_p) & =  p \\    
                F_{X_i}(\vect{x}_{p,i}) & =  F_{X_j}(\vect{x}_{p,j}) \quad \forall (i,j)
            \end{aligned}

        where :math:`F_{X_i}` is the :math:`i`-th marginal cdf. The last condition means that the quantile of order :math:`p`
        is such that all the components are associated to the same order of quantile of their margin.

        """
        return _model_copula._DistributionImplementationPointer_computeQuantile(self, *args)

    def computeScalarQuantile(self, prob, tail=False):
        r"""
        Compute the quantile function for univariate distributions.

        Parameters
        ----------
        p : float, :math:`p \in [0; 1]`
            A probability.

        Returns
        -------
        xp : float
            Quantile of order *p*.

        Notes
        -----
        The quantile of order :math:`p`, denoted by :math:`x_p`,
        is defined as the generalized inverse of its cumulative distribution function:

        .. math::

              x_p  = F_X^{-1}(p) = \inf \{ x \in \Rset \, |\, F(x) \geq p \}, \quad 0 \leq p \leq 1.

        If the distribution is discrete, then the quantile of order :math:`p=0` is defined by:

        .. math::

            x_0 = \sup \{ x \in \Rset \, |\, F(x)= 0 \}.

        See Also
        --------
        computeQuantile
        """
        return _model_copula._DistributionImplementationPointer_computeScalarQuantile(self, prob, tail)

    def computeMinimumVolumeInterval(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu` with density function :math:`p`. 

        The minimum volume confidence interval :math:`I^*_{\alpha}` is the Cartesian product
        :math:`I^*_{\alpha} = [a_1, b_1] \times \dots \times [a_d, b_d]` where
        :math:`[a_i, b_i]   = \argmin_{I \in \Rset \, | \, \mu_i(I) = \beta} \lambda_i(I)`
        and :math:`\mu(I^*_{\alpha})  =  \alpha` with :math:`\lambda` is the Lebesgue measure on :math:`\Rset^d`.

        This problem resorts to solving :math:`d` univariate non linear equations: for a fixed value :math:`\beta`, we find each intervals :math:`[a_i, b_i]` such that:

        .. math::
            :nowrap:

            \begin{eqnarray*}
            F_i(b_i) - F_i(a_i) & = & \beta \\
            p_i(b_i) & = & p_i(a_i)
            \end{eqnarray*}

        which consists of finding the bound :math:`a_i` such that:

        .. math::

            p_i(a_i) =  p_i(F_i^{-1}(\beta + F_i(a_i)))

        To find :math:`\beta`, we use the Brent algorithm:  :math:`\mu([\vect{a}(\beta); \vect{b}(\beta)] = g(\beta) = \alpha` with :math:`g` a non linear function.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt = paramDist.computeMinimumVolumeInterval(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula._DistributionImplementationPointer_computeMinimumVolumeInterval(self, prob)

    def computeMinimumVolumeIntervalWithMarginalProbability(self, prob):
        r"""
        Compute the confidence interval with minimum volume.

        Refer to :func:`computeMinimumVolumeInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence interval of the native parameters at level 0.9 with minimum volume:

        >>> ot.ResourceMap.SetAsUnsignedInteger('Distribution-MinimumVolumeLevelSetSamplingSize', 1000)
        >>> confInt, marginalProb = paramDist.computeMinimumVolumeIntervalWithMarginalProbability(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula._DistributionImplementationPointer_computeMinimumVolumeIntervalWithMarginalProbability(self, prob)

    def computeBilateralConfidenceInterval(self, prob):
        r"""
        Compute a bilateral confidence interval.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *alpha*.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu` with density function :math:`p`. 

        The bilateral confidence interval :math:`I^*_{\alpha}` is the Cartesian product
        :math:`I^*_{\alpha} = [a_1, b_1] \times \dots \times [a_d, b_d]`
        such that there exists :math:`\beta \in [0,1]` which satisfies the equations :math:`a_i = F_i^{-1}((1 - \beta) / 2)` and :math:`b_i = F_i^{-1}((1 + \beta) / 2)`
        for all :math:`i` and :math:`\mu(I^*_{\alpha}) = \alpha`.

        Examples
        --------
        We consider a Normal(2) distribution with zero mean, unit standard deviation and independent components.
        We note :math:`\Phi_2` its cdf. Due to
        symetries of the distribution, the bilateral confidence interval is :math:`I^*_{\alpha} = [-a, a] \times \times [-a, a]`
        where :math:`a = \Phi^{-1}((1+\beta)/2)` where :math:`\Phi` is the marginal cdf of each component. Then :math:`\beta` is such that
        :math:`\Phi_2(I^*_{\alpha}) = \alpha`. As :math:`\Phi_2(I^*_{\alpha}) = (2\Phi(a) - 1)^2 = \beta^2`,
        then, :math:`\beta` is equal to :math:`\beta = \sqrt{\alpha} \simeq 0.9486`
        and :math:`a \simeq -1.9488`.

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> confInt = dist.computeBilateralConfidenceInterval(0.9)
        """
        return _model_copula._DistributionImplementationPointer_computeBilateralConfidenceInterval(self, prob)

    def computeBilateralConfidenceIntervalWithMarginalProbability(self, prob):
        r"""
        Compute a bilateral confidence interval.

        Refer to :func:`computeBilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The confidence interval of level *\alpha*.
        beta : float
            The probability :math:`\beta`.

        Examples
        --------
        We consider a Normal(2) distribution with zero mean, unit standard deviation and independent components.
        We note :math:`\Phi_2` its cdf. Due to
        symetries of the distribution, the bilateral confidence interval is :math:`I^*_{\alpha} = [-a, a] \times [-a, a]`
        where :math:`a = \Phi^{-1}((1 + \beta) / 2)` where :math:`\Phi` is the marginal cdf of each 1D marginal standard Gaussian component. Then :math:`\beta` is such that
        :math:`\Phi_2(I^*_{\alpha}) = \alpha`. As :math:`\Phi_2(I^*_{\alpha}) = (2\Phi(a) - 1)^2 = \beta^2`,
        then, :math:`\beta` is equal to :math:`\beta = \sqrt{\alpha} = 0.9486`
        and :math:`a = -1.9488` with 4 significant digits.

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> confInt, beta = dist.computeBilateralConfidenceIntervalWithMarginalProbability(0.9)
        """
        return _model_copula._DistributionImplementationPointer_computeBilateralConfidenceIntervalWithMarginalProbability(self, prob)

    def computeUnilateralConfidenceInterval(self, prob, tail=False):
        r"""
        Compute a unilateral confidence interval.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.
        tail : bool
            `True` indicates the interval is bounded by an lower value.
            `False` indicates the interval is bounded by an upper value.
            Default value is `False`.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The unilateral confidence interval of level :math:`\alpha`.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu`.

        The left unilateral confidence interval :math:`I^*_{\alpha}` is the cartesian product :math:`I^*_{\alpha} = ]-\infty, b_1] \times \dots \times ]-\infty, b_d]` where :math:`b_i = F_i^{-1}(\beta)` for all :math:`i` and which verifies :math:`\mu(I^*_{\alpha}) = \alpha`. 
        It means that :math:`\vect{b}` is the quantile of level :math:`\alpha` of the measure :math:`\mu`, with iso-quantile components.

        The right unilateral confidence interval :math:`I^*_{\alpha}` is the cartesian product :math:`I^*_{\alpha} = ]a_1; +\infty[ \times \dots \times ]a_d; +\infty[` where :math:`a_i = F_i^{-1}(1-\beta)` for all :math:`i` and which verifies :math:`\mu(I^*_{\alpha}) = \alpha`. 
        It means that :math:`S_{\mu}^{-1}(\vect{a}) = \alpha` with iso-quantile components, where :math:`S_{\mu}` is the survival function of the measure :math:`\mu`.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution: 

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the right unilateral confidence interval at level 0.9:

        >>> confInt = paramDist.computeUnilateralConfidenceInterval(0.9)

        Determine the left unilateral confidence interval at level 0.9:

        >>> confInt = paramDist.computeUnilateralConfidenceInterval(0.9, True)

        """
        return _model_copula._DistributionImplementationPointer_computeUnilateralConfidenceInterval(self, prob, tail)

    def computeUnilateralConfidenceIntervalWithMarginalProbability(self, prob, tail):
        r"""
        Compute a unilateral confidence interval.

        Refer to :func:`computeUnilateralConfidenceInterval()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.
        tail : bool
            `True` indicates the interval is bounded by an lower value.
            `False` indicates the interval is bounded by an upper value.
            Default value is `False`.

        Returns
        -------
        confInterval : :class:`~openturns.Interval`
            The unilateral confidence interval of level *alpha*.
        marginalProb : float
            The value :math:`\beta` which is the common marginal probability of each marginal interval.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution: 

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the right unilateral confidence interval at level 0.9:

        >>> confInt, marginalProb = paramDist.computeUnilateralConfidenceIntervalWithMarginalProbability(0.9, False)

        Determine the left unilateral confidence interval at level 0.9:

        >>> confInt, marginalProb = paramDist.computeUnilateralConfidenceIntervalWithMarginalProbability(0.9, True)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula._DistributionImplementationPointer_computeUnilateralConfidenceIntervalWithMarginalProbability(self, prob, tail)

    def computeMinimumVolumeLevelSet(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.

        Notes
        -----
        We consider an absolutely continuous measure :math:`\mu` with density function :math:`p`. 

        The minimum volume confidence domain :math:`A^*_{\alpha}` is the set of minimum volume and which measure is at least :math:`\alpha`. It is defined by:

        .. math::

            A^*_{\alpha} = \argmin_{A \in \Rset^d\, | \, \mu(A) \geq \alpha} \lambda(A)


        where :math:`\lambda` is the Lebesgue measure on :math:`\Rset^d`. Under some general conditions on :math:`\mu` (for example, no flat regions), the set  :math:`A^*_{\alpha}` is unique and realises the minimum: :math:`\mu(A^*_{\alpha}) = \alpha`. We show that :math:`A^*_{\alpha}` writes:

        .. math::

            A^*_{\alpha} = \{ \vect{x} \in \Rset^d \, | \, p(\vect{x}) \geq p_{\alpha} \}

        for a certain :math:`p_{\alpha} >0`.

        If we consider the random variable :math:`Y = p(\vect{X})`, with cumulative distribution function :math:`F_Y`, then :math:`p_{\alpha}` is defined by:

        .. math::

            1-F_Y(p_{\alpha}) = \alpha


        Thus the minimum volume domain of confidence :math:`\alpha` is the interior of the domain which frontier is the :math:`1-\alpha` quantile of :math:`Y`. It can be determined with simulations of :math:`Y`.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9:

        >>> levelSet = paramDist.computeMinimumVolumeLevelSet(0.9)
        >>> ot.ResourceMap.Reload()

        """
        return _model_copula._DistributionImplementationPointer_computeMinimumVolumeLevelSet(self, prob)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure *alpha*.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _model_copula._DistributionImplementationPointer_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def getRange(self):
        r"""
        Accessor to the range of the distribution.

        Returns
        -------
        range : :class:`~openturns.Interval`
            Range of the distribution.

        Notes
        -----
        The *mathematical* range is the smallest closed interval outside of which the
        PDF is zero. The *numerical* range is the interval outside of which the PDF is
        rounded to zero in double precision.

        See Also
        --------
        getSupport
        """
        return _model_copula._DistributionImplementationPointer_getRange(self)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _model_copula._DistributionImplementationPointer_getRoughness(self)

    def getMean(self):
        r"""
        Accessor to the mean.

        Returns
        -------
        k : :class:`~openturns.Point`
            Mean.

        Notes
        -----
        The mean is the first-order moment:

        .. math::

            \vect{\mu} = \Tr{\left(\Expect{X_i}, \quad i = 1, \ldots, n\right)}
        """
        return _model_copula._DistributionImplementationPointer_getMean(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _model_copula._DistributionImplementationPointer_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, d\right)}
        """
        return _model_copula._DistributionImplementationPointer_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _model_copula._DistributionImplementationPointer_getKurtosis(self)

    def getMoment(self, n):
        r"""
        Accessor to the componentwise moments.

        Parameters
        ----------
        k : int
            The order of the moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise moment of order *k*.

        Notes
        -----
        The componentwise moment of order :math:`k` is defined as:

        .. math::

            \vect{m}^{(k)} = \Tr{\left(\Expect{X_i^k}, \quad i = 1, \ldots, d\right)}
        """
        return _model_copula._DistributionImplementationPointer_getMoment(self, n)

    def getCentralMoment(self, n):
        r"""
        Accessor to the componentwise central moments.

        Parameters
        ----------
        k : int
            The order of the central moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise central moment of order *k*.

        Notes
        -----
        Central moments are centered with respect to the first-order moment:

        .. math::

            \vect{m}^{(k)}_0 = \Tr{\left(\Expect{\left(X_i - \mu_i\right)^k},
                                         \quad i = 1, \ldots, n\right)}

        See Also
        --------
        getMoment
        """
        return _model_copula._DistributionImplementationPointer_getCentralMoment(self, n)

    def getShiftedMoment(self, n, shift):
        r"""
        Accessor to the componentwise shifted moments.

        Parameters
        ----------
        k : int
            The order of the shifted moment.
        shift : sequence of float
            The shift of the moment.

        Returns
        -------
        m : :class:`~openturns.Point`
            Componentwise central moment of order *k*.

        Notes
        -----
        The moments are centered with respect to the given shift :math:`\vect{s}`:

        .. math::

            \vect{m}^{(k)}_0 = \Tr{\left(\Expect{\left(X_i - s_i\right)^k},
                                         \quad i = 1, \ldots, n\right)}

        See Also
        --------
        getMoment, getCentralMoment
        """
        return _model_copula._DistributionImplementationPointer_getShiftedMoment(self, n, shift)

    def getCovariance(self):
        r"""
        Accessor to the covariance matrix.

        Returns
        -------
        Sigma : :class:`~openturns.CovarianceMatrix`
            Covariance matrix.

        Notes
        -----
        The covariance is the second-order central moment. It is defined as:

        .. math::

            \mat{\Sigma} & = \Cov{\vect{X}} \\
                         & = \Expect{\left(\vect{X} - \vect{\mu}\right)
                                     \Tr{\left(\vect{X} - \vect{\mu}\right)}}
        """
        return _model_copula._DistributionImplementationPointer_getCovariance(self)

    def getCorrelation(self):
        r"""
         Accessor to the correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            The correlation matrix of the distribution.

        Notes
        -----

        .. math::

           R_{ij} = \dfrac{C_{ij}}{\sigma_i\sigma_j}

        where the :math:`(\sigma_i)` are the margin standard deviations
        and :math:`(C_{ij})` the covariance coefficients.

        """
        return _model_copula._DistributionImplementationPointer_getCorrelation(self)

    def getPearsonCorrelation(self):
        r"""
        Accessor to the Pearson correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Pearson's correlation matrix.

        See Also
        --------
        getCovariance

        Notes
        -----
        Pearson's correlation is defined as the normalized covariance matrix:

        .. math::

            \mat{\rho} & = \left[\frac{\Cov{X_i, X_j}}{\sqrt{\Var{X_i}\Var{X_j}}},
                                 \quad i,j = 1, \ldots, d\right] \\
                       & = \left[\frac{\Sigma_{i,j}}{\sqrt{\Sigma_{i,i}\Sigma_{j,j}}},
                                 \quad i,j = 1, \ldots, d\right]
        """
        return _model_copula._DistributionImplementationPointer_getPearsonCorrelation(self)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, d\right]

        See Also
        --------
        getKendallTau
        """
        return _model_copula._DistributionImplementationPointer_getSpearmanCorrelation(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau : :class:`~openturns.CorrelationMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _model_copula._DistributionImplementationPointer_getKendallTau(self)

    def getShapeMatrix(self):
        r"""
        Accessor to the shape matrix of the underlying copula if it is elliptical.

        Returns
        -------
        shape : :class:`~openturns.CorrelationMatrix`
            Shape matrix of the elliptical copula of a distribution.

        Notes
        -----
        This is not the Pearson correlation matrix.

        See Also
        --------
        getPearsonCorrelation
        """
        return _model_copula._DistributionImplementationPointer_getShapeMatrix(self)

    def getCholesky(self):
        r"""
        Accessor to the Cholesky factor of the covariance matrix.

        Returns
        -------
        L : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix.

        See Also
        --------
        getCovariance
        """
        return _model_copula._DistributionImplementationPointer_getCholesky(self)

    def getInverseCholesky(self):
        r"""
        Accessor to the inverse Cholesky factor of the covariance matrix.

        Returns
        -------
        Linv : :class:`~openturns.TriangularMatrix`
            Inverse Cholesky factor of the covariance matrix.

        See also
        --------
        openturns.Distribution.getCholesky
        """
        return _model_copula._DistributionImplementationPointer_getInverseCholesky(self)

    def isCopula(self):
        r"""
        Test whether the distribution is a copula or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A copula is a distribution with uniform margins on [0; 1].
        """
        return _model_copula._DistributionImplementationPointer_isCopula(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^d

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _model_copula._DistributionImplementationPointer_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula._DistributionImplementationPointer_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula._DistributionImplementationPointer_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula._DistributionImplementationPointer_isIntegral(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _model_copula._DistributionImplementationPointer_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _model_copula._DistributionImplementationPointer_hasIndependentCopula(self)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given *interval*.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the
        collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _model_copula._DistributionImplementationPointer_getSupport(self, *args)

    def getProbabilities(self):
        r"""
        Accessor to the discrete probability levels.

        Returns
        -------
        probabilities : :class:`~openturns.Point`
            The probability levels of a discrete distribution.
        """
        return _model_copula._DistributionImplementationPointer_getProbabilities(self)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities
        (i.e. discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _model_copula._DistributionImplementationPointer_getSingularities(self)

    def computeRadialDistributionCDF(self, radius, tail=False):
        r"""
        Compute the cumulative distribution function of the squared radius.

        For the underlying standard spherical distribution (for elliptical
        distributions only).

        Parameters
        ----------
        r2 : float, :math:`0 \leq R^2`
            Squared radius.

        Returns
        -------
        F : float
            CDF value at input *r2*.

        Notes
        -----
        This is the CDF of the sum of the squared independent, standard, identically
        distributed components:

        .. math::

            R^2 = \sqrt{\sum\limits_{i=1}^n U_i^2}
        """
        return _model_copula._DistributionImplementationPointer_computeRadialDistributionCDF(self, radius, tail)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`0 \leq i < d`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _model_copula._DistributionImplementationPointer_getMarginal(self, *args)

    def getCopula(self):
        r"""
        Accessor to the copula of the distribution.

        Returns
        -------
        C : :class:`~openturns.Distribution`
            Copula of the distribution.

        See Also
        --------
        openturns.JointDistribution
        """
        return _model_copula._DistributionImplementationPointer_getCopula(self)

    def computeConditionalDDF(self, x, y):
        r"""
        Compute the conditional derivative density function of the last component.

        With respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        ddf : float,
            Conditional DDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional derivative density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d^2}{d\,x_j^2}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it reduces to :math:`\dfrac{d^2}{d\,x_1^2}F_{X_1}(x_1)`, ie the DDF of
        the first component at :math:`x_1`.

        See Also
        --------
        computeDDF, computeConditionalCDF
        """
        return _model_copula._DistributionImplementationPointer_computeConditionalDDF(self, x, y)

    def computeSequentialConditionalDDF(self, x):
        r"""
        Compute the sequential conditional derivative density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the DDF.

        Returns
        -------
        ddf : sequence of float
            Conditional DDF values at *x*.

        Notes
        -----
        The sequential conditional derivative density function is defined by:

        .. math::

            \left(\dfrac{d^2}{d\,x_j^2}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})
            \right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d^2}{d\,x_1^2}F_{X_1}(x_1)`.
        """
        return _model_copula._DistributionImplementationPointer_computeSequentialConditionalDDF(self, x)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        xj : float, sequence of float, 
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        cpdf : float, sequence of float
            Conditional PDF at *xd*, given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional probability density function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             \dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _model_copula._DistributionImplementationPointer_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Sequence of conditional PDF values at *x*.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            \left(\dfrac{d}{d\,x_j}F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`\dfrac{d}{d\,x_1}F_{X_1}(x_1)`.
        """
        return _model_copula._DistributionImplementationPointer_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        xj : float, sequence of float
            Conditional CDF input.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        p : float, sequence of float
            Conditional CDF value at  *xj* given *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional cumulative distribution function of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})` is defined by:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
                \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        For :math:`j=1`, it
        reduces to :math:`F_{X_1}(x_1)`.
        """
        return _model_copula._DistributionImplementationPointer_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        x : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at *x*.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            \left(F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1})\right)_{j=1,\ldots,d}

        where for :math:`2 \leq j \leq d`:

        .. math::

            F_{X_j \mid X_1, \ldots, X_{j - 1}}(x_j; x_1, \dots, x_{j-1}) =
            \Prob{X_j \leq x_j \mid X_1=x_1, \ldots, X_{j-1}=x_{j-1}}.

        The first term, for :math:`j=1`, is :math:`F_{X_1}(x_1)`.
        """
        return _model_copula._DistributionImplementationPointer_computeSequentialConditionalCDF(self, x)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`p \in [0, 1]`
            Conditional quantile.
        xcond : sequence of float, 2-d sequence of float with size :math:`j-1`, :math:`j \leq d`
            Conditioning values for the components :math:`(X_{1}, \dots, X_{j-1})`.

        Returns
        -------
        xj : float
            Conditional quantile of order *p* of the component :math:`X_j`
            given that the components of indices :math:`k \leq j-1` are fixed and
            equal to *xcond*.

        Notes
        -----
        Let :math:`\vect{X}` be a random vector of dimension :math:`d`.
        The conditional quantile of order :math:`p` of the component :math:`X_j`
        given that the components of indices :math:`k \leq j-1` are fixed to :math:`(x_1, \dots, x_{j-1})`
        is defined by:

        .. math::

             F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p; x_1, \dots, x_{j-1})

        where :math:`F^{-1}` is the quantile function.
        For :math:`j=1`, it
        reduces to :math:`F^{-1}_{X_1}(p)`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _model_copula._DistributionImplementationPointer_computeConditionalQuantile(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        p : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Sequence of conditional quantiles values at *p*

        Notes
        -----
        The sequential conditional quantile function is defined by:

        .. math::

            \left(F^{-1}_{X_j \mid X_1, \ldots, X_{j - 1}}(p_j; x_1, \dots, x_{j-1})\right)_{i=1,\ldots,d}

        where :math:`F^{-1}` is the quantile function and
        where :math:`x_1,\ldots,x_{j-1}` are defined recursively as :math:`x_1=F_1^{-1}(p_1)` and for :math:`2\leq j \leq d`,
        :math:`x_j=F_{X_j}^{-1}(p_j|X_1=x_1,\ldots,X_{j-1}=x_{j-1})`: the conditioning part is the set of already
        computed conditional quantiles.
        """
        return _model_copula._DistributionImplementationPointer_computeSequentialConditionalQuantile(self, q)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        openturns.Distribution.getInverseIsoProbabilisticTransformation
        openturns.Distribution.isElliptical
        openturns.Distribution.hasEllipticalCopula
        """
        return _model_copula._DistributionImplementationPointer_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        openturns.Distribution.getIsoProbabilisticTransformation
        """
        return _model_copula._DistributionImplementationPointer_getInverseIsoProbabilisticTransformation(self)

    def getStandardDistribution(self):
        r"""
        Accessor to the standard distribution.

        Returns
        -------
        standard_distribution : :class:`~openturns.Distribution`
            Standard distribution.

        Notes
        -----
        The standard distribution is determined according to the distribution
        properties. This is the target distribution achieved by the iso-probabilistic
        transformation.

        See Also
        --------
        getIsoProbabilisticTransformation
        """
        return _model_copula._DistributionImplementationPointer_getStandardDistribution(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution-by-distribution basis, most of the time by
        scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the
        distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using
        generic algorithms of orthonormalization (see :class:`~openturns.StandardDistributionPolynomialFactory`).
        """
        return _model_copula._DistributionImplementationPointer_getStandardRepresentative(self)

    def getIntegrationNodesNumber(self):
        r"""
        Accessor to the number of Gauss integration points.

        Returns
        -------
        N : int
            Number of integration points.
        """
        return _model_copula._DistributionImplementationPointer_getIntegrationNodesNumber(self)

    def setIntegrationNodesNumber(self, integrationNodesNumber):
        r"""
        Accessor to the number of Gauss integration points.

        Parameters
        ----------
        N : int
            Number of integration points.
        """
        return _model_copula._DistributionImplementationPointer_setIntegrationNodesNumber(self, integrationNodesNumber)

    def drawPDF(self, *args):
        r"""
        Draw the graph or of iso-lines of probability density function.

        Available constructors:
            drawPDF(*x_min, x_max, pointNumber, logScale*)

            drawPDF(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawPDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the PDF or its iso_lines.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computePDF

        Examples
        --------
        View the PDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawPDF()
        >>> graph.setLegends(['normal pdf'])

        View the iso-lines PDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawPDF()
        >>> graph2.setLegends(['iso- normal pdf'])
        >>> graph3 = dist.drawPDF([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula._DistributionImplementationPointer_drawPDF(self, *args)

    def drawMarginal1DPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the probability density function of a margin.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale.
            Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the PDF of the requested margin.

        See Also
        --------
        openturns.Distribution.computePDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DPDF(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula._DistributionImplementationPointer_drawMarginal1DPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawMarginal2DPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the probability density function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the first margin of interest.
        j : int, :math:`1 \leq i \neq j \leq d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal PDF of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computePDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DPDF(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula._DistributionImplementationPointer_drawMarginal2DPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawLogPDF(self, *args):
        r"""
        Draw the graph or of iso-lines of log-probability density function.

        Available constructors:
            drawLogPDF(*x_min, x_max, pointNumber, logScale*)

            drawLogPDF(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawLogPDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the log-PDF or its iso_lines.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computeLogPDF
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------
        View the log-PDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawLogPDF()
        >>> graph.setLegends(['normal log-pdf'])

        View the iso-lines log-PDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawLogPDF()
        >>> graph2.setLegends(['iso- normal pdf'])
        >>> graph3 = dist.drawLogPDF([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula._DistributionImplementationPointer_drawLogPDF(self, *args)

    def drawMarginal1DLogPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the log-probability density function of a margin.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the log-PDF of the requested margin.

        See Also
        --------
        openturns.Distribution.computeLogPDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DLogPDF(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula._DistributionImplementationPointer_drawMarginal1DLogPDF(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawMarginal2DLogPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the log-probability density function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the first margin of interest.
        j : int, :math:`1 \leq i \neq j \leq d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal log-PDF of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computeLogPDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DLogPDF(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula._DistributionImplementationPointer_drawMarginal2DLogPDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawCDF(self, *args):
        r"""
        Draw the cumulative distribution function.

        Available constructors:
            drawCDF(*x_min, x_max, pointNumber, logScale*)

            drawCDF(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawCDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the CDF.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computeCDF
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------
        View the CDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawCDF()
        >>> graph.setLegends(['normal cdf'])

        View the iso-lines CDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawCDF()
        >>> graph2.setLegends(['iso- normal cdf'])
        >>> graph3 = dist.drawCDF([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula._DistributionImplementationPointer_drawCDF(self, *args)

    def drawMarginal1DCDF(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the cumulative distribution function of a margin.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the CDF of the requested margin.

        See Also
        --------
        openturns.Distribution.computeCDF
        openturns.Distribution.getMarginal
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------

        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DCDF(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula._DistributionImplementationPointer_drawMarginal1DCDF(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawMarginal2DCDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the cumulative distribution function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`1 \leq i \leq d`
            The index of the first margin of interest.
        j : int, :math:`1 \leq i \neq j \leq d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal CDF of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computeCDF
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DCDF(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula._DistributionImplementationPointer_drawMarginal2DCDF(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawSurvivalFunction(self, *args):
        r"""
        Draw the cumulative distribution function.

        Available constructors:
            drawSurvivalFunction(*x_min, x_max, pointNumber, logScale*)

            drawSurvivalFunction(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawSurvivalFunction(*lowerCorner, upperCorner*)

        Parameters
        ----------
        xMin : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        xMax : float, optional, *xMax > xMin*
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the SurvivalFunction.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        openturns.Distribution.computeSurvivalFunction

        Examples
        --------
        View the SurvivalFunction of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawSurvivalFunction()
        >>> graph.setLegends(['normal cdf'])

        View the iso-lines SurvivalFunction of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawSurvivalFunction()
        >>> graph2.setLegends(['iso- normal cdf'])
        >>> graph3 = dist.drawSurvivalFunction([-10, -5],[5, 10], [511, 511])

        """
        return _model_copula._DistributionImplementationPointer_drawSurvivalFunction(self, *args)

    def drawMarginal1DSurvivalFunction(self, marginalIndex, xMin, xMax, pointNumber, logScale=False):
        r"""
        Draw the cumulative distribution function of a margin.

        Parameters
        ----------
        i : int, :math:`0 \leq i < d`
            The index of the margin of interest.
        xMin : float
            The starting value that is used for meshing the x-axis.
        xMax : float, *xMax > xMin*
            The ending value that is used for meshing the x-axis.
        nPoints : int
            The number of points that is used for meshing the x-axis.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the SurvivalFunction of the requested margin.

        See Also
        --------
        openturns.Distribution.computeSurvivalFunction
        openturns.Distribution.getMarginal
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------

        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal1DSurvivalFunction(2, -6.0, 6.0, 100)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula._DistributionImplementationPointer_drawMarginal1DSurvivalFunction(self, marginalIndex, xMin, xMax, pointNumber, logScale)

    def drawMarginal2DSurvivalFunction(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX=False, logScaleY=False):
        r"""
        Draw the cumulative distribution function of a couple of margins.

        Parameters
        ----------
        i : int, :math:`0 \leq i < d`
            The index of the first margin of interest.
        j : int, :math:`0 \leq i \neq j < d`
            The index of the second margin of interest.
        xMin : list of 2 floats
            The starting values that are used for meshing the x- and y- axes.
        xMax : list of 2 floats, *xMax > xMin*
            The ending values that are used for meshing the x- and y- axes.
        nPoints : list of 2 ints
            The number of points that are used for meshing the x- and y- axes.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the marginal SurvivalFunction of the requested couple of
            margins.

        See Also
        --------
        openturns.Distribution.computeSurvivalFunction
        openturns.Distribution.getMarginal

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal(10)
        >>> graph = distribution.drawMarginal2DSurvivalFunction(2, 3, [-6.0] * 2, [6.0] * 2, [100] * 2)
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula._DistributionImplementationPointer_drawMarginal2DSurvivalFunction(self, firstMarginal, secondMarginal, xMin, xMax, pointNumber, logScaleX, logScaleY)

    def drawQuantile(self, *args):
        r"""
        Draw the quantile function.

        Parameters
        ----------
        qmin : float, in :math:`[0,1]`
            The min value of the mesh of the x-axis.
        qmax : float, in :math:`[0,1]`
            The max value of the mesh of the x-axis.
        nPoints : int, optional
            The number of points that is used for meshing the quantile curve.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the quantile function.

        Notes
        -----
        This is implemented for univariate and bivariate distributions only.
        In the case of bivariate distributions, defined by its CDF :math:`F` and its marginals :math:`(F_1, F_2)`, the quantile of order :math:`q` is the point :math:`(F_1(u),F_2(u))` defined by

        .. math::

            F(F_1(u), F_2(u)) = q


        See Also
        --------
        openturns.Distribution.computeQuantile
        openturns.viewer.View
        openturns.ResourceMap

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> distribution = ot.Normal()
        >>> graph = distribution.drawQuantile()
        >>> view = View(graph)
        >>> view.show()
        >>> distribution = ot.JointDistribution([ot.Normal(), ot.Exponential(1.0)], ot.ClaytonCopula(0.5))
        >>> graph = distribution.drawQuantile()
        >>> view = View(graph)
        >>> view.show()
        """
        return _model_copula._DistributionImplementationPointer_drawQuantile(self, *args)

    def computeUpperTailDependenceMatrix(self):
        r"""
        Compute the upper tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper tail dependence matrix is :math:`(\chi^{ij})_{1 \leq i, j \leq d}` where :math:`\chi^{ij}` is
        the upper tail dependence coefficient of the bivariate distribution :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi^{ij} = \lim_{u \to 1} \chi^{ij}(u)

        where  :math:`u \mapsto \chi^{ij}(u)` is the upper tail dependence function of the bivariate distribution
        :math:`(X_i, X_j)` defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chi = copula.computeUpperTailDependenceMatrix()[1, 0]
        """
        return _model_copula._DistributionImplementationPointer_computeUpperTailDependenceMatrix(self)

    def computeUpperExtremalDependenceMatrix(self):
        r"""
        Compute the upper extremal dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that its copula is
        denoted by :math:`C`.
        The upper extremal dependence matrix is :math:`(\bar{\chi}^{ij})_{1 \leq i, j \leq d}` where
        :math:`\bar{\chi}^{ij}` is the upper extremal dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \bar{\chi}^{ij} = \lim_{u \to 1} \bar{\chi}^{ij}(u)

        where  :math:`u \mapsto \bar{\chi}^{ij}(u)` is the upper extremal dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \bar{\chi}(u) = \frac{2 \log 1-u}{\log \bar{C}(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chib = copula.computeUpperExtremalDependenceMatrix()[1, 0]
        """
        return _model_copula._DistributionImplementationPointer_computeUpperExtremalDependenceMatrix(self)

    def computeLowerTailDependenceMatrix(self):
        r"""
        Compute the lower tail dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower tail dependence matrix is :math:`(\chi_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\chi_L^{ij}` is the lower tail dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \chi_L^{ij} = \lim_{u \to 0} \chi_L^{ij}(u)

        where  :math:`u \mapsto \chi_L^{ij}(u)` is the lower tail dependence function of the bivariate
        distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiL = copula.computeLowerTailDependenceMatrix()[1, 0]
        """
        return _model_copula._DistributionImplementationPointer_computeLowerTailDependenceMatrix(self)

    def computeLowerExtremalDependenceMatrix(self):
        r"""
        Compute the lower extremal dependence coefficients.

        We assume that the distribution is :math:`d`-dimensional, with :math:`d \geq 2` and that
        its copula is denoted by :math:`C`.
        The lower extremal dependence matrix is :math:`(\bar{\chi}_L^{ij})_{1 \leq i, j \leq d}` where
        :math:`\\bar{\chi}_L^{ij}` is the lower extremal dependence coefficient of the bivariate distribution
        :math:`(X_i, X_j)`.
        It is defined by:

        .. math::

            \bar{\chi}_L^{ij} = \lim_{u \to 0} \bar{\chi}_L^{ij}(u)

        where  :math:`u \mapsto \bar{\chi}_L^{ij}(u)` is the lower extremal dependence function
        of the bivariate distribution :math:`(X_i, X_j)` defined by:

        .. math::

            \bar{\chi}_L(u) = \frac{2 \log u}{\log C(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        dep : :class:`~openturns.CorrelationMatrix`
            The dependence matrix.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> chiLb = copula.computeLowerExtremalDependenceMatrix()[1, 0]
        """
        return _model_copula._DistributionImplementationPointer_computeLowerExtremalDependenceMatrix(self)

    def drawUpperTailDependenceFunction(self):
        r"""
        Draw the upper tail dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The upper tail dependence function :math:`u \mapsto \chi(u)` is defined by:

        .. math::

            \chi(u) = 2 - \frac{\log C(u,u)}{\log u}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of the function :math:`u \mapsto \chi(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawUpperTailDependenceFunction()
        """
        return _model_copula._DistributionImplementationPointer_drawUpperTailDependenceFunction(self)

    def drawUpperExtremalDependenceFunction(self):
        r"""
        Draw the upper extremal dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The upper extremal dependence function :math:`u \mapsto \bar{\chi}(u)` is defined by:

        .. math::

            \bar{\chi}(u) = \frac{2 \log 1-u}{\log \bar{C}(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of the function :math:`u \mapsto \bar{\chi}(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawUpperExtremalDependenceFunction()
        """
        return _model_copula._DistributionImplementationPointer_drawUpperExtremalDependenceFunction(self)

    def drawLowerTailDependenceFunction(self):
        r"""
        Draw the lower tail dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The lower tail dependence  function :math:`u \mapsto \chi_L(u)` is defined by:

        .. math::

            \chi_L(u) = \frac{\log (1 - C(u,u))}{\log (1-u)}, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph of the function :math:`u \mapsto \chi_L(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawLowerTailDependenceFunction()
        """
        return _model_copula._DistributionImplementationPointer_drawLowerTailDependenceFunction(self)

    def drawLowerExtremalDependenceFunction(self):
        r"""
        Draw the lower extremal dependence function.

        We assume that the distribution is bivariate and that its copula is denoted by :math:`C`.
        The lower extremal dependence function :math:`u \mapsto \bar{\chi}(u)` is defined by:

        .. math::

            \bar{\chi}_L(u) = \frac{2 \log u}{\log C(u,u)} - 1, \forall u \in [0,1]

        Refer to :ref:`tail_dependence` to get more details.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of the function :math:`u \mapsto \bar{\chi}_L(u)`.

        Examples
        --------
        >>> import openturns as ot
        >>> copula = ot.FrankCopula()
        >>> graph = copula.drawLowerExtremalDependenceFunction()
        """
        return _model_copula._DistributionImplementationPointer_drawLowerExtremalDependenceFunction(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula._DistributionImplementationPointer_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _model_copula._DistributionImplementationPointer_setParametersCollection(self, *args)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _model_copula._DistributionImplementationPointer_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _model_copula._DistributionImplementationPointer_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _model_copula._DistributionImplementationPointer_getParameterDescription(self)

    def getParameterDimension(self):
        r"""
        Accessor to the number of parameters in the distribution.

        Returns
        -------
        n_parameters : int
            Number of parameters in the distribution.

        See Also
        --------
        getParametersCollection
        """
        return _model_copula._DistributionImplementationPointer_getParameterDimension(self)

    def setDescription(self, description):
        r"""
        Accessor to the componentwise description.

        Parameters
        ----------
        description : sequence of str
            Description of the components of the distribution.
        """
        return _model_copula._DistributionImplementationPointer_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the componentwise description.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the components of the distribution.

        See Also
        --------
        setDescription
        """
        return _model_copula._DistributionImplementationPointer_getDescription(self)

    def getPDFEpsilon(self):
        r"""
        Accessor to the PDF computation precision.

        Returns
        -------
        PDFEpsilon : float
            PDF computation precision.
        """
        return _model_copula._DistributionImplementationPointer_getPDFEpsilon(self)

    def getCDFEpsilon(self):
        r"""
        Accessor to the CDF computation precision.

        Returns
        -------
        CDFEpsilon : float
            CDF computation precision.
        """
        return _model_copula._DistributionImplementationPointer_getCDFEpsilon(self)

    def getPositionIndicator(self):
        r"""
        Position indicator accessor.

        Defines a generic metric of the position. When the mean is not defined it falls
        back to the median.
        Available only for 1-d distributions.

        Returns
        -------
        position : float
            Mean or median of the distribution.
        """
        return _model_copula._DistributionImplementationPointer_getPositionIndicator(self)

    def getDispersionIndicator(self):
        r"""
        Dispersion indicator accessor.

        Defines a generic metric of the dispersion. When the standard deviation is not
        defined it falls back to the interquartile.
        Only available for 1-d distributions.

        Returns
        -------
        dispersion : float
            Standard deviation or interquartile.
        """
        return _model_copula._DistributionImplementationPointer_getDispersionIndicator(self)

    def setSupportEpsilon(self, epsilon):
        r"""
        Accessor to the support tolerance for discrete distributions.

        Parameters
        ----------
        epsilon : float
            The support tolerance.
        """
        return _model_copula._DistributionImplementationPointer_setSupportEpsilon(self, epsilon)

    def getSupportEpsilon(self):
        r"""
        Accessor to the support tolerance for discrete distributions.

        Returns
        -------
        epsilon : float
            The support tolerance.
        """
        return _model_copula._DistributionImplementationPointer_getSupportEpsilon(self)

    def __rtruediv__(self, s):
        return _model_copula._DistributionImplementationPointer___rtruediv__(self, s)

    def __rdiv__(self, s):
        return _model_copula._DistributionImplementationPointer___rdiv__(self, s)

    def __pow__(self, s):
        return _model_copula._DistributionImplementationPointer___pow__(self, s)

    def __rsub__(self, s):
        return _model_copula._DistributionImplementationPointer___rsub__(self, s)

    def __neg__(self):
        return _model_copula._DistributionImplementationPointer___neg__(self)

    def __radd__(self, s):
        return _model_copula._DistributionImplementationPointer___radd__(self, s)

    def __rmul__(self, s):
        return _model_copula._DistributionImplementationPointer___rmul__(self, s)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _model_copula._DistributionImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _model_copula._DistributionImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _model_copula._DistributionImplementationPointer_setName(self, name)

# Register _DistributionImplementationPointer in _model_copula:
_model_copula._DistributionImplementationPointer_swigregister(_DistributionImplementationPointer)
class _RandomVectorImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ptr_ = property(_model_copula._RandomVectorImplementationPointer_ptr__get, _model_copula._RandomVectorImplementationPointer_ptr__set)

    def __init__(self, *args):
        _model_copula._RandomVectorImplementationPointer_swiginit(self, _model_copula.new__RandomVectorImplementationPointer(*args))
    __swig_destroy__ = _model_copula.delete__RandomVectorImplementationPointer

    def reset(self):
        return _model_copula._RandomVectorImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _model_copula._RandomVectorImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _model_copula._RandomVectorImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _model_copula._RandomVectorImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _model_copula._RandomVectorImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _model_copula._RandomVectorImplementationPointer_get(self)

    def getImplementation(self):
        return _model_copula._RandomVectorImplementationPointer_getImplementation(self)

    def unique(self):
        return _model_copula._RandomVectorImplementationPointer_unique(self)

    def use_count(self):
        return _model_copula._RandomVectorImplementationPointer_use_count(self)

    def swap(self, other):
        return _model_copula._RandomVectorImplementationPointer_swap(self, other)

# Register _RandomVectorImplementationPointer in _model_copula:
_model_copula._RandomVectorImplementationPointer_swigregister(_RandomVectorImplementationPointer)

