%define OT_Basis_doc
"Basis.

Available constructors:
    Basis(*functionsColl*)

    Basis(*size*)

Parameters
----------
functionsColl : list of :class:`~openturns.Function`
    Functions constituting the Basis.
size : int
    Size of the Basis.

Examples
--------
>>> import openturns as ot
>>> dimension = 3
>>> input = ['x0', 'x1', 'x2']
>>> functions = []
>>> for i in range(dimension):
...     functions.append(ot.SymbolicFunction(input, [input[i]]))
>>> basis = ot.Basis(functions)"
%enddef
%feature("docstring") OT::BasisImplementation
OT_Basis_doc

// ---------------------------------------------------------------------

%define OT_Basis_build_doc
"Build the element of the given index.

Parameters
----------
index : int, :math:`index \\geq 0`
    Index of an element of the Basis.

Returns
-------
function : :class:`~openturns.Function`
    The function at the index *index* of the Basis.

Examples
--------
>>> import openturns as ot
>>> dimension = 3
>>> input = ['x0', 'x1', 'x2']
>>> functions = []
>>> for i in range(dimension):
...     functions.append(ot.SymbolicFunction(input, [input[i]]))
>>> basis = ot.Basis(functions)
>>> print(basis.build(0).getEvaluation())
[x0,x1,x2]->[x0]"
%enddef
%feature("docstring") OT::BasisImplementation::build
OT_Basis_build_doc

// ---------------------------------------------------------------------

%define OT_Basis_getInputDimension_doc
"Get the input dimension of the Basis.

Returns
-------
inDim : int
    Input dimension of the functions."
%enddef
%feature("docstring") OT::BasisImplementation::getInputDimension
OT_Basis_getInputDimension_doc

// ---------------------------------------------------------------------

%define OT_Basis_getOutputDimension_doc
"Get the output dimension of the Basis.

Returns
-------
outDim : int
    Output dimension of the functions."
%enddef
%feature("docstring") OT::BasisImplementation::getOutputDimension
OT_Basis_getOutputDimension_doc

// ---------------------------------------------------------------------

%define OT_Basis_getSize_doc
"Get the size of the Basis.

Returns
-------
size : int
    Size of the Basis."
%enddef
%feature("docstring") OT::BasisImplementation::getSize
OT_Basis_getSize_doc

// ---------------------------------------------------------------------

%define OT_Basis_getSubBasis_doc
"Get a sub-basis of the Basis.

Parameters
----------
indices : list of int
    Indices of the terms of the Basis put in the sub-basis.

Returns
-------
subBasis : list of :class:`~openturns.Function`
    Functions defining a sub-basis.

Examples
--------
>>> import openturns as ot
>>> dimension = 3
>>> input = ['x0', 'x1', 'x2']
>>> functions = []
>>> for i in range(dimension):
...     functions.append(ot.SymbolicFunction(input, [input[i]]))
>>> basis = ot.Basis(functions)
>>> subbasis = basis.getSubBasis([1])
>>> print(subbasis[0].getEvaluation())
[x0,x1,x2]->[x1]"
%enddef
%feature("docstring") OT::BasisImplementation::getSubBasis
OT_Basis_getSubBasis_doc

// ---------------------------------------------------------------------

%define OT_Basis_isFinite_doc
"Tell whether the basis is finite.

Returns
-------
isFinite : bool
    `True` if the basis is finite."
%enddef
%feature("docstring") OT::BasisImplementation::isFinite
OT_Basis_isFinite_doc

// ---------------------------------------------------------------------

%define OT_Basis_isOrthogonal_doc
"Tell whether the basis is orthogonal.

Returns
-------
isOrthogonal : bool
    `True` if the basis is orthogonal."
%enddef
%feature("docstring") OT::BasisImplementation::isOrthogonal
OT_Basis_isOrthogonal_doc

// ---------------------------------------------------------------------

%define OT_Basis_add_doc
"Add a function.

Parameters
----------
function : a :class:`~openturns.Function`
    Function to be added."
%enddef
%feature("docstring") OT::BasisImplementation::add
OT_Basis_add_doc

// ---------------------------------------------------------------------

%define OT_Basis_isTensorProduct_doc
"Tell whether the basis is a tensor product

Returns
-------
isTensorProduct : bool
    `True` if the basis is a tensor product."
%enddef
%feature("docstring") OT::BasisImplementation::isTensorProduct
OT_Basis_isTensorProduct_doc
