%feature("docstring") OT::PosteriorDistribution
"Distribution conditioned by observations.

.. warning::
    This class is experimental and likely to be modified in future releases.
    To use it, import the ``openturns.experimental`` submodule.

Parameters
----------
conditional : :class:`~openturns.ConditionalDistribution`
    The distribution of density :math:`f_{\\vect{X}}(\\vect{x}) = \\int f_{\\vect{X}|\\vect{\\Theta}=\\vect{y}}(\\vect{x}|\\vect{y}) f_{\\vect{Y}}(\\vect{y})\\di{\\vect{y}}`.
observations : 2-d sequence of float
    Observations :math:`\\vect{x}_i`.

See Also
--------
openturns.ConditionalDistribution
openturns.MetropolisHastings

Notes
-----
Its probability density function is defined as:

.. math::

    f_{\\vect{Y}|\\vect{X}_1=\\vect{x}_1, ..., \\vect{X}_n = \\vect{x}_n}(\\vect{y}) = \\frac{f_{\\vect{Y}}(\\vect{y})\\prod_{i=1}^n f_{\\vect{X}|\\vect{\\Theta}=\\vect{y}}(\\vect{x}_i)}{\\int f_{\\vect{Y}}(\\vect{y}')\\prod_{i=1}^n f_{\\vect{X}|\\vect{\\Theta}=\\vect{y}'}(\\vect{x}_i) d \\vect{y}'}

with :math:`f_{\\vect{X}|\\vect{\\Theta}}` the PDF of the conditioned distribution,
:math:`f_{\\vect{Y}}` the PDF of the conditioning distribution, i.e. the marginal distribution of :math:`\\vect{Y}`,
:math:`\\vect{x}_i` the observations of the conditional distribution.

Examples
--------
>>> import openturns as ot
>>> import openturns.experimental as otexp
>>> ot.RandomGenerator.SetSeed(0)
>>> conditionedDistribution = ot.Normal()
>>> # Conditional distribution
>>> atoms = [ot.Uniform(0.0, 1.0), ot.Uniform(1.0, 2.0)]
>>> conditioning = ot.JointDistribution(atoms)
>>> conditional = ot.ConditionalDistribution(conditionedDistribution, conditioning)
>>> # Observations
>>> observationsSize = 5
>>> observationsDistribution = ot.Distribution(conditionedDistribution)
>>> observationsDistribution.setParameter(conditioning.getMean())
>>> observations = observationsDistribution.getSample(observationsSize)
>>> # Posterior distribution
>>> distribution = otexp.PosteriorDistribution(conditional, observations)"

// ---------------------------------------------------------------------

%feature("docstring") OT::PosteriorDistribution::setConditionalDistribution
"Conditional distribution accessor.

Parameters
----------
conditional : :class:`~openturns.ConditionalDistribution`
    The conditional distribution."

// ---------------------------------------------------------------------

%feature("docstring") OT::PosteriorDistribution::getConditionalDistribution
"Conditional distribution accessor.

Returns
-------
conditional : :class:`~openturns.ConditionalDistribution`
    The conditional distribution."

// ---------------------------------------------------------------------

%feature("docstring") OT::PosteriorDistribution::setObservations
"Accessor to the observations.

Parameters
----------
observations : 2-d sequence of float
    Observations."

// ---------------------------------------------------------------------

%feature("docstring") OT::PosteriorDistribution::getObservations
"Accessor to the observations.

Returns
-------
observations : :class:`~openturns.Sample`
    Observations."

// ---------------------------------------------------------------------

%feature("docstring") OT::PosteriorDistribution::getLogNormalizationFactor
"Normalization factor accessor.

Returns
-------
factor : float
    Log-scale normalization factor."
