%feature("docstring") OT::InverseNormalFactory
"Inverse Normal factory.

Notes
-----
The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{\\mu}_n =  \\bar{x}_n\\\\
      \\displaystyle\\Hat{\\lambda}_n = \\left(  \\frac{1}{n} \\sum_{i=1}^n \\frac{1}{x_i} - \\frac{1}{\\bar{x}_n} \\right)^{-1}
    \\end{eqnarray*}

See also
--------
DistributionFactory, InverseNormal"

// ---------------------------------------------------------------------

%feature("docstring") OT::InverseNormalFactory::buildAsInverseNormal
"Estimate the distribution as native distribution.


**Available usages**:

    buildAsInverseNormal()

    buildAsInverseNormal(*sample*)

    buildAsInverseNormal(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : sequence of float
   The parameters of the :class:`~openturns.InverseNormal`.

Returns
-------
distribution : :class:`~openturns.InverseNormal`
    The estimated distribution as a :class:`~openturns.InverseNormal`.
    
    In the first usage, the default :class:`openturns.InverseNormal` distribution is built."
    

