
var snark =
	"<!DOCTYPE html>"
	+"<style>"
	+"#a { margin: 30px; }"
	+"#b { margin: 20px; }"
	+"#c { margin: 5px; }"
	+"#a { border: 1px solid red; }"
	+"#b { border: 1px solid green; }"
	+"#c { border: 1px solid blue; }"
	+"</style>"
	+"<body>"
	+"<div id=\"a\">"
	+"A"
	+"</div>"
	+"<div id=\"b\">"
	+"<div id=\"c\">"
	+"C"
	+"</div>"
	+"</div>"
	+"<p>\"Just the place for a Snark!\" the Bellman cried,<br>"
	+"As he landed his crew with care;<br>"
	+"Supporting each man on the top of the tide<br>"
	+"By a finger entwined in his hair.</p>"

	+"<P>Just the place for a Snark! I have said it twice:<br>"
	+"That alone should encourage the crew.<br>"
	+"Just the place for a Snark! I have said it thrice:<br>"
	+"What I tell you three times is true.</p>"

	+"<p>The crew was complete: it included a Boots-<br>"
	+"A maker of Bonnets and Hoods-<br>"
	+"A Barrister, brought to arrange their disputes-<br>"
	+"And a Broker, to value their goods.</p>"

	+"<p>A Billiard-marker, whose skill was immense,<br>"
	+"Might perhaps have won more than his share-<br>"
	+"But a Banker, engaged at enormous expense,<br>"
	+"Had the whole of their cash in his care.</p>"

	+"<p>There was also a Beaver, that paced on the deck,<br>"
	+"Or would sit making lace in the bow:<br>"
	+"And had often (the Bellman said) saved them from wreck,<br>"
	+"Though none of the sailors knew how.</p>"

	+"<p>There was one who was famed for the number of things<br>"
	+"He forgot when he entered the ship:<br>"
	+"His umbrella, his watch, all his jewels and rings,<br>"
	+"And the clothes he had bought for the trip.</p>"
	+"<div id=\"a\">"
	+"<p>He had forty-two boxes, all carefully packed,<br>"
	+"With his name painted clearly on each:<br>"
	+"But, since he omitted to mention the fact,<br>"
	+"They were all left behind on the beach.</p>"
	+"</div>"

	+"<p>The loss of his clothes hardly mattered, because<br>"
	+"He had seven coats on when he came,<br>"
	+"With three pair of boots-but the worst of it was,<br>"
	+"He had wholly forgotten his name.</p>"

	+"<p>He would answer to \"Hi!\" or to any loud cry,<br>"
	+"Such as \"Fry me!\" or \"Fritter my wig!\"<br>"
	+"To \"What-you-may-call-um!\" or \"What-was-his-name!\"<br>"
	+"But especially \"Thing-um-a-jig!\"</p>"

	+"<p>While, for those who preferred a more forcible word,<br>"
	+"He had different names from these:<br>"
	+"His intimate friends called him \"Candle-ends,\"<br>"
	+"And his enemies \"Toasted-cheese.\"</p>"

	+"<p>\"His form is ungainly-his intellect small-\"<br>"
	+"(So the Bellman would often remark)<br>"
	+"\"But his courage is perfect! And that, after all,<br>"
	+"Is the thing that one needs with a Snark.\"</p>"

	+"<p>He would joke with hyenas, returning their stare<br>"
	+"With an impudent wag of the head:<br>"
	+"And he once went a walk, paw-in-paw, with a bear,<br>"
	+"\"Just to keep up its spirits,\" he said.</p>"

	+"<p>He came as a Baker: but owned, when too late-<br>"
	+"And it drove the poor Bellman half-mad-<br>"
	+"He could only bake Bride-cake-for which, I may state,<br>"
	+"No materials were to be had.</p>"

	+"<p>The last of the crew needs especial remark,<br>"
	+"Though he looked an incredible dunce:<br>"
	+"He had just one idea-but, that one being \"Snark,\"<br>"
	+"The good Bellman engaged him at once.</p>"

	+"<p>He came as a Butcher: but gravely declared,<br>"
	+"When the ship had been sailing a week,<br>"
	+"He could only kill Beavers. The Bellman looked scared,<br>"
	+"And was almost too frightened to speak:</p>"

	+"<p>But at length he explained, in a tremulous tone,<br>"
	+"There was only one Beaver on board;<br>"
	+"And that was a tame one he had of his own,<br>"
	+"Whose death would be deeply deplored.</p>"

	+"<div id=\"b\">"
	+"<p>The Beaver, who happened to hear the remark,<br>"
	+"Protested, with tears in its eyes,<br>"
	+"That not even the rapture of hunting the Snark<br>"
	+"Could atone for that dismal surprise!</p>"
	+"</div>"

	+"<p style=\"-mupdf-leading:7pt;\">It strongly advised that the Butcher should be<br>"
	+"Conveyed in a separate ship:<br>"
	+"But the Bellman declared that would never agree<br>"
	+"With the plans he had made for the trip:</p>";

snark +="<p style=\"-mupdf-leading:11pt;\">Navigation was always a difficult art,<br>"
	+"Though with only one ship and one bell:<br>"
	+"And he feared he must really decline, for his part,<br>"
	+"Undertaking another as well.</p>"

	+"<p style=\"-mupdf-leading:15pt;\">The Beaver's best course was, no doubt, to procure<br>"
	+"A second-hand dagger-proof coat-<br>"
	+"So the Baker advised it-and next, to insure<br>"
	+"Its life in some Office of note:</p>"

	+"<p style=\"-mupdf-leading:20pt;\">This the Banker suggested, and offered for hire<br>"
	+"(On moderate terms), or for sale,<br>"
	+"Two excellent Policies, one Against Fire,<br>"
	+"And one Against Damage From Hail.</p>"

	+"<p style=\"-mupdf-leading:30pt;\">Yet still, ever after that sorrowful day,<br>"
	+"Whenever the Butcher was by,<br>"
	+"The Beaver kept looking the opposite way,<br>"
	+"And appeared unaccountably shy.</p>"
;

var films =
[
	{
		"title":"Pulp Fiction",
		"director":"Quentin Tarantino",
		"year":"1994",
		"cast":[
			"John Travolta",
			"Samuel L Jackson",
			"Uma Thurman",
			"Bruce Willis",
			"Ving Rhames",
			"Harvey Keitel",
			"Tim Roth",
			"Bridget Fonda"
		]
	},

	{
		"title":"The Usual Suspects",
		"director":"Bryan Singer",
		"year":"1995",
		"cast":[
			"Kevin Spacey",
			"Gabriel Byrne",
			"Chazz Palminteri",
			"Benicio Del Toro",
			"Kevin Pollak",
			"Pete Postlethwaite",
			"Steven Baldwin"
		]

	},

	{
		"title":"Fight Club",
		"director":"David Fincher",
		"year":"1999",
		"cast":[
			"Brad Pitt",
			"Edward Norton",
			"Helena Bonham Carter"
		]
	}
];

var festival_template =
	"<html><head><title>Why do we have a title? Why not?</title></head>"
	+"<body><h1 style=\"text-align:center\">Hook Norton Film Festival</h1>"
	+"<ol>"
	+"<li id=\"filmtemplate\">"
	+"<b id=\"filmtitle\"></b>"
	+"<dl>"
	+"<dt>Director<dd id=\"director\">"
	+"<dt>Release Year<dd id=\"filmyear\">"
	+"<dt>Cast<dd id=\"cast\">"
	+"</dl>"
	+"</li>"
	+"<ul>"
	+"</body></html";

var mediabox = [0, 0, 512, 640];
var margin = 10;

/* First one made with precooked content. */
{
	var writer = new DocumentWriter("out.pdf", "PDF", "");
	var buf = new Buffer(snark.length);
	buf.write(snark);
	var story = new Story(buf, "", 11);
	var placed;

	do
	{
		var where = [
			mediabox[0] + margin,
			mediabox[1] + margin,
			mediabox[2] - margin,
			mediabox[3] - margin
		];

		var dev = writer.beginPage(mediabox);

		placed = story.place(where);

		story.draw(dev, Identity);

		writer.endPage();
	}
	while (placed.more);

	writer.close();
}

/* Now one made with programmatic content. */
{
	var writer = new DocumentWriter("out2.pdf", "PDF", "");
	var story = new Story(null, "", 11);

	var dom = story.document();
	var body = dom.body();

	body.appendChild(dom.createTextNode("This is some text."));
	var tmp = dom.createElement("b");
	body.appendChild(tmp);
	tmp.appendChild(dom.createTextNode("This is some bold text."));
	body.appendChild(dom.createTextNode("This is some normal text."));

	var placed;

	do
	{
		var where = [
			mediabox[0] + margin,
			mediabox[1] + margin,
			mediabox[2] - margin,
			mediabox[3] - margin
		];

		var dev = writer.beginPage(mediabox);

		placed = story.place(where);

		story.draw(dev, Identity);

		writer.endPage(writer);
	}
	while (placed.more);

	writer.close();
}

/* Now a combination of the two. */
{
	var writer = new DocumentWriter("out3.pdf", "PDF", "");

	var buf = new Buffer(festival_template.length);
	buf.write(festival_template);
	var story = new Story(buf, "", 11);

	var dom = story.document();
	var body = dom.body();

	var templat = body.find(null, "id", "filmtemplate");
	var placed;

	for (var f = 0; f < films.length; f++)
	{
		var film = templat.clone();

		/* Now fill in some of the template. */
		var tmp = film.find(null, "id", "filmtitle");
		tmp.appendChild(dom.createTextNode(films[f].title));

		tmp = film.find(null, "id", "director");
		tmp.appendChild(dom.createTextNode(films[f].director));

		tmp = film.find(null, "id", "filmyear");
		tmp.appendChild(dom.createTextNode(films[f].year));

		tmp = film.find(null, "id", "cast");
		for (var j = 0; j < films[f].cast.length; j++)
		{
			tmp.appendChild(dom.createTextNode(films[f].cast[j]));
			tmp.appendChild(dom.createElement("br"));
		}

		templat.parent().appendChild(film);
	}

	/* Remove the template. */
	templat.remove();

	do
	{
		var where = [
			mediabox[0] + margin,
			mediabox[1] + margin,
			mediabox[2] - margin,
			mediabox[3] - margin
		];

		var dev = writer.beginPage(mediabox);

		placed = story.place(where);

		story.draw(dev, Identity);

		writer.endPage();
	}
	while (placed.more);

	writer.close();
}
