
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was liblcf-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

# Required to find our installed Findinih.cmake
list(APPEND CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}")

if(1)
	find_dependency(inih REQUIRED)
endif()

if(1 EQUAL 1)
	find_dependency(ICU COMPONENTS i18n uc data REQUIRED)
endif()

if(1 EQUAL 1)
	find_dependency(expat CONFIG REQUIRED)
elseif(1 EQUAL 2)
	# Fallback to old expat detection
	find_dependency(EXPAT REQUIRED)
endif()

## Create aliases for common expat target names
# The config file creates expat::expat
if (TARGET expat::expat AND NOT TARGET EXPAT::EXPAT)
	add_library(EXPAT::EXPAT ALIAS expat::expat)
endif()

# The find module creates EXPAT::EXPAT
if (TARGET EXPAT::EXPAT AND NOT TARGET expat::expat)
	add_library(expat::expat ALIAS EXPAT::EXPAT)
endif()

include(${CMAKE_CURRENT_LIST_DIR}/liblcf-targets.cmake)
