#ifndef _XMLSUITE_H_INCLUDED_
#define _XMLSUITE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// XMLSuite.h
// -----------
// xml suite class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: XMLSuite
// 
// Description: XML handling class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/File.h>
#include <lfcbase/StackT.h>
#include <lfcbase/ListT.h>

#include "XML.h"
#include "Element.h"
#include "Document.h"
#include "Attribute.h"
#include "XMLInStream.h"
#include "XMLOutStream.h"

// XML INCLUDES

#define XMLSUITE_MAXSTRINGLEN 10000
#define XMLSUITE_MAXCONTENT 10000
#define XMLSUITE_INBUFSIZE 8192
#define XMLSUITE_CHUNKSIZE 1024

class XMLSuite : public XML {
    
public:

    XMLSuite(char *pC = 0);
    ~XMLSuite();

    // access methods
    Document* getDocument();
    void setDocument(Document* pDoc);

    void getXMLChain(Chain& xmlChain);
    void getXMLChain(File* pOutFile);
   
    // parser methods

    void setChain(char *pC);
    void setFile(File *pFile);
    void setInStream(XMLInStream *pInStream);

    int getLineNo() const;

private:

    char nextChar();
    void backChar();

    bool moreData();

    void scanContent();
    void scanData();
    void checkDataLen(int j);
    
    void putPreamble();
    void putDocType();

    void putBody();
    void putAttribute();
    void preElement();
    void conElement();
    void postElement();

    void putElement();
    void putStreamElement();

    void preStreamData();
    void postStreamData();
    void preData();
    void putData();
    void storeData();


    void getXMLForElement(Element* pElement, Chain& xmlElement, int level, bool isStream = false);
    void getXMLForElement(Element* pElement, File* pOutFile, int level, bool isStream = false);
    
    int _i;
    char *_pC;
    File *_pFile;
    XMLInStream* _pInStream;

    Element* _pElem;
    Document* _pDoc;

    Chain _streamName;

    ListT<Attribute> _attrList;
    ListT<Attribute> _streamAttrList;
    ListT<Element> _elemList;
    StackT<Element*> _elemStack;

    char _inBuf[XMLSUITE_INBUFSIZE]; 
    char _stringBuf[XMLSUITE_MAXSTRINGLEN]; 
    char _content[XMLSUITE_MAXCONTENT]; 
    ListT<char*> _dataList;

    bool _scanContent;
    bool _scanData;
    bool _streamFirst;

    char *_data;
    int _dataLen;

    int _lineNo;

};
#endif
