/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.interpreter;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.configuration.ExecutionOptions;
import org.islandoftex.arara.api.files.ProjectFile;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.api.rules.DirectiveConditional;
import org.islandoftex.arara.api.rules.Rule;
import org.islandoftex.arara.api.rules.RuleArgument;
import org.islandoftex.arara.api.rules.RuleCommand;
import org.islandoftex.arara.api.session.Command;
import org.islandoftex.arara.api.session.ExecutionStatus;
import org.islandoftex.arara.cli.interpreter.HaltExpectedException;
import org.islandoftex.arara.cli.interpreter.Interpreter;
import org.islandoftex.arara.cli.interpreter.InterpreterUtils;
import org.islandoftex.arara.cli.ruleset.RuleFormat;
import org.islandoftex.arara.cli.ruleset.RuleUtils;
import org.islandoftex.arara.cli.utils.DisplayUtils;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Session;
import org.islandoftex.arara.core.ui.InputHandling;
import org.islandoftex.arara.mvel.interpreter.AraraExceptionWithHeader;
import org.islandoftex.arara.mvel.rules.DirectiveConditionalEvaluator;
import org.islandoftex.arara.mvel.rules.SerialRuleCommand;
import org.islandoftex.arara.mvel.utils.MvelState;
import org.jetbrains.annotations.NotNull;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J4\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J4\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001d2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u001a2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fH\u0002J$\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JB\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u001f2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010 2\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u001a2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010)\u001a\u00020\u0001H\u0002J&\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0002J0\u0010-\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\u001f2\b\u0010/\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/islandoftex/arara/cli/interpreter/Interpreter;", "", "executionOptions", "Lorg/islandoftex/arara/api/configuration/ExecutionOptions;", "currentFile", "Lorg/islandoftex/arara/api/files/ProjectFile;", "workingDirectory", "Ljava/nio/file/Path;", "(Lorg/islandoftex/arara/api/configuration/ExecutionOptions;Lorg/islandoftex/arara/api/files/ProjectFile;Ljava/nio/file/Path;)V", "haltKey", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "execute", "Lorg/islandoftex/arara/api/session/ExecutionStatus;", "directive", "Lorg/islandoftex/arara/api/rules/Directive;", "executeCommand", "command", "Lorg/islandoftex/arara/mvel/rules/SerialRuleCommand;", "conditional", "Lorg/islandoftex/arara/api/rules/DirectiveConditional;", "rule", "Lorg/islandoftex/arara/api/rules/Rule;", "parameters", "", "getRule", "getUnknownKeys", "", "arguments", "", "Lorg/islandoftex/arara/api/rules/RuleArgument;", "parseArguments", "processArgument", "argument", "idInDirectiveParams", "", "context", "parameterValue", "resultToList", "result", "runBoolean", "value", "authors", "runCommand", "Lorg/islandoftex/arara/api/session/Command;", "ruleCommandExitValue", "cli"})
public final class Interpreter {
    @NotNull
    private final ExecutionOptions executionOptions;
    @NotNull
    private final Path workingDirectory;
    private final Logger logger;
    @NotNull
    private final String haltKey;

    public Interpreter(@NotNull ExecutionOptions executionOptions, @NotNull ProjectFile currentFile, @NotNull Path workingDirectory) {
        Intrinsics.checkNotNullParameter(executionOptions, "executionOptions");
        Intrinsics.checkNotNullParameter(currentFile, "currentFile");
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        this.executionOptions = executionOptions;
        this.workingDirectory = workingDirectory;
        this.logger = LoggerFactory.getLogger(Interpreter.class);
        this.haltKey = "arara:" + currentFile.getPath().getFileName() + ":halt";
    }

    /*
     * WARNING - void declaration
     */
    private final Path getRule(Directive directive, Path workingDirectory) throws AraraException {
        Object v1;
        Object object;
        Set<Path> paths;
        block3: {
            void $this$firstOrNull$iv;
            void $this$flatMapTo$iv$iv;
            paths = this.executionOptions.getRulePaths();
            boolean bl = false;
            Iterable $this$flatMap$iv = paths;
            boolean $i$f$flatMap = false;
            object = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Path path2 = (Path)element$iv$iv;
                boolean bl2 = false;
                Path[] pathArray = new Path[]{InterpreterUtils.INSTANCE.construct$cli(path2, directive.getIdentifier(), RuleFormat.MVEL, workingDirectory), InterpreterUtils.INSTANCE.construct$cli(path2, directive.getIdentifier(), RuleFormat.KOTLIN_DSL, workingDirectory), InterpreterUtils.INSTANCE.construct$cli(path2, Intrinsics.stringPlus("arara-rule-", directive.getIdentifier()), RuleFormat.MVEL, workingDirectory)};
                Iterable list$iv$iv = CollectionsKt.listOf(pathArray);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl3 = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Path path3 = v1;
        if (path3 == null) {
            Object[] objectArray = new Object[]{directive.getIdentifier(), directive.getIdentifier(), CollectionsKt.joinToString$default(paths, "; ", "(", ")", 0, null, getRule.1.3.INSTANCE, 24, null)};
            object = String.format(LanguageController.getMessages().getERROR_INTERPRETER_RULE_NOT_FOUND(), Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(object, "format(this, *args)");
            throw new AraraException((String)object);
        }
        return path3;
    }

    private final boolean runBoolean(boolean value, DirectiveConditional conditional, List<String> authors) {
        Object[] objectArray = new Object[]{value};
        String string = String.format(LanguageController.getMessages().getLOG_INFO_BOOLEAN_MODE(), Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
        this.logger.info(string);
        if (this.executionOptions.getExecutionMode() == ExecutionMode.DRY_RUN) {
            DisplayUtils.INSTANCE.printAuthors(authors);
            objectArray = new Object[]{value};
            string = String.format(LanguageController.getMessages().getINFO_INTERPRETER_DRYRUN_MODE_BOOLEAN_MODE(), Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
            DisplayUtils.INSTANCE.printWrapped(string);
            DisplayUtils.INSTANCE.printConditional(conditional);
        }
        return value;
    }

    private final boolean runCommand(Command command, DirectiveConditional conditional, List<String> authors, String ruleCommandExitValue) throws AraraException {
        Object[] objectArray = new Object[]{command};
        Object[] objectArray2 = String.format(LanguageController.getMessages().getLOG_INFO_SYSTEM_COMMAND(), Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(objectArray2, "format(this, *args)");
        this.logger.info((String)objectArray2);
        boolean success = true;
        if (this.executionOptions.getExecutionMode() != ExecutionMode.DRY_RUN) {
            Object object;
            int code = InterpreterUtils.INSTANCE.run$cli(command);
            try {
                Map<String, Integer> context2 = MapsKt.mapOf(TuplesKt.to("value", code));
                StringBuilder stringBuilder = new StringBuilder().append("@{ ");
                String string = ruleCommandExitValue;
                if (string == null) {
                    string = "value == 0";
                }
                object = TemplateRuntime.eval(stringBuilder.append(string).append(" }").toString(), context2);
            }
            catch (RuntimeException exception) {
                throw new AraraExceptionWithHeader(LanguageController.getMessages().getERROR_INTERPRETER_EXIT_RUNTIME_ERROR(), exception);
            }
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue(object2, "try {\n                va\u2026          )\n            }");
            Object check2 = object2;
            if (!(check2 instanceof Boolean)) {
                throw new AraraExceptionWithHeader(LanguageController.getMessages().getERROR_INTERPRETER_WRONG_EXIT_CLOSURE_RETURN());
            }
            success = (Boolean)check2;
        } else {
            DisplayUtils.INSTANCE.printAuthors(authors);
            objectArray2 = new Object[]{command};
            String string = String.format(LanguageController.getMessages().getINFO_INTERPRETER_DRYRUN_MODE_SYSTEM_COMMAND(), Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
            DisplayUtils.INSTANCE.printWrapped(string);
            DisplayUtils.INSTANCE.printConditional(conditional);
        }
        return success;
    }

    private final List<Object> resultToList(Object result2) {
        return result2 instanceof List ? InputHandling.flatten((List)result2) : CollectionsKt.listOf(result2);
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionStatus executeCommand(SerialRuleCommand command, DirectiveConditional conditional, Rule rule, Map<String, ? extends Object> parameters2) throws AraraException {
        void $this$fold$iv;
        Object element$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable<Object> iterable;
        try {
            String string = command.getCommandString();
            Intrinsics.checkNotNull(string);
            iterable = TemplateRuntime.eval(string, parameters2);
            Intrinsics.checkNotNullExpressionValue(iterable, "eval(command.commandString!!, parameters)");
            iterable = this.resultToList(iterable);
        }
        catch (RuntimeException exception) {
            throw new AraraExceptionWithHeader(LanguageController.getMessages().getERROR_INTERPRETER_COMMAND_RUNTIME_ERROR(), exception);
        }
        iterable = iterable;
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank(it.toString());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        ExecutionStatus initial$iv = new ExecutionStatus.Processing();
        boolean $i$f$fold = false;
        ExecutionStatus accumulator$iv = initial$iv;
        Iterator iterator3 = $this$fold$iv.iterator();
        while (iterator3.hasNext()) {
            boolean bl;
            void current;
            Object element$iv;
            element$iv$iv = element$iv = iterator3.next();
            ExecutionStatus $noName_0 = accumulator$iv;
            boolean bl3 = false;
            String string = rule.getDisplayName();
            Intrinsics.checkNotNull(string);
            String string2 = command.getName();
            DisplayUtils.INSTANCE.printEntry(string, string2 == null ? LanguageController.getMessages().getINFO_LABEL_UNNAMED_TASK() : string2);
            void var15_20 = current;
            if (var15_20 instanceof Boolean) {
                bl = this.runBoolean((Boolean)current, conditional, rule.getAuthors());
            } else if (var15_20 instanceof Command) {
                bl = this.runCommand((Command)current, conditional, rule.getAuthors(), command.getExit());
            } else {
                throw new AraraExceptionWithHeader(LanguageController.getMessages().getERROR_INTERPRETER_WRONG_RETURN_TYPE());
            }
            boolean success = bl;
            DisplayUtils.INSTANCE.printEntryResult(success);
            if (Session.INSTANCE.contains(this.haltKey)) {
                throw new HaltExpectedException(LanguageController.getMessages().getERROR_INTERPRETER_USER_REQUESTED_HALT(), new ExecutionStatus.FinishedWithCode(Integer.parseInt(Session.INSTANCE.get(this.haltKey).toString())));
            }
            if (this.executionOptions.getHaltOnErrors() && !success) {
                Object[] objectArray = new Object[]{command.getName()};
                String string3 = String.format(LanguageController.getMessages().getERROR_INTERPRETER_COMMAND_UNSUCCESSFUL_EXIT(), Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
                throw new HaltExpectedException(string3, new ExecutionStatus.ExternalCallFailed());
            }
            accumulator$iv = success ? (ExecutionStatus)new ExecutionStatus.Processing() : (ExecutionStatus)new ExecutionStatus.ExternalCallFailed();
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExecutionStatus execute(@NotNull Directive directive) throws AraraException {
        ExecutionStatus executionStatus;
        Intrinsics.checkNotNullParameter(directive, "directive");
        Object[] objectArray = new Object[]{directive.getIdentifier()};
        Object[] objectArray2 = String.format(LanguageController.getMessages().getLOG_INFO_INTERPRET_RULE(), Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(objectArray2, "format(this, *args)");
        this.logger.info((String)objectArray2);
        Path file2 = this.getRule(directive, this.workingDirectory);
        objectArray2 = new Object[]{file2.getParent()};
        String string = String.format(LanguageController.getMessages().getLOG_INFO_RULE_LOCATION(), Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
        this.logger.info(string);
        Rule rule = RuleUtils.INSTANCE.parseRule(file2, directive.getIdentifier());
        Map<String, Object> parameters2 = MapsKt.plus(this.parseArguments(rule, directive), MvelState.getRuleMethods());
        DirectiveConditionalEvaluator evaluator = new DirectiveConditionalEvaluator(this.executionOptions);
        boolean available = InterpreterUtils.INSTANCE.runPriorEvaluation$cli(directive.getConditional()) ? evaluator.evaluate(directive.getConditional()) : true;
        if (!available) {
            executionStatus = new ExecutionStatus.Processing();
        } else if (Session.INSTANCE.contains(this.haltKey)) {
            executionStatus = new ExecutionStatus.FinishedWithCode(Integer.parseInt(Session.INSTANCE.get(this.haltKey).toString()));
        } else {
            ExecutionStatus executionStatus2;
            try {
                ExecutionStatus retValue = null;
                do {
                    void $this$fold$iv;
                    Iterable iterable = rule.getCommands();
                    ExecutionStatus initial$iv = new ExecutionStatus.Processing();
                    boolean $i$f$fold = false;
                    ExecutionStatus accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        void command;
                        RuleCommand ruleCommand = (RuleCommand)element$iv;
                        ExecutionStatus $noName_0 = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = this.executeCommand((SerialRuleCommand)command, directive.getConditional(), rule, parameters2);
                    }
                    retValue = accumulator$iv;
                } while (evaluator.evaluate(directive.getConditional()));
                executionStatus2 = retValue;
            }
            catch (HaltExpectedException e) {
                executionStatus2 = e.getStatus();
            }
            catch (AraraExceptionWithHeader e) {
                StringBuilder stringBuilder = new StringBuilder();
                Object[] objectArray3 = new Object[]{directive.getIdentifier(), ((Object)file2.getParent()).toString()};
                String string2 = String.format(LanguageController.getMessages().getERROR_RULE_IDENTIFIER_AND_PATH(), Arrays.copyOf(objectArray3, objectArray3.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                String string3 = stringBuilder.append(string2).append(' ').append((Object)e.getMessage()).toString();
                Exception exception = e.getException();
                if (exception == null) {
                    exception = e;
                }
                throw new AraraException(string3, exception);
            }
            executionStatus = executionStatus2;
        }
        return executionStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getUnknownKeys(Map<String, ? extends Object> parameters2, List<? extends RuleArgument<?>> arguments2) {
        void $this$mapTo$iv$iv;
        Set<String> found = parameters2.keySet();
        Iterable $this$map$iv = arguments2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RuleArgument ruleArgument = (RuleArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getIdentifier());
        }
        List expected = (List)destination$iv$iv;
        return CollectionsKt.subtract((Iterable)found, expected);
    }

    private final Map<String, Object> parseArguments(Rule rule, Directive directive) throws AraraException {
        Set<String> unknown = SetsKt.minus(this.getUnknownKeys(directive.getParameters(), rule.getArguments()), "reference");
        if (!((Collection)unknown).isEmpty()) {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default(unknown, ", ", "(", ")", 0, null, null, 56, null)};
            String string = String.format(LanguageController.getMessages().getERROR_INTERPRETER_UNKNOWN_KEYS(), Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
            throw new AraraExceptionWithHeader(string);
        }
        Map resolvedArguments = new LinkedHashMap();
        resolvedArguments.put("reference", MapsKt.getValue(directive.getParameters(), "reference"));
        Pair[] pairArray = new Pair[]{TuplesKt.to("parameters", directive.getParameters()), TuplesKt.to("reference", MapsKt.getValue(directive.getParameters(), "reference"))};
        Map<String, Object> context2 = MapsKt.plus(MapsKt.mapOf(pairArray), MvelState.getRuleMethods());
        Iterable $this$forEach$iv = rule.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RuleArgument argument2 = (RuleArgument)element$iv;
            boolean bl = false;
            resolvedArguments.put(argument2.getIdentifier(), this.processArgument(argument2, directive.getParameters().containsKey(argument2.getIdentifier()), context2, directive.getParameters().get(argument2.getIdentifier())));
        }
        return resolvedArguments;
    }

    private final List<?> processArgument(RuleArgument<Object> argument2, boolean idInDirectiveParams, Map<String, ? extends Object> context2, Object parameterValue) throws AraraException {
        List<String> list;
        if (argument2.isRequired() && !idInDirectiveParams) {
            Object[] objectArray = new Object[]{argument2.getIdentifier()};
            String string = String.format(LanguageController.getMessages().getERROR_INTERPRETER_ARGUMENT_IS_REQUIRED(), Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
            throw new AraraExceptionWithHeader(string);
        }
        if (idInDirectiveParams) {
            list = argument2.getProcessor().invoke(parameterValue, context2);
        } else {
            List<String> list2;
            Object object = argument2.getDefaultValue();
            if (object == null) {
                list2 = null;
            } else {
                Object object2 = object;
                boolean bl = false;
                list2 = argument2.getProcessor().invoke(object2, context2);
            }
            List<String> list3 = list2;
            list = list3 == null ? CollectionsKt.emptyList() : list3;
        }
        return list;
    }
}

