%feature("docstring") OT::WeibullMaxMuSigma
"WeibullMax distribution parameters.

Parameters
----------
mu : float
    Mean.
sigma : float
    Standard deviation :math:`\\sigma > 0`.
gamma : float, optional
    Shift parameter :math:`\\gamma > \\mu`.

Notes
-----
The native parameters :math:`\\alpha` and :math:`\\beta` are searched such as:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\mu & = & \\gamma - \\beta \\,\\Gamma\\left(1 + \\frac{1}{\\alpha}\\right)\\\\
        \\sigma^2 & = & \\beta^2 \\left( \\Gamma \\left( 1 + \\frac{2}{\\alpha} \\right) -
                     \\Gamma^2 \\left( 1 + \\frac{1}{\\alpha} \\right) \\right)
    \\end{eqnarray*}

The :math:`\\gamma` parameter is the same.

See also
--------
WeibullMax

Examples
--------
Create the parameters :math:`(\\mu, \\sigma, \\gamma)` of the WeibullMax distribution:

>>> import openturns as ot
>>> parameters = ot.WeibullMaxMuSigma(1.3, 1.23, 3.1)

Convert parameters into the native parameters :math:`(\\beta, \\alpha, \\gamma)`:

>>> print(parameters.evaluate())
[1.99222,1.48961,3.1]"
