%feature("docstring") OT::UniformFactory
"Uniform factory.

Available constructor:
    UniformFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{a}_n=(1-\\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}\\\\
      \\displaystyle\\Hat{b}_n=(1+\\mathrm{sign}(x_{(n,n)})/(2+n))x_{(n,n)}
    \\end{eqnarray*}

See also
--------
DistributionFactory, Uniform"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsUniform_doc
"Build the Uniform distribution.

**Available usages**:

    buildAsUniform(*sample*)

    buildAsUniform(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Uniform`
    The built distribution."
%enddef
%feature("docstring") OT::UniformFactory::buildAsUniform
OT_DistributionFactory_buildAsUniform_doc

