%feature("docstring") OT::RayleighFactory
"Rayleigh factory.

Available constructor:
    RayleighFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{\\gamma}_n = (1-\\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}\\\\
      \\displaystyle\\Hat{\\sigma}_n=\\sqrt{\\frac{2}{n}\\sum_{i=1}^n(x_i-\\Hat{\\gamma}_n)^2}
    \\end{eqnarray*}

See also
--------
DistributionFactory, Rayleigh"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsRayleigh_doc
"Build the Rayleigh distribution.

**Available usages**:

    buildAsRayleigh(*sample*)

    buildAsRayleigh(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Rayleigh`
    The built distribution."
%enddef
%feature("docstring") OT::RayleighFactory::buildAsRayleigh
OT_DistributionFactory_buildAsRayleigh_doc

