%feature("docstring") OT::LogisticFactory
"Logistic factory.

Available constructor:
    LogisticFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{\\alpha} = \\bar{x}\\\\
      \\displaystyle\\Hat{\\beta} = \\Hat{\\sigma}_x
    \\end{eqnarray*}

See also
--------
DistributionFactory, Logistic"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsLogistic_doc
"Build the Logistic distribution.

**Available usages**:

    buildAsLogistic(*sample*)

    buildAsLogistic(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Logistic`
    The built distribution."
%enddef
%feature("docstring") OT::LogisticFactory::buildAsLogistic
OT_DistributionFactory_buildAsLogistic_doc

