%feature("docstring") OT::EventSimulation
"Base class for sampling methods.

Available constructor:
    EventSimulation(*event, verbose=True, convergenceStrategy=ot.Compact()*)

Parameters
----------
event : :class:`~openturns.RandomVector`
    The event we are computing the probability of.
verbose : bool
    If *True*, make the computation verbose.
convergenceStrategy : :class:`~openturns.HistoryStrategy`
    Storage strategy used to store the values of the probability estimator and
    its variance during the simulation algorithm.

Notes
-----
Base class for sampling methods, using the probability distribution of a random
vector :math:`\\vect{X}` to evaluate the failure probability:

.. math::

    P_f = \\int_{\\Rset^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\underline{d}) \\leq 0 \\}}f_{\\uX}(\\ux)\\di{\\ux}
        = \\Prob{g\\left( \\vect{X},\\vect{d} \\right) \\leq 0}

Here, :math:`\\vect{X}` is a random vector, :math:`\\vect{d}` a deterministic
vector, :math:`g(\\vect{X},\\vect{d})` the function known as *limit state function*
which enables the definition of the event
:math:`\\cD_f = \\{\\vect{X} \\in \\Rset^n \\, | \\, g(\\vect{X},\\vect{d}) \\le 0\\}`.
:math:`\\mathbf{1}_{ \\left\\{ g(\\vect{x}_i,\\vect{d}) \\leq 0 \\right\\} }`
describes the indicator function equal to 1 if
:math:`g(\\vect{x}_i,\\vect{d}) \\leq 0` and equal to 0 otherwise.

The EventSimulation object provides a generic simulation service for non-composite
events, and its derived classes provide dedicated algorithms:

- :class:`~openturns.ProbabilitySimulationAlgorithm`

- :class:`~openturns.DirectionalSampling`

- :class:`~openturns.LHS`,

- :class:`~openturns.PostAnalyticalControlledImportanceSampling`,

- :class:`~openturns.PostAnalyticalImportanceSampling`,

See also
--------
SimulationResult"

// ---------------------------------------------------------------------

%feature("docstring") OT::EventSimulation::getResult
"Accessor to the results.

Returns
-------
results : :class:`~openturns.SimulationResult`
    Structure containing all the results obtained after simulation and created
    by the method :py:meth:`run`."

// ---------------------------------------------------------------------

%feature("docstring") OT::EventSimulation::getEvent
"Accessor to the event.

Returns
-------
event : :class:`~openturns.RandomVector`
    Event we want to evaluate the probability."

// ---------------------------------------------------------------------

%feature("docstring") OT::EventSimulation::run
"Launch simulation.

Notes
-----
It launches the simulation and creates a :class:`~openturns.SimulationResult`,
structure containing all the results obtained after simulation.
It computes the probability of occurrence of the given event by computing the
empirical mean of a sample of size at most *outerSampling * blockSize*,
this sample being built by blocks of size *blockSize*. It allows one to use
efficiently the distribution of the computation as well as it allows one to deal
with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
*outerSampling*.

see also
--------
setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult"

// ---------------------------------------------------------------------

%feature("docstring") OT::EventSimulation::drawProbabilityConvergence
"Draw the probability convergence at a given level.

Parameters
----------
level : float, optional
    The probability convergence is drawn at this given confidence length
    *level*. By default *level* is 0.95.

Returns
-------
graph : a :class:`~openturns.Graph`
    probability convergence graph"
