%feature("docstring") OT::ChiSquareFactory
"Chi-Square factory.

Available constructor:
    ChiSquareFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle \\Hat{\\nu} = \\bar{x}
    \\end{eqnarray*}

See also
--------
DistributionFactory, ChiSquare"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsChiSquare_doc
"Build the ChiSquare distribution.

**Available usages**:

    buildAsChiSquare(*sample*)

    buildAsChiSquare(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.ChiSquare`
    The built distribution."
%enddef
%feature("docstring") OT::ChiSquareFactory::buildAsChiSquare
OT_DistributionFactory_buildAsChiSquare_doc

