// Created by: Peter KURNEV
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _BOPTools_SetMapHasher_HeaderFile
#define _BOPTools_SetMapHasher_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>

#include <Standard_Integer.hxx>
class BOPTools_Set;



class Standard_EXPORT BOPTools_SetMapHasher 
{
public:

  DEFINE_STANDARD_ALLOC
    
  //! Computes a hash code for the given set, in the range [1, theUpperBound]
  //! @param theSet the set which hash code is to be computed
  //! @param theUpperBound the upper bound of the range a computing hash code must be within
  //! @return a computed hash code, in the range [1, theUpperBound]
  static Standard_Integer HashCode (const BOPTools_Set& theSet, Standard_Integer theUpperBound);

  static Standard_Boolean IsEqual (const BOPTools_Set& aSet1, const BOPTools_Set& aSet2);




protected:





private:





};


#include <BOPTools_SetMapHasher.lxx>





#endif // _BOPTools_SetMapHasher_HeaderFile
