set(ITKVtkGlue_LOADED 1)
set(ITKVtkGlue_ENABLE_SHARED "1")
set(ITKVtkGlue_DEPENDS "ITKCommon;ITKImageIntensity;ITKVTK")
set(ITKVtkGlue_PUBLIC_DEPENDS "ITKCommon;ITKVTK")
set(ITKVtkGlue_TRANSITIVE_DEPENDS "ITKCommon;ITKImageIntensity;ITKVTK")
set(ITKVtkGlue_PRIVATE_DEPENDS "")
set(ITKVtkGlue_LIBRARIES "ITKVtkGlue")
set(ITKVtkGlue_INCLUDE_DIRS "${ITK_INSTALL_PREFIX}/include/ITK")
set(ITKVtkGlue_LIBRARY_DIRS "")
set(ITKVtkGlue_RUNTIME_LIBRARY_DIRS "${ITK_INSTALL_PREFIX}/bin")
set(ITKVtkGlue_TARGETS_FILE "")
set(ITKVtkGlue_FACTORY_NAMES "")

set(VTK_DIR "${ITK_INSTALL_PREFIX}/lib/cmake/vtk")

find_package(VTK NO_MODULE REQUIRED)

  if(NOT COMMAND vtk_module_config)
    macro(vtk_module_config ns)
       foreach(arg ${ARGN})
        if(${arg} MATCHES "^[Vv][Tt][Kk]")
          string(REGEX REPLACE "^[Vv][Tt][Kk]" "" _arg ${arg})
        else()
          set(_arg ${arg})
        endif()
        set(${ns}_LIBRARIES ${${ns}_LIBRARIES} VTK::${_arg})
       endforeach()
    endmacro()
  endif()

if(NOT VTK_VERSION)
  set(VTK_VERSION "9.2.2")
endif()
if(NOT VTK_RENDERING_BACKEND)
  if(NOT COMMAND vtk_module_config)
    set(VTK_RENDERING_BACKEND OpenGL2)
  else()
    set(VTK_RENDERING_BACKEND OpenGL)
  endif()
endif()
set(_target_freetypeopengl)
if(TARGET VTK::RenderingFreeTypeOpenGL2)
  set(_target_freetypeopengl VTK::RenderingFreeTypeOpenGL2)
endif()

set(_required_vtk_libraries
  VTK::IOImage
  VTK::ImagingSources
  )
if(ITK_WRAP_PYTHON)
  list(APPEND _required_vtk_libraries VTK::WrappingPythonCore)
endif()
if(NOT VTK_RENDERING_BACKEND STREQUAL "None")
  list(APPEND _required_vtk_libraries
    VTK::RenderingOpenGL2
    VTK::RenderingFreeType
    
    VTK::InteractionStyle
    VTK::InteractionWidgets
  )
endif()
if(9.2.2 VERSION_LESS 6.0.0)
  set(ITKVtkGlue_VTK_INCLUDE_DIRS )
  set(ITKVtkGlue_VTK_LIBRARIES VTK::WrappingTools;VTK::ViewsQt;VTK::ViewsInfovis;VTK::UtilitiesBenchmarks;VTK::ViewsContext2D;VTK::zfp;VTK::loguru;VTK::cli11;VTK::TestingRendering;VTK::TestingIOSQL;VTK::TestingGenericBridge;VTK::TestingDataModel;VTK::TestingCore;VTK::RenderingRayTracing;VTK::RenderingVolumeAMR;VTK::RenderingQt;VTK::PythonContext2D;VTK::RenderingParallel;VTK::RenderingOpenXR;VTK::RenderingOpenVR;VTK::RenderingVR;VTK::RenderingVolumeOpenGL2;VTK::RenderingMatplotlib;VTK::PythonInterpreter;VTK::RenderingLabel;VTK::octree;VTK::RenderingLOD;VTK::RenderingLICOpenGL2;VTK::RenderingImage;VTK::RenderingFreeTypeFontConfig;VTK::RenderingFFMPEGOpenGL2;VTK::RenderingExternal;VTK::RenderingContextOpenGL2;VTK::IOXdmf2;VTK::xdmf2;VTK::IOVeraOut;VTK::IOVPIC;VTK::vpic;VTK::IOTecplotTable;VTK::IOTRUCHAS;VTK::IOSegY;VTK::IOPostgreSQL;VTK::IOXdmf3;VTK::xdmf3;VTK::IOParallelXML;VTK::IOParallelLSDyna;VTK::IOParallelExodus;VTK::IOParallel;VTK::IOPLY;VTK::IOPIO;VTK::IOPDAL;VTK::IOOpenVDB;VTK::IOOggTheora;VTK::theora;VTK::ogg;VTK::IOOMF;VTK::IOODBC;VTK::IONetCDF;VTK::IOMySQL;VTK::IOMotionFX;VTK::pegtl;VTK::IOMINC;VTK::IOLSDyna;VTK::IOLAS;VTK::IOInfovis;VTK::libxml2;VTK::IOImport;VTK::IOIOSS;VTK::ioss;VTK::IOH5part;VTK::h5part;VTK::IOH5Rage;VTK::IOGeoJSON;VTK::IOFFMPEG;VTK::IOVideo;VTK::IOMovie;VTK::IOExportPDF;VTK::IOExportGL2PS;VTK::RenderingGL2PSOpenGL2;VTK::gl2ps;VTK::IOExport;VTK::libharu;VTK::RenderingVtkJS;VTK::jsoncpp;VTK::RenderingSceneGraph;VTK::IOExodus;VTK::exodusII;VTK::netcdf;VTK::IOEnSight;VTK::IOCityGML;VTK::IOChemistry;VTK::IOCesium3DTiles;VTK::IOGeometry;VTK::IOCONVERGECFD;VTK::IOHDF;VTK::IOCGNSReader;VTK::cgns;VTK::IOAsynchronous;VTK::IOAMR;VTK::hdf5;VTK::IOADIOS2;VTK::InteractionImage;VTK::InfovisBoostGraphAlgorithms;VTK::InfovisBoost;VTK::ImagingStencil;VTK::ImagingStatistics;VTK::ImagingOpenGL2;VTK::ImagingMorphological;VTK::ImagingMath;VTK::ImagingFourier;VTK::GUISupportQtSQL;VTK::IOSQL;VTK::GUISupportQtQuick;VTK::GUISupportQt;VTK::GeovisGDAL;VTK::IOGDAL;VTK::GeovisCore;VTK::InfovisLayout;VTK::libproj;VTK::sqlite;VTK::nlohmannjson;VTK::ViewsCore;VTK::InteractionWidgets;VTK::RenderingVolume;VTK::RenderingAnnotation;VTK::ImagingHybrid;VTK::ImagingColor;VTK::InteractionStyle;VTK::FiltersTopology;VTK::FiltersSelection;VTK::FiltersSMP;VTK::FiltersReebGraph;VTK::FiltersPython;VTK::FiltersProgrammable;VTK::FiltersPoints;VTK::FiltersVerdict;VTK::verdict;VTK::FiltersParallelStatistics;VTK::FiltersParallelImaging;VTK::FiltersParallelDIY2;VTK::FiltersOpenTURNS;VTK::FiltersImaging;VTK::ImagingGeneral;VTK::FiltersGeneric;VTK::FiltersFlowPaths;VTK::FiltersAMR;VTK::FiltersParallel;VTK::FiltersTexture;VTK::FiltersModeling;VTK::DomainsMicroscopy;VTK::DomainsChemistryOpenGL2;VTK::RenderingOpenGL2;VTK::glew;VTK::opengl;VTK::RenderingUI;VTK::RenderingHyperTreeGrid;VTK::FiltersHyperTree;VTK::FiltersHybrid;VTK::DomainsChemistry;VTK::CommonPython;VTK::WrappingPythonCore;VTK::Python;VTK::CommonArchive;VTK::ChartsCore;VTK::InfovisCore;VTK::FiltersExtraction;VTK::ParallelDIY;VTK::IOXML;VTK::IOXMLParser;VTK::expat;VTK::diy2;VTK::ParallelCore;VTK::IOLegacy;VTK::IOCore;VTK::lzma;VTK::lz4;VTK::doubleconversion;VTK::FiltersStatistics;VTK::eigen;VTK::ImagingSources;VTK::IOImage;VTK::tiff;VTK::png;VTK::metaio;VTK::jpeg;VTK::DICOMParser;VTK::RenderingContext2D;VTK::RenderingFreeType;VTK::freetype;VTK::zlib;VTK::RenderingCore;VTK::FiltersSources;VTK::CommonColor;VTK::ImagingCore;VTK::FiltersGeometry;VTK::FiltersGeneral;VTK::fmt;VTK::CommonComputationalGeometry;VTK::FiltersCore;VTK::CommonExecutionModel;VTK::CommonDataModel;VTK::pugixml;VTK::CommonSystem;VTK::CommonMisc;VTK::exprtk;VTK::CommonTransforms;VTK::CommonMath;VTK::kissfft;VTK::CommonCore;VTK::utf8;VTK::vtksys;VTK::kwiml)
else()
  vtk_module_config(ITKVtkGlue_VTK
    ${_required_vtk_libraries}
    )
  set(ITKVtkGlue_VTK_LIBRARIES ${_required_vtk_libraries})
  set_property(DIRECTORY APPEND PROPERTY COMPILE_DEFINITIONS ${ITKVtkGlue_VTK_DEFINITIONS})
endif()

