/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// CodeGenRewrite
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CodeGenRewriteBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = CodeGenRewriteBase;

  CodeGenRewriteBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  CodeGenRewriteBase(const CodeGenRewriteBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("cg-rewrite");
  }
  ::llvm::StringRef getArgument() const override { return "cg-rewrite"; }

  ::llvm::StringRef getDescription() const override { return "Rewrite some FIR ops into their code-gen forms."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("CodeGenRewrite");
  }
  ::llvm::StringRef getName() const override { return "CodeGenRewrite"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<fir::FIROpsDialect>();

  registry.insert<fir::FIRCodeGenDialect>();

  }

protected:
  ::mlir::Pass::Statistic numDCE{this, "num-dce'd", "Number of operations eliminated"};
};

//===----------------------------------------------------------------------===//
// FIRToLLVMLowering
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class FIRToLLVMLoweringBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = FIRToLLVMLoweringBase;

  FIRToLLVMLoweringBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  FIRToLLVMLoweringBase(const FIRToLLVMLoweringBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("fir-to-llvm-ir");
  }
  ::llvm::StringRef getArgument() const override { return "fir-to-llvm-ir"; }

  ::llvm::StringRef getDescription() const override { return "Convert FIR dialect to LLVM-IR dialect"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FIRToLLVMLowering");
  }
  ::llvm::StringRef getName() const override { return "FIRToLLVMLowering"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<mlir::LLVM::LLVMDialect>();

  }

protected:
  ::mlir::Pass::Option<std::string> forcedTargetTriple{*this, "target", ::llvm::cl::desc("Override module's target triple.")};
};

//===----------------------------------------------------------------------===//
// TargetRewrite
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TargetRewriteBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = TargetRewriteBase;

  TargetRewriteBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TargetRewriteBase(const TargetRewriteBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("target-rewrite");
  }
  ::llvm::StringRef getArgument() const override { return "target-rewrite"; }

  ::llvm::StringRef getDescription() const override { return "Rewrite some FIR dialect into target specific forms."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TargetRewrite");
  }
  ::llvm::StringRef getName() const override { return "TargetRewrite"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<fir::FIROpsDialect>();

  }

protected:
  ::mlir::Pass::Option<std::string> forcedTargetTriple{*this, "target", ::llvm::cl::desc("Override module's target triple.")};
  ::mlir::Pass::Option<bool> noCharacterConversion{*this, "no-character-conversion", ::llvm::cl::desc("Disable target-specific conversion of CHARACTER."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> noComplexConversion{*this, "no-complex-conversion", ::llvm::cl::desc("Disable target-specific conversion of COMPLEX."), ::llvm::cl::init(false)};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// CodeGenRewrite Registration
//===----------------------------------------------------------------------===//

inline void registerCodeGenRewritePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::fir::createFirCodeGenRewritePass();
  });
}

//===----------------------------------------------------------------------===//
// FIRToLLVMLowering Registration
//===----------------------------------------------------------------------===//

inline void registerFIRToLLVMLoweringPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::fir::createFIRToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// TargetRewrite Registration
//===----------------------------------------------------------------------===//

inline void registerTargetRewritePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::fir::createFirTargetRewritePass();
  });
}

//===----------------------------------------------------------------------===//
// OptCodeGen Registration
//===----------------------------------------------------------------------===//

inline void registerOptCodeGenPasses() {
  registerCodeGenRewritePass();
  registerFIRToLLVMLoweringPass();
  registerTargetRewritePass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
