/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.increment;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSExpressionWithOperationNode;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.braces.JSAddBracesIntention;
import org.jetbrains.annotations.NotNull;

public class JSExtractIncrementIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        return this.getText(((JSExpressionWithOperationNode)element).getOperationNode().getText());
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ExtractIncrementPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean isPostfix;
        JSExpression operand;
        if (element == null) {
            JSExtractIncrementIntention.$$$reportNull$$$0(0);
        }
        JSExpression jSExpression = operand = (isPostfix = element instanceof JSPostfixExpression) ? ((JSPostfixExpression)element).getExpression() : ((JSPrefixExpression)element).getExpression();
        if (operand == null) {
            return;
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        assert (statement != null);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)element);
        JSStatement statementNode = JSPsiElementFactory.createJSStatement((String)(element.getText() + semicolon), (PsiElement)element);
        if (statement instanceof JSLoopStatement) {
            JSStatement body = ((JSLoopStatement)statement).getBody();
            if (!(body instanceof JSBlockStatement)) {
                assert (body != null);
                new JSAddBracesIntention().processIntention((PsiElement)body);
            }
            JSBlockStatement block = (JSBlockStatement)((JSLoopStatement)statement).getBody();
            assert (block != null);
            block.addAfter((PsiElement)statementNode, block.getFirstChild());
            if (statement instanceof JSForStatement) {
                element.delete();
            } else {
                JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)((JSExpression)element), (String)operand.getText());
            }
            return;
        }
        if (isPostfix) {
            statement.addStatementAfter(statementNode);
        } else {
            statement.addStatementBefore(statementNode);
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)((JSExpression)element), (String)operand.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention", "processIntention"));
    }

    private static class ExtractIncrementPredicate
    implements JSElementPredicate {
        private ExtractIncrementPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ExtractIncrementPredicate.$$$reportNull$$$0(0);
            }
            if (!ExpressionUtil.isIncrementDecrementExpression((PsiElement)element)) {
                return false;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof JSExpressionStatement) {
                return false;
            }
            JSStatement containingStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
            if (element instanceof JSPostfixExpression && containingStatement instanceof JSFunctionExitPoint) {
                return false;
            }
            return containingStatement != null && (!(containingStatement instanceof JSLoopStatement) || ExtractIncrementPredicate.isSuitableForLoop((JSLoopStatement)containingStatement, element));
        }

        private static boolean isSuitableForLoop(JSLoopStatement statement, PsiElement element) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention$ExtractIncrementPredicate", "satisfiedBy"));
        }
    }
}

