/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFlipIfIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = element -> element instanceof JSIfStatement && !PsiUtilCore.hasErrorElementChild((PsiElement)element) && ((JSIfStatement)element).getCondition() != null;
        if (jSElementPredicate == null) {
            JSFlipIfIntention.$$$reportNull$$$0(0);
        }
        return jSElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        Pair<JSStatement, JSSourceElement> elementRange;
        JSStatement statement;
        Document document;
        JSIfStatement exp;
        JSExpression condition;
        String negatedText;
        JSExpression replacementExpression;
        if (element == null) {
            JSFlipIfIntention.$$$reportNull$$$0(1);
        }
        JSExpression jSExpression = replacementExpression = StringUtil.isNotEmpty((String)(negatedText = BoolUtils.getNegatedExpressionText(condition = (exp = (JSIfStatement)element).getCondition()))) ? JSPsiElementFactory.createJSExpression((String)negatedText, (PsiElement)exp) : null;
        if (condition != null && replacementExpression != null) {
            condition.replace(replacementExpression);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(statement = (JSStatement)(elementRange = JSFlipIfIntention.processIfStatement(exp)).getFirst()).getProject()).getDocument(statement.getContainingFile())) != null) {
            FormatFixer.create((PsiElement)statement, (PsiElement)((PsiElement)elementRange.getSecond()), (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        }
    }

    @Override
    protected boolean stopTraversingUp(@Nullable PsiElement element) {
        return super.stopTraversingUp(element) || element instanceof JSExpression && !ConditionalUtils.isInIfCondition((JSExpression)element);
    }

    @NotNull
    private static Pair<JSStatement, JSSourceElement> processIfStatement(@NotNull JSIfStatement original) {
        JSBlockStatement containerStatement;
        JSStatement originalElse;
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(2);
        }
        if ((originalElse = original.getElse()) != null) {
            return JSFlipIfIntention.defaultFlipBranches(original);
        }
        if (JSFlipIfIntention.alwaysTransfersControlAtEnd((JSSourceElement)original.getThen())) {
            List<JSStatement> statementsAfter = JSFlipIfIntention.getStatementsAfter((JSStatement)original);
            if (!statementsAfter.isEmpty()) {
                JSStatement first = statementsAfter.get(0);
                PsiElement beforeStatements = first.getPrevSibling();
                if (beforeStatements instanceof PsiWhiteSpace && beforeStatements.textContains('\n')) {
                    beforeStatements.delete();
                }
                original.getParent().deleteChildRange((PsiElement)first, (PsiElement)statementsAfter.get(statementsAfter.size() - 1));
            }
            JSFlipIfIntention.setElseBranch(original, original.getThen());
            JSFlipIfIntention.setThenBranch(original, statementsAfter);
            Pair pair = Pair.create((Object)original, (Object)original);
            if (pair == null) {
                JSFlipIfIntention.$$$reportNull$$$0(3);
            }
            return pair;
        }
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)original, (Class[])new Class[]{JSFunction.class, JSLoopStatement.class, JSSwitchStatement.class});
        Object object = container instanceof JSFunction ? ((JSFunction)container).getBlock() : (containerStatement = container instanceof JSLoopStatement ? ((JSLoopStatement)container).getBody() : null);
        if (container != null && containerStatement instanceof JSBlockStatement && ControlFlowUtils.blockCompletesWithStatement((JSBlockStatement)containerStatement, (JSStatement)original)) {
            String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)original);
            String keyword = container instanceof JSFunction ? "return" : "continue";
            JSStatement jumpStatement = JSPsiElementFactory.createJSStatement((String)(keyword + semicolon), (PsiElement)original, JSStatement.class);
            JSSourceElement[] originalThen = JSFlipIfIntention.extractStatements(original.getThen());
            JSSourceElement lastStatement = JSFlipIfIntention.addStatementsAfter(original, originalThen);
            JSFlipIfIntention.setThenBranch(original, jumpStatement);
            Pair pair = Pair.create((Object)original, (Object)lastStatement);
            if (pair == null) {
                JSFlipIfIntention.$$$reportNull$$$0(4);
            }
            return pair;
        }
        return JSFlipIfIntention.defaultFlipBranches(original);
    }

    private static JSSourceElement addStatementsAfter(@NotNull JSIfStatement original, JSSourceElement @NotNull [] statements) {
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(5);
        }
        if (statements == null) {
            JSFlipIfIntention.$$$reportNull$$$0(6);
        }
        JSIfStatement anchor = original;
        for (JSSourceElement statement : statements) {
            anchor = (JSSourceElement)anchor.getParent().addAfter((PsiElement)statement, (PsiElement)anchor);
        }
        return anchor;
    }

    private static void setThenBranch(@NotNull JSIfStatement original, @NotNull List<JSStatement> statements) {
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(7);
        }
        if (statements == null) {
            JSFlipIfIntention.$$$reportNull$$$0(8);
        }
        JSFlipIfIntention.setThenBranch(original, JSFlipIfIntention.wrapWithBlockStatement((PsiElement)original, statements));
    }

    private static void setThenBranch(@NotNull JSIfStatement original, @Nullable JSStatement statement) {
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(9);
        }
        original.setThen(statement == null ? null : JSFlipIfIntention.wrapWithBlockStatement((PsiElement)original, statement));
    }

    private static void setElseBranch(@NotNull JSIfStatement original, @Nullable JSStatement statement) {
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(10);
        }
        original.setElse(statement == null ? null : JSFlipIfIntention.wrapWithBlockStatement((PsiElement)original, statement));
    }

    @NotNull
    private static JSStatement wrapWithBlockStatement(@NotNull PsiElement context, @NotNull JSStatement statement) {
        if (context == null) {
            JSFlipIfIntention.$$$reportNull$$$0(11);
        }
        if (statement == null) {
            JSFlipIfIntention.$$$reportNull$$$0(12);
        }
        return statement instanceof JSBlockStatement ? statement : JSFlipIfIntention.wrapWithBlockStatement(context, Collections.singletonList(statement));
    }

    @NotNull
    private static JSStatement wrapWithBlockStatement(@NotNull PsiElement context, @NotNull List<JSStatement> statements) {
        if (context == null) {
            JSFlipIfIntention.$$$reportNull$$$0(13);
        }
        if (statements == null) {
            JSFlipIfIntention.$$$reportNull$$$0(14);
        }
        JSBlockStatement blockStatement = (JSBlockStatement)JSPsiElementFactory.createJSStatement((String)"{}", (PsiElement)context, JSBlockStatement.class);
        PsiElement anchor = Objects.requireNonNull(blockStatement.getNode().findChildByType(JSTokenTypes.LBRACE)).getPsi();
        for (JSStatement toAdd : statements) {
            anchor = blockStatement.addAfter((PsiElement)toAdd, anchor);
        }
        JSBlockStatement jSBlockStatement = blockStatement;
        if (jSBlockStatement == null) {
            JSFlipIfIntention.$$$reportNull$$$0(15);
        }
        return jSBlockStatement;
    }

    private static boolean alwaysTransfersControlAtEnd(@Nullable JSSourceElement statement) {
        if (statement instanceof JSFunctionExitPoint || statement instanceof JSBreakStatement || statement instanceof JSContinueStatement) {
            return true;
        }
        return statement instanceof JSBlockStatement && JSFlipIfIntention.alwaysTransfersControlAtEnd((JSSourceElement)ArrayUtil.getLastElement((Object[])((JSBlockStatement)statement).getStatementListItems()));
    }

    @NotNull
    private static List<JSStatement> getStatementsAfter(@NotNull JSStatement original) {
        PsiElement parent;
        List statementsInBlock;
        int originalIndex;
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(16);
        }
        List list = (originalIndex = (statementsInBlock = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)(parent = original.getParent()), JSStatement.class)).indexOf(original)) >= 0 && !statementsInBlock.isEmpty() ? statementsInBlock.subList(originalIndex + 1, statementsInBlock.size()) : statementsInBlock;
        if (list == null) {
            JSFlipIfIntention.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static JSSourceElement @NotNull [] extractStatements(@NotNull JSStatement statement) {
        JSSourceElement[] jSSourceElementArray;
        JSBlockStatement jsBlockStatement;
        if (statement == null) {
            JSFlipIfIntention.$$$reportNull$$$0(18);
        }
        JSBlockStatement jSBlockStatement = jsBlockStatement = statement instanceof JSBlockStatement ? (JSBlockStatement)statement : null;
        if (jsBlockStatement != null) {
            jSSourceElementArray = jsBlockStatement.getStatementListItems();
        } else {
            JSSourceElement[] jSSourceElementArray2 = new JSSourceElement[1];
            jSSourceElementArray = jSSourceElementArray2;
            jSSourceElementArray2[0] = statement;
        }
        if (jSSourceElementArray == null) {
            JSFlipIfIntention.$$$reportNull$$$0(19);
        }
        return jSSourceElementArray;
    }

    @NotNull
    private static Pair<JSStatement, JSSourceElement> defaultFlipBranches(@NotNull JSIfStatement original) {
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(20);
        }
        JSStatement elseCopy = original.getElse() != null ? (JSStatement)original.getElse().copy() : null;
        JSStatement thenCopy = original.getThen() != null ? (JSStatement)original.getThen().copy() : null;
        JSFlipIfIntention.setThenBranch(original, elseCopy);
        JSFlipIfIntention.setElseBranch(original, thenCopy);
        Pair pair = Pair.create((Object)original, (Object)original);
        if (pair == null) {
            JSFlipIfIntention.$$$reportNull$$$0(21);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/conditional/JSFlipIfIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/conditional/JSFlipIfIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processIfStatement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithBlockStatement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsAfter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "extractStatements";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultFlipBranches";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIfStatement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addStatementsAfter";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setThenBranch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setElseBranch";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithBlockStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStatementsAfter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractStatements";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "defaultFlipBranches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

