/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.timeTracking.TasksToolWindowFactory;
import com.intellij.tasks.timeTracking.model.WorkItem;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.util.Alarm;
import com.intellij.util.ui.TimerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

@State(name="TimeTrackingManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class TimeTrackingManager
implements Disposable,
PersistentStateComponent<Config> {
    private static final int TIME_TRACKING_TIME_UNIT = 1000;
    private final Project myProject;
    private final TaskManager myTaskManager;
    private Config myConfig;
    private Timer myTimeTrackingTimer;
    private final Alarm myIdleAlarm;
    private Runnable myActivityListener;
    private LocalTask myLastActiveTask;
    private Disposable myActivityListenerDisposable;

    public TimeTrackingManager(@NotNull Project project) {
        if (project == null) {
            TimeTrackingManager.$$$reportNull$$$0(0);
        }
        this.myConfig = new Config();
        this.myIdleAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        PluginVerifier.verifyUltimatePlugin();
        this.myProject = project;
        this.myTaskManager = TaskManager.getManager((Project)project);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myTimeTrackingTimer = TimerUtil.createNamedTimer((String)"TaskManager time tracking", (int)1000, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalTask activeTask = TimeTrackingManager.this.myTaskManager.getActiveTask();
                if (TimeTrackingManager.this.myLastActiveTask != activeTask) {
                    activeTask.addWorkItem(new WorkItem(new Date()));
                }
                if (activeTask.isRunning() || TimeTrackingManager.this.getState().autoMode) {
                    WorkItem lastWorkItem = (WorkItem)activeTask.getWorkItems().get(activeTask.getWorkItems().size() - 1);
                    lastWorkItem.duration += 1000L;
                    TimeTrackingManager.this.getState().totallyTimeSpent += 1000L;
                }
                TimeTrackingManager.this.myLastActiveTask = activeTask;
            }
        });
        this.myActivityListener = () -> {
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            if (frame == null) {
                return;
            }
            Project project1 = frame.getProject();
            if (project1 == null || !this.myProject.equals(project1)) {
                return;
            }
            this.startTimeTrackingTimer();
        };
        if (this.getState().autoMode) {
            IdeEventQueue.getInstance().addActivityListener(this.myActivityListener, (Disposable)this.myProject);
        }
    }

    public static TimeTrackingManager getInstance(@NotNull Project project) {
        if (project == null) {
            TimeTrackingManager.$$$reportNull$$$0(1);
        }
        return (TimeTrackingManager)ServiceManager.getService((Project)project, TimeTrackingManager.class);
    }

    private void startTimeTrackingTimer() {
        if (this.myIdleAlarm.isDisposed()) {
            return;
        }
        if (!this.myTimeTrackingTimer.isRunning()) {
            this.myTimeTrackingTimer.start();
        }
        this.startIdleAlarm();
    }

    void startIdleAlarm() {
        this.myIdleAlarm.cancelAllRequests();
        this.myIdleAlarm.addRequest(() -> {
            if (this.myTimeTrackingTimer.isRunning()) {
                this.myTimeTrackingTimer.stop();
            }
        }, this.getState().suspendDelayInSeconds * 1000);
    }

    public void updateTimeTrackingToolWindow() {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Time Tracking");
        if (this.isTimeTrackingToolWindowAvailable()) {
            if (toolWindow == null) {
                toolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow("Time Tracking", true, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, true);
                new TasksToolWindowFactory().createToolWindowContent(this.myProject, toolWindow);
            }
            ToolWindow finalToolWindow = toolWindow;
            ApplicationManager.getApplication().invokeLater(() -> {
                finalToolWindow.setAvailable(true);
                finalToolWindow.show(null);
                finalToolWindow.activate(null);
            });
        } else if (toolWindow != null) {
            ToolWindow finalToolWindow = toolWindow;
            ApplicationManager.getApplication().invokeLater(() -> finalToolWindow.setAvailable(false));
        }
    }

    public boolean isTimeTrackingToolWindowAvailable() {
        return this.getState().enabled;
    }

    public void setAutoMode(boolean on) {
        boolean oldState = this.getState().autoMode;
        if (on == oldState) {
            return;
        }
        this.getState().autoMode = on;
        Disposable activityListenerDisposable = this.myActivityListenerDisposable;
        if (on) {
            if (activityListenerDisposable == null) {
                this.myActivityListenerDisposable = activityListenerDisposable = Disposer.newDisposable();
            }
            IdeEventQueue.getInstance().addActivityListener(this.myActivityListener, activityListenerDisposable);
        } else {
            if (activityListenerDisposable != null) {
                this.myActivityListenerDisposable = null;
                Disposer.dispose((Disposable)activityListenerDisposable);
            }
            this.myIdleAlarm.cancelAllRequests();
            if (!this.myTimeTrackingTimer.isRunning()) {
                this.myTimeTrackingTimer.start();
            }
        }
    }

    public void dispose() {
        if (this.myTimeTrackingTimer != null) {
            this.myTimeTrackingTimer.stop();
        }
    }

    @NotNull
    public Config getState() {
        Config config = this.myConfig;
        if (config == null) {
            TimeTrackingManager.$$$reportNull$$$0(2);
        }
        return config;
    }

    public void loadState(@NotNull Config state) {
        if (state == null) {
            TimeTrackingManager.$$$reportNull$$$0(3);
        }
        this.myConfig = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/timeTracking/TimeTrackingManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/timeTracking/TimeTrackingManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Config {
        public boolean enabled = false;
        public long totallyTimeSpent = 0L;
        public int suspendDelayInSeconds = 600;
        public boolean autoMode = true;
        public boolean showClosedTasks = true;
        public boolean showSpentTimeFromLastPost = false;
    }

    static final class TimeTrackingStartupActivity
    implements StartupActivity.DumbAware {
        TimeTrackingStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            Application app;
            if (project == null) {
                TimeTrackingStartupActivity.$$$reportNull$$$0(0);
            }
            if ((app = ApplicationManager.getApplication()).isUnitTestMode()) {
                return;
            }
            app.invokeLater(() -> TimeTrackingManager.getInstance(project).startTimeTrackingTimer(), project.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/timeTracking/TimeTrackingManager$TimeTrackingStartupActivity", "runActivity"));
        }
    }
}

