/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.api;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.intellij.datalore.api.DataloreHttpClient;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002JF\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u00112\u0016\b\u0002\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0011J<\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00142\u0016\b\u0002\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0011J\n\u0010\u0015\u001a\u00020\u0016*\u00020\nR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/intellij/datalore/api/AbstractController;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logError", "", "response", "Lorg/apache/http/HttpResponse;", "requestWithStatus", "request", "Lorg/apache/http/client/methods/HttpUriRequest;", "client", "Lorg/apache/http/client/HttpClient;", "expectedStatus", "Lkotlin/Function1;", "", "errorHandler", "", "getStringFromRequest", "", "datalore-intellij-plugin"})
public abstract class AbstractController {
    @NotNull
    public abstract Logger getLogger();

    @Nullable
    public final HttpResponse requestWithStatus(@NotNull HttpUriRequest request, @NotNull HttpClient client, @NotNull Function1<? super HttpResponse, Boolean> expectedStatus, @Nullable Function1<? super HttpResponse, Unit> errorHandler) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull(expectedStatus, (String)"expectedStatus");
        try {
            HttpResponse response;
            HttpResponse httpResponse = response = client.execute(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponse, (String)"response");
            if (!((Boolean)expectedStatus.invoke((Object)httpResponse)).booleanValue()) {
                if (errorHandler != null) {
                    errorHandler.invoke((Object)response);
                }
                this.logError(response);
                return null;
            }
            return response;
        }
        catch (IOException e) {
            this.getLogger().warn("Error when executing HTTP request: " + e.getMessage());
            return null;
        }
        catch (IllegalStateException e) {
            this.getLogger().warn("Error when executing HTTP request: " + e.getMessage());
            return null;
        }
    }

    public static /* synthetic */ HttpResponse requestWithStatus$default(AbstractController abstractController, HttpUriRequest httpUriRequest, HttpClient httpClient, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestWithStatus");
        }
        if ((n & 2) != 0) {
            httpClient = (HttpClient)DataloreHttpClient.INSTANCE.getGLOBAL_HTTP_CLIENT();
        }
        if ((n & 8) != 0) {
            function12 = null;
        }
        return abstractController.requestWithStatus(httpUriRequest, httpClient, (Function1<? super HttpResponse, Boolean>)function1, (Function1<? super HttpResponse, Unit>)function12);
    }

    @Nullable
    public final HttpResponse requestWithStatus(@NotNull HttpUriRequest request, @NotNull HttpClient client, int expectedStatus, @Nullable Function1<? super HttpResponse, Unit> errorHandler) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        return this.requestWithStatus(request, client, (Function1<? super HttpResponse, Boolean>)((Function1)new Function1<HttpResponse, Boolean>(expectedStatus){
            final /* synthetic */ int $expectedStatus;

            public final boolean invoke(@NotNull HttpResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                StatusLine statusLine = response.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
                return statusLine.getStatusCode() == this.$expectedStatus;
            }
            {
                this.$expectedStatus = n;
                super(1);
            }
        }), errorHandler);
    }

    public static /* synthetic */ HttpResponse requestWithStatus$default(AbstractController abstractController, HttpUriRequest httpUriRequest, HttpClient httpClient, int n, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestWithStatus");
        }
        if ((n2 & 2) != 0) {
            httpClient = (HttpClient)DataloreHttpClient.INSTANCE.getGLOBAL_HTTP_CLIENT();
        }
        if ((n2 & 4) != 0) {
            n = 200;
        }
        if ((n2 & 8) != 0) {
            function1 = null;
        }
        return abstractController.requestWithStatus(httpUriRequest, httpClient, n, (Function1<? super HttpResponse, Unit>)function1);
    }

    @NotNull
    public final String getStringFromRequest(@NotNull HttpResponse $this$getStringFromRequest) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getStringFromRequest, (String)"$this$getStringFromRequest");
        String string = EntityUtils.toString((HttpEntity)$this$getStringFromRequest.getEntity(), (Charset)Charset.defaultCharset());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EntityUtils.toString(ent\u2026Charset.defaultCharset())");
        return string;
    }

    private final void logError(HttpResponse response) {
        Logger logger = this.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("Not expected status received: ");
        StatusLine statusLine = response.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
        logger.warn(stringBuilder.append(statusLine.getStatusCode()).append(". Response body: ").append(this.getStringFromRequest(response)).toString());
    }
}

