/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInsight.preview;

import com.intellij.codeInsight.preview.ColorPreviewComponent;
import com.intellij.codeInsight.preview.ImagePreviewComponent;
import com.intellij.htmltools.codeInsight.preview.BaseHtmlPreviewHintProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlPreviewHintProvider
extends BaseHtmlPreviewHintProvider {
    public JComponent getPreviewComponent(@NotNull PsiElement element) {
        PsiElement parentParent;
        if (element == null) {
            HtmlPreviewHintProvider.$$$reportNull$$$0(0);
        }
        if (element.getParent() instanceof XmlAttributeValue && (parentParent = element.getParent().getParent()) instanceof XmlAttribute) {
            PsiElement attributeValue;
            String s;
            XmlAttribute attribute = (XmlAttribute)parentParent;
            String attrName = attribute.getName();
            if (("alink".equalsIgnoreCase(attrName) || "link".equalsIgnoreCase(attrName) || "text".equalsIgnoreCase(attrName) || "vlink".equalsIgnoreCase(attrName) || StringUtil.containsIgnoreCase((String)attrName, (String)"color")) && (s = element.getText()).length() > 0) {
                String hexColor;
                String string = hexColor = s.charAt(0) == '#' ? s : ColorMap.getHexCodeForColorName((String)StringUtil.toLowerCase((String)s));
                if (hexColor != null) {
                    try {
                        return new ColorPreviewComponent(Color.decode("0x" + hexColor.substring(1)));
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            }
            if ((attributeValue = element.getParent()).getParent() instanceof XmlAttribute && ("background".equalsIgnoreCase(attrName) || "src".equalsIgnoreCase(attrName) || "href".equalsIgnoreCase(attrName))) {
                String attrValue = attribute.getValue();
                if (attrValue != null && URLUtil.isDataUri((String)attrValue)) {
                    return HtmlPreviewHintProvider.getPreviewFromDataUri(attrValue);
                }
                for (PsiElement parent = element; parent != null && parent != attribute; parent = parent.getParent()) {
                    JComponent c = ImagePreviewComponent.getPreviewComponent((PsiElement)parent);
                    if (c == null) continue;
                    return c;
                }
            }
        }
        return null;
    }

    @Nullable
    private static JComponent getPreviewFromDataUri(@NotNull String dataUri) {
        if (dataUri == null) {
            HtmlPreviewHintProvider.$$$reportNull$$$0(1);
        }
        ImagePreviewComponent preview = null;
        byte[] imageBytes = URLUtil.getBytesFromDataUri((String)dataUri);
        if (imageBytes != null) {
            try {
                preview = ImagePreviewComponent.getPreviewComponent((BufferedImage)ImagePreviewComponent.readImageFromBytes((byte[])imageBytes), (long)imageBytes.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return preview;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataUri";
                break;
            }
        }
        objectArray2[1] = "com/intellij/htmltools/codeInsight/preview/HtmlPreviewHintProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreviewComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreviewFromDataUri";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

