/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.PropertyRevision;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SvnLazyPropertyContentRevision
extends SvnBaseContentRevision
implements PropertyRevision {
    private static final String ourPropertiesDelimiter = "\n";
    private final VcsRevisionNumber myNumber;
    private final Url myUrl;
    private List<PropertyData> myContent;

    public SvnLazyPropertyContentRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, VcsRevisionNumber number, Url url) {
        if (vcs == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(1);
        }
        super(vcs, file);
        this.myNumber = number;
        this.myUrl = url;
    }

    @Override
    @Nullable
    public List<PropertyData> getProperties() throws VcsException {
        if (this.myContent == null) {
            this.myContent = this.loadContent();
        }
        return this.myContent;
    }

    public String getContent() throws VcsException {
        return SvnLazyPropertyContentRevision.toSortedStringPresentation(this.getProperties());
    }

    private List<PropertyData> loadContent() throws VcsException {
        Ref ref = new Ref();
        Ref exceptionRef = new Ref();
        Runnable runnable = () -> {
            try {
                ref.set(SvnLazyPropertyContentRevision.getPropertyList(this.myVcs, this.myUrl, ((SvnRevisionNumber)this.myNumber).getRevision()));
            }
            catch (VcsException e) {
                exceptionRef.set((Object)e);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, SvnBundle.message("progress.title.loading.file.properties", new Object[0]), true, this.myVcs.getProject());
            if (!completed) {
                throw new VcsException("Properties load for revision " + this.getRevisionNumber().asString() + " was canceled.");
            }
        } else {
            runnable.run();
        }
        if (!exceptionRef.isNull()) {
            throw (VcsException)((Object)exceptionRef.get());
        }
        return (List)ref.get();
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = this.myNumber;
        if (vcsRevisionNumber == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(2);
        }
        return vcsRevisionNumber;
    }

    @NotNull
    public static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull Url url, @Nullable Revision revision) throws SvnBindException {
        if (vcs == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(3);
        }
        if (url == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(4);
        }
        return SvnLazyPropertyContentRevision.getPropertyList(vcs, Target.on(url, revision), revision);
    }

    @NotNull
    public static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull File ioFile, @Nullable Revision revision) throws SvnBindException {
        if (vcs == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(5);
        }
        if (ioFile == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(6);
        }
        return SvnLazyPropertyContentRevision.getPropertyList(vcs, Target.on(ioFile, revision), revision);
    }

    @NotNull
    public static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull Target target, @Nullable Revision revision) throws SvnBindException {
        if (vcs == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(7);
        }
        if (target == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(8);
        }
        ArrayList<PropertyData> lines = new ArrayList<PropertyData>();
        PropertyConsumer propertyHandler = SvnLazyPropertyContentRevision.createHandler(revision, lines);
        vcs.getFactory(target).createPropertyClient().list(target, revision, Depth.EMPTY, propertyHandler);
        ArrayList<PropertyData> arrayList = lines;
        if (arrayList == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static PropertyConsumer createHandler(Revision revision, final @NotNull List<? super PropertyData> lines) {
        ProgressIndicator indicator;
        if (lines == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(10);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.checkCanceled();
            indicator.setText(SvnBundle.message("show.properties.diff.progress.text.revision.information", revision.toString()));
        }
        return new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) {
                this.registerProperty(property);
            }

            @Override
            public void handleProperty(Url url, PropertyData property) {
                this.registerProperty(property);
            }

            @Override
            public void handleProperty(long revision, PropertyData property) {
            }

            private void registerProperty(@NotNull PropertyData property) {
                if (property == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(SvnBundle.message("show.properties.diff.progress.text2.property.information", property.getName()));
                }
                lines.add(property);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/history/SvnLazyPropertyContentRevision$1", "registerProperty"));
            }
        };
    }

    @NotNull
    public static String toSortedStringPresentation(@NotNull List<? extends PropertyData> lines) {
        if (lines == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(11);
        }
        StringBuilder sb = new StringBuilder();
        Collections.sort(lines, Comparator.comparing(PropertyData::getName));
        for (PropertyData propertyData : lines) {
            SvnLazyPropertyContentRevision.addPropertyPresentation(propertyData, sb);
        }
        String string = sb.toString();
        if (string == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void addPropertyPresentation(@NotNull PropertyData property, @NotNull StringBuilder sb) {
        if (property == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(13);
        }
        if (sb == null) {
            SvnLazyPropertyContentRevision.$$$reportNull$$$0(14);
        }
        if (sb.length() != 0) {
            sb.append(ourPropertiesDelimiter);
        }
        sb.append(property.getName()).append("=").append(StringUtil.notNullize((String)PropertyValue.toString(property.getValue())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnLazyPropertyContentRevision";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnLazyPropertyContentRevision";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toSortedStringPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toSortedStringPresentation";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

