/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.StatisticsEventLogUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogBuildNumber
implements Comparable<EventLogBuildNumber> {
    public static final int SNAPSHOT_VALUE = Integer.MAX_VALUE;
    @NotNull
    private final int[] myComponents;

    public EventLogBuildNumber(int ... components) {
        if (components == null) {
            EventLogBuildNumber.$$$reportNull$$$0(0);
        }
        this.myComponents = components;
    }

    @NotNull
    public int[] getComponents() {
        int[] nArray = (int[])this.myComponents.clone();
        if (nArray == null) {
            EventLogBuildNumber.$$$reportNull$$$0(1);
        }
        return nArray;
    }

    @Nullable
    public static EventLogBuildNumber fromString(@Nullable String version) {
        if (version == null || StatisticsEventLogUtil.isEmptyOrSpaces(version)) {
            return null;
        }
        String versionWithoutCode = EventLogBuildNumber.removeProductCode(version);
        int separator = versionWithoutCode.indexOf(46);
        if (separator > 0) {
            List<String> components = StatisticsEventLogUtil.split(versionWithoutCode, '.');
            return new EventLogBuildNumber(EventLogBuildNumber.toIntArray(components));
        }
        return new EventLogBuildNumber(EventLogBuildNumber.tryParseInt(versionWithoutCode), 0);
    }

    private static int[] toIntArray(List<String> components) {
        int componentsSize = components.size();
        int size = componentsSize != 1 ? componentsSize : 2;
        int[] array = new int[size];
        for (int i = 0; i < componentsSize; ++i) {
            String component = components.get(i);
            array[i] = EventLogBuildNumber.tryParseInt(component);
        }
        if (componentsSize < size) {
            array[componentsSize] = 0;
        }
        return array;
    }

    @NotNull
    private static String removeProductCode(@NotNull String version) {
        String code;
        int productSeparator;
        if (version == null) {
            EventLogBuildNumber.$$$reportNull$$$0(2);
        }
        if ((productSeparator = (code = version).indexOf(45)) > 0) {
            code = code.substring(productSeparator + 1);
        }
        String string = code;
        if (string == null) {
            EventLogBuildNumber.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static int tryParseInt(@NotNull String version) {
        if (version == null) {
            EventLogBuildNumber.$$$reportNull$$$0(4);
        }
        try {
            return Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public int compareTo(@NotNull EventLogBuildNumber o) {
        if (o == null) {
            EventLogBuildNumber.$$$reportNull$$$0(5);
        }
        int[] c1 = this.myComponents;
        int[] c2 = o.myComponents;
        for (int i = 0; i < Math.min(c1.length, c2.length); ++i) {
            if (c1[i] == c2[i] && c1[i] == Integer.MAX_VALUE) {
                return 0;
            }
            if (c1[i] == Integer.MAX_VALUE) {
                return 1;
            }
            if (c2[i] == Integer.MAX_VALUE) {
                return -1;
            }
            int result = c1[i] - c2[i];
            if (result == 0) continue;
            return result;
        }
        return c1.length - c2.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventLogBuildNumber number = (EventLogBuildNumber)o;
        return Arrays.equals(this.myComponents, number.myComponents);
    }

    public int hashCode() {
        return Arrays.hashCode(this.myComponents);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogBuildNumber";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogBuildNumber";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeProductCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeProductCode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryParseInt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

