/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ComponentInfoImpl;
import com.intellij.configurationStore.ComponentWithModificationTrackerInfo;
import com.intellij.configurationStore.ComponentWithStateModificationTrackerInfo;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.ThreeState;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"createComponentInfo", "Lcom/intellij/configurationStore/ComponentInfo;", "component", "", "stateSpec", "Lcom/intellij/openapi/components/State;", "serviceDescriptor", "Lcom/intellij/openapi/components/ServiceDescriptor;", "isUseSaveThreshold", "", "storage", "Lcom/intellij/openapi/components/Storage;", "intellij.platform.configurationStore.impl"})
public final class ComponentInfoKt {
    @NotNull
    public static final ComponentInfo createComponentInfo(@NotNull Object component, @Nullable State stateSpec, @Nullable ServiceDescriptor serviceDescriptor) {
        ComponentInfo result;
        ComponentInfo componentInfo;
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Storage[] storageArray = component;
        if (storageArray instanceof PersistentStateComponentWithModificationTracker) {
            ServiceDescriptor serviceDescriptor2 = serviceDescriptor;
            componentInfo = new ComponentWithStateModificationTrackerInfo((PersistentStateComponentWithModificationTracker)component, stateSpec, serviceDescriptor2 != null ? serviceDescriptor2.configurationSchemaKey : null);
        } else if (storageArray instanceof ModificationTracker) {
            ServiceDescriptor serviceDescriptor3 = serviceDescriptor;
            componentInfo = new ComponentWithModificationTrackerInfo((ModificationTracker)component, stateSpec, serviceDescriptor3 != null ? serviceDescriptor3.configurationSchemaKey : null);
        } else {
            componentInfo = result = (ComponentInfo)new ComponentInfoImpl(component, stateSpec);
        }
        if (stateSpec != null) {
            storageArray = stateSpec.storages();
            boolean bl = false;
            Storage[] storageArray2 = storageArray;
            int n = 0;
            if (!(storageArray2.length == 0)) {
                boolean bl2;
                block8: {
                    Storage[] $this$all$iv = stateSpec.storages();
                    boolean $i$f$all = false;
                    storageArray2 = $this$all$iv;
                    n = storageArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Storage element$iv;
                        Storage it = element$iv = storageArray2[i];
                        boolean bl3 = false;
                        if (it.deprecated() || ComponentInfoKt.isUseSaveThreshold(it)) continue;
                        bl2 = false;
                        break block8;
                    }
                    bl2 = true;
                }
                if (bl2) {
                    result.setLastSaved((int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
                }
            }
        }
        return result;
    }

    private static final boolean isUseSaveThreshold(Storage storage2) {
        return storage2.useSaveThreshold() != ThreeState.NO && StateStorageManagerImplKt.getEffectiveRoamingType(storage2.roamingType(), StateStorageManagerImplKt.getPath(storage2)) == RoamingType.DISABLED;
    }
}

