/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import org.intellij.lang.regexp.inspection.RegExpEquivalenceChecker;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DuplicateAlternationBranchInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicateAlternationBranchInspection.$$$reportNull$$$0(0);
        }
        return new DuplicateAlternationBranchVisitor(holder, isOnTheFly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/DuplicateAlternationBranchInspection", "buildVisitor"));
    }

    private static class DuplicateAlternationBranchFix
    implements LocalQuickFix {
        private DuplicateAlternationBranchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Remove duplicate branch";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2;
            if (project == null) {
                DuplicateAlternationBranchFix.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                DuplicateAlternationBranchFix.$$$reportNull$$$0(1);
            }
            if (!((element2 = descriptor2.getPsiElement()) instanceof RegExpBranch)) {
                return;
            }
            PsiElement prevSibling = element2.getPrevSibling();
            if (prevSibling != null) {
                prevSibling.delete();
            } else {
                PsiElement nextSibling = element2.getNextSibling();
                if (nextSibling != null) {
                    nextSibling.delete();
                }
            }
            element2.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/inspection/DuplicateAlternationBranchInspection$DuplicateAlternationBranchFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DuplicateAlternationBranchVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        DuplicateAlternationBranchVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches = pattern.getBranches();
            if (branches.length < 2) {
                return;
            }
            HashSet<RegExpBranch> reported = new HashSet<RegExpBranch>(2);
            for (int i = 0; i < branches.length - 1; ++i) {
                RegExpBranch branch1 = branches[i];
                if (branch1.getAtoms().length == 0) continue;
                for (int j = i + 1; j < branches.length; ++j) {
                    RegExpBranch branch2 = branches[j];
                    if (!RegExpEquivalenceChecker.areElementsEquivalent(branch1, branch2)) continue;
                    if (reported.add(branch1) && this.myIsOnTheFly) {
                        this.registerProblem(branch1);
                    }
                    if (!reported.add(branch2)) continue;
                    this.registerProblem(branch2);
                }
            }
        }

        private void registerProblem(RegExpBranch branch1) {
            this.myHolder.registerProblem((PsiElement)branch1, "Duplicate branch in alternation", new LocalQuickFix[]{new DuplicateAlternationBranchFix()});
        }
    }
}

