/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.legacyBridge.intellij;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponent;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspace.UtilsKt;
import com.intellij.workspace.api.EntityChange;
import com.intellij.workspace.api.EntityStoreChanged;
import com.intellij.workspace.api.LibraryEntity;
import com.intellij.workspace.ide.WorkspaceModelChangeListener;
import com.intellij.workspace.ide.WorkspaceModelTopics;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rR\u00020\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeProjectRootManager;", "Lcom/intellij/openapi/roots/impl/ProjectRootManagerComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "myLibraryTableListenersLock", "", "myLibraryTableMultiListeners", "", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeProjectRootManager$LibraryTableMultiListener;", "addListenerForTable", "Lcom/intellij/openapi/Disposable;", "libraryTable", "libraryHasOrderEntry", "", "name", "", "processChanges", "events", "Lcom/intellij/workspace/api/EntityStoreChanged;", "removeListenerForTable", "", "LibraryTableMultiListener", "intellij.platform.workspaceModel.ide"})
public final class LegacyBridgeProjectRootManager
extends ProjectRootManagerComponent {
    private final Logger LOG;
    private final Object myLibraryTableListenersLock;
    private final Map<LibraryTable, LibraryTableMultiListener> myLibraryTableMultiListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Disposable addListenerForTable(@NotNull LibraryTable libraryTable) {
        Intrinsics.checkParameterIsNotNull((Object)libraryTable, (String)"libraryTable");
        Object object = this.myLibraryTableListenersLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener == null) {
                multiListener = new LibraryTableMultiListener();
                libraryTable.addListener((LibraryTable.Listener)multiListener);
                this.myLibraryTableMultiListeners.put(libraryTable, multiListener);
            }
            multiListener.incListener();
            Disposable disposable2 = new Disposable(this, libraryTable){
                final /* synthetic */ LegacyBridgeProjectRootManager this$0;
                final /* synthetic */ LibraryTable $libraryTable$inlined;
                {
                    this.this$0 = legacyBridgeProjectRootManager;
                    this.$libraryTable$inlined = libraryTable;
                }

                public final void dispose() {
                    LegacyBridgeProjectRootManager.access$removeListenerForTable(this.this$0, this.$libraryTable$inlined);
                }
            };
            return disposable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeListenerForTable(LibraryTable libraryTable) {
        Object object = this.myLibraryTableListenersLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean last;
            boolean bl3 = false;
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener != null && (last = multiListener.decListener())) {
                libraryTable.removeListener((LibraryTable.Listener)multiListener);
                this.myLibraryTableMultiListeners.remove(libraryTable);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean processChanges(EntityStoreChanged events, Project project) {
        List<EntityChange<LibraryEntity>> libraryChanges = events.getChanges(LibraryEntity.class);
        Collection collection = libraryChanges;
        boolean bl = false;
        if (!collection.isEmpty()) {
            collection = libraryChanges;
            bl = false;
            if (collection.size() == SequencesKt.count(events.getAllChanges())) {
                for (EntityChange<LibraryEntity> event : libraryChanges) {
                    boolean res2;
                    boolean bl2;
                    EntityChange<LibraryEntity> entityChange = event;
                    if (entityChange instanceof EntityChange.Added) {
                        bl2 = this.libraryHasOrderEntry(((LibraryEntity)((EntityChange.Added)event).getEntity()).getName(), project);
                    } else if (entityChange instanceof EntityChange.Removed) {
                        bl2 = this.libraryHasOrderEntry(((LibraryEntity)((EntityChange.Removed)event).getEntity()).getName(), project);
                    } else if (entityChange instanceof EntityChange.Replaced) {
                        bl2 = this.libraryHasOrderEntry(((LibraryEntity)((EntityChange.Replaced)event).getNewEntity()).getName(), project);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    if (!(res2 = bl2)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private final boolean libraryHasOrderEntry(String name, Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Module[] $this$forEach$iv = moduleArray;
        boolean $i$f$forEach = false;
        Module[] moduleArray2 = $this$forEach$iv;
        int n = moduleArray2.length;
        for (int i = 0; i < n; ++i) {
            boolean exists;
            block2: {
                boolean bl;
                OrderEntry[] $this$any$iv;
                Module element$iv;
                Module module = element$iv = moduleArray2[i];
                boolean bl2 = false;
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager.getOrderEntries(), (String)"ModuleRootManager.getInstance(module).orderEntries");
                boolean $i$f$any = false;
                OrderEntry[] orderEntryArray = $this$any$iv;
                int n2 = orderEntryArray.length;
                for (int j = 0; j < n2; ++j) {
                    OrderEntry element$iv2;
                    OrderEntry it = element$iv2 = orderEntryArray[j];
                    boolean bl3 = false;
                    if (!(it instanceof LibraryOrderEntry && Intrinsics.areEqual((Object)((LibraryOrderEntry)it).getLibraryName(), (Object)name))) continue;
                    bl = true;
                    break block2;
                }
                bl = exists = false;
            }
            if (!exists) continue;
            return true;
        }
        return false;
    }

    public LegacyBridgeProjectRootManager(final @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG = logger;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection bus = messageBusConnection;
        WorkspaceModelTopics.Companion.getInstance(project).subscribeAfterModuleLoading(bus, new WorkspaceModelChangeListener(){

            @Override
            public void beforeChanged(@NotNull EntityStoreChanged event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Project project2 = myProject;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myProject");
                if (project2.isDisposed() || Disposer.isDisposing((Disposable)((Disposable)myProject))) {
                    return;
                }
                boolean performUpdate = this.processChanges(event, project);
                if (performUpdate) {
                    this.getBatchSession(false).beforeRootsChanged();
                }
            }

            @Override
            public void changed(@NotNull EntityStoreChanged event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Project project2 = myProject;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myProject");
                if (project2.isDisposed() || Disposer.isDisposing((Disposable)((Disposable)myProject))) {
                    return;
                }
                UtilsKt.bracket(LOG, "ProjectRootManager.EntityStoreChange", (Function0)new Function0<Unit>(this, event){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ EntityStoreChanged $event;

                    public final void invoke() {
                        boolean performUpdate = LegacyBridgeProjectRootManager.access$processChanges(this.this$0.this, this.$event, this.this$0.project);
                        if (performUpdate) {
                            LegacyBridgeProjectRootManager.access$getBatchSession(this.this$0.this, false).rootsChanged();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$event = entityStoreChanged;
                        super(0);
                    }
                });
            }
        });
        final RootProvider.RootSetChangedListener listener2 = new RootProvider.RootSetChangedListener(this){
            final /* synthetic */ LegacyBridgeProjectRootManager this$0;

            public final void rootSetChanged(@NotNull RootProvider it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.makeRootsChange(EmptyRunnable.INSTANCE, false, true);
            }
            {
                this.this$0 = legacyBridgeProjectRootManager;
            }
        };
        bus.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Listener(){

            public void jdkAdded(@NotNull Sdk jdk) {
                Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
                jdk.getRootProvider().addRootSetChangedListener(listener2, (Disposable)this);
            }

            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
                Intrinsics.checkParameterIsNotNull((Object)previousName, (String)"previousName");
            }

            public void jdkRemoved(@NotNull Sdk jdk) {
                Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
                jdk.getRootProvider().removeRootSetChangedListener(listener2);
            }
        });
        this.myLibraryTableListenersLock = new Object();
        this.myLibraryTableMultiListeners = new HashMap();
    }

    public static final /* synthetic */ void access$removeListenerForTable(LegacyBridgeProjectRootManager $this, LibraryTable libraryTable) {
        $this.removeListenerForTable(libraryTable);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeProjectRootManager$LibraryTableMultiListener;", "Lcom/intellij/openapi/roots/libraries/LibraryTable$Listener;", "(Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeProjectRootManager;)V", "counter", "", "afterLibraryAdded", "", "newLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "afterLibraryRemoved", "library", "afterLibraryRenamed", "beforeLibraryRemoved", "decListener", "", "incListener", "intellij.platform.workspaceModel.ide"})
    private final class LibraryTableMultiListener
    implements LibraryTable.Listener {
        private int counter;

        public final synchronized void incListener() {
            int n = this.counter;
            this.counter = n + 1;
        }

        public final synchronized boolean decListener() {
            LibraryTableMultiListener libraryTableMultiListener = this;
            libraryTableMultiListener.counter += -1;
            return libraryTableMultiListener.counter == 0;
        }

        public void afterLibraryAdded(@NotNull Library newLibrary2) {
            Intrinsics.checkParameterIsNotNull((Object)newLibrary2, (String)"newLibrary");
            LegacyBridgeProjectRootManager.this.incModificationCount();
        }

        public void afterLibraryRenamed(@NotNull Library library) {
            Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
            LegacyBridgeProjectRootManager.this.incModificationCount();
        }

        public void beforeLibraryRemoved(@NotNull Library library) {
            Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
            LegacyBridgeProjectRootManager.this.incModificationCount();
        }

        public void afterLibraryRemoved(@NotNull Library library) {
            Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
            LegacyBridgeProjectRootManager.this.incModificationCount();
        }
    }
}

