/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.jps;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.workspace.jps.JpsFileContentReader;
import com.intellij.workspace.jps.JpsProjectEntitiesLoaderKt;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0002R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/workspace/jps/CachingJpsFileContentReader;", "Lcom/intellij/workspace/jps/JpsFileContentReader;", "projectBaseDirUrl", "", "(Ljava/lang/String;)V", "fileContentCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jdom/Element;", "projectPathMacroManager", "Lcom/intellij/workspace/jps/CachingJpsFileContentReader$LegacyBridgeProjectPathMacroManager;", "loadComponent", "fileUrl", "componentName", "loadComponents", "LegacyBridgeModulePathMacroManager", "LegacyBridgeProjectPathMacroManager", "intellij.platform.workspaceModel.ide"})
public final class CachingJpsFileContentReader
implements JpsFileContentReader {
    private final LegacyBridgeProjectPathMacroManager projectPathMacroManager;
    private final ConcurrentHashMap<String, Map<String, Element>> fileContentCache;

    @Override
    @Nullable
    public Element loadComponent(@NotNull String fileUrl, @NotNull String componentName) {
        Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Map<String, Element> map2 = this.fileContentCache.computeIfAbsent(fileUrl, (Function<String, Map<String, Element>>)new Function<String, Map<String, ? extends Element>>(this){
            final /* synthetic */ CachingJpsFileContentReader this$0;

            @NotNull
            public final Map<String, Element> apply(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return CachingJpsFileContentReader.access$loadComponents(this.this$0, it);
            }
            {
                this.this$0 = cachingJpsFileContentReader;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"fileContentCache.compute\u2026 loadComponents(it)\n    }");
        Map<String, Element> content2 = map2;
        return content2.get(componentName);
    }

    private final Map<String, Element> loadComponents(String fileUrl) {
        File file2;
        PathMacroManager pathMacroManager;
        if (FileUtil.extensionEquals((String)fileUrl, (String)"iml")) {
            PathMacros pathMacros = PathMacros.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)pathMacros, (String)"PathMacros.getInstance()");
            String string = JpsPathUtil.urlToPath((String)fileUrl);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JpsPathUtil.urlToPath(fileUrl)");
            pathMacroManager = new LegacyBridgeModulePathMacroManager(pathMacros, string);
        } else {
            pathMacroManager = this.projectPathMacroManager;
        }
        PathMacroManager macroManager = pathMacroManager;
        File file3 = file2 = JpsPathUtil.urlToFile((String)fileUrl);
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file");
        if (!file3.isFile()) {
            return MapsKt.emptyMap();
        }
        return JpsProjectEntitiesLoaderKt.loadStorageFile(file2, macroManager);
    }

    public CachingJpsFileContentReader(@NotNull String projectBaseDirUrl) {
        Intrinsics.checkParameterIsNotNull((Object)projectBaseDirUrl, (String)"projectBaseDirUrl");
        String string = JpsPathUtil.urlToPath((String)projectBaseDirUrl);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JpsPathUtil.urlToPath(projectBaseDirUrl)");
        this.projectPathMacroManager = new LegacyBridgeProjectPathMacroManager(string);
        this.fileContentCache = new ConcurrentHashMap();
    }

    public static final /* synthetic */ Map access$loadComponents(CachingJpsFileContentReader $this, String fileUrl) {
        return $this.loadComponents(fileUrl);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspace/jps/CachingJpsFileContentReader$LegacyBridgeModulePathMacroManager;", "Lcom/intellij/openapi/components/PathMacroManager;", "pathMacros", "Lcom/intellij/openapi/application/PathMacros;", "moduleFilePath", "", "(Lcom/intellij/openapi/application/PathMacros;Ljava/lang/String;)V", "computeReplacePathMap", "Lcom/intellij/application/options/ReplacePathToMacroMap;", "getExpandMacroMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "intellij.platform.workspaceModel.ide"})
    public static final class LegacyBridgeModulePathMacroManager
    extends PathMacroManager {
        private final String moduleFilePath;

        @Override
        @NotNull
        public ExpandMacroToPathMap getExpandMacroMap() {
            ExpandMacroToPathMap expandMacroToPathMap = super.getExpandMacroMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)expandMacroToPathMap, (String)"super.getExpandMacroMap()");
            ExpandMacroToPathMap result2 = expandMacroToPathMap;
            LegacyBridgeModulePathMacroManager.access$addFileHierarchyReplacements$s-1592960218(result2, "MODULE_DIR", PathMacroUtil.getModuleDir((String)this.moduleFilePath));
            return result2;
        }

        @Override
        @NotNull
        public ReplacePathToMacroMap computeReplacePathMap() {
            ReplacePathToMacroMap replacePathToMacroMap = super.computeReplacePathMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)replacePathToMacroMap), (String)"super.computeReplacePathMap()");
            ReplacePathToMacroMap result2 = replacePathToMacroMap;
            String modulePath = PathMacroUtil.getModuleDir((String)this.moduleFilePath);
            LegacyBridgeModulePathMacroManager.access$addFileHierarchyReplacements$s-1592960218(result2, "MODULE_DIR", modulePath, PathMacroUtil.getUserHomePath());
            return result2;
        }

        public LegacyBridgeModulePathMacroManager(@NotNull PathMacros pathMacros, @NotNull String moduleFilePath) {
            Intrinsics.checkParameterIsNotNull((Object)pathMacros, (String)"pathMacros");
            Intrinsics.checkParameterIsNotNull((Object)moduleFilePath, (String)"moduleFilePath");
            super(pathMacros);
            this.moduleFilePath = moduleFilePath;
        }

        public static final /* synthetic */ void access$addFileHierarchyReplacements$s-1592960218(ExpandMacroToPathMap p0, String p1, String p2) {
            PathMacroManager.addFileHierarchyReplacements(p0, p1, p2);
        }

        public static final /* synthetic */ void access$addFileHierarchyReplacements$s-1592960218(ReplacePathToMacroMap p0, String p1, String p2, String p3) {
            PathMacroManager.addFileHierarchyReplacements(p0, p1, p2, p3);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/workspace/jps/CachingJpsFileContentReader$LegacyBridgeProjectPathMacroManager;", "Lcom/intellij/openapi/components/PathMacroManager;", "projectDirPath", "", "(Ljava/lang/String;)V", "computeReplacePathMap", "Lcom/intellij/application/options/ReplacePathToMacroMap;", "getExpandMacroMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "intellij.platform.workspaceModel.ide"})
    public static final class LegacyBridgeProjectPathMacroManager
    extends PathMacroManager {
        private final String projectDirPath;

        @Override
        @NotNull
        public ExpandMacroToPathMap getExpandMacroMap() {
            ExpandMacroToPathMap expandMacroToPathMap = super.getExpandMacroMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)expandMacroToPathMap, (String)"super.getExpandMacroMap()");
            ExpandMacroToPathMap result2 = expandMacroToPathMap;
            LegacyBridgeProjectPathMacroManager.access$addFileHierarchyReplacements$s-1592960218(result2, "PROJECT_DIR", this.projectDirPath);
            return result2;
        }

        @Override
        @NotNull
        protected ReplacePathToMacroMap computeReplacePathMap() {
            ReplacePathToMacroMap replacePathToMacroMap = super.computeReplacePathMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)replacePathToMacroMap), (String)"super.computeReplacePathMap()");
            ReplacePathToMacroMap result2 = replacePathToMacroMap;
            LegacyBridgeProjectPathMacroManager.access$addFileHierarchyReplacements$s-1592960218(result2, "PROJECT_DIR", this.projectDirPath, null);
            return result2;
        }

        public LegacyBridgeProjectPathMacroManager(@NotNull String projectDirPath) {
            Intrinsics.checkParameterIsNotNull((Object)projectDirPath, (String)"projectDirPath");
            super(PathMacros.getInstance());
            this.projectDirPath = projectDirPath;
        }

        public static final /* synthetic */ void access$addFileHierarchyReplacements$s-1592960218(ExpandMacroToPathMap p0, String p1, String p2) {
            PathMacroManager.addFileHierarchyReplacements(p0, p1, p2);
        }

        public static final /* synthetic */ void access$addFileHierarchyReplacements$s-1592960218(ReplacePathToMacroMap p0, String p1, String p2, String p3) {
            PathMacroManager.addFileHierarchyReplacements(p0, p1, p2, p3);
        }
    }
}

