/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.api;

import com.intellij.workspace.api.CachedValue;
import com.intellij.workspace.api.CachedValueWithParameter;
import com.intellij.workspace.api.EntityChange;
import com.intellij.workspace.api.TypedEntityStorage;
import com.intellij.workspace.api.TypedEntityStore;
import com.intellij.workspace.api.ValuesCache;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J5\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00110\u00162\u0006\u0010\u0017\u001a\u0002H\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016J5\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00110\u00162\u0006\u0010\u0017\u001a\u0002H\u0015H\u0016\u00a2\u0006\u0002\u0010\u001bJ:\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032 \u0010\u001f\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"0 H\u0014J:\u0010$\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032 \u0010\u001f\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"0 H\u0014J0\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u00032 \u0010\u001f\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"0 R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006("}, d2={"Lcom/intellij/workspace/api/EntityStoreImpl;", "Lcom/intellij/workspace/api/TypedEntityStore;", "initialStorage", "Lcom/intellij/workspace/api/TypedEntityStorage;", "(Lcom/intellij/workspace/api/TypedEntityStorage;)V", "current", "getCurrent", "()Lcom/intellij/workspace/api/TypedEntityStorage;", "currentPointer", "Lcom/intellij/workspace/api/EntityStoreImpl$Current;", "valuesCache", "Lcom/intellij/workspace/api/ValuesCache;", "version", "", "getVersion", "()J", "cachedValue", "R", "value", "Lcom/intellij/workspace/api/CachedValue;", "(Lcom/intellij/workspace/api/CachedValue;)Ljava/lang/Object;", "P", "Lcom/intellij/workspace/api/CachedValueWithParameter;", "parameter", "(Lcom/intellij/workspace/api/CachedValueWithParameter;Ljava/lang/Object;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/workspace/api/CachedValueWithParameter;Ljava/lang/Object;)V", "onBeforeChanged", "before", "after", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspace/api/EntityChange;", "onChanged", "replace", "newStorage", "Current", "intellij.platform.workspaceModel.core"})
public class EntityStoreImpl
implements TypedEntityStore {
    private final ValuesCache valuesCache;
    private volatile Current currentPointer;

    @Override
    @NotNull
    public TypedEntityStorage getCurrent() {
        return this.currentPointer.getStorage();
    }

    @Override
    public long getVersion() {
        return this.currentPointer.getVersion();
    }

    @Override
    public <R> R cachedValue(@NotNull CachedValue<R> value2) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        return this.valuesCache.cachedValue(value2, this.getVersion(), this.getCurrent());
    }

    @Override
    public <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        return this.valuesCache.cachedValue(value2, parameter, this.getVersion(), this.getCurrent());
    }

    @Override
    public <R> void clearCachedValue(@NotNull CachedValue<R> value2) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        this.valuesCache.clearCachedValue(value2);
    }

    @Override
    public <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value2, P parameter) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        this.valuesCache.clearCachedValue(value2, parameter);
    }

    public final synchronized void replace(@NotNull TypedEntityStorage newStorage, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
        Intrinsics.checkParameterIsNotNull((Object)newStorage, (String)"newStorage");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        Current oldCopy = this.currentPointer;
        if (Intrinsics.areEqual((Object)oldCopy.getStorage(), (Object)newStorage)) {
            return;
        }
        this.onBeforeChanged(oldCopy.getStorage(), newStorage, changes);
        this.currentPointer = new Current(oldCopy.getVersion() + 1L, newStorage);
        this.onChanged(oldCopy.getStorage(), newStorage, changes);
    }

    protected void onBeforeChanged(@NotNull TypedEntityStorage before, @NotNull TypedEntityStorage after2, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
        Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
        Intrinsics.checkParameterIsNotNull((Object)after2, (String)"after");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
    }

    protected void onChanged(@NotNull TypedEntityStorage before, @NotNull TypedEntityStorage after2, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
        Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
        Intrinsics.checkParameterIsNotNull((Object)after2, (String)"after");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
    }

    public EntityStoreImpl(@NotNull TypedEntityStorage initialStorage) {
        Intrinsics.checkParameterIsNotNull((Object)initialStorage, (String)"initialStorage");
        this.valuesCache = new ValuesCache();
        this.currentPointer = new Current(0L, initialStorage);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspace/api/EntityStoreImpl$Current;", "", "version", "", "storage", "Lcom/intellij/workspace/api/TypedEntityStorage;", "(JLcom/intellij/workspace/api/TypedEntityStorage;)V", "getStorage", "()Lcom/intellij/workspace/api/TypedEntityStorage;", "getVersion", "()J", "intellij.platform.workspaceModel.core"})
    private static final class Current {
        private final long version;
        @NotNull
        private final TypedEntityStorage storage;

        public final long getVersion() {
            return this.version;
        }

        @NotNull
        public final TypedEntityStorage getStorage() {
            return this.storage;
        }

        public Current(long version2, @NotNull TypedEntityStorage storage) {
            Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
            this.version = version2;
            this.storage = storage;
        }
    }
}

