/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.IndexableSetContributor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class FileBasedIndexScanRunnableCollectorImpl
extends FileBasedIndexScanRunnableCollector {
    private final Project myProject;
    private final ProjectFileIndex myProjectFileIndex;
    private final boolean myDisabled;

    FileBasedIndexScanRunnableCollectorImpl(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myProjectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        this.myDisabled = LightEdit.owns((Project)this.myProject);
    }

    @Override
    public boolean shouldCollect(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(1);
        }
        if (this.myDisabled) {
            return false;
        }
        if (this.myProjectFileIndex.isInContent(file2) || this.myProjectFileIndex.isInLibrary(file2)) {
            return !FileTypeManager.getInstance().isFileIgnored(file2);
        }
        return false;
    }

    @Override
    public List<Runnable> collectScanRootRunnables(@NotNull ContentIterator processor2, ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(2);
        }
        if (this.myDisabled) {
            return Collections.emptyList();
        }
        return (List)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return Collections.emptyList();
            }
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            Set visitedRoots = ContainerUtil.newConcurrentSet();
            tasks.add(() -> this.myProjectFileIndex.iterateContent(processor2, file2 -> !file2.isDirectory() || visitedRoots.add(file2)));
            LinkedHashSet contributedRoots = new LinkedHashSet();
            for (IndexableSetContributor contributor : IndexableSetContributor.EP_NAME.getExtensionList()) {
                if (this.myProject.isDisposed()) {
                    return tasks;
                }
                contributedRoots.addAll(IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor));
                contributedRoots.addAll(IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)contributor, (Project)this.myProject));
            }
            for (VirtualFile root : contributedRoots) {
                if (this.myProjectFileIndex.isInContent(root) || !visitedRoots.add(root)) continue;
                tasks.add(() -> {
                    if (this.myProject.isDisposed() || !root.isValid()) {
                        return;
                    }
                    FileBasedIndex.iterateRecursively((VirtualFile)root, (ContentIterator)processor2, (ProgressIndicator)indicator, (Set)visitedRoots, null);
                });
            }
            for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
                if (this.myProject.isDisposed()) {
                    return tasks;
                }
                for (SyntheticLibrary library : provider.getAdditionalProjectLibraries(this.myProject)) {
                    for (VirtualFile root : library.getAllRoots()) {
                        if (this.myProjectFileIndex.isInContent(root) || !visitedRoots.add(root)) continue;
                        tasks.add(() -> {
                            if (this.myProject.isDisposed() || !root.isValid()) {
                                return;
                            }
                            FileBasedIndex.iterateRecursively((VirtualFile)root, (ContentIterator)processor2, (ProgressIndicator)indicator, (Set)visitedRoots, (ProjectFileIndex)this.myProjectFileIndex);
                        });
                    }
                }
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                OrderEntry[] orderEntries;
                for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    if (!(orderEntry instanceof LibraryOrSdkOrderEntry) || !orderEntry.isValid()) continue;
                    LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                    VirtualFile[] libSources = entry.getRootFiles(OrderRootType.SOURCES);
                    VirtualFile[] libClasses = entry.getRootFiles(OrderRootType.CLASSES);
                    VirtualFile[][] virtualFileArrayArray = new VirtualFile[][]{libSources, libClasses};
                    int n = virtualFileArrayArray.length;
                    for (int i = 0; i < n; ++i) {
                        VirtualFile[] roots;
                        for (VirtualFile root : roots = virtualFileArrayArray[i]) {
                            if (this.myProjectFileIndex.isInContent(root) || !visitedRoots.add(root)) continue;
                            tasks.add(() -> {
                                if (this.myProject.isDisposed() || module.isDisposed() || !root.isValid()) {
                                    return;
                                }
                                FileBasedIndex.iterateRecursively((VirtualFile)root, (ContentIterator)processor2, (ProgressIndicator)indicator, (Set)visitedRoots, (ProjectFileIndex)this.myProjectFileIndex);
                            });
                        }
                    }
                }
            }
            return tasks;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexScanRunnableCollectorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCollect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectScanRootRunnables";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

