/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndicesRegistrationResult;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class FileBasedIndexDataInitialization
extends IndexInfrastructure.DataInitialization<IndexConfiguration> {
    private static final NotificationGroup NOTIFICATIONS = new NotificationGroup("Indexing", NotificationDisplayType.BALLOON, false, null, null, null, PluginManagerCore.CORE_ID);
    private static final Logger LOG = Logger.getInstance(FileBasedIndexDataInitialization.class);
    private final IndexConfiguration state;
    private final IndicesRegistrationResult registrationResultSink;
    private boolean currentVersionCorrupted;
    private final FileBasedIndexImpl myFileBasedIndex;

    FileBasedIndexDataInitialization(@NotNull FileBasedIndexImpl index) {
        if (index == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(0);
        }
        this.state = new IndexConfiguration();
        this.registrationResultSink = new IndicesRegistrationResult();
        this.myFileBasedIndex = index;
    }

    private void initAssociatedDataForExtensions() {
        FileBasedIndexExtension extension;
        Iterator extensions2;
        Activity activity = StartUpMeasurer.startActivity((String)"file index extensions iteration");
        Iterator iterator2 = extensions2 = IndexInfrastructure.hasIndices() ? ((ExtensionPointImpl)FileBasedIndexExtension.EXTENSION_POINT_NAME.getPoint(null)).iterator() : Collections.emptyIterator();
        while (extensions2.hasNext() && (extension = (FileBasedIndexExtension)extensions2.next()) != null) {
            ID name = extension.getName();
            RebuildStatus.registerIndex(name);
            this.myFileBasedIndex.getRegisteredIndexes().registerIndexExtension(extension);
            this.addNestedInitializationTask(() -> {
                try {
                    FileBasedIndexImpl.registerIndexer(extension, this.state, this.registrationResultSink);
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    ComponentManagerImplKt.handleComponentError((Throwable)t, (String)extension.getClass().getName(), null);
                }
            });
        }
        this.myFileBasedIndex.getRegisteredIndexes().extensionsDataWasLoaded();
        activity.end();
    }

    @Override
    protected void prepare() {
        PersistentFSImpl fs = (PersistentFSImpl)ManagingFS.getInstance();
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        Disposable disposable2 = () -> new FileBasedIndexImpl.MyShutDownTask().run();
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new MyApplicationListener(fileBasedIndex), disposable2);
        Disposer.register((Disposable)fs, (Disposable)disposable2);
        this.myFileBasedIndex.setUpShutDownTask();
        this.initAssociatedDataForExtensions();
        File indexRoot = PathManager.getIndexRoot();
        PersistentIndicesConfiguration.loadConfiguration();
        File corruptionMarker = new File(indexRoot, "corruption.marker");
        boolean bl = this.currentVersionCorrupted = IndexInfrastructure.hasIndices() && corruptionMarker.exists();
        if (this.currentVersionCorrupted) {
            FileUtil.deleteWithRenaming((File)indexRoot);
            indexRoot.mkdirs();
            SerializationManagerEx.getInstanceEx().reinitializeNameStorage();
            ID.reinitializeDiskStorage();
            PersistentIndicesConfiguration.saveConfiguration();
            FileUtil.delete((File)corruptionMarker);
        }
        FileBasedIndexInfrastructureExtension.EP_NAME.extensions().forEach(ex -> ex.initialize());
    }

    @Override
    protected void onThrowable(@NotNull Throwable t) {
        if (t == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(1);
        }
        FileBasedIndexImpl.LOG.error(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IndexConfiguration finish() {
        try {
            this.state.finalizeFileTypeMappingForIndices();
            String changedIndicesText = this.registrationResultSink.changedIndices();
            String rebuildNotification = null;
            if (this.currentVersionCorrupted) {
                rebuildNotification = "Index files on disk are corrupted. Indices will be rebuilt.";
            } else if (!changedIndicesText.isEmpty()) {
                rebuildNotification = "Index file format has changed for " + changedIndicesText + " indices. These indices will be rebuilt.";
            }
            this.registrationResultSink.logChangedAndFullyBuiltIndices(FileBasedIndexImpl.LOG, "Indices to be rebuilt after version change:", this.currentVersionCorrupted ? "Indices to be rebuilt after corruption:" : "Indices to be built:");
            if (rebuildNotification != null && !ApplicationManager.getApplication().isHeadlessEnvironment() && Registry.is((String)"ide.showIndexRebuildMessage")) {
                NOTIFICATIONS.createNotification("Index Rebuild", rebuildNotification, NotificationType.INFORMATION, null).notify(null);
            }
            this.state.freeze();
            this.myFileBasedIndex.getRegisteredIndexes().setState(this.state);
            for (ID<?, ?> indexId : this.state.getIndexIDs()) {
                try {
                    RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<? extends StorageException>)((ThrowableRunnable)() -> this.myFileBasedIndex.clearIndex(indexId)));
                }
                catch (StorageException e) {
                    this.myFileBasedIndex.requestRebuild(indexId);
                    FileBasedIndexImpl.LOG.error((Throwable)e);
                }
            }
            this.myFileBasedIndex.registerIndexableSet(new AdditionalIndexableFileSet(), null);
            IndexConfiguration indexConfiguration = this.state;
            return indexConfiguration;
        }
        finally {
            this.myFileBasedIndex.setUpFlusher();
            this.myFileBasedIndex.getRegisteredIndexes().ensureLoadedIndexesUpToDate();
            this.myFileBasedIndex.getRegisteredIndexes().markInitialized();
            FileBasedIndexDataInitialization.saveRegisteredIndicesAndDropUnregisteredOnes(this.state.getIndexIDs());
        }
    }

    private static void saveRegisteredIndicesAndDropUnregisteredOnes(@NotNull Collection<? extends ID<?, ?>> ids) {
        Throwable throwable;
        if (ids == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isDisposed() || !IndexInfrastructure.hasIndices()) {
            return;
        }
        File registeredIndicesFile = new File(PathManager.getIndexRoot(), "registered");
        THashSet indicesToDrop = new THashSet();
        boolean exceptionThrown = false;
        if (registeredIndicesFile.exists()) {
            try {
                throwable = null;
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(registeredIndicesFile)));){
                    int size = in.readInt();
                    for (int idx = 0; idx < size; ++idx) {
                        indicesToDrop.add(IOUtil.readString((DataInput)in));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable e) {
                LOG.info(e);
                exceptionThrown = true;
                ids.stream().map(IndexId::getName).forEach(((Set)indicesToDrop)::add);
            }
        }
        if (!exceptionThrown) {
            for (ID<?, ?> key : ids) {
                indicesToDrop.remove(key.getName());
            }
        }
        if (!indicesToDrop.isEmpty()) {
            LOG.info("Dropping indices:" + StringUtil.join((Collection)indicesToDrop, (String)","));
            for (String s : indicesToDrop) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getFileBasedIndexRootDir(s));
            }
        }
        FileUtil.createIfDoesntExist((File)registeredIndicesFile);
        try {
            throwable = null;
            try (DataOutputStream os = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(registeredIndicesFile)));){
                os.writeInt(ids.size());
                for (ID<?, ?> id2 : ids) {
                    IOUtil.writeString((String)id2.getName(), (DataOutput)os);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexDataInitialization";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onThrowable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "saveRegisteredIndicesAndDropUnregisteredOnes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyApplicationListener
    implements ApplicationListener {
        private final FileBasedIndexImpl myFileBasedIndex;

        MyApplicationListener(FileBasedIndexImpl fileBasedIndex) {
            this.myFileBasedIndex = fileBasedIndex;
        }

        public void writeActionStarted(@NotNull Object action2) {
            if (action2 == null) {
                MyApplicationListener.$$$reportNull$$$0(0);
            }
            this.myFileBasedIndex.clearUpToDateIndexesForUnsavedOrTransactedDocs();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/util/indexing/FileBasedIndexDataInitialization$MyApplicationListener", "writeActionStarted"));
        }
    }
}

