/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationsConfigurable;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBRectangle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationBalloonActionProvider
implements BalloonImpl.ActionProvider {
    private final BalloonImpl myBalloon;
    private final BalloonLayoutData myLayoutData;
    private final String myDisplayGroupId;
    private final Component myRepaintPanel;
    private final String myNotificationId;
    private BalloonImpl.ActionButton mySettingButton;
    private BalloonImpl.ActionButton myCloseButton;
    private List<BalloonImpl.ActionButton> myActions;
    private static final Rectangle CloseHoverBounds = new JBRectangle(5, 5, 12, 10);

    public NotificationBalloonActionProvider(@NotNull BalloonImpl balloon, @Nullable Component repaintPanel, @NotNull BalloonLayoutData layoutData, @Nullable String displayGroupId, @NotNull String notificationId) {
        if (balloon == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(0);
        }
        if (layoutData == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(1);
        }
        if (notificationId == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(2);
        }
        this.myLayoutData = layoutData;
        this.myDisplayGroupId = displayGroupId;
        this.myBalloon = balloon;
        this.myRepaintPanel = repaintPanel;
        this.myNotificationId = notificationId;
    }

    @Override
    @NotNull
    public List<BalloonImpl.ActionButton> createActions() {
        this.myActions = new ArrayList<BalloonImpl.ActionButton>();
        if (!this.myLayoutData.showSettingButton || this.myDisplayGroupId == null || !NotificationsConfigurationImpl.getInstanceImpl().isRegistered(this.myDisplayGroupId)) {
            this.mySettingButton = null;
        } else {
            BalloonImpl balloonImpl = this.myBalloon;
            balloonImpl.getClass();
            this.mySettingButton = new BalloonImpl.ActionButton(balloonImpl, AllIcons.Ide.Notification.Gear, AllIcons.Ide.Notification.GearHover, "Turn notification off or change its behavior", event -> this.myBalloon.runWithSmartFadeoutPause(() -> {
                NotificationCollector.getInstance().logNotificationSettingsClicked(this.myNotificationId, this.myDisplayGroupId);
                NotificationsConfigurable configurable2 = new NotificationsConfigurable();
                ShowSettingsUtil.getInstance().editConfigurable(this.myLayoutData.project, (Configurable)configurable2, () -> configurable2.enableSearch(this.myDisplayGroupId).run());
            })){
                {
                    BalloonImpl balloonImpl = x0;
                    balloonImpl.getClass();
                    super(icon2, hoverIcon, hint, (Consumer<? super MouseEvent>)listener2);
                }

                public void repaint() {
                    super.repaint();
                    if (NotificationBalloonActionProvider.this.myRepaintPanel != null) {
                        NotificationBalloonActionProvider.this.myRepaintPanel.repaint();
                    }
                }
            };
            this.myActions.add(this.mySettingButton);
            if (this.myRepaintPanel != null) {
                this.myLayoutData.showActions = () -> {
                    for (BalloonImpl.ActionButton action2 : this.myActions) {
                        if (action2.isShowing() && action2.hasPaint()) continue;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                };
            }
        }
        BalloonImpl balloonImpl = this.myBalloon;
        balloonImpl.getClass();
        this.myCloseButton = new BalloonImpl.ActionButton(balloonImpl, AllIcons.Ide.Notification.Close, AllIcons.Ide.Notification.CloseHover, "Close. Alt-click to close all notifications", event -> {
            int modifiers = event.getModifiers();
            SwingUtilities.invokeLater(() -> {
                if ((modifiers & 8) != 0) {
                    this.myLayoutData.closeAll.run();
                } else {
                    BalloonLayoutData.MergeInfo mergeInfo = this.myLayoutData.mergeData;
                    if (mergeInfo != null && mergeInfo.linkIds != null) {
                        for (String notificationId : mergeInfo.linkIds) {
                            NotificationCollector.getInstance().logNotificationBalloonClosedByUser(notificationId, this.myDisplayGroupId);
                        }
                    }
                    NotificationCollector.getInstance().logNotificationBalloonClosedByUser(this.myNotificationId, this.myDisplayGroupId);
                    this.myBalloon.hide();
                }
            });
        }){
            {
                BalloonImpl balloonImpl = x0;
                balloonImpl.getClass();
                super(icon2, hoverIcon, hint, (Consumer<? super MouseEvent>)listener2);
            }

            @Override
            protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon2) {
                if (g == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (icon2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                icon2.paintIcon((Component)((Object)this), g, CloseHoverBounds.x, CloseHoverBounds.y);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "g";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/NotificationBalloonActionProvider$2";
                objectArray[2] = "paintIcon";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myActions.add(this.myCloseButton);
        List<BalloonImpl.ActionButton> list2 = this.myActions;
        if (list2 == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    public void layout(@NotNull Rectangle bounds2) {
        if (bounds2 == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(4);
        }
        Dimension closeSize = this.myCloseButton.getPreferredSize();
        Insets borderInsets = this.myBalloon.getShadowBorderInsets();
        int x = bounds2.x + bounds2.width - borderInsets.right - closeSize.width - this.myLayoutData.configuration.rightActionsOffset.width;
        int y = bounds2.y + borderInsets.top + this.myLayoutData.configuration.rightActionsOffset.height;
        this.myCloseButton.setBounds(x - NotificationBalloonActionProvider.CloseHoverBounds.x, y - NotificationBalloonActionProvider.CloseHoverBounds.y, closeSize.width + NotificationBalloonActionProvider.CloseHoverBounds.width, closeSize.height + NotificationBalloonActionProvider.CloseHoverBounds.height);
        if (this.mySettingButton != null) {
            Dimension size = this.mySettingButton.getPreferredSize();
            this.mySettingButton.setBounds(x - size.width - this.myLayoutData.configuration.gearCloseSpace, y, size.width, size.height);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloon";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/NotificationBalloonActionProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/NotificationBalloonActionProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "layout";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

