/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutConfiguration;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalloonLayoutImpl
implements BalloonLayout {
    private final ComponentAdapter myResizeListener;
    protected JLayeredPane myLayeredPane;
    private final Insets myInsets;
    protected final List<Balloon> myBalloons;
    private final Map<Balloon, BalloonLayoutData> myLayoutData;
    private GetInt myWidth;
    private final Alarm myRelayoutAlarm;
    private final Runnable myRelayoutRunnable;
    private JRootPane myParent;
    private final Runnable myCloseAll;
    private final Runnable myLayoutRunnable;
    private final List<Runnable> myListeners;

    public BalloonLayoutImpl(@NotNull JRootPane parent, @NotNull Insets insets) {
        if (parent == null) {
            BalloonLayoutImpl.$$$reportNull$$$0(0);
        }
        if (insets == null) {
            BalloonLayoutImpl.$$$reportNull$$$0(1);
        }
        this.myResizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                BalloonLayoutImpl.this.queueRelayout();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/BalloonLayoutImpl$1", "componentResized"));
            }
        };
        this.myBalloons = new ArrayList<Balloon>();
        this.myLayoutData = new HashMap<Balloon, BalloonLayoutData>();
        this.myRelayoutAlarm = new Alarm();
        this.myRelayoutRunnable = () -> {
            if (this.myLayeredPane == null) {
                return;
            }
            this.relayout();
            this.fireRelayout();
        };
        this.myCloseAll = () -> {
            for (Balloon balloon : new ArrayList<Balloon>(this.myBalloons)) {
                BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
                NotificationCollector.getInstance().logNotificationBalloonClosedByUser(layoutData.id, layoutData.groupId);
                this.remove(balloon, true);
            }
        };
        this.myLayoutRunnable = () -> {
            this.calculateSize();
            this.relayout();
            this.fireRelayout();
        };
        this.myListeners = new ArrayList<Runnable>();
        this.myParent = parent;
        this.myLayeredPane = parent.getLayeredPane();
        this.myInsets = insets;
        this.myLayeredPane.addComponentListener(this.myResizeListener);
    }

    public void dispose() {
        this.myLayeredPane.removeComponentListener(this.myResizeListener);
        for (Balloon balloon : new ArrayList<Balloon>(this.myBalloons)) {
            Disposer.dispose((Disposable)balloon);
        }
        this.myRelayoutAlarm.cancelAllRequests();
        this.myBalloons.clear();
        this.myLayoutData.clear();
        this.myListeners.clear();
        this.myLayeredPane = null;
        this.myParent = null;
    }

    public void addListener(Runnable listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(Runnable listener2) {
        this.myListeners.remove(listener2);
    }

    private void fireRelayout() {
        for (Runnable listener2 : this.myListeners) {
            listener2.run();
        }
    }

    @Nullable
    public Component getTopBalloonComponent() {
        BalloonImpl balloon = (BalloonImpl)ContainerUtil.getLastItem(this.myBalloons);
        return balloon == null ? null : balloon.getComponent();
    }

    public void add(@NotNull Balloon balloon) {
        if (balloon == null) {
            BalloonLayoutImpl.$$$reportNull$$$0(2);
        }
        this.add(balloon, null);
    }

    public void add(final @NotNull Balloon balloon, @Nullable Object layoutData) {
        if (balloon == null) {
            BalloonLayoutImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Balloon merge = this.merge(layoutData);
        if (merge == null) {
            if (!this.myBalloons.isEmpty() && this.myBalloons.size() == BalloonLayoutImpl.getVisibleCount()) {
                this.remove(this.myBalloons.get(0));
            }
            this.myBalloons.add(balloon);
        } else {
            int index = this.myBalloons.indexOf(merge);
            this.remove(merge);
            this.myBalloons.add(index, balloon);
        }
        if (layoutData instanceof BalloonLayoutData) {
            BalloonLayoutData balloonLayoutData = (BalloonLayoutData)layoutData;
            balloonLayoutData.closeAll = this.myCloseAll;
            balloonLayoutData.doLayout = this.myLayoutRunnable;
            this.myLayoutData.put(balloon, balloonLayoutData);
        }
        Disposer.register((Disposable)balloon, (Disposable)new Disposable(){

            public void dispose() {
                BalloonLayoutImpl.this.clearNMore(balloon);
                BalloonLayoutImpl.this.remove(balloon, false);
                BalloonLayoutImpl.this.queueRelayout();
            }
        });
        this.calculateSize();
        this.relayout();
        if (!balloon.isDisposed()) {
            balloon.show(this.myLayeredPane);
        }
        this.fireRelayout();
    }

    @Nullable
    private Balloon merge(@Nullable Object data2) {
        String mergeId = null;
        if (data2 instanceof String) {
            mergeId = (String)data2;
        } else if (data2 instanceof BalloonLayoutData) {
            mergeId = ((BalloonLayoutData)data2).groupId;
        }
        if (mergeId != null) {
            for (Map.Entry<Balloon, BalloonLayoutData> e : this.myLayoutData.entrySet()) {
                if (!mergeId.equals(e.getValue().groupId)) continue;
                return e.getKey();
            }
        }
        return null;
    }

    @Nullable
    public BalloonLayoutData.MergeInfo preMerge(@NotNull Notification notification) {
        BalloonLayoutData layoutData;
        Balloon balloon;
        if (notification == null) {
            BalloonLayoutImpl.$$$reportNull$$$0(4);
        }
        if ((balloon = this.merge(notification.getGroupId())) != null && (layoutData = this.myLayoutData.get(balloon)) != null) {
            return layoutData.merge();
        }
        return null;
    }

    public void remove(@NotNull Notification notification) {
        Balloon balloon;
        if (notification == null) {
            BalloonLayoutImpl.$$$reportNull$$$0(5);
        }
        if ((balloon = this.merge(notification.getGroupId())) != null) {
            this.remove(balloon, true);
        }
    }

    private void remove(@NotNull Balloon balloon) {
        if (balloon == null) {
            BalloonLayoutImpl.$$$reportNull$$$0(6);
        }
        this.remove(balloon, false);
        balloon.hide(true);
        this.fireRelayout();
    }

    private void clearNMore(@NotNull Balloon balloon) {
        BalloonLayoutData layoutData;
        if (balloon == null) {
            BalloonLayoutImpl.$$$reportNull$$$0(7);
        }
        if ((layoutData = this.myLayoutData.get(balloon)) != null && layoutData.project != null && layoutData.mergeData != null) {
            EventLog.clearNMore(layoutData.project, Collections.singleton(layoutData.groupId));
        }
    }

    private void remove(@NotNull Balloon balloon, boolean hide) {
        if (balloon == null) {
            BalloonLayoutImpl.$$$reportNull$$$0(8);
        }
        this.myBalloons.remove(balloon);
        BalloonLayoutData layoutData = this.myLayoutData.remove(balloon);
        if (layoutData != null) {
            layoutData.mergeData = null;
        }
        if (hide) {
            balloon.hide();
            this.fireRelayout();
        }
    }

    public void closeAll() {
        this.myCloseAll.run();
    }

    public void closeFirst() {
        if (!this.myBalloons.isEmpty()) {
            this.remove(this.myBalloons.get(0), true);
        }
    }

    public int getBalloonCount() {
        return this.myBalloons.size();
    }

    private static int getVisibleCount() {
        return Registry.intValue((String)"ide.notification.visible.count", (int)2);
    }

    @NotNull
    private Dimension getSize(@NotNull Balloon balloon) {
        BalloonLayoutData layoutData;
        if (balloon == null) {
            BalloonLayoutImpl.$$$reportNull$$$0(9);
        }
        if ((layoutData = this.myLayoutData.get(balloon)) == null) {
            Dimension size = balloon.getPreferredSize();
            return this.myWidth == null ? size : new Dimension(this.myWidth.i(), size.height);
        }
        return new Dimension(this.myWidth.i(), layoutData.height);
    }

    public boolean isEmpty() {
        return this.myBalloons.isEmpty();
    }

    public void queueRelayout() {
        this.myRelayoutAlarm.cancelAllRequests();
        this.myRelayoutAlarm.addRequest(this.myRelayoutRunnable, 200);
    }

    private void calculateSize() {
        this.myWidth = null;
        for (Balloon balloon : this.myBalloons) {
            BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
            if (layoutData == null) continue;
            layoutData.height = balloon.getPreferredSize().height;
        }
        this.myWidth = BalloonLayoutConfiguration::FixedWidth;
    }

    private void relayout() {
        Dimension size = this.myLayeredPane.getSize();
        JBInsets.removeFrom((Dimension)size, (Insets)this.myInsets);
        Rectangle layoutRec = new Rectangle(new Point(this.myInsets.left, this.myInsets.top), size);
        List<ArrayList<Balloon>> columns = this.createColumns(layoutRec);
        while (columns.size() > 1) {
            this.remove(this.myBalloons.get(0), true);
            columns = this.createColumns(layoutRec);
        }
        ToolWindowsPane pane2 = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)this.myParent, ToolWindowsPane.class));
        JComponent layeredPane = pane2 != null ? pane2.getLayeredPane() : null;
        int eachColumnX = (layeredPane == null ? this.myLayeredPane.getWidth() : layeredPane.getX() + layeredPane.getWidth()) - 4;
        this.doLayout((List<Balloon>)columns.get(0), eachColumnX + 4, (int)this.myLayeredPane.getBounds().getMaxY());
    }

    private void doLayout(List<Balloon> balloons, int startX, int bottomY) {
        int y = bottomY;
        ToolWindowsPane pane2 = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)this.myParent, ToolWindowsPane.class));
        if (pane2 != null) {
            y -= pane2.getBottomHeight();
        }
        if (this.myParent instanceof IdeRootPane) {
            y -= ((IdeRootPane)this.myParent).getStatusBarHeight();
        }
        for (Balloon balloon : balloons) {
            Rectangle bounds2 = new Rectangle(this.getSize(balloon));
            bounds2.setLocation(startX - bounds2.width, y -= bounds2.height);
            balloon.setBounds(bounds2);
        }
    }

    private List<ArrayList<Balloon>> createColumns(Rectangle layoutRec) {
        ArrayList<ArrayList<Balloon>> columns = new ArrayList<ArrayList<Balloon>>();
        ArrayList<Balloon> eachColumn = new ArrayList<Balloon>();
        columns.add(eachColumn);
        int eachColumnHeight = 0;
        for (Balloon each : this.myBalloons) {
            Dimension eachSize = this.getSize(each);
            if ((double)(eachColumnHeight + eachSize.height) > layoutRec.getHeight()) {
                eachColumn = new ArrayList();
                columns.add(eachColumn);
                eachColumnHeight = 0;
            }
            eachColumn.add(each);
            eachColumnHeight += eachSize.height;
        }
        return columns;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloon";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/BalloonLayoutImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "preMerge";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "clearNMore";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getSize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface GetInt {
        public int i();
    }
}

