/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.SimpleActionGroup;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsGroup;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExternalToolsGroup<T extends Tool>
extends SimpleActionGroup
implements DumbAware {
    protected BaseExternalToolsGroup() {
        this.updateGroups(true);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            BaseExternalToolsGroup.$$$reportNull$$$0(0);
        }
        Presentation presentation = event.getPresentation();
        this.removeAll();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        this.updateGroups(false);
        presentation.setEnabled(true);
        presentation.setVisible(this.getChildrenCount() > 0);
    }

    protected void updateGroups(boolean registerActions) {
        List<ToolsGroup<T>> groups = this.getToolsGroups();
        for (ToolsGroup<T> group : groups) {
            String groupName = group.getName();
            if (!StringUtil.isEmptyOrSpaces((String)groupName)) {
                SimpleActionGroup subgroup = new SimpleActionGroup();
                subgroup.getTemplatePresentation().setText(groupName, false);
                subgroup.setPopup(true);
                this.fillGroup(groupName, subgroup);
                if (subgroup.getChildrenCount() <= 0) continue;
                this.add((AnAction)subgroup);
                if (!registerActions) continue;
                ActionManager.getInstance().registerAction(this.getGroupIdPrefix() + groupName, (AnAction)subgroup);
                continue;
            }
            this.fillGroup(null, this);
        }
    }

    @NotNull
    protected abstract String getGroupIdPrefix();

    protected abstract List<ToolsGroup<T>> getToolsGroups();

    private void fillGroup(@Nullable String groupName, SimpleActionGroup group) {
        List<T> tools = this.getToolsByGroupName(groupName);
        for (Tool tool : tools) {
            if (!tool.isEnabled()) continue;
            this.addToolToGroup(tool, group);
        }
    }

    private void addToolToGroup(T tool, SimpleActionGroup group) {
        String id2 = ((Tool)tool).getActionId();
        AnAction action2 = ActionManager.getInstance().getAction(id2);
        if (action2 == null) {
            action2 = this.createToolAction(tool);
            ActionManager.getInstance().registerAction(id2, action2);
        }
        group.add(action2);
    }

    protected abstract List<T> getToolsByGroupName(String var1);

    protected abstract ToolAction createToolAction(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/tools/BaseExternalToolsGroup", "update"));
    }
}

