/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.suggested.SignatureChangePresentation;
import com.intellij.refactoring.suggested.SignatureChangePresentationModel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/refactoring/suggested/SignatureChangesPage;", "Ljavax/swing/JPanel;", "signatureChangeModel", "Lcom/intellij/refactoring/suggested/SignatureChangePresentationModel;", "editorFont", "Ljava/awt/Font;", "screenSize", "Ljava/awt/Dimension;", "nameOfStuffToUpdate", "", "(Lcom/intellij/refactoring/suggested/SignatureChangePresentationModel;Ljava/awt/Font;Ljava/awt/Dimension;Ljava/lang/String;)V", "createPresentation", "Lcom/intellij/refactoring/suggested/SignatureChangePresentation;", "model", "intellij.platform.lang.impl"})
final class SignatureChangesPage
extends JPanel {
    private final SignatureChangePresentation createPresentation(SignatureChangePresentationModel model, Font editorFont, Dimension screenSize) {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getSchemeForCurrentUITheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getI\u2026).schemeForCurrentUITheme");
        EditorColorsScheme themeColorsScheme = editorColorsScheme;
        Font font = editorFont;
        double maxWidthHorizontalMode = (double)screenSize.width * 0.75;
        double maxWidth = (double)screenSize.width * 0.9;
        double maxHeight = (double)screenSize.height * 0.9;
        int minFontSize = 8;
        while (true) {
            SignatureChangePresentation presentation = new SignatureChangePresentation(model, font, themeColorsScheme, false);
            if ((double)presentation.getRequiredSize().width > maxWidthHorizontalMode) {
                presentation = new SignatureChangePresentation(model, font, themeColorsScheme, true);
            }
            if ((double)presentation.getRequiredSize().width <= maxWidth && (double)presentation.getRequiredSize().height <= maxHeight || font.getSize() <= minFontSize) {
                return presentation;
            }
            font = new Font(font.getName(), font.getStyle(), font.getSize() - 1);
        }
    }

    public SignatureChangesPage(@NotNull SignatureChangePresentationModel signatureChangeModel, @NotNull Font editorFont, @NotNull Dimension screenSize, @NotNull String nameOfStuffToUpdate) {
        Intrinsics.checkParameterIsNotNull((Object)signatureChangeModel, (String)"signatureChangeModel");
        Intrinsics.checkParameterIsNotNull((Object)editorFont, (String)"editorFont");
        Intrinsics.checkParameterIsNotNull((Object)screenSize, (String)"screenSize");
        Intrinsics.checkParameterIsNotNull((Object)nameOfStuffToUpdate, (String)"nameOfStuffToUpdate");
        super(new BorderLayout());
        final SignatureChangePresentation presentation = this.createPresentation(signatureChangeModel, editorFont, screenSize);
        this.add((Component)new JLabel(RefactoringBundle.message((String)"suggested.refactoring.change.signature.label.text", (Object[])new Object[]{nameOfStuffToUpdate})), "North");
        this.add((Component)new JComponent(){

            @Override
            public void paint(@NotNull Graphics g) {
                Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
                presentation.paint((Graphics2D)g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
            {
                this.setPreferredSize($captured_local_variable$0.getRequiredSize());
            }
        }, "Center");
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
    }
}

