/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceContextUtil {
    private static final Logger LOG = Logger.getInstance(FileReferenceContextUtil.class);
    private static final Key<Pair<PsiFileSystemItem, Integer>> REF_FILE_SYSTEM_ITEM_KEY = Key.create((String)"REF_FILE_SYSTEM_ITEM_KEY");

    private FileReferenceContextUtil() {
    }

    public static Map<String, PsiFileSystemItem> encodeFileReferences(PsiElement element2) {
        final HashMap<String, PsiFileSystemItem> map2 = new HashMap<String, PsiFileSystemItem>();
        if (element2 == null || element2 instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element2)) {
            return map2;
        }
        element2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(true){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 instanceof PsiLanguageInjectionHost && element2.isValid()) {
                    InjectedLanguageManager.getInstance((Project)element2.getProject()).enumerate(element2, (injectedPsi, places) -> FileReferenceContextUtil.encodeFileReferences((PsiElement)injectedPsi));
                }
                PsiReference[] refs = element2.getReferences();
                for (int refIndex = 0; refIndex < refs.length; ++refIndex) {
                    PsiFileReference ref;
                    PsiReference reference2 = refs[refIndex];
                    PsiFileReference psiFileReference = ref = reference2 instanceof FileReferenceOwner ? ((FileReferenceOwner)reference2).getLastFileReference() : null;
                    if (ref != null && FileReferenceContextUtil.encodeFileReference(element2, ref, map2, refIndex)) break;
                }
                super.visitElement(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/move/FileReferenceContextUtil$1", "visitElement"));
            }
        });
        return map2;
    }

    private static boolean encodeFileReference(PsiElement element2, PsiFileReference ref, Map<String, PsiFileSystemItem> map2, int refIndex) {
        ResolveResult[] results;
        for (ResolveResult result2 : results = ref.multiResolve(false)) {
            if (!(result2.getElement() instanceof PsiFileSystemItem)) continue;
            PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)result2.getElement();
            element2.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, (Object)Pair.create((Object)fileSystemItem, (Object)refIndex));
            map2.put(element2.getText(), fileSystemItem);
            return true;
        }
        return false;
    }

    private static boolean isBinary(PsiElement element2) {
        PsiFile containingFile = element2.getContainingFile();
        return containingFile == null || containingFile.getFileType().isBinary();
    }

    public static void decodeFileReferences(PsiElement element2) {
        if (element2 == null || element2 instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element2)) {
            return;
        }
        element2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(true){

            public void visitElement(@NotNull PsiElement element2) {
                Pair pair;
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                PsiFileSystemItem item = (pair = (Pair)element2.getCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY)) != null ? (PsiFileSystemItem)pair.first : null;
                element2.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, null);
                element2 = FileReferenceContextUtil.bindElement(element2, item, pair != null ? (Integer)pair.second : -1);
                if (element2 != null) {
                    element2.acceptChildren((PsiElementVisitor)this);
                }
                if (element2 instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageManager.getInstance((Project)element2.getProject()).enumerate(element2, (injectedPsi, places) -> FileReferenceContextUtil.decodeFileReferences((PsiElement)injectedPsi));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/move/FileReferenceContextUtil$2", "visitElement"));
            }
        });
    }

    public static void decodeFileReferences(PsiElement element2, final Map<String, PsiFileSystemItem> map2, final TextRange range2) {
        if (element2 == null || element2 instanceof PsiCompiledElement || FileReferenceContextUtil.isBinary(element2)) {
            return;
        }
        element2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(true){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!range2.intersects(element2.getTextRange())) {
                    return;
                }
                String text2 = element2.getText();
                PsiFileSystemItem item = (PsiFileSystemItem)map2.get(text2);
                element2.putCopyableUserData(REF_FILE_SYSTEM_ITEM_KEY, (Object)Pair.create((Object)item, (Object)-1));
                element2.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/move/FileReferenceContextUtil$3", "visitElement"));
            }
        });
        FileReferenceContextUtil.decodeFileReferences(element2);
    }

    private static PsiElement bindElement(PsiElement element2, PsiFileSystemItem item, int refIndex) {
        if (item != null && item.isValid() && item.getVirtualFile() != null) {
            PsiElement result2;
            PsiReference ref;
            PsiReference[] refs = element2.getReferences();
            if (refIndex >= 0 && refs.length > refIndex && (ref = refs[refIndex]) instanceof FileReferenceOwner && (result2 = FileReferenceContextUtil.bindAndCheckElement(ref, element2, item)) != null) {
                return result2;
            }
            for (PsiReference ref2 : refs) {
                if (!(ref2 instanceof FileReferenceOwner)) continue;
                PsiElement result3 = FileReferenceContextUtil.bindAndCheckElement(ref2, element2, item);
                if (result3 == null) break;
                return result3;
            }
        }
        return element2;
    }

    @Nullable
    private static PsiElement bindAndCheckElement(@NotNull PsiReference ref, @NotNull PsiElement element2, @NotNull PsiFileSystemItem item) {
        PsiFileReference fileReference;
        if (ref == null) {
            FileReferenceContextUtil.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            FileReferenceContextUtil.$$$reportNull$$$0(1);
        }
        if (item == null) {
            FileReferenceContextUtil.$$$reportNull$$$0(2);
        }
        if ((fileReference = ((FileReferenceOwner)ref).getLastFileReference()) != null) {
            try {
                PsiElement newElement = fileReference.bindToElement((PsiElement)item);
                if (newElement != null) {
                    LOG.assertTrue(element2.getClass() == newElement.getClass(), (Object)("Reference " + ref + " violated contract of bindToElement()"));
                }
                return newElement;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ref";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/move/FileReferenceContextUtil";
        objectArray[2] = "bindAndCheckElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

