/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.ide.IdeEventQueue;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRefactoringAction
extends AnAction
implements UpdateInBackground {
    private final Condition<Language> myLanguageCondition = this::isAvailableForLanguage;

    protected abstract boolean isAvailableInEditorOnly();

    protected abstract boolean isEnabledOnElements(PsiElement @NotNull [] var1);

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context, @NotNull String place) {
        ContextAwareActionHandler contextAwareActionHandler;
        RefactoringActionHandler handler2;
        if (element2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BaseRefactoringAction.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(2);
        }
        if (context == null) {
            BaseRefactoringAction.$$$reportNull$$$0(3);
        }
        if (place == null) {
            BaseRefactoringAction.$$$reportNull$$$0(4);
        }
        if (ActionPlaces.isPopupPlace((String)place) && (handler2 = this.getHandler(context)) instanceof ContextAwareActionHandler && !(contextAwareActionHandler = (ContextAwareActionHandler)handler2).isAvailableForQuickList(editor, file2, context)) {
            return false;
        }
        return this.isAvailableOnElementInEditorAndFile(element2, editor, file2, context);
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        if (element2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            BaseRefactoringAction.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(7);
        }
        if (context == null) {
            BaseRefactoringAction.$$$reportNull$$$0(8);
        }
        return true;
    }

    protected boolean hasAvailableHandler(@NotNull DataContext dataContext) {
        RefactoringActionHandler handler2;
        if (dataContext == null) {
            BaseRefactoringAction.$$$reportNull$$$0(9);
        }
        if ((handler2 = this.getHandler(dataContext)) != null) {
            if (handler2 instanceof ContextAwareActionHandler) {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
                if (editor != null && file2 != null && !((ContextAwareActionHandler)handler2).isAvailableForQuickList(editor, file2, dataContext)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract RefactoringActionHandler getHandler(@NotNull DataContext var1);

    public final void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile file2;
        LookupEx lookup2;
        RefactoringActionHandler handler2;
        if (e == null) {
            BaseRefactoringAction.$$$reportNull$$$0(10);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        int eventCount = IdeEventQueue.getInstance().getEventCount();
        if (!PsiDocumentManager.getInstance((Project)project).commitAllDocumentsUnderProgress()) {
            return;
        }
        IdeEventQueue.getInstance().setEventCount(eventCount);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiElement[] elements2 = BaseRefactoringAction.getPsiElementArray(dataContext);
        try {
            handler2 = this.getHandler(dataContext);
        }
        catch (ProcessCanceledException ignored) {
            return;
        }
        if (handler2 == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.symbol.to.refactor"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), null);
            return;
        }
        InplaceRefactoring activeInplaceRenamer = InplaceRefactoring.getActiveInplaceRenamer(editor);
        if (!InplaceRefactoring.canStartAnotherRefactoring(editor, project, handler2, elements2) && activeInplaceRenamer != null) {
            InplaceRefactoring.unableToStartWarning(project, editor);
            return;
        }
        if (activeInplaceRenamer == null && (lookup2 = LookupManager.getActiveLookup(editor)) instanceof LookupImpl) {
            Runnable command = () -> ((LookupImpl)lookup2).finishLookup('\n');
            Document doc = editor.getDocument();
            DocCommandGroupId group = DocCommandGroupId.noneGroupId((Document)doc);
            CommandProcessor.getInstance().executeCommand(editor.getProject(), command, ApplicationBundle.message((String)"title.code.completion", (Object[])new Object[0]), (Object)group, UndoConfirmationPolicy.DEFAULT, doc);
        }
        IdeEventQueue.getInstance().setEventCount(eventCount);
        PsiFile psiFile = file2 = editor != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) : null;
        Language language = file2 != null ? file2.getLanguage() : (elements2.length > 0 ? elements2[0].getLanguage() : null);
        FeatureUsageData data2 = new FeatureUsageData().addData("handler", handler2.getClass().getName()).addLanguage(language);
        if (elements2.length > 0) {
            data2.addData("element", elements2[0].getClass().getName());
        }
        FUCounterUsageLogger.getInstance().logEvent(project, "refactoring", "handler.invoked", data2);
        if (editor != null) {
            if (file2 == null) {
                return;
            }
            DaemonCodeAnalyzer.getInstance((Project)project).autoImportReferenceAtCursor(editor, file2);
            handler2.invoke(project, editor, file2, dataContext);
        } else {
            handler2.invoke(project, elements2, dataContext);
        }
    }

    protected boolean isEnabledOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            BaseRefactoringAction.$$$reportNull$$$0(11);
        }
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseRefactoringAction.$$$reportNull$$$0(12);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(true);
        DataContext dataContext = e.getDataContext();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || this.isHidden()) {
            BaseRefactoringAction.hideAction(e);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file2 != null && (file2 instanceof PsiCompiledElement && this.disableOnCompiledElement() || !this.isAvailableForFile(file2))) {
            BaseRefactoringAction.hideAction(e);
            return;
        }
        if (editor == null) {
            boolean isEnabled;
            if (this.isAvailableInEditorOnly()) {
                BaseRefactoringAction.hideAction(e);
                return;
            }
            PsiElement[] elements2 = BaseRefactoringAction.getPsiElementArray(dataContext);
            boolean bl = isEnabled = this.isEnabledOnDataContext(dataContext) || elements2.length != 0 && this.isEnabledOnElements(elements2);
            if (!isEnabled) {
                BaseRefactoringAction.disableAction(e);
            } else {
                this.updateActionText(e);
            }
        } else {
            PsiElement element2 = this.findRefactoringTargetInEditor(dataContext);
            if (element2 != null) {
                boolean isEnabled;
                boolean bl = isEnabled = file2 != null && this.isAvailableOnElementInEditorAndFile(element2, editor, file2, dataContext, e.getPlace());
                if (!isEnabled) {
                    BaseRefactoringAction.disableAction(e);
                } else {
                    this.updateActionText(e);
                }
            } else {
                BaseRefactoringAction.hideAction(e);
            }
        }
    }

    protected PsiElement findRefactoringTargetInEditor(DataContext dataContext) {
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        PsiFile file2 = (PsiFile)dataContext.getData(CommonDataKeys.PSI_FILE);
        PsiElement element2 = (PsiElement)dataContext.getData(CommonDataKeys.PSI_ELEMENT);
        Object[] languages = (Language[])dataContext.getData(LangDataKeys.CONTEXT_LANGUAGES);
        if (element2 == null || !this.isAvailableForLanguage(element2.getLanguage())) {
            if (file2 == null || editor == null) {
                return null;
            }
            element2 = BaseRefactoringAction.getElementAtCaret(editor, file2);
        }
        if (element2 == null || element2 instanceof SyntheticElement || languages == null) {
            return null;
        }
        if (ContainerUtil.find((Object[])languages, this.myLanguageCondition) == null) {
            return null;
        }
        return element2;
    }

    private void updateActionText(AnActionEvent e) {
        String actionText = this.getActionName(e.getDataContext());
        if (actionText != null) {
            e.getPresentation().setText(actionText);
        }
    }

    @Nullable
    protected String getActionName(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            BaseRefactoringAction.$$$reportNull$$$0(13);
        }
        return null;
    }

    protected boolean disableOnCompiledElement() {
        return true;
    }

    private static void hideAction(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseRefactoringAction.$$$reportNull$$$0(14);
        }
        e.getPresentation().setVisible(false);
        BaseRefactoringAction.disableAction(e);
    }

    protected boolean isHidden() {
        return false;
    }

    public static PsiElement getElementAtCaret(@NotNull Editor editor, PsiFile file2) {
        int offset;
        PsiElement element2;
        if (editor == null) {
            BaseRefactoringAction.$$$reportNull$$$0(15);
        }
        if ((element2 = file2.findElementAt(offset = BaseRefactoringAction.fixCaretOffset(editor))) == null && offset == file2.getTextLength()) {
            element2 = file2.findElementAt(offset - 1);
        }
        if (element2 instanceof PsiWhiteSpace) {
            element2 = file2.findElementAt(element2.getTextRange().getStartOffset() - 1);
        }
        return element2;
    }

    private static int fixCaretOffset(@NotNull Editor editor) {
        if (editor == null) {
            BaseRefactoringAction.$$$reportNull$$$0(16);
        }
        int caret = editor.getCaretModel().getOffset();
        if (editor.getSelectionModel().hasSelection() && caret == editor.getSelectionModel().getSelectionEnd()) {
            return Math.max(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd() - 1);
        }
        return caret;
    }

    private static void disableAction(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseRefactoringAction.$$$reportNull$$$0(17);
        }
        e.getPresentation().setEnabled(false);
    }

    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    protected boolean isAvailableForFile(PsiFile file2) {
        return true;
    }

    public static PsiElement @NotNull [] getPsiElementArray(@NotNull DataContext dataContext) {
        PsiElement element2;
        PsiElement[] psiElements;
        if (dataContext == null) {
            BaseRefactoringAction.$$$reportNull$$$0(18);
        }
        if (((psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)) == null || psiElements.length == 0) && (element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) != null) {
            psiElements = new PsiElement[]{element2};
        }
        if (psiElements == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                BaseRefactoringAction.$$$reportNull$$$0(19);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> filtered2 = null;
        for (PsiElement element3 : psiElements) {
            if (!(element3 instanceof SyntheticElement)) continue;
            if (filtered2 == null) {
                filtered2 = new ArrayList<PsiElement>(Collections.singletonList(element3));
            }
            filtered2.remove(element3);
        }
        PsiElement[] psiElementArray = filtered2 == null ? psiElements : PsiUtilCore.toPsiElementArray(filtered2);
        if (psiElementArray == null) {
            BaseRefactoringAction.$$$reportNull$$$0(20);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/actions/BaseRefactoringAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/actions/BaseRefactoringAction";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasAvailableHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnDataContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hideAction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtCaret";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fixCaretOffset";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "disableAction";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementArray";
                break;
            }
            case 19: 
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

