/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.CtrlYActionChooser;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.TextRange;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteLineAction
extends TextComponentEditorAction {
    public DeleteLineAction() {
        super((EditorActionHandler)new Handler());
    }

    private static TextRange getRangeToDelete(Editor editor, Caret caret) {
        int endOffset;
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        int startOffset = EditorUtil.getNotFoldedLineStartOffset(editor, selectionStart, true);
        if (selectionEnd > 0 && selectionEnd != selectionStart) {
            --selectionEnd;
        }
        if ((endOffset = EditorUtil.getNotFoldedLineEndOffset(editor, selectionEnd, true)) < editor.getDocument().getTextLength()) {
            ++endOffset;
        } else if (startOffset > 0) {
            --startOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (CtrlYActionChooser.isCurrentShortcutOk(dataContext)) {
                super.doExecute(editor, caret, dataContext);
            }
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editor.delete.line");
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            CopyPasteManager.getInstance().stopKillRings();
            Document document = editor.getDocument();
            List carets = caret == null ? editor.getCaretModel().getAllCarets() : Collections.singletonList(caret);
            editor.getCaretModel().runBatchCaretOperation(() -> {
                int[] caretColumns = new int[carets.size()];
                int caretIndex = carets.size() - 1;
                TextRange range2 = DeleteLineAction.getRangeToDelete(editor, (Caret)carets.get(caretIndex));
                while (caretIndex >= 0) {
                    int currentCaretIndex = caretIndex;
                    TextRange currentRange = range2;
                    while (--caretIndex >= 0 && (range2 = DeleteLineAction.getRangeToDelete(editor, (Caret)carets.get(caretIndex))).getEndOffset() >= currentRange.getStartOffset()) {
                        currentRange = new TextRange(range2.getStartOffset(), currentRange.getEndOffset());
                    }
                    for (int i = caretIndex + 1; i <= currentCaretIndex; ++i) {
                        caretColumns[i] = ((Caret)carets.get((int)i)).getVisualPosition().column;
                    }
                    int targetLine = editor.offsetToVisualPosition((int)currentRange.getStartOffset()).line;
                    document.deleteString(currentRange.getStartOffset(), currentRange.getEndOffset());
                    for (int i = caretIndex + 1; i <= currentCaretIndex; ++i) {
                        ((Caret)carets.get(i)).moveToVisualPosition(new VisualPosition(targetLine, caretColumns[i]));
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/DeleteLineAction$Handler", "doExecute"));
        }
    }
}

