/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.impl.NotificationWhitelistEP;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationCollector {
    private static final Logger LOG = Logger.getInstance(NotificationCollector.class);
    private static final Map<String, PluginInfo> ourNotificationWhitelist = new HashMap<String, PluginInfo>();
    private static final String NOTIFICATIONS = "notifications";
    private static final String UNKNOWN = "unknown";
    private static final String NOTIFICATION_GROUP = "notification_group";

    private NotificationCollector() {
        for (NotificationWhitelistEP extension : NotificationWhitelistEP.EP_NAME.getExtensionList()) {
            NotificationCollector.addNotificationToWhitelist(extension);
        }
        NotificationWhitelistEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<NotificationWhitelistEP>(){

            public void extensionAdded(@NotNull NotificationWhitelistEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                NotificationCollector.addNotificationToWhitelist(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/notification/impl/NotificationCollector$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    public void logBalloonShown(@Nullable Project project, @NotNull NotificationDisplayType displayType, @NotNull Notification notification, boolean isExpandable) {
        if (displayType == null) {
            NotificationCollector.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(1);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id).addData("display_type", displayType.name()).addData("severity", notification.getType().name()).addData("is_expandable", isExpandable);
        FUCounterUsageLogger.getInstance().logEvent(project, NOTIFICATIONS, "shown", data2);
    }

    public void logToolWindowNotificationShown(@Nullable Project project, @NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(2);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id).addData("display_type", NotificationDisplayType.TOOL_WINDOW.name()).addData("severity", notification.getType().name());
        FUCounterUsageLogger.getInstance().logEvent(project, NOTIFICATIONS, "shown", data2);
    }

    public void logNotificationLoggedInEventLog(@NotNull Project project, @NotNull Notification notification) {
        if (project == null) {
            NotificationCollector.$$$reportNull$$$0(3);
        }
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(4);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id).addData("severity", notification.getType().name());
        FUCounterUsageLogger.getInstance().logEvent(project, NOTIFICATIONS, "logged", data2);
    }

    public void logNotificationBalloonClosedByUser(@Nullable String notificationId, @Nullable String groupId2) {
        if (notificationId == null) {
            return;
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(groupId2, notificationId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "closed.by.user", data2);
    }

    public void logNotificationActionInvoked(@NotNull Notification notification, @NotNull AnAction action2, @NotNull NotificationPlace notificationPlace) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(5);
        }
        if (action2 == null) {
            NotificationCollector.$$$reportNull$$$0(6);
        }
        if (notificationPlace == null) {
            NotificationCollector.$$$reportNull$$$0(7);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id).addData("notification_place", notificationPlace.name());
        ActionsCollectorImpl.addActionClass(data2, action2, PluginInfoDetectorKt.getPluginInfo(action2.getClass()));
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "action.invoked", data2);
    }

    public void logHyperlinkClicked(@NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(8);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "hyperlink.clicked", data2);
    }

    public void logBalloonShownFromEventLog(@NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(9);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "event.log.balloon.shown", data2);
    }

    public void logNotificationSettingsClicked(@NotNull String notificationId, @Nullable String groupId2) {
        if (notificationId == null) {
            NotificationCollector.$$$reportNull$$$0(10);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(groupId2, notificationId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "settings.clicked", data2);
    }

    public void logNotificationBalloonExpanded(@NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(11);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "balloon.expanded", data2);
    }

    public void logNotificationBalloonCollapsed(@NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(12);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "balloon.collapsed", data2);
    }

    @NotNull
    private static FeatureUsageData createNotificationData(@Nullable String groupId2, @NotNull String id2) {
        if (id2 == null) {
            NotificationCollector.$$$reportNull$$$0(13);
        }
        FeatureUsageData featureUsageData = new FeatureUsageData().addData("id", id2).addData(NOTIFICATION_GROUP, StringUtil.isNotEmpty((String)groupId2) ? groupId2 : UNKNOWN).addPluginInfo(NotificationCollector.getPluginInfo(groupId2));
        if (featureUsageData == null) {
            NotificationCollector.$$$reportNull$$$0(14);
        }
        return featureUsageData;
    }

    public static NotificationCollector getInstance() {
        return (NotificationCollector)ServiceManager.getService(NotificationCollector.class);
    }

    private static PluginInfo getPluginInfo(@Nullable String groupId2) {
        if (groupId2 == null) {
            return null;
        }
        PluginInfo pluginInfo = ourNotificationWhitelist.get(groupId2);
        if (pluginInfo != null) {
            return pluginInfo;
        }
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId2);
        if (group == null) {
            return null;
        }
        return PluginInfoDetectorKt.getPluginInfoById((PluginId)group.getPluginId());
    }

    private static void addNotificationToWhitelist(NotificationWhitelistEP extension) {
        String[] values2;
        if (extension == null) {
            return;
        }
        PluginDescriptor pluginDescriptor = extension.getPluginDescriptor();
        if (pluginDescriptor == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor);
        String groupIds = extension.groupIds;
        if (groupIds == null || !info.isDevelopedByJetBrains()) {
            return;
        }
        for (String value2 : values2 = StringUtil.convertLineSeparators((String)groupIds, (String)"").split(";")) {
            String notificationGroup;
            PluginInfo oldValue;
            if (StringUtil.isEmptyOrSpaces((String)value2) || (oldValue = ourNotificationWhitelist.put(notificationGroup = StringUtil.trim((String)value2), info)) == null) continue;
            LOG.warn("Notification group '" + notificationGroup + "' is already registered in whitelist");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationPlace";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationCollector";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logBalloonShown";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logToolWindowNotificationShown";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationLoggedInEventLog";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationActionInvoked";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logHyperlinkClicked";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logBalloonShownFromEventLog";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationSettingsClicked";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationBalloonExpanded";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationBalloonCollapsed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationData";
                break;
            }
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum NotificationPlace {
        BALLOON,
        EVENT_LOG;

    }

    public static class NotificationRuleValidator
    extends CustomWhiteListRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return NotificationCollector.NOTIFICATION_GROUP.equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                NotificationRuleValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                NotificationRuleValidator.$$$reportNull$$$0(1);
            }
            if (NotificationCollector.UNKNOWN.equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationRuleValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ourNotificationWhitelist.containsKey(data2) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
            if (validationResultType == null) {
                NotificationRuleValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/NotificationCollector$NotificationRuleValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/NotificationCollector$NotificationRuleValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

