/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TreeElementWrapper
extends CachingChildrenTreeNode<TreeElement> {
    private static final Logger LOG = Logger.getInstance(TreeElementWrapper.class);

    public TreeElementWrapper(Project project, @NotNull TreeElement value2, @NotNull TreeModel treeModel) {
        if (value2 == null) {
            TreeElementWrapper.$$$reportNull$$$0(0);
        }
        if (treeModel == null) {
            TreeElementWrapper.$$$reportNull$$$0(1);
        }
        super(project, value2, treeModel);
    }

    @Override
    public void copyFromNewInstance(@NotNull CachingChildrenTreeNode oldInstance) {
        if (oldInstance == null) {
            TreeElementWrapper.$$$reportNull$$$0(2);
        }
    }

    public void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            TreeElementWrapper.$$$reportNull$$$0(3);
        }
        if (((StructureViewTreeElement)this.getValue()).getValue() != null) {
            presentation.updateFrom(((TreeElement)this.getValue()).getPresentation());
        }
    }

    @Override
    public void initChildren() {
        Object[] children2;
        this.clearChildren();
        TreeElement value2 = (TreeElement)this.getValue();
        for (TreeElement treeElement : children2 = value2.getChildren()) {
            if (treeElement == null) {
                LOG.error(value2 + " returned null child: " + Arrays.toString(children2));
            }
            this.addSubElement(this.createChildNode(treeElement));
        }
        if (this.myTreeModel instanceof ProvidingTreeModel) {
            Collection originalProviders = ((ProvidingTreeModel)this.myTreeModel).getNodeProviders();
            List providers = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(originalProviders);
            for (NodeProvider nodeProvider : providers) {
                if (!((ProvidingTreeModel)this.myTreeModel).isEnabled(nodeProvider)) continue;
                Collection nodes = nodeProvider.provideNodes(value2);
                for (TreeElement node : nodes) {
                    if (node == null) {
                        LOG.error(nodeProvider + " returned null node: " + nodes);
                    }
                    this.addSubElement(this.createChildNode(node));
                }
            }
        }
    }

    @Override
    protected void performTreeActions() {
        this.filterChildren(this.myTreeModel.getFilters());
        this.groupChildren(this.myTreeModel.getGroupers());
        this.sortChildren(this.myTreeModel.getSorters());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInstance";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/treeView/smartTree/TreeElementWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copyFromNewInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

