/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.VersionComparatorUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class PluginLoadingResult {
    final Map<PluginId, Set<String>> brokenPluginVersions;
    @NotNull
    final BuildNumber productBuildNumber;
    final Map<PluginId, IdeaPluginDescriptorImpl> incompletePlugins;
    final List<IdeaPluginDescriptorImpl> pluginsWithoutId;
    private final Map<PluginId, IdeaPluginDescriptorImpl> plugins;
    final Map<PluginId, IdeaPluginDescriptorImpl> idMap;
    @Nullable
    Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateModuleMap;
    private final Map<PluginId, PluginError> errors;
    private final Set<PluginId> shadowedBundledIds;
    final boolean checkModuleDependencies;
    private List<IdeaPluginDescriptorImpl> enabledPlugins;

    @NotNull
    List<IdeaPluginDescriptorImpl> getEnabledPlugins() {
        List<IdeaPluginDescriptorImpl> list2 = this.enabledPlugins;
        if (list2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(0);
        }
        return list2;
    }

    PluginLoadingResult(@NotNull Map<PluginId, Set<String>> brokenPluginVersions, @NotNull BuildNumber productBuildNumber) {
        if (brokenPluginVersions == null) {
            PluginLoadingResult.$$$reportNull$$$0(1);
        }
        if (productBuildNumber == null) {
            PluginLoadingResult.$$$reportNull$$$0(2);
        }
        this(brokenPluginVersions, productBuildNumber, !PlatformUtils.isIntelliJ());
    }

    PluginLoadingResult(@NotNull Map<PluginId, Set<String>> brokenPluginVersions, @NotNull BuildNumber productBuildNumber, boolean checkModuleDependencies) {
        if (brokenPluginVersions == null) {
            PluginLoadingResult.$$$reportNull$$$0(3);
        }
        if (productBuildNumber == null) {
            PluginLoadingResult.$$$reportNull$$$0(4);
        }
        this.incompletePlugins = ContainerUtil.newConcurrentMap();
        this.pluginsWithoutId = new ArrayList<IdeaPluginDescriptorImpl>();
        this.plugins = new HashMap<PluginId, IdeaPluginDescriptorImpl>();
        this.idMap = ContainerUtil.newConcurrentMap();
        this.errors = ContainerUtil.newConcurrentMap();
        this.shadowedBundledIds = new HashSet<PluginId>();
        this.brokenPluginVersions = brokenPluginVersions;
        this.productBuildNumber = productBuildNumber;
        this.checkModuleDependencies = checkModuleDependencies;
    }

    int enabledPluginCount() {
        return this.plugins.size();
    }

    void finishLoading() {
        IdeaPluginDescriptorImpl[] enabledPlugins = this.plugins.values().toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        this.plugins.clear();
        Arrays.sort(enabledPlugins, Comparator.comparing(IdeaPluginDescriptorImpl::getPluginId));
        this.enabledPlugins = Arrays.asList(enabledPlugins);
    }

    @NotNull
    List<PluginError> getErrors() {
        if (this.errors.isEmpty()) {
            List<PluginError> list2 = Collections.emptyList();
            if (list2 == null) {
                PluginLoadingResult.$$$reportNull$$$0(5);
            }
            return list2;
        }
        PluginId[] ids = this.errors.keySet().toArray(PluginId.EMPTY_ARRAY);
        Arrays.sort(ids, null);
        ArrayList<PluginError> result2 = new ArrayList<PluginError>(ids.length);
        for (PluginId id2 : ids) {
            result2.add(this.errors.get(id2));
        }
        ArrayList<PluginError> arrayList = result2;
        if (arrayList == null) {
            PluginLoadingResult.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    void addIncompletePlugin(@NotNull IdeaPluginDescriptorImpl plugin, @Nullable PluginError error) {
        if (plugin == null) {
            PluginLoadingResult.$$$reportNull$$$0(7);
        }
        if (!this.idMap.containsKey(plugin.getPluginId())) {
            this.incompletePlugins.put(plugin.getPluginId(), plugin);
        }
        if (error != null) {
            this.errors.put(plugin.getPluginId(), error);
        }
    }

    void reportIncompatiblePlugin(@NotNull IdeaPluginDescriptorImpl plugin, @NotNull String reason, @Nullable String since, @Nullable String until) {
        if (plugin == null) {
            PluginLoadingResult.$$$reportNull$$$0(8);
        }
        if (reason == null) {
            PluginLoadingResult.$$$reportNull$$$0(9);
        }
        if (this.idMap.containsKey(plugin.getPluginId())) {
            return;
        }
        if (since == null) {
            since = "0.0";
        }
        if (until == null) {
            until = "*.*";
        }
        String message = "is incompatible (reason: " + reason + ", target build " + (since.equals(until) ? "is " + since : "range is " + since + " to " + until) + ")";
        this.errors.put(plugin.getPluginId(), new PluginError(plugin, message, reason));
    }

    void reportCannotLoad(@NotNull DescriptorListLoadingContext context, @NotNull Path file2, Exception e) {
        if (context == null) {
            PluginLoadingResult.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(11);
        }
        context.getLogger().warn("Cannot load " + file2, (Throwable)e);
        this.errors.put(PluginId.getId((String)"__cannot load__"), new PluginError(null, "File \"" + FileUtil.getLocationRelativeToUserHome((String)file2.toString(), (boolean)false) + "\" contains invalid plugin descriptor", null));
    }

    boolean add(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull DescriptorListLoadingContext context, boolean overrideUseIfCompatible) {
        PluginId pluginId;
        if (descriptor2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(12);
        }
        if (context == null) {
            PluginLoadingResult.$$$reportNull$$$0(13);
        }
        if ((pluginId = descriptor2.getPluginId()) == null) {
            this.pluginsWithoutId.add(descriptor2);
            context.getLogger().warn("No id is provided by \"" + descriptor2.getPluginPath().getFileName().toString() + "\"");
            return true;
        }
        if (descriptor2.incomplete) {
            return true;
        }
        if (!descriptor2.isBundled()) {
            Set<String> set = this.brokenPluginVersions.get(pluginId);
            if (set != null && set.contains(descriptor2.getVersion())) {
                this.errors.put(pluginId, new PluginError(descriptor2, "was marked as broken", "marked as broken"));
                return true;
            }
            if (this.checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor2)) {
                String message = "defines no module dependencies (supported only in IntelliJ IDEA)";
                this.errors.put(pluginId, new PluginError(descriptor2, message, "supported only in IntelliJ IDEA"));
                return false;
            }
        }
        this.errors.remove(pluginId);
        this.incompletePlugins.remove(pluginId);
        IdeaPluginDescriptorImpl prevDescriptor = this.plugins.put(pluginId, descriptor2);
        if (prevDescriptor == null) {
            this.idMap.put(pluginId, descriptor2);
            for (PluginId module : descriptor2.getModules()) {
                this.checkAndAdd(descriptor2, module);
            }
            return true;
        }
        if (prevDescriptor.isBundled() || descriptor2.isBundled()) {
            this.shadowedBundledIds.add(pluginId);
        }
        if (this.isCompatible(descriptor2) && (overrideUseIfCompatible || VersionComparatorUtil.compare((String)descriptor2.getVersion(), (String)prevDescriptor.getVersion()) > 0)) {
            context.getLogger().info(descriptor2.getPluginPath() + " overrides " + prevDescriptor.getPluginPath());
            this.idMap.put(pluginId, descriptor2);
            return true;
        }
        this.plugins.put(pluginId, prevDescriptor);
        return false;
    }

    private boolean isCompatible(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(14);
        }
        return PluginManagerCore.isIncompatible(this.productBuildNumber, descriptor2.getSinceBuild(), descriptor2.getUntilBuild()) == null;
    }

    private void checkAndAdd(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginId id2) {
        if (descriptor2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(15);
        }
        if (id2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(16);
        }
        if (this.duplicateModuleMap != null && this.duplicateModuleMap.containsKey(id2)) {
            ContainerUtilRt.putValue((Object)id2, (Object)descriptor2, this.duplicateModuleMap);
            return;
        }
        IdeaPluginDescriptorImpl existingDescriptor = this.idMap.put(id2, descriptor2);
        if (existingDescriptor == null) {
            return;
        }
        this.idMap.remove(id2);
        if (this.duplicateModuleMap == null) {
            this.duplicateModuleMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list2 = new ArrayList<IdeaPluginDescriptorImpl>();
        list2.add(existingDescriptor);
        list2.add(descriptor2);
        this.duplicateModuleMap.put(id2, list2);
    }

    Set<PluginId> getShadowedBundledIds() {
        return this.shadowedBundledIds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginLoadingResult";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenPluginVersions";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productBuildNumber";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPlugins";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginLoadingResult";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addIncompletePlugin";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportIncompatiblePlugin";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportCannotLoad";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkAndAdd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

