/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.NonProjectScopeDisablerEP;
import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.actions.ToolWindowsGroup;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.ide.util.gotoByName.GotoSymbolModel2;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.lang.Language;
import com.intellij.lang.LanguagePsiElementExternalizer;
import com.intellij.lang.PsiElementExternalizer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.Changeable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gradient;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.FontUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereAction
extends AnAction
implements CustomComponentAction,
DumbAware,
DataProvider {
    private static final String SE_HISTORY_KEY = "SearchEverywhereHistoryKey";
    private static final int SEARCH_FIELD_COLUMNS = 25;
    private static final int MAX_CLASSES = 6;
    private static final int MAX_FILES = 6;
    private static final int MAX_RUN_CONFIGURATION = 6;
    private static final int MAX_TOOL_WINDOWS = 4;
    private static final int MAX_SYMBOLS = 6;
    private static final int MAX_SETTINGS = 5;
    private static final int MAX_ACTIONS = 5;
    private static final int MAX_RECENT_FILES = 10;
    private static final int DEFAULT_MORE_STEP_COUNT = 15;
    private static final int MAX_SEARCH_EVERYWHERE_HISTORY = 50;
    private static final int MAX_TOP_HIT = 15;
    private static final Logger LOG = Logger.getInstance(SearchEverywhereAction.class);
    private MyListRenderer myRenderer;
    private MySearchTextField myPopupField;
    private volatile GotoClassModel2 myClassModel;
    private volatile GotoFileModel myFileModel;
    private volatile GotoActionItemProvider myActionProvider;
    private volatile GotoSymbolModel2 mySymbolsModel;
    private Component myFocusComponent;
    private JBPopup myPopup;
    private final Map<String, String> myConfigurables = new HashMap<String, String>();
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)ApplicationManager.getApplication());
    private JBList<Object> myList;
    private JCheckBox myNonProjectCheckBox;
    private AnActionEvent myActionEvent;
    private final Set<AnAction> myDisabledActions = new HashSet<AnAction>();
    private Component myContextComponent;
    private CalcThread myCalcThread;
    private volatile ActionCallback myCurrentWorker = ActionCallback.DONE;
    private int myCalcThreadRestartRequestId;
    private final Object myWorkerRestartRequestLock = new Object();
    private int myHistoryIndex;
    private boolean mySkipFocusGain;
    public static final Key<JBPopup> SEARCH_EVERYWHERE_POPUP = new Key("SearchEverywherePopup");
    private volatile JBPopup myBalloon;
    private int myPopupActualWidth;
    private Component myFocusOwner;
    private ChooseByNamePopup myFileChooseByName;
    private ChooseByNamePopup myClassChooseByName;
    private ChooseByNamePopup mySymbolsChooseByName;
    private StructureViewModel myStructureModel;
    private Editor myEditor;
    private String myInitialTextForNavigation;
    private FileEditor myFileEditor;
    private HistoryItem myHistoryItem;

    public SearchEverywhereAction() {
        this.setEnabledInModalContext(false);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            SearchEverywhereAction.$$$reportNull$$$0(0);
        }
        if (place == null) {
            SearchEverywhereAction.$$$reportNull$$$0(1);
        }
        return new ActionButton(this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            @Override
            protected void updateToolTipText() {
                String shortcutText = SearchEverywhereAction.getShortcut();
                String classesTabName = String.join((CharSequence)"/", GotoClassPresentationUpdater.getActionTitlePluralized());
                if (Registry.is((String)"ide.helptooltip.enabled")) {
                    HelpTooltip.dispose((Component)this);
                    new HelpTooltip().setTitle(this.myPresentation.getText()).setShortcut(shortcutText).setDescription(IdeBundle.message((String)"search.everywhere.action.tooltip.description.text", (Object[])new Object[]{classesTabName})).installOn((JComponent)this);
                } else {
                    this.setToolTipText(IdeBundle.message((String)"search.everywhere.action.tooltip.text", (Object[])new Object[]{shortcutText, classesTabName}));
                }
            }
        };
    }

    private void updateComponents() {
        this.myList = new JBList<Object>((ListModel)new SearchListModel()){
            int lastKnownHeight;
            {
                this.lastKnownHeight = JBUIScale.scale((int)30);
            }

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height == -1) {
                    size.height = this.lastKnownHeight;
                } else {
                    this.lastKnownHeight = size.height;
                }
                int width = SearchEverywhereAction.this.myBalloon != null ? ((SearchEverywhereAction)SearchEverywhereAction.this).myBalloon.getSize().width : 0;
                return new Dimension(Math.max(width, Math.min(size.width - 2, SearchEverywhereAction.getPopupMaxWidth())), SearchEverywhereAction.this.myList.isEmpty() ? JBUIScale.scale((int)30) : size.height);
            }

            public void clearSelection() {
            }

            public Object getSelectedValue() {
                try {
                    return super.getSelectedValue();
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
        this.myRenderer = new MyListRenderer(this.myList);
        this.myList.setCellRenderer((ListCellRenderer)((Object)this.myRenderer));
        this.myList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                int i = SearchEverywhereAction.this.myList.locationToIndex(e.getPoint());
                if (i != -1) {
                    SearchEverywhereAction.this.mySkipFocusGain = true;
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)SearchEverywhereAction.this.getField(), true));
                    ApplicationManager.getApplication().invokeLater(() -> {
                        SearchEverywhereAction.this.myList.setSelectedIndex(i);
                        SearchEverywhereAction.this.doNavigate(i);
                    });
                }
            }
        });
        this.myNonProjectCheckBox = new JCheckBox();
        this.myNonProjectCheckBox.setOpaque(false);
        this.myNonProjectCheckBox.setAlignmentX(1.0f);
        this.myNonProjectCheckBox.addActionListener(e -> {
            if (Holder.showAll.get() != this.myNonProjectCheckBox.isSelected()) {
                JTextField editor;
                Holder.showAll.set(!Holder.showAll.get());
                JTextField jTextField = editor = this.myBalloon.isDisposed() ? null : (JTextField)UIUtil.findComponentOfType((JComponent)this.myBalloon.getContent(), JTextField.class);
                if (editor != null) {
                    String pattern = editor.getText();
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(() -> {
                        if (editor.hasFocus()) {
                            this.rebuildList(pattern);
                        }
                    }, 30);
                }
            }
        });
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            SearchEverywhereAction.$$$reportNull$$$0(2);
        }
        return null;
    }

    private static String getShortcut() {
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"SearchEverywhere").getShortcuts();
        if (shortcuts.length == 0) {
            return "Double" + (SystemInfo.isMac ? FontUtil.thinSpace() + "\u21e7" : " Shift");
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    private void initSearchField(final MySearchTextField search2) {
        JBTextField editor = search2.getTextEditor();
        editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((JTextField)editor){
            final /* synthetic */ JTextField val$editor;
            {
                this.val$editor = jTextField;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                String pattern = this.val$editor.getText();
                if (this.val$editor.hasFocus()) {
                    SearchEverywhereAction.this.rebuildList(pattern);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/SearchEverywhereAction$4", "textChanged"));
            }
        });
        editor.addFocusListener(new FocusAdapter((JTextField)editor){
            final /* synthetic */ JTextField val$editor;
            {
                this.val$editor = jTextField;
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (SearchEverywhereAction.this.mySkipFocusGain) {
                    SearchEverywhereAction.this.mySkipFocusGain = false;
                    return;
                }
                String text2 = SearchEverywhereAction.this.myInitialTextForNavigation;
                text2 = text2 != null ? text2.trim() : "";
                search2.setText(text2);
                search2.getTextEditor().setForeground(UIUtil.getLabelForeground());
                search2.selectText();
                this.val$editor.setColumns(25);
                SearchEverywhereAction.this.myFocusComponent = e.getOppositeComponent();
                SwingUtilities.invokeLater(() -> {
                    JComponent parent = (JComponent)this.val$editor.getParent();
                    parent.revalidate();
                    parent.repaint();
                });
                SearchEverywhereAction.this.rebuildList(text2);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SearchEverywhereAction.this.myPopup instanceof AbstractPopup && SearchEverywhereAction.this.myPopup.isVisible() && (SearchEverywhereAction.this.myList == e.getOppositeComponent() || ((AbstractPopup)SearchEverywhereAction.this.myPopup).getPopupWindow() == e.getOppositeComponent())) {
                    return;
                }
                if (SearchEverywhereAction.this.myNonProjectCheckBox == e.getOppositeComponent()) {
                    SearchEverywhereAction.this.mySkipFocusGain = true;
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.val$editor, true));
                    return;
                }
                if (UIUtil.haveCommonOwner((Component)e.getComponent(), (Component)e.getOppositeComponent())) {
                    return;
                }
                SearchEverywhereAction.this.onFocusLost();
            }
        });
    }

    private void jumpNextGroup(boolean forward) {
        int index = this.myList.getSelectedIndex();
        SearchListModel model = this.getModel();
        if (index >= 0) {
            int newIndex = forward ? model.next(index) : model.prev(index);
            this.myList.setSelectedIndex(newIndex);
            int more = model.next(newIndex) - 1;
            if (more < newIndex) {
                more = this.myList.getItemsCount() - 1;
            }
            ScrollingUtil.ensureIndexIsVisible(this.myList, (int)more, (int)(forward ? 1 : -1));
            ScrollingUtil.ensureIndexIsVisible(this.myList, (int)newIndex, (int)(forward ? 1 : -1));
        }
    }

    private SearchListModel getModel() {
        return (SearchListModel)this.myList.getModel();
    }

    private ActionCallback onFocusLost() {
        ActionCallback result2 = new ActionCallback();
        UIUtil.invokeLaterIfNeeded(() -> {
            try {
                if (this.myCalcThread != null) {
                    this.myCalcThread.cancel();
                }
                this.myAlarm.cancelAllRequests();
                if (this.myBalloon != null && !this.myBalloon.isDisposed()) {
                    this.myBalloon.cancel();
                }
                if (this.myPopup != null && !this.myPopup.isDisposed()) {
                    this.myPopup.cancel();
                }
                SwingUtilities.invokeLater(ActionToolbarImpl::updateAllToolbarsImmediately);
            }
            finally {
                result2.setDone();
            }
        });
        return result2;
    }

    private SearchTextField getField() {
        return this.myPopupField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNavigate(int index) {
        String pattern;
        DataManager dataManager = DataManager.getInstance();
        if (dataManager == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataManager.getDataContext((Component)this.getField().getTextEditor()));
        assert (project != null);
        SearchListModel model = this.getModel();
        if (this.isMoreItem(index)) {
            pattern = this.myPopupField.getText();
            WidgetID wid = null;
            if (index == model.moreIndex.classes) {
                wid = WidgetID.CLASSES;
            } else if (index == model.moreIndex.files) {
                wid = WidgetID.FILES;
            } else if (index == model.moreIndex.settings) {
                wid = WidgetID.SETTINGS;
            } else if (index == model.moreIndex.actions) {
                wid = WidgetID.ACTIONS;
            } else if (index == model.moreIndex.symbols) {
                wid = WidgetID.SYMBOLS;
            } else if (index == model.moreIndex.runConfigurations) {
                wid = WidgetID.RUN_CONFIGURATIONS;
            }
            if (wid != null) {
                WidgetID widgetID = wid;
                Object object = this.myWorkerRestartRequestLock;
                synchronized (object) {
                    int currentRestartRequest = ++this.myCalcThreadRestartRequestId;
                    this.myCurrentWorker.doWhenProcessed(() -> {
                        Object object = this.myWorkerRestartRequestLock;
                        synchronized (object) {
                            if (currentRestartRequest != this.myCalcThreadRestartRequestId) {
                                return;
                            }
                            this.myCalcThread = new CalcThread(project, pattern, true);
                            this.myPopupActualWidth = 0;
                            this.myCurrentWorker = this.myCalcThread.insert(index, widgetID);
                        }
                    });
                }
                return;
            }
        }
        pattern = this.getField().getText();
        Object value2 = this.myList.getSelectedValue();
        SearchEverywhereAction.saveHistory(project, pattern, value2);
        IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent((Component)this.getField().getTextEditor());
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.myPopup.cancel();
        }
        if (value2 instanceof BooleanOptionDescription) {
            BooleanOptionDescription option2;
            option2.setOptionState(!(option2 = (BooleanOptionDescription)value2).isOptionEnabled());
            this.myList.revalidate();
            this.myList.repaint();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getField(), true));
            return;
        }
        if (value2 instanceof OptionsTopHitProvider) {
            SwingUtilities.invokeLater(() -> this.getField().setText(SearchTopHitProvider.getTopHitAccelerator() + ((OptionsTopHitProvider)value2).getId() + " "));
            return;
        }
        Runnable onDone = (Runnable)ReadAction.compute(() -> {
            if (value2 instanceof PsiElement) {
                return () -> NavigationUtil.activateFileWithPsiElement((PsiElement)value2, true);
            }
            if (SearchEverywhereAction.isVirtualFile(value2)) {
                return () -> OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{new OpenFileDescriptor(project, (VirtualFile)value2)});
            }
            if (SearchEverywhereAction.isActionValue(value2) || SearchEverywhereAction.isSetting(value2) || SearchEverywhereAction.isRunConfiguration(value2)) {
                focusManager.requestDefaultFocus(true);
                Component comp = this.myContextComponent;
                IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> {
                    Component c = comp;
                    if (c == null) {
                        c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    }
                    if (SearchEverywhereAction.isRunConfiguration(value2)) {
                        Executor executor;
                        ChooseRunConfigurationPopup.ItemWrapper itemWrapper = (ChooseRunConfigurationPopup.ItemWrapper)value2;
                        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)ObjectUtils.tryCast(itemWrapper.getValue(), RunnerAndConfigurationSettings.class);
                        if (settings != null && (executor = SearchEverywhereAction.findExecutor(settings)) != null) {
                            itemWrapper.perform(project, executor, dataManager.getDataContext(c));
                        }
                    } else {
                        GotoActionAction.openOptionOrPerformAction(value2, pattern, project, c);
                    }
                });
                return () -> {};
            }
            if (value2 instanceof Navigatable) {
                return () -> OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{(Navigatable)value2});
            }
            return null;
        });
        ActionCallback callback2 = this.onFocusLost();
        if (onDone != null) {
            callback2.doWhenDone(onDone);
            return;
        }
        focusManager.requestDefaultFocus(true);
    }

    private boolean isMoreItem(int index) {
        SearchListModel model = this.getModel();
        return index == model.moreIndex.classes || index == model.moreIndex.files || index == model.moreIndex.settings || index == model.moreIndex.actions || index == model.moreIndex.symbols || index == model.moreIndex.runConfigurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildList(@NotNull String pattern) {
        if (pattern == null) {
            SearchEverywhereAction.$$$reportNull$$$0(3);
        }
        assert (EventQueue.isDispatchThread()) : "Must be EDT";
        if (this.myCalcThread != null && !this.myCurrentWorker.isProcessed()) {
            this.myCurrentWorker = this.myCalcThread.cancel();
        }
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.getField().getTextEditor()));
        assert (project != null);
        this.myRenderer.myProject = project;
        Object object = this.myWorkerRestartRequestLock;
        synchronized (object) {
            int currentRestartRequest = ++this.myCalcThreadRestartRequestId;
            this.myCurrentWorker.doWhenProcessed(() -> {
                Object object = this.myWorkerRestartRequestLock;
                synchronized (object) {
                    if (currentRestartRequest != this.myCalcThreadRestartRequestId) {
                        return;
                    }
                    this.myCalcThread = new CalcThread(project, pattern, false);
                    this.myPopupActualWidth = 0;
                    this.myCurrentWorker = this.myCalcThread.start();
                }
            });
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SearchEverywhereAction.$$$reportNull$$$0(4);
        }
        if (LightEdit.owns((Project)e.getProject())) {
            return;
        }
        if (Registry.is((String)"ide.suppress.double.click.handler") && e.getInputEvent() instanceof KeyEvent && ((KeyEvent)e.getInputEvent()).getKeyCode() == 16) {
            return;
        }
        this.actionPerformed(e, null);
    }

    public void actionPerformed(AnActionEvent e, MouseEvent me) {
        Window wnd;
        if (Registry.is((String)"new.search.everywhere") && e.getProject() != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("SearchEverywhere");
            SearchEverywhereManager seManager = SearchEverywhereManager.getInstance(e.getProject());
            String searchProviderID = "SearchEverywhereContributor.All";
            if (seManager.isShown()) {
                if (searchProviderID.equals(seManager.getSelectedContributorID())) {
                    seManager.toggleEverywhereFilter();
                } else {
                    seManager.setSelectedContributor(searchProviderID);
                    FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(searchProviderID).addInputEvent(e);
                    SearchEverywhereUsageTriggerCollector.trigger(e.getProject(), "tabSwitched", data2);
                }
                return;
            }
            FeatureUsageData data3 = SearchEverywhereUsageTriggerCollector.createData(searchProviderID).addInputEvent(e);
            SearchEverywhereUsageTriggerCollector.trigger(e.getProject(), "dialogOpen", data3);
            IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
            String text2 = GotoActionBase.getInitialTextForNavigation(e);
            seManager.show(searchProviderID, text2, e);
            return;
        }
        if (this.myBalloon != null && this.myBalloon.isVisible()) {
            Holder.showAll.set(!Holder.showAll.get());
            this.myNonProjectCheckBox.setSelected(Holder.showAll.get());
            this.rebuildList(this.myPopupField.getText());
            return;
        }
        this.myCurrentWorker = ActionCallback.DONE;
        if (e != null) {
            this.myEditor = (Editor)e.getData(CommonDataKeys.EDITOR);
            this.myInitialTextForNavigation = GotoActionBase.getInitialTextForNavigation(e);
            this.myFileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        }
        if (e == null && this.myFocusOwner != null) {
            e = AnActionEvent.createFromAnAction((AnAction)this, (InputEvent)me, (String)"unknown", (DataContext)DataManager.getInstance().getDataContext(this.myFocusOwner));
        }
        if (e == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> LookupManager.getInstance(project).hideActiveLookup());
        this.updateComponents();
        this.myContextComponent = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Window window = wnd = this.myContextComponent != null ? SwingUtilities.windowForComponent(this.myContextComponent) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (wnd == null && this.myContextComponent instanceof Window) {
            wnd = (Window)this.myContextComponent;
        }
        if (wnd == null || wnd.getParent() != null) {
            return;
        }
        this.myActionEvent = e;
        if (this.myPopupField != null) {
            Disposer.dispose((Disposable)this.myPopupField);
        }
        this.myPopupField = new MySearchTextField();
        this.myPopupField.getTextEditor().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SearchEverywhereAction.this.myHistoryIndex = 0;
                SearchEverywhereAction.this.myHistoryItem = null;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    SearchEverywhereAction.this.myList.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    SearchEverywhereAction.this.myList.repaint();
                }
            }
        });
        this.initSearchField(this.myPopupField);
        this.myPopupField.setOpaque(false);
        JBTextField editor = this.myPopupField.getTextEditor();
        editor.setColumns(25);
        JPanel panel2 = UIUtil.isUnderWin10LookAndFeel() ? new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(UIManager.getColor("SearchEverywhere.background"));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        } : new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                Gradient gradient = new Gradient((Color)new JBColor(6657010, 4214878), (Color)new JBColor(3043277, 3490135));
                ((Graphics2D)g).setPaint(new GradientPaint(0.0f, 0.0f, gradient.getStartColor(), 0.0f, this.getHeight(), gradient.getEndColor()));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        JLabel title = new JLabel(" Search Everywhere:       ");
        NonOpaquePanel topPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        Color foregroundColor = UIUtil.isUnderWin10LookAndFeel() ? UIManager.getColor("SearchEverywhere.foreground") : new JBColor((Color)Gray._240, (Color)Gray._200);
        title.setForeground(foregroundColor);
        if (SystemInfo.isMac) {
            title.setFont(title.getFont().deriveFont(1, (float)title.getFont().getSize() - 1.0f));
        } else {
            title.setFont(title.getFont().deriveFont(1));
        }
        topPanel.add((Component)title, "West");
        JPanel controls = new JPanel(new BorderLayout());
        controls.setOpaque(false);
        JLabel settings = new JLabel(AllIcons.General.GearPlain);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    9.$$$reportNull$$$0(0);
                }
                SearchEverywhereAction.this.showSettings();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/SearchEverywhereAction$9", "onClick"));
            }
        }.installOn((Component)settings);
        settings.setBorder((Border)(UIUtil.isUnderWin10LookAndFeel() ? JBUI.Borders.emptyLeft((int)6) : JBUI.Borders.empty()));
        controls.add((Component)settings, "East");
        if (!NonProjectScopeDisablerEP.isSearchInNonProjectDisabled()) {
            this.myNonProjectCheckBox.setForeground(foregroundColor);
            Color shortcutColor = UIUtil.isUnderWin10LookAndFeel() ? UIManager.getColor("SearchEverywhere.shortcutForeground") : foregroundColor;
            StringBuilder cbText = new StringBuilder("<html>");
            cbText.append(IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.items", new Object[0]));
            cbText.append(" ");
            if (!UIUtil.isUnderWin10LookAndFeel()) {
                cbText.append("<b>");
            }
            cbText.append("<font color=#").append(ColorUtil.toHex((Color)shortcutColor)).append(">").append(SearchEverywhereAction.getShortcut()).append("</font>");
            if (!UIUtil.isUnderWin10LookAndFeel()) {
                cbText.append("</b>");
            }
            cbText.append("</html>");
            this.myNonProjectCheckBox.setText(cbText.toString());
            controls.add((Component)this.myNonProjectCheckBox, "West");
        }
        controls.setBorder((Border)(UIUtil.isUnderWin10LookAndFeel() ? JBUI.Borders.emptyTop((int)1) : JBUI.Borders.empty()));
        topPanel.add((Component)controls, "East");
        panel2.add((Component)((Object)this.myPopupField), "Center");
        panel2.add((Component)topPanel, "North");
        panel2.setBorder((Border)JBUI.Borders.empty((int)3, (int)5, (int)4, (int)5));
        DataManager.registerDataProvider((JComponent)panel2, (DataProvider)this);
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)editor);
        this.myBalloon = builder2.setCancelOnClickOutside(true).setModalContext(false).setRequestFocus(true).createPopup();
        this.myBalloon.getContent().setBorder((Border)JBUI.Borders.empty());
        project.getMessageBus().connect((Disposable)this.myBalloon).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> SearchEverywhereAction.this.rebuildList(SearchEverywhereAction.this.myPopupField.getText()));
            }
        });
        this.registerDataProvider(panel2, project);
        RelativePoint showPoint = SearchEverywhereAction.calculateShowingPoint(e, panel2);
        this.myList.setFont(UIUtil.getListFont());
        this.myBalloon.show(showPoint);
        this.initSearchActions(this.myBalloon, this.myPopupField);
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)project);
        focusManager.requestFocus((Component)editor, true);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("SearchEverywhere");
    }

    @NotNull
    private static RelativePoint calculateShowingPoint(AnActionEvent e, JComponent showingContent) {
        RelativePoint showPoint;
        Project project = e.getProject();
        Window window = project != null ? WindowManager.getInstance().suggestParentWindow(project) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        Component parent = UIUtil.findUltimateParent((Component)window);
        if (parent != null) {
            int height;
            int n = height = UISettings.getInstance().getShowMainToolbar() ? 135 : 115;
            if (parent instanceof IdeFrameImpl && ((IdeFrameImpl)parent).isInFullScreen()) {
                height -= 20;
            }
            showPoint = new RelativePoint(parent, new Point((parent.getSize().width - showingContent.getPreferredSize().width) / 2, height));
        } else {
            showPoint = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        }
        RelativePoint relativePoint = showPoint;
        if (relativePoint == null) {
            SearchEverywhereAction.$$$reportNull$$$0(5);
        }
        return relativePoint;
    }

    private void showSettings() {
        this.myPopupField.setText("");
        SearchListModel model = new SearchListModel();
        model.addElement((Object)new SEOption("Show files", "search.everywhere.files"));
        model.addElement((Object)new SEOption("Show symbols", "search.everywhere.symbols"));
        model.addElement((Object)new SEOption("Show tool windows", "search.everywhere.toolwindows"));
        model.addElement((Object)new SEOption("Show run configurations", "search.everywhere.configurations"));
        model.addElement((Object)new SEOption("Show actions", "search.everywhere.actions"));
        model.addElement((Object)new SEOption("Show IDE settings", "search.everywhere.settings"));
        if (this.myCalcThread != null && !this.myCurrentWorker.isProcessed()) {
            this.myCurrentWorker = this.myCalcThread.cancel();
        }
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
        this.myCurrentWorker.doWhenProcessed(() -> {
            this.myList.setModel((ListModel)model);
            this.updatePopupBounds();
        });
    }

    private static void saveHistory(Project project, String text2, Object value2) {
        PsiElement psiElement;
        Language language;
        String name;
        if (project == null || project.isDisposed() || !project.isInitialized()) {
            return;
        }
        HistoryType type = null;
        String fqn = null;
        if (SearchEverywhereAction.isActionValue(value2)) {
            type = HistoryType.ACTION;
            AnAction action2 = (AnAction)(value2 instanceof GotoActionModel.ActionWrapper ? ((GotoActionModel.ActionWrapper)value2).getAction() : value2);
            fqn = ActionManager.getInstance().getId(action2);
        } else if (value2 instanceof VirtualFile) {
            type = HistoryType.FILE;
            fqn = ((VirtualFile)value2).getUrl();
        } else if (value2 instanceof ChooseRunConfigurationPopup.ItemWrapper) {
            type = HistoryType.RUN_CONFIGURATION;
            fqn = ((ChooseRunConfigurationPopup.ItemWrapper)value2).getText();
        } else if (value2 instanceof PsiElement && (name = ((PsiElementExternalizer)LanguagePsiElementExternalizer.INSTANCE.forLanguage(language = (psiElement = (PsiElement)value2).getLanguage())).getQualifiedName(psiElement)) != null) {
            type = HistoryType.PSI;
            fqn = language.getID() + "://" + name;
        }
        PropertiesComponent storage = PropertiesComponent.getInstance((Project)project);
        String[] values2 = storage.getValues(SE_HISTORY_KEY);
        List<HistoryItem> history = new ArrayList<HistoryItem>();
        if (values2 != null) {
            for (String s : values2) {
                String[] split = s.split("\t");
                if (split.length != 3 || text2.equals(split[0]) || StringUtil.isEmpty((String)split[0])) continue;
                history.add(new HistoryItem(split[0], split[1], split[2]));
            }
        }
        history.add(0, new HistoryItem(text2, type == null ? null : type.name(), fqn));
        history = ContainerUtil.getFirstItems(history, (int)50);
        String[] newValues = new String[history.size()];
        for (int i = 0; i < newValues.length; ++i) {
            newValues[i] = ((HistoryItem)history.get(i)).toString();
        }
        storage.setValues(SE_HISTORY_KEY, newValues);
    }

    @Nullable
    private static Executor findExecutor(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            SearchEverywhereAction.$$$reportNull$$$0(6);
        }
        Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
        Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById("Debug");
        Executor executor = Holder.ourShiftIsPressed.get() ? runExecutor : debugExecutor;
        RunConfiguration runConf = settings.getConfiguration();
        if (executor == null) {
            return null;
        }
        ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runConf);
        if (runner == null) {
            executor = runExecutor == executor ? debugExecutor : runExecutor;
        }
        return executor;
    }

    private void registerDataProvider(JPanel panel2, final Project project) {
        DataManager.registerDataProvider((JComponent)panel2, dataId -> {
            Object value2 = this.myList.getSelectedValue();
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && value2 instanceof PsiElement) {
                return value2;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId) && value2 instanceof VirtualFile) {
                return value2;
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                Object config2;
                if (value2 instanceof Navigatable) {
                    return value2;
                }
                if (value2 instanceof ChooseRunConfigurationPopup.ItemWrapper && (config2 = ((ChooseRunConfigurationPopup.ItemWrapper)value2).getValue()) instanceof RunnerAndConfigurationSettings) {
                    return new Navigatable(){

                        public void navigate(boolean requestFocus) {
                            Executor executor = SearchEverywhereAction.findExecutor((RunnerAndConfigurationSettings)config2);
                            RunDialog.editConfiguration(project, (RunnerAndConfigurationSettings)config2, "Edit Configuration", executor);
                        }

                        public boolean canNavigate() {
                            return true;
                        }

                        public boolean canNavigateToSource() {
                            return true;
                        }
                    };
                }
            }
            if (PlatformDataKeys.SEARCH_INPUT_TEXT.is(dataId)) {
                return this.myPopupField == null ? null : this.myPopupField.getText();
            }
            return null;
        });
    }

    private void initSearchActions(JBPopup balloon, MySearchTextField searchTextField) {
        JBTextField editor = searchTextField.getTextEditor();
        DumbAwareAction.create(e -> this.jumpNextGroup(true)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), (JComponent)editor, (Disposable)balloon);
        DumbAwareAction.create(e -> this.jumpNextGroup(false)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), (JComponent)editor, (Disposable)balloon);
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction.create(e -> {
            if (this.myBalloon != null && this.myBalloon.isVisible()) {
                this.myBalloon.cancel();
            }
            if (this.myPopup != null && this.myPopup.isVisible()) {
                this.myPopup.cancel();
            }
        }).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)editor, (Disposable)balloon);
        DumbAwareAction.create(e -> {
            int index = this.myList.getSelectedIndex();
            if (index != -1) {
                this.doNavigate(index);
            }
        }).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER", "shift ENTER"}), (JComponent)editor, (Disposable)balloon);
        new DumbAwareAction((JTextField)editor){
            final /* synthetic */ JTextField val$editor;
            {
                this.val$editor = jTextField;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                PropertiesComponent storage;
                String[] values2;
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                if ((values2 = (storage = PropertiesComponent.getInstance((Project)e.getProject())).getValues(SearchEverywhereAction.SE_HISTORY_KEY)) != null && values2.length > SearchEverywhereAction.this.myHistoryIndex) {
                    List data2 = StringUtil.split((String)values2[SearchEverywhereAction.this.myHistoryIndex], (String)"\t");
                    SearchEverywhereAction.this.myHistoryItem = new HistoryItem((String)data2.get(0), (String)data2.get(1), (String)data2.get(2));
                    SearchEverywhereAction.this.myHistoryIndex++;
                    this.val$editor.setText(((SearchEverywhereAction)SearchEverywhereAction.this).myHistoryItem.pattern);
                    this.val$editor.setCaretPosition(((SearchEverywhereAction)SearchEverywhereAction.this).myHistoryItem.pattern.length());
                    this.val$editor.moveCaretPosition(0);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(this.val$editor.getCaretPosition() == 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ide/actions/SearchEverywhereAction$12";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"LEFT"}), (JComponent)editor, (Disposable)balloon);
    }

    private static String getSettingText(OptionDescription value2) {
        String hit = value2.getHit();
        if (hit == null) {
            hit = value2.getOption();
        }
        if ((hit = StringUtil.unescapeXmlEntities((String)hit)).length() > 60) {
            hit = hit.substring(0, 60) + "...";
        }
        hit = hit.replace("  ", " ");
        String text2 = hit.trim();
        text2 = StringUtil.trimEnd((String)text2, (String)":");
        return text2;
    }

    private static boolean isActionValue(Object o) {
        return o instanceof GotoActionModel.ActionWrapper || o instanceof AnAction;
    }

    private static boolean isSetting(Object o) {
        return o instanceof OptionDescription;
    }

    private static boolean isRunConfiguration(Object o) {
        return o instanceof ChooseRunConfigurationPopup.ItemWrapper;
    }

    private static boolean isVirtualFile(Object o) {
        return o instanceof VirtualFile;
    }

    private static Font getTitleFont() {
        return UIUtil.getLabelFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    private static boolean shouldSkipPattern(String pattern) {
        return Registry.is((String)"search.everywhere.pattern.checking") && StringUtil.split((String)pattern, (String)".").size() == 2;
    }

    private void resetFields() {
        if (this.myBalloon != null) {
            JBPopup balloonToBeCanceled = this.myBalloon;
            SwingUtilities.invokeLater(() -> ((JBPopup)balloonToBeCanceled).cancel());
            this.myBalloon = null;
        }
        this.myCurrentWorker.doWhenProcessed(() -> {
            CalcThread lock;
            this.myFileModel = null;
            if (this.myFileChooseByName != null) {
                this.myFileChooseByName.close(false);
                this.myFileChooseByName = null;
            }
            if (this.myClassChooseByName != null) {
                this.myClassChooseByName.close(false);
                this.myClassChooseByName = null;
            }
            if (this.mySymbolsChooseByName != null) {
                this.mySymbolsChooseByName.close(false);
                this.mySymbolsChooseByName = null;
            }
            if ((lock = this.myCalcThread) != null) {
                CalcThread calcThread = lock;
                synchronized (calcThread) {
                    this.myClassModel = null;
                    this.myActionProvider = null;
                    this.mySymbolsModel = null;
                    this.myConfigurables.clear();
                    this.myFocusComponent = null;
                    this.myContextComponent = null;
                    this.myFocusOwner = null;
                    this.myRenderer.myProject = null;
                    this.myPopup = null;
                    this.myHistoryIndex = 0;
                    this.myPopupActualWidth = 0;
                    Holder.showAll.set(false);
                    this.myCurrentWorker = this.myCalcThread.cancel();
                    this.myCalcThread = null;
                    this.myEditor = null;
                    this.myInitialTextForNavigation = null;
                    this.myFileEditor = null;
                    this.myStructureModel = null;
                    this.myDisabledActions.clear();
                }
            }
        });
        this.mySkipFocusGain = false;
    }

    private void updatePopupBounds() {
        if (this.myPopup == null || !this.myPopup.isVisible()) {
            return;
        }
        Container parent = this.getField().getParent();
        Dimension size = this.myList.getParent().getParent().getPreferredSize();
        size.width = this.myPopupActualWidth - 2;
        if (size.width + 2 < parent.getWidth()) {
            size.width = parent.getWidth();
        }
        if (this.myList.getItemsCount() == 0) {
            size.height = JBUIScale.scale((int)30);
        }
        Dimension sz = new Dimension(size.width, this.myList.getPreferredSize().height);
        if (!SystemInfo.isMac) {
            if (sz.width > SearchEverywhereAction.getPopupMaxWidth() || sz.height > SearchEverywhereAction.getPopupMaxWidth()) {
                JBScrollPane pane2 = new JBScrollPane();
                int extraWidth = pane2.getVerticalScrollBar().getWidth() + 1;
                int extraHeight = pane2.getHorizontalScrollBar().getHeight() + 1;
                sz = new Dimension(Math.min(SearchEverywhereAction.getPopupMaxWidth(), Math.max(this.getField().getWidth(), sz.width + extraWidth)), Math.min(SearchEverywhereAction.getPopupMaxWidth(), sz.height + extraHeight));
                sz.width += 20;
            } else {
                sz.width += 2;
            }
        }
        sz.height += 2;
        sz.width = Math.max(sz.width, this.myPopup.getSize().width);
        this.myPopup.setSize(sz);
        if (this.myActionEvent != null && this.myActionEvent.getInputEvent() == null) {
            Point p = parent.getLocationOnScreen();
            p.y += parent.getHeight();
            if (parent.getWidth() < sz.width) {
                p.x -= sz.width - parent.getWidth();
            }
            this.myPopup.setLocation(p);
        } else {
            try {
                this.adjustPopup();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static int getPopupMaxWidth() {
        return PropertiesComponent.getInstance().getInt("search.everywhere.max.popup.width", JBUIScale.scale((int)600));
    }

    private void adjustPopup() {
        Dimension d = PopupPositionManager.PositionAdjuster.getPopupSize(this.myPopup);
        JComponent myRelativeTo = this.myBalloon.getContent();
        Point myRelativeOnScreen = myRelativeTo.getLocationOnScreen();
        Rectangle screen = ScreenUtil.getScreenRectangle((Point)myRelativeOnScreen);
        Rectangle popupRect = null;
        Rectangle r = new Rectangle(myRelativeOnScreen.x, myRelativeOnScreen.y + myRelativeTo.getHeight(), d.width, d.height);
        if (screen.contains(r)) {
            popupRect = r;
        }
        if (popupRect != null) {
            Point location2 = new Point(r.x, r.y);
            if (!location2.equals(this.myPopup.getLocationOnScreen())) {
                this.myPopup.setLocation(location2);
            }
        } else {
            if (r.y + d.height > screen.y + screen.height) {
                r.height = screen.y + screen.height - r.y - 2;
            }
            if (r.width > screen.width) {
                r.width = screen.width - 50;
            }
            if (r.x + r.width > screen.x + screen.width) {
                r.x = screen.x + screen.width - r.width - 2;
            }
            this.myPopup.setSize(r.getSize());
            this.myPopup.setLocation(r.getLocation());
        }
    }

    private static boolean isToolWindowAction(Object o) {
        return SearchEverywhereAction.isActionValue(o) && o instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)o).getAction() instanceof ActivateToolWindowAction;
    }

    private void fillConfigurablesIds(String pathToParent, @NotNull List<? extends Configurable> configurables) {
        if (configurables == null) {
            SearchEverywhereAction.$$$reportNull$$$0(7);
        }
        for (Configurable configurable2 : configurables) {
            if (!(configurable2 instanceof SearchableConfigurable)) continue;
            String id2 = ((SearchableConfigurable)configurable2).getId();
            String name = configurable2.getDisplayName();
            if (pathToParent != null) {
                name = pathToParent + " -> " + name;
            }
            this.myConfigurables.put(id2, name);
            if (!(configurable2 instanceof SearchableConfigurable.Parent)) continue;
            this.fillConfigurablesIds(name, Arrays.asList(((SearchableConfigurable.Parent)configurable2).getConfigurables()));
        }
    }

    private static JComponent createTitle(String titleText) {
        JLabel titleLabel = new JLabel(titleText);
        titleLabel.setFont(SearchEverywhereAction.getTitleFont());
        titleLabel.setForeground(UIUtil.getLabelDisabledForeground());
        SeparatorComponent separatorComponent = new SeparatorComponent(titleLabel.getPreferredSize().height / 2, (Color)new JBColor((Color)Gray._220, (Color)Gray._80), null);
        return ((BorderLayoutPanel)JBUI.Panels.simplePanel((int)5, (int)10).addToCenter((Component)separatorComponent).addToLeft((Component)titleLabel).withBorder(Holder.RENDERER_TITLE_BORDER)).withBackground(UIUtil.getListBackground());
    }

    @Nullable
    private static HistoryType parseHistoryType(@Nullable String name) {
        try {
            return HistoryType.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        ModifierKeyDoubleClickHandler.getInstance().registerAction("SearchEverywhere", 16, -1, false);
        IdeEventQueue.getInstance().addPostprocessor(event -> {
            int keyCode;
            if (event instanceof KeyEvent && (keyCode = ((KeyEvent)event).getKeyCode()) == 16) {
                Holder.ourShiftIsPressed.set(event.getID() == 401);
            }
            return false;
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SearchEverywhereAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SearchEverywhereAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateShowingPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rebuildList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findExecutor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillConfigurablesIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HistoryItem {
        final String pattern;
        final String type;
        final String fqn;

        private HistoryItem(String pattern, String type, String fqn) {
            this.pattern = pattern;
            this.type = type;
            this.fqn = fqn;
        }

        public String toString() {
            return this.pattern + "\t" + this.type + "\t" + this.fqn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistoryItem item = (HistoryItem)o;
            return this.pattern.equals(item.pattern);
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }
    }

    private static enum HistoryType {
        PSI,
        FILE,
        SETTING,
        ACTION,
        RUN_CONFIGURATION;

    }

    static class More
    extends JPanel {
        static final More instance = new More();
        final JLabel label = new JLabel(IdeBundle.message((String)"search.everywhere.points.spaces.more", (Object[])new Object[0]));

        private More() {
            super(new BorderLayout());
            this.add((Component)this.label, "Center");
        }

        static More get(boolean isSelected) {
            instance.setBackground(UIUtil.getListBackground((boolean)isSelected));
            More.instance.label.setForeground(UIUtil.getLabelDisabledForeground());
            More.instance.label.setFont(SearchEverywhereAction.getTitleFont());
            More.instance.label.setBackground(UIUtil.getListBackground((boolean)isSelected));
            return instance;
        }
    }

    private static class SearchListModel
    extends DefaultListModel<Object> {
        Vector myDelegate;
        volatile TitleIndex titleIndex = new TitleIndex();
        volatile MoreIndex moreIndex = new MoreIndex();

        private SearchListModel() {
            this.myDelegate = (Vector)ReflectionUtil.getField(DefaultListModel.class, (Object)this, Vector.class, (String)"delegate");
        }

        int next(int index) {
            int[] all = this.getAll();
            Arrays.sort(all);
            for (int next : all) {
                if (next <= index) continue;
                return next;
            }
            return 0;
        }

        int[] getAll() {
            return new int[]{this.titleIndex.topHit, this.titleIndex.recentFiles, this.titleIndex.structure, this.titleIndex.runConfigurations, this.titleIndex.classes, this.titleIndex.files, this.titleIndex.actions, this.titleIndex.settings, this.titleIndex.toolWindows, this.titleIndex.symbols, this.moreIndex.classes, this.moreIndex.actions, this.moreIndex.files, this.moreIndex.settings, this.moreIndex.symbols, this.moreIndex.runConfigurations, this.moreIndex.structure};
        }

        int prev(int index) {
            int[] all = this.getAll();
            Arrays.sort(all);
            for (int i = all.length - 1; i >= 0; --i) {
                if (all[i] == -1 || all[i] >= index) continue;
                return all[i];
            }
            return all[all.length - 1];
        }

        @Override
        public void addElement(Object obj) {
            this.myDelegate.add(obj);
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    static class SearchResult
    extends ArrayList<Object> {
        boolean needMore;

        SearchResult() {
        }
    }

    static class TitleIndex {
        volatile int topHit = -1;
        volatile int recentFiles = -1;
        volatile int runConfigurations = -1;
        volatile int classes = -1;
        volatile int structure = -1;
        volatile int files = -1;
        volatile int actions = -1;
        volatile int settings = -1;
        volatile int toolWindows = -1;
        volatile int symbols = -1;
        final String gotoClassTitle;
        final String gotoFileTitle;
        final String gotoActionTitle;
        final String gotoSettingsTitle;
        final String gotoRecentFilesTitle;
        final String gotoRunConfigurationsTitle;
        final String gotoSymbolTitle;
        final String gotoStructureTitle;
        static final String toolWindowsTitle = "Tool Windows";

        TitleIndex() {
            String gotoClass = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoClass"));
            String classesStr = StringUtil.capitalize((String)StringUtil.join(GotoClassPresentationUpdater.getElementKindsPluralized(), (String)"/"));
            this.gotoClassTitle = StringUtil.isEmpty((String)gotoClass) ? classesStr : classesStr + " (" + gotoClass + ")";
            String gotoFile = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoFile"));
            this.gotoFileTitle = StringUtil.isEmpty((String)gotoFile) ? "Files" : "Files (" + gotoFile + ")";
            String gotoAction = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoAction"));
            this.gotoActionTitle = StringUtil.isEmpty((String)gotoAction) ? "Actions" : "Actions (" + gotoAction + ")";
            String gotoSettings = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowSettings"));
            this.gotoSettingsTitle = StringUtil.isEmpty((String)gotoAction) ? ShowSettingsUtil.getSettingsMenuName() : ShowSettingsUtil.getSettingsMenuName() + " (" + gotoSettings + ")";
            String gotoRecentFiles = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("RecentFiles"));
            this.gotoRecentFilesTitle = StringUtil.isEmpty((String)gotoRecentFiles) ? "Recent Files" : "Recent Files (" + gotoRecentFiles + ")";
            String gotoSymbol = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoSymbol"));
            this.gotoSymbolTitle = StringUtil.isEmpty((String)gotoSymbol) ? "Symbols" : "Symbols (" + gotoSymbol + ")";
            String gotoRunConfiguration = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ChooseDebugConfiguration"));
            if (StringUtil.isEmpty((String)gotoRunConfiguration)) {
                gotoRunConfiguration = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ChooseRunConfiguration"));
            }
            this.gotoRunConfigurationsTitle = StringUtil.isEmpty((String)gotoRunConfiguration) ? "Run Configurations" : "Run Configurations (" + gotoRunConfiguration + ")";
            String gotoStructure = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("FileStructurePopup"));
            this.gotoStructureTitle = StringUtil.isEmpty((String)gotoStructure) ? "File Structure" : "File Structure (" + gotoStructure + ")";
        }

        String getTitle(int index) {
            if (index == this.topHit) {
                return index == 0 ? "Top Hit" : "Top Hits";
            }
            if (index == this.recentFiles) {
                return this.gotoRecentFilesTitle;
            }
            if (index == this.structure) {
                return this.gotoStructureTitle;
            }
            if (index == this.runConfigurations) {
                return this.gotoRunConfigurationsTitle;
            }
            if (index == this.classes) {
                return this.gotoClassTitle;
            }
            if (index == this.files) {
                return this.gotoFileTitle;
            }
            if (index == this.toolWindows) {
                return toolWindowsTitle;
            }
            if (index == this.actions) {
                return this.gotoActionTitle;
            }
            if (index == this.settings) {
                return this.gotoSettingsTitle;
            }
            if (index == this.symbols) {
                return this.gotoSymbolTitle;
            }
            return null;
        }

        public void clear() {
            this.topHit = -1;
            this.runConfigurations = -1;
            this.recentFiles = -1;
            this.classes = -1;
            this.files = -1;
            this.structure = -1;
            this.actions = -1;
            this.settings = -1;
            this.toolWindows = -1;
        }

        public void shift(int index, int shift) {
            if (this.toolWindows != -1 && this.toolWindows > index) {
                this.toolWindows += shift;
            }
            if (this.settings != -1 && this.settings > index) {
                this.settings += shift;
            }
            if (this.actions != -1 && this.actions > index) {
                this.actions += shift;
            }
            if (this.files != -1 && this.files > index) {
                this.files += shift;
            }
            if (this.structure != -1 && this.structure > index) {
                this.structure += shift;
            }
            if (this.classes != -1 && this.classes > index) {
                this.classes += shift;
            }
            if (this.runConfigurations != -1 && this.runConfigurations > index) {
                this.runConfigurations += shift;
            }
            if (this.symbols != -1 && this.symbols > index) {
                this.symbols += shift;
            }
        }
    }

    static class MoreIndex {
        volatile int classes = -1;
        volatile int files = -1;
        volatile int actions = -1;
        volatile int settings = -1;
        volatile int symbols = -1;
        volatile int runConfigurations = -1;
        volatile int structure = -1;

        MoreIndex() {
        }

        public void shift(int index, int shift) {
            if (this.runConfigurations >= index) {
                this.runConfigurations += shift;
            }
            if (this.classes >= index) {
                this.classes += shift;
            }
            if (this.files >= index) {
                this.files += shift;
            }
            if (this.symbols >= index) {
                this.symbols += shift;
            }
            if (this.actions >= index) {
                this.actions += shift;
            }
            if (this.settings >= index) {
                this.settings += shift;
            }
            if (this.structure >= index) {
                this.structure += shift;
            }
        }
    }

    private class CalcThread
    implements Runnable {
        private final Project project;
        @NotNull
        private final String pattern;
        private final ProgressIndicator myProgressIndicator;
        private final ActionCallback myDone;
        private final SearchListModel myListModel;
        private final ArrayList<VirtualFile> myAlreadyAddedFiles;
        private final ArrayList<AnAction> myAlreadyAddedActions;

        CalcThread(@NotNull Project project, String pattern, boolean reuseModel) {
            if (pattern == null) {
                CalcThread.$$$reportNull$$$0(0);
            }
            this.myProgressIndicator = new ProgressIndicatorBase();
            this.myDone = new ActionCallback();
            this.myAlreadyAddedFiles = new ArrayList();
            this.myAlreadyAddedActions = new ArrayList();
            this.project = project;
            this.pattern = pattern;
            this.myListModel = reuseModel ? (SearchListModel)SearchEverywhereAction.this.myList.getModel() : new SearchListModel();
        }

        @Override
        public void run() {
            try {
                this.check();
                SwingUtilities.invokeLater(() -> {
                    SearchEverywhereAction.this.myList.getEmptyText().setText("Searching...");
                    if (SearchEverywhereAction.this.myList.getModel() instanceof SearchListModel) {
                        SearchEverywhereAction.this.myAlarm.cancelAllRequests();
                        SearchEverywhereAction.this.myAlarm.addRequest(() -> {
                            if (!this.myDone.isRejected()) {
                                SearchEverywhereAction.this.myList.setModel((ListModel)this.myListModel);
                                this.updatePopup();
                            }
                        }, 50);
                    } else {
                        SearchEverywhereAction.this.myList.setModel((ListModel)this.myListModel);
                    }
                });
                if (this.pattern.trim().isEmpty()) {
                    this.buildModelFromRecentFiles();
                    return;
                }
                this.checkModelsUpToDate();
                this.check();
                this.buildTopHit(this.pattern);
                this.check();
                if (!this.pattern.startsWith(SearchTopHitProvider.getTopHitAccelerator())) {
                    this.buildRecentFiles(this.pattern);
                    this.check();
                    this.runReadAction(() -> this.buildStructure(this.pattern), true);
                    this.updatePopup();
                    this.check();
                    this.buildToolWindows(this.pattern);
                    this.check();
                    this.updatePopup();
                    this.check();
                    this.checkModelsUpToDate();
                    this.runReadAction(() -> this.buildRunConfigurations(this.pattern), true);
                    this.runReadAction(() -> this.buildClasses(this.pattern), true);
                    this.runReadAction(() -> this.buildFiles(this.pattern), false);
                    this.runReadAction(() -> this.buildSymbols(this.pattern), true);
                    this.buildActionsAndSettings(this.pattern);
                    this.updatePopup();
                }
                this.updatePopup();
            }
            catch (ProcessCanceledException ignore) {
                this.myDone.setRejected();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.myDone.setRejected();
            }
            finally {
                if (!this.isCanceled()) {
                    SwingUtilities.invokeLater(() -> SearchEverywhereAction.this.myList.getEmptyText().setText(StatusText.getDefaultEmptyText()));
                    this.updatePopup();
                }
                if (!this.myDone.isProcessed()) {
                    this.myDone.setDone();
                }
            }
        }

        private void runReadAction(Runnable action2, boolean checkDumb) {
            if (!checkDumb || !DumbService.getInstance((Project)this.project).isDumb()) {
                ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action2, this.myProgressIndicator);
                this.updatePopup();
            }
        }

        protected void check() {
            this.myProgressIndicator.checkCanceled();
            if (this.myDone.isRejected()) {
                throw new ProcessCanceledException();
            }
            if (SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed()) {
                throw new ProcessCanceledException();
            }
            assert (SearchEverywhereAction.this.myCalcThread == this) : "There are two CalcThreads running before one of them was cancelled";
        }

        private synchronized void buildToolWindows(String pattern) {
            if (!Registry.is((String)"search.everywhere.toolwindows")) {
                return;
            }
            ArrayList<ActivateToolWindowAction> actions = new ArrayList<ActivateToolWindowAction>();
            for (ActivateToolWindowAction action2 : ToolWindowsGroup.getToolWindowActions(this.project, false)) {
                String text2 = action2.getTemplatePresentation().getText();
                if (text2 == null || !StringUtil.startsWithIgnoreCase((String)text2, (String)pattern)) continue;
                actions.add(action2);
                if (actions.size() != 4) continue;
                break;
            }
            this.check();
            if (actions.isEmpty()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                this.myListModel.titleIndex.toolWindows = this.myListModel.size();
                for (Object toolWindow : actions) {
                    this.myListModel.addElement(toolWindow);
                }
            });
        }

        private SearchResult getActionsOrSettings(@NotNull String pattern, int max, boolean actions) {
            if (pattern == null) {
                CalcThread.$$$reportNull$$$0(1);
            }
            SearchResult result2 = new SearchResult();
            if (actions ? !Registry.is((String)"search.everywhere.actions") : !Registry.is((String)"search.everywhere.settings")) {
                return result2;
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern)).build();
            if (SearchEverywhereAction.this.myActionProvider == null) {
                SearchEverywhereAction.this.myActionProvider = this.createActionProvider();
            }
            SearchEverywhereAction.this.myActionProvider.filterElements(pattern, (Processor<? super GotoActionModel.MatchedValue>)((Processor)matched -> {
                this.check();
                Object object = matched.value;
                if (this.myListModel.contains(object)) {
                    return true;
                }
                if (!actions && SearchEverywhereAction.isSetting(object)) {
                    if (matcher.matches(SearchEverywhereAction.getSettingText((OptionDescription)object))) {
                        result2.add(object);
                    }
                } else if (actions && !SearchEverywhereAction.isToolWindowAction(object) && SearchEverywhereAction.isActionValue(object)) {
                    AnAction action2 = object instanceof AnAction ? (AnAction)object : ((GotoActionModel.ActionWrapper)object).getAction();
                    CalcThread lock = SearchEverywhereAction.this.myCalcThread;
                    if (lock != null) {
                        CalcThread calcThread = lock;
                        synchronized (calcThread) {
                            if (this.isEnabled(action2)) {
                                result2.add(object);
                            }
                        }
                    }
                }
                return result2.size() <= max;
            }));
            return result2;
        }

        private synchronized void buildActionsAndSettings(@NotNull String pattern) {
            if (pattern == null) {
                CalcThread.$$$reportNull$$$0(2);
            }
            SearchResult actions = this.getActionsOrSettings(pattern, 5, true);
            SearchResult settings = this.getActionsOrSettings(pattern, 5, false);
            this.check();
            SwingUtilities.invokeLater(() -> {
                if (this.isCanceled()) {
                    return;
                }
                if (!actions.isEmpty()) {
                    this.myListModel.titleIndex.actions = this.myListModel.size();
                    for (Object action2 : actions) {
                        this.myListModel.addElement(action2);
                    }
                }
                int n = this.myListModel.moreIndex.actions = actions.size() >= 5 ? this.myListModel.size() - 1 : -1;
                if (!settings.isEmpty()) {
                    this.myListModel.titleIndex.settings = this.myListModel.size();
                    for (Object setting : settings) {
                        this.myListModel.addElement(setting);
                    }
                }
                this.myListModel.moreIndex.settings = settings.size() >= 5 ? this.myListModel.size() - 1 : -1;
            });
        }

        private synchronized void buildFiles(String pattern) {
            SearchResult files2 = this.getFiles(pattern, Holder.showAll.get(), 6, SearchEverywhereAction.this.myFileChooseByName);
            this.check();
            if (!files2.isEmpty()) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.files = this.myListModel.size();
                    for (Object file2 : files2) {
                        this.myListModel.addElement(file2);
                    }
                    this.myListModel.moreIndex.files = files2.needMore ? this.myListModel.size() - 1 : -1;
                });
            }
        }

        private synchronized void buildStructure(String pattern) {
            if (!Registry.is((String)"search.everywhere.structure") || SearchEverywhereAction.this.myStructureModel == null) {
                return;
            }
            ArrayList elements2 = new ArrayList();
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern)).build();
            this.fillStructure(SearchEverywhereAction.this.myStructureModel.getRoot(), elements2, (Matcher)matcher);
            if (!elements2.isEmpty()) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.structure = this.myListModel.size();
                    for (Object element2 : elements2) {
                        this.myListModel.addElement(element2);
                    }
                    this.myListModel.moreIndex.files = -1;
                });
            }
        }

        private void fillStructure(StructureViewTreeElement element2, List<? super StructureViewTreeElement> elements2, Matcher matcher) {
            TreeElement[] children2 = element2.getChildren();
            this.check();
            for (TreeElement child2 : children2) {
                this.check();
                if (!(child2 instanceof StructureViewTreeElement)) continue;
                String text2 = child2.getPresentation().getPresentableText();
                if (text2 != null && matcher.matches(text2)) {
                    elements2.add((StructureViewTreeElement)((StructureViewTreeElement)child2));
                }
                this.fillStructure((StructureViewTreeElement)child2, elements2, matcher);
            }
        }

        private synchronized void buildSymbols(String pattern) {
            SearchResult symbols = this.getSymbols(pattern, 6, Holder.showAll.get(), SearchEverywhereAction.this.mySymbolsChooseByName);
            this.check();
            if (!symbols.isEmpty()) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.symbols = this.myListModel.size();
                    for (Object file2 : symbols) {
                        this.myListModel.addElement(file2);
                    }
                    this.myListModel.moreIndex.symbols = symbols.needMore ? this.myListModel.size() - 1 : -1;
                });
            }
        }

        @Nullable
        private ChooseRunConfigurationPopup.ItemWrapper getRunConfigurationByName(String name) {
            List<ChooseRunConfigurationPopup.ItemWrapper> wrappers = ChooseRunConfigurationPopup.createFlatSettingsList(this.project);
            for (ChooseRunConfigurationPopup.ItemWrapper wrapper2 : wrappers) {
                if (!wrapper2.getText().equals(name)) continue;
                return wrapper2;
            }
            return null;
        }

        private synchronized void buildRunConfigurations(String pattern) {
            SearchResult runConfigurations = this.getConfigurations(pattern, 6);
            if (!runConfigurations.isEmpty()) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.runConfigurations = this.myListModel.size();
                    for (Object runConfiguration : runConfigurations) {
                        this.myListModel.addElement(runConfiguration);
                    }
                    this.myListModel.moreIndex.runConfigurations = runConfigurations.needMore ? this.myListModel.getSize() - 1 : -1;
                });
            }
        }

        private SearchResult getConfigurations(String pattern, int max) {
            SearchResult configurations = new SearchResult();
            if (!Registry.is((String)"search.everywhere.configurations")) {
                return configurations;
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)pattern).build();
            List<ChooseRunConfigurationPopup.ItemWrapper> wrappers = ChooseRunConfigurationPopup.createFlatSettingsList(this.project);
            this.check();
            for (ChooseRunConfigurationPopup.ItemWrapper wrapper2 : wrappers) {
                if (matcher.matches(wrapper2.getText()) && !this.myListModel.contains(wrapper2)) {
                    if (configurations.size() == max) {
                        configurations.needMore = true;
                        break;
                    }
                    configurations.add(wrapper2);
                }
                this.check();
            }
            return configurations;
        }

        private synchronized void buildClasses(String pattern) {
            SearchResult classes = this.getClasses(pattern, Holder.showAll.get(), 6, SearchEverywhereAction.this.myClassChooseByName);
            this.check();
            if (!classes.isEmpty()) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.classes = this.myListModel.size();
                    for (Object file2 : classes) {
                        this.myListModel.addElement(file2);
                    }
                    this.myListModel.moreIndex.classes = -1;
                    if (classes.needMore) {
                        this.myListModel.moreIndex.classes = this.myListModel.size() - 1;
                    }
                });
            }
        }

        @NotNull
        private GlobalSearchScope getProjectScope(@NotNull Project project) {
            GlobalSearchScope scope;
            if (project == null) {
                CalcThread.$$$reportNull$$$0(3);
            }
            if ((scope = SearchEverywhereClassifier.EP_Manager.getProjectScope(project)) != null) {
                GlobalSearchScope globalSearchScope = scope;
                if (globalSearchScope == null) {
                    CalcThread.$$$reportNull$$$0(4);
                }
                return globalSearchScope;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            if (globalSearchScope == null) {
                CalcThread.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }

        private SearchResult getSymbols(String pattern, int max, boolean includeLibs, ChooseByNamePopup chooseByNamePopup) {
            SearchResult symbols = new SearchResult();
            if (!Registry.is((String)"search.everywhere.symbols") || SearchEverywhereAction.shouldSkipPattern(pattern)) {
                return symbols;
            }
            GlobalSearchScope scope = this.getProjectScope(this.project);
            if (chooseByNamePopup == null) {
                return symbols;
            }
            ChooseByNameItemProvider provider = chooseByNamePopup.getProvider();
            provider.filterElements(chooseByNamePopup, pattern, includeLibs, this.myProgressIndicator, (Processor<Object>)((Processor)o -> {
                if (SearchEverywhereClassifier.EP_Manager.isSymbol(o) && !this.myListModel.contains(o) && !symbols.contains(o)) {
                    boolean isSpecialElement;
                    PsiElement element2 = null;
                    if (o instanceof PsiElement) {
                        element2 = (PsiElement)o;
                    } else if (o instanceof PsiElementNavigationItem) {
                        element2 = ((PsiElementNavigationItem)o).getTargetElement();
                    }
                    VirtualFile virtualFile = SearchEverywhereClassifier.EP_Manager.getVirtualFile(o);
                    boolean isElementWithoutFile = element2 != null && element2.getContainingFile() == null;
                    boolean isFileInScope = virtualFile != null && (includeLibs || scope.accept(virtualFile));
                    boolean bl = isSpecialElement = element2 == null && virtualFile == null;
                    if (isElementWithoutFile || isFileInScope || isSpecialElement) {
                        symbols.add(o);
                    }
                }
                symbols.needMore = symbols.size() == max;
                return !symbols.needMore;
            }));
            if (!includeLibs && symbols.isEmpty()) {
                return this.getSymbols(pattern, max, true, chooseByNamePopup);
            }
            return symbols;
        }

        private SearchResult getClasses(String pattern, boolean includeLibs, int max, ChooseByNamePopup chooseByNamePopup) {
            SearchResult classes = new SearchResult();
            if (chooseByNamePopup == null || SearchEverywhereAction.shouldSkipPattern(pattern)) {
                return classes;
            }
            chooseByNamePopup.getProvider().filterElements(chooseByNamePopup, pattern, includeLibs, this.myProgressIndicator, (Processor<Object>)((Processor)o -> {
                if (SearchEverywhereClassifier.EP_Manager.isClass(o) && !this.myListModel.contains(o) && !classes.contains(o)) {
                    if (classes.size() == max) {
                        classes.needMore = true;
                        return false;
                    }
                    PsiElement element2 = null;
                    if (o instanceof PsiElement) {
                        element2 = (PsiElement)o;
                    } else if (o instanceof PsiElementNavigationItem) {
                        element2 = ((PsiElementNavigationItem)o).getTargetElement();
                    }
                    classes.add(o);
                    if (element2 instanceof PsiNamedElement) {
                        String name = ((PsiNamedElement)element2).getName();
                        VirtualFile virtualFile = SearchEverywhereClassifier.EP_Manager.getVirtualFile(o);
                        if (virtualFile != null && StringUtil.equals((CharSequence)name, (CharSequence)virtualFile.getNameWithoutExtension())) {
                            this.myAlreadyAddedFiles.add(virtualFile);
                        }
                    }
                }
                return true;
            }));
            if (!includeLibs && classes.isEmpty()) {
                return this.getClasses(pattern, true, max, chooseByNamePopup);
            }
            return classes;
        }

        private SearchResult getFiles(String pattern, boolean includeLibs, int max, ChooseByNamePopup chooseByNamePopup) {
            SearchResult files2 = new SearchResult();
            if (chooseByNamePopup == null || !Registry.is((String)"search.everywhere.files")) {
                return files2;
            }
            GlobalSearchScope scope = this.getProjectScope(this.project);
            chooseByNamePopup.getProvider().filterElements(chooseByNamePopup, pattern, true, this.myProgressIndicator, (Processor<Object>)((Processor)o -> {
                VirtualFile file2 = null;
                if (o instanceof VirtualFile) {
                    file2 = (VirtualFile)o;
                } else if (o instanceof PsiFile) {
                    file2 = ((PsiFile)o).getVirtualFile();
                } else if (o instanceof PsiDirectory) {
                    file2 = ((PsiDirectory)o).getVirtualFile();
                }
                if (!(file2 == null || pattern.indexOf(32) != -1 && file2.getName().indexOf(32) == -1 || !includeLibs && (!scope.accept(file2) || this.myListModel.contains(file2) || this.myAlreadyAddedFiles.contains(file2)) || files2.contains(file2))) {
                    if (files2.size() == max) {
                        files2.needMore = true;
                        return false;
                    }
                    files2.add(file2);
                }
                return true;
            }));
            if (!includeLibs && files2.isEmpty()) {
                return this.getFiles(pattern, true, max, chooseByNamePopup);
            }
            return files2;
        }

        private synchronized void buildRecentFiles(String pattern) {
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern)).build();
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            List<VirtualFile> selected2 = Arrays.asList(FileEditorManager.getInstance((Project)this.project).getSelectedFiles());
            for (VirtualFile file2 : ContainerUtil.reverse(EditorHistoryManager.getInstance(this.project).getFileList())) {
                if ((StringUtil.isEmptyOrSpaces((String)pattern) || matcher.matches(file2.getName())) && !files2.contains(file2) && !selected2.contains(file2)) {
                    files2.add(file2);
                }
                if (files2.size() <= 10) continue;
                break;
            }
            if (!files2.isEmpty()) {
                this.myAlreadyAddedFiles.addAll(files2);
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.recentFiles = this.myListModel.size();
                    for (Object file2 : files2) {
                        this.myListModel.addElement(file2);
                    }
                    this.updatePopup();
                });
            }
        }

        private boolean isCanceled() {
            return this.myProgressIndicator.isCanceled() || this.myDone.isRejected();
        }

        private synchronized void buildTopHit(@NotNull String pattern) {
            HistoryType type;
            if (pattern == null) {
                CalcThread.$$$reportNull$$$0(6);
            }
            ArrayList<Object> elements2 = new ArrayList<Object>();
            HistoryItem history = SearchEverywhereAction.this.myHistoryItem;
            if (history != null && (type = SearchEverywhereAction.parseHistoryType(history.type)) != null) {
                switch (type) {
                    case PSI: {
                        if (DumbService.isDumb((Project)this.project)) break;
                        ApplicationManager.getApplication().runReadAction(() -> {
                            int i = history.fqn.indexOf("://");
                            if (i != -1) {
                                PsiElement psi;
                                String langId = history.fqn.substring(0, i);
                                Language language = Language.findLanguageByID((String)langId);
                                String psiFqn = history.fqn.substring(i + 3);
                                if (language != null && (psi = ((PsiElementExternalizer)LanguagePsiElementExternalizer.INSTANCE.forLanguage(language)).findByQualifiedName(this.project, psiFqn)) != null) {
                                    VirtualFile file2;
                                    elements2.add(psi);
                                    PsiFile psiFile = psi.getContainingFile();
                                    if (psiFile != null && (file2 = psiFile.getVirtualFile()) != null) {
                                        this.myAlreadyAddedFiles.add(file2);
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case FILE: {
                        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(history.fqn);
                        if (file2 == null) break;
                        elements2.add(file2);
                        break;
                    }
                    case SETTING: {
                        break;
                    }
                    case ACTION: {
                        AnAction action2 = ActionManager.getInstance().getAction(history.fqn);
                        if (action2 == null) break;
                        elements2.add(action2);
                        this.myAlreadyAddedActions.add(action2);
                        break;
                    }
                    case RUN_CONFIGURATION: {
                        if (DumbService.isDumb((Project)this.project)) break;
                        ApplicationManager.getApplication().runReadAction(() -> {
                            ChooseRunConfigurationPopup.ItemWrapper runConfiguration = this.getRunConfigurationByName(history.fqn);
                            if (runConfiguration != null) {
                                elements2.add(runConfiguration);
                            }
                        });
                    }
                }
            }
            Consumer<Object> consumer = o -> {
                if (SearchEverywhereAction.isSetting(o) || SearchEverywhereAction.isVirtualFile(o) || SearchEverywhereAction.isActionValue(o) || o instanceof PsiElement || o instanceof OptionsTopHitProvider) {
                    if (o instanceof AnAction && this.myAlreadyAddedActions.contains(o)) {
                        return;
                    }
                    elements2.add(o);
                }
            };
            if (pattern.startsWith(SearchTopHitProvider.getTopHitAccelerator()) && !pattern.contains(" ")) {
                String id2 = pattern.substring(1);
                HashSet<String> ids = new HashSet<String>();
                for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
                    String providerId;
                    this.check();
                    if (!(provider instanceof OptionsTopHitProvider) || ids.contains(providerId = ((OptionsTopHitProvider)provider).getId()) || !StringUtil.startsWithIgnoreCase((String)providerId, (String)id2)) continue;
                    consumer.accept(provider);
                    ids.add(providerId);
                }
            } else {
                ActionManager actionManager = ActionManager.getInstance();
                List actions = AbbreviationManager.getInstance().findActions(pattern);
                for (String actionId : actions) {
                    consumer.accept(actionManager.getAction(actionId));
                }
                for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
                    this.check();
                    provider.consumeTopHits(pattern, consumer, this.project);
                }
            }
            if (!elements2.isEmpty()) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    for (Object element2 : new ArrayList(elements2)) {
                        if (!(element2 instanceof AnAction)) continue;
                        if (!this.isEnabled((AnAction)element2)) {
                            elements2.remove(element2);
                        }
                        if (!this.isCanceled()) continue;
                        return;
                    }
                    if (this.isCanceled() || elements2.isEmpty()) {
                        return;
                    }
                    this.myListModel.titleIndex.topHit = this.myListModel.size();
                    for (Object element2 : ContainerUtil.getFirstItems((List)elements2, (int)15)) {
                        this.myListModel.addElement(element2);
                    }
                });
            }
        }

        protected boolean isEnabled(AnAction action2) {
            boolean enabled;
            AnActionEvent event = SearchEverywhereAction.this.myActionEvent;
            if (SearchEverywhereAction.this.myDisabledActions.contains(action2) || event == null) {
                return false;
            }
            AtomicReference presentationReference = new AtomicReference();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                AnActionEvent e = new AnActionEvent(event.getInputEvent(), DataManager.getInstance().getDataContext(SearchEverywhereAction.this.myContextComponent), event.getPlace(), action2.getTemplatePresentation().clone(), event.getActionManager(), event.getModifiers());
                ActionUtil.performDumbAwareUpdate((AnAction)action2, (AnActionEvent)e, (boolean)false);
                presentationReference.set(e.getPresentation());
            }, ModalityState.NON_MODAL);
            Presentation presentation = (Presentation)presentationReference.get();
            boolean bl = enabled = presentation.isEnabled() && presentation.isVisible() && !StringUtil.isEmpty((String)presentation.getText());
            if (!enabled) {
                SearchEverywhereAction.this.myDisabledActions.add(action2);
            }
            return enabled;
        }

        private synchronized void checkModelsUpToDate() {
            if (SearchEverywhereAction.this.myClassModel == null) {
                SearchEverywhereAction.this.myClassModel = new GotoClassModel2(this.project);
                SearchEverywhereAction.this.myFileModel = new GotoFileModel(this.project){

                    @Override
                    public boolean isSlashlessMatchingEnabled() {
                        return false;
                    }
                };
                SearchEverywhereAction.this.mySymbolsModel = new GotoSymbolModel2(this.project);
                SearchEverywhereAction.this.myFileChooseByName = ChooseByNamePopup.createPopup(this.project, (ChooseByNameModel)SearchEverywhereAction.this.myFileModel, (PsiElement)null);
                SearchEverywhereAction.this.myClassChooseByName = ChooseByNamePopup.createPopup(this.project, (ChooseByNameModel)SearchEverywhereAction.this.myClassModel, (PsiElement)null);
                SearchEverywhereAction.this.mySymbolsChooseByName = ChooseByNamePopup.createPopup(this.project, (ChooseByNameModel)SearchEverywhereAction.this.mySymbolsModel, (PsiElement)null);
                this.project.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, null);
                SearchEverywhereAction.this.myActionProvider = this.createActionProvider();
                SearchEverywhereAction.this.myConfigurables.clear();
                SearchEverywhereAction.this.fillConfigurablesIds(null, ShowSettingsUtilImpl.getConfigurables(this.project, true));
            }
            if (SearchEverywhereAction.this.myStructureModel == null && SearchEverywhereAction.this.myFileEditor != null && Registry.is((String)"search.everywhere.structure")) {
                this.runReadAction(() -> {
                    StructureViewBuilder structureViewBuilder = SearchEverywhereAction.this.myFileEditor.getStructureViewBuilder();
                    if (structureViewBuilder == null) {
                        return;
                    }
                    StructureView structureView = structureViewBuilder.createStructureView(SearchEverywhereAction.this.myFileEditor, this.project);
                    SearchEverywhereAction.this.myStructureModel = structureView.getTreeModel();
                }, true);
            }
        }

        private void buildModelFromRecentFiles() {
            this.buildRecentFiles("");
        }

        private GotoActionItemProvider createActionProvider() {
            GotoActionModel model = new GotoActionModel(this.project, SearchEverywhereAction.this.myFocusComponent, SearchEverywhereAction.this.myEditor){

                @Override
                protected GotoActionModel.MatchMode actionMatches(@NotNull String pattern, Matcher matcher, @NotNull AnAction anAction) {
                    GotoActionModel.MatchMode mode;
                    if (pattern == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (anAction == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return (mode = super.actionMatches(pattern, matcher, anAction)) == GotoActionModel.MatchMode.NAME ? mode : GotoActionModel.MatchMode.NONE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "pattern";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "anAction";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/actions/SearchEverywhereAction$CalcThread$2";
                    objectArray[2] = "actionMatches";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            return new GotoActionItemProvider(model);
        }

        private void updatePopup() {
            this.check();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CalcThread.this.myListModel.update();
                    SearchEverywhereAction.this.myList.revalidate();
                    SearchEverywhereAction.this.myList.repaint();
                    SearchEverywhereAction.this.myRenderer.recalculateWidth();
                    if (SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed()) {
                        return;
                    }
                    if (SearchEverywhereAction.this.myPopup == null || !SearchEverywhereAction.this.myPopup.isVisible()) {
                        ScrollingUtil.installActions((JList)SearchEverywhereAction.this.myList, (JComponent)SearchEverywhereAction.this.getField().getTextEditor());
                        JBScrollPane content2 = new JBScrollPane((Component)SearchEverywhereAction.this.myList){
                            {
                                if (StartupUiUtil.isUnderDarcula()) {
                                    this.setBorder(null);
                                }
                            }

                            public Dimension getPreferredSize() {
                                Dimension size = super.getPreferredSize();
                                Dimension listSize = SearchEverywhereAction.this.myList.getPreferredSize();
                                if (size.height > listSize.height || SearchEverywhereAction.this.myList.getModel().getSize() == 0) {
                                    size.height = Math.max(JBUIScale.scale((int)30), listSize.height);
                                }
                                if (SearchEverywhereAction.this.myBalloon != null && size.width < ((SearchEverywhereAction)SearchEverywhereAction.this).myBalloon.getSize().width) {
                                    size.width = ((SearchEverywhereAction)SearchEverywhereAction.this).myBalloon.getSize().width;
                                }
                                return size;
                            }
                        };
                        content2.setHorizontalScrollBarPolicy(31);
                        content2.setMinimumSize(new Dimension(((SearchEverywhereAction)SearchEverywhereAction.this).myBalloon.getSize().width, 30));
                        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content2, null);
                        SearchEverywhereAction.this.myPopup = builder2.setRequestFocus(false).setCancelKeyEnabled(false).setResizable(true).setCancelCallback(() -> {
                            boolean canClose;
                            JBPopup balloon = SearchEverywhereAction.this.myBalloon;
                            AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
                            if (event instanceof MouseEvent) {
                                Component comp = ((MouseEvent)event).getComponent();
                                if (balloon != null && !balloon.isDisposed() && ComponentUtil.getWindow((Component)comp) == ComponentUtil.getWindow((Component)balloon.getContent())) {
                                    return false;
                                }
                            }
                            boolean bl = canClose = balloon == null || balloon.isDisposed() || !SearchEverywhereAction.this.getField().getTextEditor().hasFocus() && !SearchEverywhereAction.this.mySkipFocusGain;
                            if (canClose) {
                                PropertiesComponent.getInstance().setValue("search.everywhere.max.popup.width", Math.max(content2.getWidth(), JBUIScale.scale((int)600)), JBUIScale.scale((int)600));
                            }
                            return canClose;
                        }).setShowShadow(false).setShowBorder(false).createPopup();
                        CalcThread.this.project.putUserData(SEARCH_EVERYWHERE_POPUP, (Object)SearchEverywhereAction.this.myPopup);
                        SearchEverywhereAction.this.myPopup.getContent().setBorder(null);
                        Disposer.register((Disposable)SearchEverywhereAction.this.myPopup, () -> {
                            CalcThread.this.project.putUserData(SEARCH_EVERYWHERE_POPUP, null);
                            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                                JLabel label2;
                                Component component2;
                                SearchEverywhereAction.this.resetFields();
                                SearchEverywhereAction.this.myNonProjectCheckBox.setSelected(false);
                                SwingUtilities.invokeLater(ActionToolbarImpl::updateAllToolbarsImmediately);
                                if (SearchEverywhereAction.this.myActionEvent != null && SearchEverywhereAction.this.myActionEvent.getInputEvent() instanceof MouseEvent && (component2 = SearchEverywhereAction.this.myActionEvent.getInputEvent().getComponent()) != null && (label2 = (JLabel)ComponentUtil.getParentOfType(JLabel.class, (Component)component2)) != null) {
                                    SwingUtilities.invokeLater(() -> label2.setIcon(AllIcons.Actions.Find));
                                }
                                SearchEverywhereAction.this.myActionEvent = null;
                            });
                        });
                        SearchEverywhereAction.this.updatePopupBounds();
                        SearchEverywhereAction.this.myPopup.show(new RelativePoint((Component)SearchEverywhereAction.this.getField().getParent(), new Point(0, SearchEverywhereAction.this.getField().getParent().getHeight())));
                        ApplicationManager.getApplication().getMessageBus().connect((Disposable)SearchEverywhereAction.this.myPopup).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

                            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                                if (action2 == null) {
                                    CalcThread.2.$$$reportNull$$$0(0);
                                }
                                if (dataContext == null) {
                                    CalcThread.2.$$$reportNull$$$0(1);
                                }
                                if (event == null) {
                                    CalcThread.2.$$$reportNull$$$0(2);
                                }
                                if (action2 instanceof TextComponentEditorAction) {
                                    return;
                                }
                                if (SearchEverywhereAction.this.myPopup != null) {
                                    SearchEverywhereAction.this.myPopup.cancel();
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "action";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "dataContext";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "event";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/ide/actions/SearchEverywhereAction$CalcThread$3$2";
                                objectArray[2] = "beforeActionPerformed";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                    } else {
                        SearchEverywhereAction.this.myList.revalidate();
                        SearchEverywhereAction.this.myList.repaint();
                    }
                    ScrollingUtil.ensureSelectionExists((JList)SearchEverywhereAction.this.myList);
                    if (SearchEverywhereAction.this.myList.getModel().getSize() > 0) {
                        SearchEverywhereAction.this.updatePopupBounds();
                    }
                }
            });
        }

        public ActionCallback cancel() {
            this.myProgressIndicator.cancel();
            return this.myDone;
        }

        public ActionCallback insert(int index, WidgetID id2) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.runReadAction(() -> {
                        SearchResult result2 = id2 == WidgetID.CLASSES ? this.getClasses(this.pattern, Holder.showAll.get(), 15, SearchEverywhereAction.this.myClassChooseByName) : (id2 == WidgetID.FILES ? this.getFiles(this.pattern, Holder.showAll.get(), 15, SearchEverywhereAction.this.myFileChooseByName) : (id2 == WidgetID.RUN_CONFIGURATIONS ? this.getConfigurations(this.pattern, 15) : (id2 == WidgetID.SYMBOLS ? this.getSymbols(this.pattern, 15, Holder.showAll.get(), SearchEverywhereAction.this.mySymbolsChooseByName) : (id2 == WidgetID.ACTIONS ? this.getActionsOrSettings(this.pattern, 15, true) : (id2 == WidgetID.SETTINGS ? this.getActionsOrSettings(this.pattern, 15, false) : new SearchResult())))));
                        this.check();
                        SwingUtilities.invokeLater(() -> {
                            try {
                                int shift = 0;
                                int i = index + 1;
                                for (Object o : result2) {
                                    this.myListModel.insertElementAt(o, i);
                                    ++shift;
                                    ++i;
                                }
                                MoreIndex moreIndex = this.myListModel.moreIndex;
                                this.myListModel.titleIndex.shift(index, shift);
                                moreIndex.shift(index, shift);
                                if (!result2.needMore) {
                                    switch (id2) {
                                        case CLASSES: {
                                            moreIndex.classes = -1;
                                            break;
                                        }
                                        case FILES: {
                                            moreIndex.files = -1;
                                            break;
                                        }
                                        case ACTIONS: {
                                            moreIndex.actions = -1;
                                            break;
                                        }
                                        case SETTINGS: {
                                            moreIndex.settings = -1;
                                            break;
                                        }
                                        case SYMBOLS: {
                                            moreIndex.symbols = -1;
                                            break;
                                        }
                                        case RUN_CONFIGURATIONS: {
                                            moreIndex.runConfigurations = -1;
                                        }
                                    }
                                }
                                ScrollingUtil.selectItem((JList)SearchEverywhereAction.this.myList, (int)index);
                                this.myDone.setDone();
                            }
                            catch (Exception e) {
                                this.myDone.setRejected();
                            }
                        });
                    }, true);
                }
                catch (Exception e) {
                    this.myDone.setRejected();
                }
            });
            return this.myDone;
        }

        public ActionCallback start() {
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
            return this.myDone;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/SearchEverywhereAction$CalcThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/SearchEverywhereAction$CalcThread";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionsOrSettings";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildActionsAndSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getProjectScope";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTopHit";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum WidgetID {
        CLASSES,
        FILES,
        ACTIONS,
        SETTINGS,
        SYMBOLS,
        RUN_CONFIGURATIONS;

    }

    private class MyListRenderer
    extends ColoredListCellRenderer<Object> {
        ColoredListCellRenderer myLocation;
        SearchEverywherePsiRenderer myFileRenderer;
        ListCellRenderer myActionsRenderer;
        private String myLocationString;
        private Icon myLocationIcon;
        private Project myProject;
        private final MyAccessibleComponent myMainPanel;
        private final JLabel myTitle;

        MyListRenderer(JBList myList) {
            if (myList == null) {
                MyListRenderer.$$$reportNull$$$0(0);
            }
            this.myLocation = new ColoredListCellRenderer(){

                protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.setPaintFocusBorder(false);
                    this.append(MyListRenderer.this.myLocationString, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.setIcon(MyListRenderer.this.myLocationIcon);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/SearchEverywhereAction$MyListRenderer$1", "customizeCellRenderer"));
                }
            };
            this.myFileRenderer = new SearchEverywherePsiRenderer();
            this.myActionsRenderer = new GotoActionModel.GotoActionListCellRenderer((Function<? super OptionDescription, String>)Functions.TO_STRING());
            this.myMainPanel = new MyAccessibleComponent(new BorderLayout());
            this.myTitle = new JLabel();
            assert (myList == SearchEverywhereAction.this.myList);
        }

        public void clear() {
            super.clear();
            this.myLocation.clear();
            this.myLocationString = null;
            this.myLocationIcon = null;
        }

        public void setLocationString(String locationString) {
            this.myLocationString = locationString;
        }

        public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            int width;
            Color bg;
            Component cmp;
            this.myLocationString = null;
            String pattern = "*" + SearchEverywhereAction.this.myPopupField.getText();
            Matcher matcher = NameUtil.buildMatcher((String)pattern, (int)0, (boolean)true, (boolean)true);
            Component component2 = cmp = SearchEverywhereAction.this.isMoreItem(index) ? More.get(isSelected) : SearchEverywhereClassifier.EP_Manager.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
            if (cmp == null) {
                cmp = this.tryFileRenderer(matcher, list2, value2, index, isSelected);
            }
            if (cmp == null) {
                if (value2 instanceof GotoActionModel.ActionWrapper) {
                    cmp = this.myActionsRenderer.getListCellRendererComponent(list2, new GotoActionModel.MatchedValue(value2, pattern), index, isSelected, isSelected);
                    if (cmp instanceof JComponent) {
                        ((JComponent)cmp).setBorder(null);
                    }
                } else {
                    cmp = super.getListCellRendererComponent(list2, value2, index, isSelected, isSelected);
                    JPanel p = new JPanel(new BorderLayout());
                    p.setBackground(UIUtil.getListBackground((boolean)isSelected));
                    p.add(cmp, "Center");
                    cmp = p;
                }
            }
            if (this.myLocationString != null || value2 instanceof BooleanOptionDescription) {
                Component rightComponent;
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setBackground(UIUtil.getListBackground((boolean)isSelected));
                panel2.add(cmp, "Center");
                if (value2 instanceof BooleanOptionDescription) {
                    OnOffButton button2 = new OnOffButton();
                    button2.setSelected(((BooleanOptionDescription)value2).isOptionEnabled());
                    rightComponent = button2;
                } else {
                    rightComponent = this.myLocation.getListCellRendererComponent(list2, value2, index, isSelected, isSelected);
                }
                panel2.add(rightComponent, "East");
                cmp = panel2;
            }
            if ((bg = cmp.getBackground()) == null) {
                cmp.setBackground(UIUtil.getListBackground((boolean)isSelected));
                bg = cmp.getBackground();
            }
            String title = ((SearchEverywhereAction)SearchEverywhereAction.this).getModel().titleIndex.getTitle(index);
            this.myMainPanel.removeAll();
            if (title != null) {
                this.myTitle.setText(title);
                this.myMainPanel.add((Component)SearchEverywhereAction.createTitle(" " + title), "North");
            }
            JPanel wrapped = new JPanel(new BorderLayout());
            wrapped.setBackground(bg);
            wrapped.setBorder(Holder.RENDERER_BORDER);
            wrapped.add(cmp, "Center");
            this.myMainPanel.add((Component)wrapped, "Center");
            if (cmp instanceof Accessible) {
                this.myMainPanel.setAccessible((Accessible)((Object)cmp));
            }
            if ((width = this.myMainPanel.getPreferredSize().width) > SearchEverywhereAction.this.myPopupActualWidth) {
                SearchEverywhereAction.this.myPopupActualWidth = width;
            }
            return this.myMainPanel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Component tryFileRenderer(Matcher matcher, JList list2, Object value2, int index, boolean isSelected) {
            if (this.myProject != null && value2 instanceof VirtualFile) {
                value2 = PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)((VirtualFile)value2));
            }
            if (value2 instanceof PsiElement) {
                MatcherHolder.associateMatcher(list2, matcher);
                try {
                    Component component2 = this.myFileRenderer.getListCellRendererComponent(list2, value2, index, isSelected, isSelected);
                    return component2;
                }
                finally {
                    MatcherHolder.associateMatcher(list2, null);
                }
            }
            return null;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyListRenderer.$$$reportNull$$$0(1);
            }
            this.setPaintFocusBorder(false);
            this.setIcon(EmptyIcon.ICON_16);
            ApplicationManager.getApplication().runReadAction(() -> {
                if (value2 instanceof PsiElement) {
                    String name1 = SearchEverywhereAction.this.myClassModel.getElementName(value2);
                    assert (name1 != null);
                    this.append(name1);
                } else if (value2 instanceof ChooseRunConfigurationPopup.ItemWrapper) {
                    Executor executor;
                    ChooseRunConfigurationPopup.ItemWrapper wrapper2 = (ChooseRunConfigurationPopup.ItemWrapper)value2;
                    this.append(wrapper2.getText());
                    this.setIcon(wrapper2.getIcon());
                    RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)ObjectUtils.tryCast(wrapper2.getValue(), RunnerAndConfigurationSettings.class);
                    if (settings != null && (executor = SearchEverywhereAction.findExecutor(settings)) != null) {
                        this.setLocationString(executor.getId());
                        this.myLocationIcon = executor.getToolWindowIcon();
                    }
                } else if (SearchEverywhereAction.isVirtualFile(value2)) {
                    VirtualFile file2 = (VirtualFile)value2;
                    if (file2 instanceof VirtualFilePathWrapper) {
                        this.append(((VirtualFilePathWrapper)file2).getPresentablePath());
                    } else {
                        this.append(file2.getName());
                    }
                    this.setIcon(IconUtil.getIcon((VirtualFile)file2, (int)2, (Project)this.myProject));
                } else if (SearchEverywhereAction.isActionValue(value2)) {
                    String groupName;
                    GotoActionModel.ActionWrapper actionWithParentGroup = value2 instanceof GotoActionModel.ActionWrapper ? (GotoActionModel.ActionWrapper)value2 : null;
                    AnAction anAction = actionWithParentGroup == null ? (AnAction)value2 : actionWithParentGroup.getAction();
                    Presentation templatePresentation = anAction.getTemplatePresentation();
                    Icon icon2 = templatePresentation.getIcon();
                    if (anAction instanceof ActivateToolWindowAction) {
                        String id2 = ((ActivateToolWindowAction)anAction).getToolWindowId();
                        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(id2);
                        if (toolWindow != null) {
                            icon2 = toolWindow.getIcon();
                        }
                    }
                    this.append(String.valueOf(templatePresentation.getText()));
                    if (actionWithParentGroup != null && !StringUtil.isEmpty((String)(groupName = actionWithParentGroup.getGroupName()))) {
                        this.setLocationString(groupName);
                    }
                    String string = groupName = actionWithParentGroup == null ? null : actionWithParentGroup.getGroupName();
                    if (!StringUtil.isEmpty((String)groupName)) {
                        this.setLocationString(groupName);
                    }
                    if (icon2 != null && icon2.getIconWidth() <= 16 && icon2.getIconHeight() <= 16) {
                        this.setIcon(IconUtil.toSize((Icon)icon2, (int)16, (int)16));
                    }
                } else if (SearchEverywhereAction.isSetting(value2)) {
                    String text2 = SearchEverywhereAction.getSettingText((OptionDescription)value2);
                    SimpleTextAttributes attrs = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    if (value2 instanceof Changeable && ((Changeable)value2).hasChanged()) {
                        if (selected2) {
                            attrs = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                        } else {
                            SimpleTextAttributes base = SimpleTextAttributes.LINK_BOLD_ATTRIBUTES;
                            attrs = base.derive(1, base.getFgColor(), null, null);
                        }
                    }
                    this.append(text2, attrs);
                    String id3 = ((OptionDescription)value2).getConfigurableId();
                    String location2 = (String)SearchEverywhereAction.this.myConfigurables.get(id3);
                    if (location2 == null) {
                        location2 = ((OptionDescription)value2).getValue();
                    }
                    if (location2 != null) {
                        this.setLocationString(location2);
                    }
                } else if (value2 instanceof OptionsTopHitProvider) {
                    this.append(SearchTopHitProvider.getTopHitAccelerator() + ((OptionsTopHitProvider)value2).getId());
                } else {
                    ItemPresentation presentation = null;
                    if (value2 instanceof ItemPresentation) {
                        presentation = (ItemPresentation)value2;
                    } else if (value2 instanceof NavigationItem) {
                        presentation = ((NavigationItem)value2).getPresentation();
                    }
                    if (presentation != null) {
                        Icon icon3;
                        String text3 = presentation.getPresentableText();
                        this.append(text3 == null ? value2.toString() : text3);
                        String location3 = presentation.getLocationString();
                        if (!StringUtil.isEmpty((String)location3)) {
                            this.setLocationString(location3);
                        }
                        if ((icon3 = presentation.getIcon(false)) != null) {
                            this.setIcon(icon3);
                        }
                    }
                }
            });
        }

        void recalculateWidth() {
            ListModel model = SearchEverywhereAction.this.myList.getModel();
            this.myTitle.setIcon(EmptyIcon.ICON_16);
            this.myTitle.setFont(SearchEverywhereAction.getTitleFont());
            for (int index = 0; index < model.getSize(); ++index) {
                String title = ((SearchEverywhereAction)SearchEverywhereAction.this).getModel().titleIndex.getTitle(index);
                if (title == null) continue;
                this.myTitle.setText(title);
            }
            this.myTitle.setForeground((Color)Gray._122);
            this.myTitle.setAlignmentY(1.0f);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/SearchEverywhereAction$MyListRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyAccessibleComponent
        extends JPanel {
            private Accessible myAccessible;

            MyAccessibleComponent(LayoutManager layout) {
                super(layout);
                this.setOpaque(false);
            }

            void setAccessible(Accessible comp) {
                this.myAccessible = comp;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                this.accessibleContext = this.myAccessible != null ? this.myAccessible.getAccessibleContext() : super.getAccessibleContext();
                return this.accessibleContext;
            }
        }
    }

    private static class MySearchTextField
    extends SearchTextField
    implements DataProvider,
    Disposable {
        MySearchTextField() {
            super(false, "SearchEveryWhereHistory");
            JBTextField editor = this.getTextEditor();
            editor.setOpaque(false);
            editor.putClientProperty("search-everywhere-textfield", true);
            editor.putClientProperty("JTextField.Search.noBorderRing", Boolean.TRUE);
            if (StartupUiUtil.isUnderDarcula()) {
                editor.setBackground((Color)Gray._45);
                editor.setForeground((Color)Gray._240);
            }
        }

        protected void showPopup() {
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MySearchTextField.$$$reportNull$$$0(0);
            }
            if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
                return this.getTextEditor().getText();
            }
            return null;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/actions/SearchEverywhereAction$MySearchTextField", "getData"));
        }
    }

    static class SEOption
    extends BooleanOptionDescription {
        private final String myKey;

        SEOption(String option2, String registryKey) {
            super(option2, null);
            this.myKey = registryKey;
        }

        public boolean isOptionEnabled() {
            return Registry.is((String)this.myKey);
        }

        public void setOptionState(boolean enabled) {
            Registry.get((String)this.myKey).setValue(enabled);
        }
    }

    private static class Holder {
        private static final Border RENDERER_BORDER = JBUI.Borders.empty((int)1, (int)0);
        private static final Border RENDERER_TITLE_BORDER = JBUI.Borders.emptyTop((int)3);
        private static final AtomicBoolean ourShiftIsPressed = new AtomicBoolean(false);
        private static final AtomicBoolean showAll = new AtomicBoolean(false);

        private Holder() {
        }
    }
}

