/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.pathMacros;

import com.intellij.DynamicBundle;
import com.intellij.application.options.pathMacros.PathMacroTable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class PathMacroListEditor {
    JPanel myPanel;
    private JTextField myIgnoredVariables;
    private JPanel myPathVariablesPanel;
    private final PathMacroTable myPathMacroTable;

    public PathMacroListEditor() {
        this(null);
    }

    public PathMacroListEditor(Collection<String> undefinedMacroNames) {
        this.$$$setupUI$$$();
        this.myPathMacroTable = undefinedMacroNames != null ? new PathMacroTable(undefinedMacroNames) : new PathMacroTable();
        this.myPathVariablesPanel.add((Component)ToolbarDecorator.createDecorator((JTable)((Object)this.myPathMacroTable)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                PathMacroListEditor.this.myPathMacroTable.addMacro();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                PathMacroListEditor.this.myPathMacroTable.removeSelectedMacros();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                PathMacroListEditor.this.myPathMacroTable.editMacro();
            }
        }).disableUpDownActions().createPanel(), "Center");
        this.fillIgnoredVariables();
    }

    private void fillIgnoredVariables() {
        Collection ignored = PathMacros.getInstance().getIgnoredMacroNames();
        this.myIgnoredVariables.setText(StringUtil.join((Collection)ignored, (String)";"));
    }

    private boolean isIgnoredModified() {
        Collection ignored = PathMacros.getInstance().getIgnoredMacroNames();
        return !this.parseIgnoredVariables().equals(ignored);
    }

    private Collection<String> parseIgnoredVariables() {
        String s = this.myIgnoredVariables.getText();
        ArrayList<String> ignored = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreElements()) {
            ignored.add(st.nextElement().trim());
        }
        return ignored;
    }

    public void commit() throws ConfigurationException {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myPathMacroTable.commit();
            Collection<String> ignored = this.parseIgnoredVariables();
            PathMacros instance = PathMacros.getInstance();
            instance.setIgnoredMacroNames(ignored);
        });
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public void reset() {
        this.myPathMacroTable.reset();
        this.fillIgnoredVariables();
    }

    public boolean isModified() {
        return this.myPathMacroTable.isModified() || this.isIgnoredModified();
    }

    private void createUIComponents() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPathVariablesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", PathMacroListEditor.class).getString("path.macro.ignored.variables"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIgnoredVariables = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", PathMacroListEditor.class).getString("path.macro.use.semicolon"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 9, 0, 0, 0, null, null, null, 1));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

