/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.Disposable;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingErrorHandler;
import org.jetbrains.plugins.github.ui.HtmlInfoPanel;
import org.jetbrains.plugins.github.util.GithubUIUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u000b\b \u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u00015B\u001f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0007H&J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0018\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020&H\u0016J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\tH\u0014J\b\u0010/\u001a\u00020\tH\u0002J\b\u00100\u001a\u00020&H\u0002J\u0010\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\tH&J\b\u00103\u001a\u00020&H\u0002J\b\u00104\u001a\u00020&H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0005\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/plugins/github/ui/GHListLoaderPanel;", "L", "Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "listLoader", "contentComponent", "Ljavax/swing/JComponent;", "loadAllAfterFirstScroll", "", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;Ljavax/swing/JComponent;Z)V", "errorHandler", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;", "getErrorHandler", "()Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;", "setErrorHandler", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;)V", "infoPanel", "Lorg/jetbrains/plugins/github/ui/HtmlInfoPanel;", "getInfoPanel", "()Lorg/jetbrains/plugins/github/ui/HtmlInfoPanel;", "getListLoader", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "loadingText", "", "getLoadingText", "()Ljava/lang/String;", "scrollPane", "Ljavax/swing/JScrollPane;", "Lorg/jetbrains/annotations/NotNull;", "getScrollPane", "()Ljavax/swing/JScrollPane;", "userScrolled", "createCenterPanel", "Ljavax/swing/JPanel;", "content", "displayEmptyStatus", "", "emptyText", "Lcom/intellij/util/ui/StatusText;", "displayErrorStatus", "error", "", "dispose", "getErrorPrefix", "listEmpty", "isScrollAtThreshold", "potentiallyLoadMore", "setLoading", "isLoading", "updateEmptyText", "updateInfoPanel", "Companion", "intellij.vcs.github"})
public abstract class GHListLoaderPanel<L extends GHListLoader>
extends BorderLayoutPanel
implements Disposable {
    private boolean userScrolled;
    @NotNull
    private final JScrollPane scrollPane;
    @NotNull
    private final HtmlInfoPanel infoPanel;
    @Nullable
    private GHLoadingErrorHandler errorHandler;
    @NotNull
    private final L listLoader;
    private final JComponent contentComponent;
    private final boolean loadAllAfterFirstScroll;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @NotNull
    protected final HtmlInfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    @NotNull
    protected String getLoadingText() {
        return "Loading...";
    }

    @Nullable
    public final GHLoadingErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(@Nullable GHLoadingErrorHandler gHLoadingErrorHandler) {
        this.errorHandler = gHLoadingErrorHandler;
    }

    @NotNull
    public abstract JPanel createCenterPanel(@NotNull JComponent var1);

    public abstract void setLoading(boolean var1);

    private final void updateEmptyText() {
        ComponentWithEmptyText componentWithEmptyText;
        JComponent jComponent = this.contentComponent;
        if (!(jComponent instanceof ComponentWithEmptyText)) {
            jComponent = null;
        }
        if ((componentWithEmptyText = (ComponentWithEmptyText)jComponent) == null || (componentWithEmptyText = componentWithEmptyText.getEmptyText()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)componentWithEmptyText, (String)"(contentComponent as? Co\u2026ext)?.emptyText ?: return");
        ComponentWithEmptyText emptyText2 = componentWithEmptyText;
        emptyText2.clear();
        if (this.listLoader.getLoading()) {
            emptyText2.setText(this.getLoadingText());
        } else {
            Throwable error = this.listLoader.getError();
            if (error != null) {
                this.displayErrorStatus((StatusText)emptyText2, error);
            } else {
                this.displayEmptyStatus((StatusText)emptyText2);
            }
        }
    }

    private final void displayErrorStatus(StatusText emptyText2, Throwable error) {
        block0: {
            emptyText2.appendText(this.getErrorPrefix(!this.listLoader.getHasLoadedItems()), SimpleTextAttributes.ERROR_ATTRIBUTES).appendSecondaryText(org.jetbrains.plugins.github.ui.GHListLoaderPanel$Companion.getLoadingErrorText$default(Companion, error, null, 2, null), SimpleTextAttributes.ERROR_ATTRIBUTES, null);
            Object object = this.errorHandler;
            if (object == null || (object = object.getActionForError(error)) == null) break block0;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            emptyText2.appendSecondaryText(' ' + GithubUIUtilKt.getName((Action)it), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, (ActionListener)it);
        }
    }

    protected void displayEmptyStatus(@NotNull StatusText emptyText2) {
        Intrinsics.checkParameterIsNotNull((Object)emptyText2, (String)"emptyText");
        emptyText2.setText("List is empty ");
        emptyText2.appendSecondaryText("Refresh", SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, new ActionListener(this){
            final /* synthetic */ GHListLoaderPanel this$0;

            public final void actionPerformed(ActionEvent it) {
                this.this$0.getListLoader().reset();
            }
            {
                this.this$0 = gHListLoaderPanel;
            }
        });
    }

    protected void updateInfoPanel() {
        Throwable error = this.listLoader.getError();
        if (error != null && this.listLoader.getHasLoadedItems()) {
            Action action2;
            String errorPrefix = this.getErrorPrefix(!this.listLoader.getHasLoadedItems());
            String errorText = GHListLoaderPanel.Companion.getLoadingErrorText(error, "<br/>");
            GHLoadingErrorHandler gHLoadingErrorHandler = this.errorHandler;
            Action action3 = action2 = gHLoadingErrorHandler != null ? gHLoadingErrorHandler.getActionForError(error) : null;
            if (action2 != null) {
                this.infoPanel.setInfo("<html><body>" + errorPrefix + "<br/>" + errorText + "<a href=''>&nbsp;" + GithubUIUtilKt.getName(action2) + "</a></body></html>", HtmlInfoPanel.Severity.ERROR, (Function1<? super HyperlinkEvent, Unit>)((Function1)new Function1<HyperlinkEvent, Unit>(this, action2){
                    final /* synthetic */ GHListLoaderPanel this$0;
                    final /* synthetic */ Action $action;

                    public final void invoke(@NotNull HyperlinkEvent it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$action.actionPerformed(new ActionEvent((Object)((Object)this.this$0.getInfoPanel()), 1001, it.getEventType().toString()));
                    }
                    {
                        this.this$0 = gHListLoaderPanel;
                        this.$action = action2;
                        super(1);
                    }
                }));
            } else {
                HtmlInfoPanel.setInfo$default(this.infoPanel, "<html><body>" + errorPrefix + "<br/>" + errorText + "</body></html>", HtmlInfoPanel.Severity.ERROR, null, 4, null);
            }
        } else {
            HtmlInfoPanel.setInfo$default(this.infoPanel, null, null, null, 6, null);
        }
    }

    @NotNull
    protected String getErrorPrefix(boolean listEmpty) {
        return listEmpty ? "Can't load list" : "Can't load full list";
    }

    private final void potentiallyLoadMore() {
        if (this.listLoader.canLoadMore() && (this.userScrolled && this.loadAllAfterFirstScroll || this.isScrollAtThreshold())) {
            GHListLoader.DefaultImpls.loadMore$default(this.listLoader, false, 1, null);
        }
    }

    private final boolean isScrollAtThreshold() {
        JScrollBar verticalScrollBar;
        JScrollBar jScrollBar = verticalScrollBar = this.scrollPane.getVerticalScrollBar();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"verticalScrollBar");
        int visibleAmount = jScrollBar.getVisibleAmount();
        int value = verticalScrollBar.getValue();
        int maximum = verticalScrollBar.getMaximum();
        if (maximum == 0) {
            return false;
        }
        float scrollFraction = (float)(visibleAmount + value) / (float)maximum;
        return !((double)scrollFraction < 0.5);
    }

    public void dispose() {
    }

    @NotNull
    protected final L getListLoader() {
        return this.listLoader;
    }

    public GHListLoaderPanel(@NotNull L listLoader, @NotNull JComponent contentComponent, boolean loadAllAfterFirstScroll) {
        JScrollPane jScrollPane;
        Intrinsics.checkParameterIsNotNull(listLoader, (String)"listLoader");
        Intrinsics.checkParameterIsNotNull((Object)contentComponent, (String)"contentComponent");
        this.listLoader = listLoader;
        this.contentComponent = contentComponent;
        this.loadAllAfterFirstScroll = loadAllAfterFirstScroll;
        JScrollPane jScrollPane2 = ScrollPaneFactory.createScrollPane((Component)this.contentComponent, (int)20, (int)31);
        GHListLoaderPanel gHListLoaderPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        JScrollPane $this$apply = jScrollPane2;
        boolean bl3 = false;
        $this$apply.setOpaque(false);
        JViewport jViewport = $this$apply.getViewport();
        Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"viewport");
        jViewport.setOpaque(false);
        $this$apply.setBorder((Border)JBUI.Borders.empty());
        JScrollBar jScrollBar = $this$apply.getVerticalScrollBar();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"verticalScrollBar");
        jScrollBar.getModel().addChangeListener(new ChangeListener(this){
            final /* synthetic */ GHListLoaderPanel this$0;
            {
                this.this$0 = gHListLoaderPanel;
            }

            public final void stateChanged(ChangeEvent it) {
                GHListLoaderPanel.access$potentiallyLoadMore(this.this$0);
            }
        });
        JScrollBar jScrollBar2 = $this$apply.getVerticalScrollBar();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar2, (String)"verticalScrollBar");
        jScrollBar2.getModel().addChangeListener(new ChangeListener($this$apply, this){
            final /* synthetic */ JScrollPane $this_apply;
            final /* synthetic */ GHListLoaderPanel this$0;
            {
                this.$this_apply = jScrollPane;
                this.this$0 = gHListLoaderPanel;
            }

            public final void stateChanged(ChangeEvent it) {
                if (!GHListLoaderPanel.access$getUserScrolled$p(this.this$0)) {
                    JScrollBar jScrollBar = this.$this_apply.getVerticalScrollBar();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"verticalScrollBar");
                    if (jScrollBar.getValue() > 0) {
                        GHListLoaderPanel.access$setUserScrolled$p(this.this$0, true);
                    }
                }
            }
        });
        Object object = jScrollPane2;
        JScrollPane jScrollPane3 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane3, (String)"ScrollPaneFactory.create\u2026userScrolled = true }\n  }");
        gHListLoaderPanel.scrollPane = jScrollPane3;
        this.infoPanel = new HtmlInfoPanel();
        jScrollPane2 = JBUI.Panels.simplePanel((Component)this.scrollPane).addToTop((Component)((Object)this.infoPanel));
        object = this;
        gHListLoaderPanel = this;
        bl = false;
        bl2 = false;
        $this$apply = jScrollPane2;
        boolean bl4 = false;
        $this$apply.setOpaque(false);
        JScrollPane jScrollPane4 = jScrollPane = jScrollPane2;
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane4, (String)"simplePanel(scrollPane).\u2026   isOpaque = false\n    }");
        gHListLoaderPanel.addToCenter(((GHListLoaderPanel)((Object)object)).createCenterPanel(jScrollPane4));
        this.listLoader.addLoadingStateChangeListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.setLoading(this.getListLoader().getLoading());
                this.updateEmptyText();
            }
        }));
        this.listLoader.addErrorChangeListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateInfoPanel();
                this.updateEmptyText();
            }
        }));
        this.setLoading(this.listLoader.getLoading());
        this.updateInfoPanel();
        this.updateEmptyText();
    }

    public /* synthetic */ GHListLoaderPanel(GHListLoader gHListLoader, JComponent jComponent, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(gHListLoader, jComponent, bl);
    }

    public static final /* synthetic */ void access$potentiallyLoadMore(GHListLoaderPanel $this) {
        $this.potentiallyLoadMore();
    }

    public static final /* synthetic */ boolean access$getUserScrolled$p(GHListLoaderPanel $this) {
        return $this.userScrolled;
    }

    public static final /* synthetic */ void access$setUserScrolled$p(GHListLoaderPanel $this, boolean bl) {
        $this.userScrolled = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u001a\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/ui/GHListLoaderPanel$Companion;", "", "()V", "addDotIfNeeded", "", "line", "getLoadingErrorText", "error", "", "newLineSeparator", "intellij.vcs.github"})
    public static final class Companion {
        private final String getLoadingErrorText(Throwable error, String newLineSeparator) {
            String string;
            block9: {
                block8: {
                    if (error instanceof GithubStatusCodeException && ((GithubStatusCodeException)error).getError() != null) {
                        GithubErrorMessage githubErrorMessage = ((GithubStatusCodeException)error).getError();
                        if (githubErrorMessage == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)githubErrorMessage, (String)"error.error!!");
                        GithubErrorMessage githubError = githubErrorMessage;
                        StringBuilder builder = new StringBuilder(githubError.getMessage());
                        List<GithubErrorMessage.Error> list2 = githubError.getErrors();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"githubError.errors");
                        Collection collection = list2;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            builder.append(": ").append(newLineSeparator);
                            Iterator<GithubErrorMessage.Error> iterator = githubError.getErrors().iterator();
                            while (iterator.hasNext()) {
                                GithubErrorMessage.Error e;
                                GithubErrorMessage.Error error2 = e = iterator.next();
                                Intrinsics.checkExpressionValueIsNotNull((Object)error2, (String)"e");
                                String string2 = error2.getMessage();
                                if (string2 == null) {
                                    string2 = e.getCode() + " error in " + e.getResource() + " field " + e.getField();
                                }
                                builder.append(string2).append(newLineSeparator);
                            }
                        }
                        String string3 = builder.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"builder.toString()");
                        return string3;
                    }
                    string = error.getMessage();
                    if (string == null) break block8;
                    String string4 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string4;
                    boolean bl3 = false;
                    string = Companion.addDotIfNeeded(it);
                    if (string != null) break block9;
                }
                string = "Unknown loading error.";
            }
            return string;
        }

        static /* synthetic */ String getLoadingErrorText$default(Companion companion, Throwable throwable, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "\n";
            }
            return companion.getLoadingErrorText(throwable, string);
        }

        private final String addDotIfNeeded(String line) {
            return StringsKt.endsWith$default((CharSequence)line, (char)'.', (boolean)false, (int)2, null) ? line : line + '.';
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

