/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlIntroduceHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfoKt;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0014J\u0016\u0010\"\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "()V", "parenthesizeEmptyParameterList", "", "getParenthesizeEmptyParameterList", "()Z", "returnTypeKeyword", "", "getReturnTypeKeyword", "()Ljava/lang/String;", "addRoutine", "Lcom/intellij/sql/psi/SqlRoutineDefinition;", "declaration", "anchor", "Lcom/intellij/psi/PsiElement;", "block", "Lcom/intellij/sql/psi/SqlElement;", "findAnchor", "element", "container", "findTopmostBlock", "generateBody", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "functionInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "generateBodyStatement", "generateCall", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "generateParameter", "param", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "generateRoutine", "isPreview", "intellij.database.sql.impl"})
public abstract class SqlExtractFunctionHelper
implements SqlIntroduceHelper {
    @Override
    @Nullable
    public PsiElement findTopmostBlock(@Nullable PsiElement element2) {
        PsiElement psiElement = element2;
        return (PsiElement)(psiElement != null ? psiElement.getContainingFile() : null);
    }

    @Nullable
    public PsiElement findAnchor(@NotNull PsiElement element2, @NotNull PsiElement container) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        return PsiTreeUtil.findPrevParent((PsiElement)container, (PsiElement)element2);
    }

    public boolean getParenthesizeEmptyParameterList() {
        return true;
    }

    @NotNull
    public String getReturnTypeKeyword() {
        return "returns";
    }

    protected void generateParameter(@NotNull DdlBuilder builder, @NotNull SqlExtractableParameterInfo param) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        builder.identifier(param.getName(), ObjectKind.VARIABLE);
        builder.space();
        builder.type(param.getSqlType().getDataType());
    }

    protected final void generateBodyStatement(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)functionInfo, (String)"functionInfo");
        boolean bl = false;
        boolean bl2 = false;
        DdlBuilder $this$with = builder;
        boolean bl3 = false;
        $this$with.keyword("begin");
        $this$with.newLine();
        $this$with.keyword("return ");
        $this$with.plain(functionInfo.getSubstitutedExpression().getText());
        $this$with.symbol(";");
        $this$with.newLine();
        $this$with.keyword("end");
    }

    public void generateBody(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)functionInfo, (String)"functionInfo");
        boolean bl = false;
        boolean bl2 = false;
        DdlBuilder $this$with = builder;
        boolean bl3 = false;
        $this$with.keyword("as ");
        this.generateBodyStatement($this$with, functionInfo);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SqlRoutineDefinition generateRoutine(@NotNull SqlExtractFunctionInfo functionInfo, boolean isPreview) {
        Collection<SqlExtractableParameterInfo> parameters;
        Intrinsics.checkParameterIsNotNull((Object)functionInfo, (String)"functionInfo");
        SqlExtractableCodeInfo codeInfo = functionInfo.getCodeInfo();
        DdlBuilder ddlBuilder = SqlExtractableCodeInfoKt.createBuilder(functionInfo);
        boolean bl = false;
        boolean bl2 = false;
        DdlBuilder $this$apply = ddlBuilder;
        boolean bl3 = false;
        $this$apply.keyword("create function ");
        $this$apply.identifier(functionInfo.getName(), ObjectKind.ROUTINE);
        Collection<SqlExtractableParameterInfo> collection = parameters = functionInfo.getParameters();
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            $this$apply.symbol("(");
            Iterable $this$forEachIndexed$iv = parameters;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void param;
                int n = index$iv++;
                boolean bl5 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)item$iv;
                int i2 = n2;
                boolean bl6 = false;
                if (i2 > 0) {
                    $this$apply.symbol(", ");
                }
                this.generateParameter($this$apply, (SqlExtractableParameterInfo)param);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$apply.symbol(")"), (String)"symbol(\")\")");
        } else if (this.getParenthesizeEmptyParameterList()) {
            $this$apply.symbol("()");
        }
        $this$apply.keyword(' ' + this.getReturnTypeKeyword() + ' ');
        SqlType sqlType = codeInfo.getOriginalExpression().getSqlType();
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlType, (String)"codeInfo.originalExpression.sqlType");
        $this$apply.type(sqlType.getDataType());
        if (!isPreview) {
            $this$apply.space();
            this.generateBody($this$apply, functionInfo);
        }
        DdlBuilder builder = ddlBuilder;
        SqlStatement sqlStatement = SqlPsiElementFactory.createStatementFromText(builder.getStatement(), codeInfo.getDialect(), codeInfo.getProject(), null);
        if (sqlStatement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlRoutineDefinition");
        }
        return (SqlRoutineDefinition)sqlStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SqlFunctionCallExpression generateCall(@NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkParameterIsNotNull((Object)functionInfo, (String)"functionInfo");
        SqlExtractableCodeInfo codeInfo = functionInfo.getCodeInfo();
        DdlBuilder ddlBuilder = SqlExtractableCodeInfoKt.createBuilder(functionInfo);
        boolean bl = false;
        boolean bl2 = false;
        DdlBuilder $this$apply = ddlBuilder;
        boolean bl3 = false;
        $this$apply.configureBuilder(codeInfo.getProject(), codeInfo.getDialect());
        $this$apply.identifier(functionInfo.getName(), ObjectKind.ROUTINE);
        $this$apply.symbol("(");
        Iterable $this$forEachIndexed$iv = functionInfo.getParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)item$iv;
            int i2 = n2;
            boolean bl5 = false;
            if (i2 > 0) {
                $this$apply.symbol(", ");
            }
            $this$apply.plain(param.getOriginalExpression().getText());
        }
        $this$apply.symbol(")");
        DdlBuilder builder = ddlBuilder;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(builder.getStatement(), codeInfo.getDialect(), codeInfo.getProject(), null);
        if (sqlExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlFunctionCallExpression");
        }
        return (SqlFunctionCallExpression)sqlExpression;
    }

    @NotNull
    public final SqlRoutineDefinition addRoutine(@NotNull SqlRoutineDefinition declaration, @Nullable PsiElement anchor, @NotNull SqlElement block) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        PsiElement psiElement = block.addBefore((PsiElement)declaration, anchor);
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.SqlRoutineDefinition");
        }
        SqlRoutineDefinition element2 = (SqlRoutineDefinition)psiElement;
        Project project = block.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"block.project");
        Project project2 = project;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)declaration);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(declaration)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        PsiElement psiElement2 = SqlPsiElementFactory.createLeafFromText(project2, dialect, ";");
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"SqlPsiElementFactory.cre\u2026xt(project, dialect, \";\")");
        PsiElement semi = psiElement2;
        PsiElement psiElement3 = SqlPsiElementFactory.newLine(project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"SqlPsiElementFactory.newLine(project)");
        PsiElement newLine = psiElement3;
        block.addBefore(newLine, (PsiElement)element2);
        block.addAfter(newLine, (PsiElement)element2);
        block.addAfter(newLine, (PsiElement)element2);
        block.addAfter(semi, (PsiElement)element2);
        return element2;
    }
}

