/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.sql.util.NameTemplate;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

class TemplateEditorWithHelp
extends JBTextField {
    private final String myHintText;
    private final NameTemplate myDefaultTemplate;
    private final String myShortcutHelp;

    public TemplateEditorWithHelp(@NotNull NameTemplate defaultTemplate) {
        if (defaultTemplate == null) {
            TemplateEditorWithHelp.$$$reportNull$$$0(0);
        }
        this.myDefaultTemplate = defaultTemplate;
        this.myHintText = TemplateEditorWithHelp.createHint(defaultTemplate);
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc").getShortcuts();
        this.myShortcutHelp = shortcuts.length == 0 ? "" : "\n" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " for help";
        new AnAction("Help"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                TemplateEditorWithHelp.this.showHint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/formatter/settings/TemplateEditorWithHelp$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)((Object)this));
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                TemplateEditorWithHelp.this.updateExample();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/formatter/settings/TemplateEditorWithHelp$2", "textChanged"));
            }
        });
    }

    @NotNull
    private static String createHint(@NotNull NameTemplate template) {
        if (template == null) {
            TemplateEditorWithHelp.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Template can contain:<ul>");
        for (NameTemplate.Placeholder placeholder : template.allowed) {
            sb.append("<li><b>").append(placeholder.text).append("</b> - ").append(placeholder.desc).append(";</li>");
        }
        sb.append("</ul>");
        sb.append("Example: ").append(template.template);
        String string = sb.toString();
        if (string == null) {
            TemplateEditorWithHelp.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void showHint() {
        JBPopupFactory.getInstance().createBalloonBuilder(HintUtil.createInformationLabel((String)this.myHintText)).setFillColor(HintUtil.getInformationColor()).setHideOnClickOutside(true).setHideOnAction(true).setClickHandler(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/formatter/settings/TemplateEditorWithHelp$3", "actionPerformed"));
            }
        }, true).createBalloon().show(RelativePoint.getSouthWestOf((JComponent)((Object)this)), Balloon.Position.below);
    }

    private void updateExample() {
        String tip = "Ex. name: " + NameTemplate.example((String)this.getText(), (NameTemplate.Placeholder[])this.myDefaultTemplate.allowed) + this.myShortcutHelp;
        this.setToolTipText(tip);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTemplate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/TemplateEditorWithHelp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/TemplateEditorWithHelp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createHint";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

