/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public class QuoteIdentifierQuickFix
implements LocalQuickFix {
    private final SqlLanguageDialect myDialect;

    public QuoteIdentifierQuickFix(SqlLanguageDialect dialect) {
        this.myDialect = dialect;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("quickfix.name.quote.identifier", new Object[0]);
        if (string == null) {
            QuoteIdentifierQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element2;
        if (project == null) {
            QuoteIdentifierQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            QuoteIdentifierQuickFix.$$$reportNull$$$0(2);
        }
        if (!((element2 = descriptor.getPsiElement()) instanceof SqlIdentifier)) {
            return;
        }
        SqlImplUtil.quoteIdentifier(project, (SqlIdentifier)element2, this.myDialect);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/QuoteIdentifierQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/QuoteIdentifierQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

