/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriverManagerImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCommonTestUtils {
    private static final PluginDescriptor ourDescriptor = new DefaultPluginDescriptor(PluginId.getId((String)"database.tests"), SqlCommonTestUtils.class.getClassLoader());

    @NotNull
    public static JBIterable<DbmsExtension.Bean<SqlLanguageDialect>> loadSqlDialectBeans() {
        return SqlCommonTestUtils.loadDbmsExtensionBeans(SqlLanguageDialect.EP);
    }

    @NotNull
    public static JBIterable<DbmsExtension.Bean<DatabaseDialect>> loadDatabaseDialectBeans() {
        return SqlCommonTestUtils.loadDbmsExtensionBeans(DatabaseDialect.EP);
    }

    @NotNull
    public static <T> JBIterable<DbmsExtension.Bean<T>> loadDbmsExtensionBeans(@NotNull DbmsExtension<T> ep) {
        if (ep == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(0);
        }
        String epName = ep.getName();
        boolean isInstance = ep == SqlLanguageDialect.EP;
        boolean isSql = epName.contains(".sql.") || ep == DatabaseDialect.EP;
        Class clazz = isInstance ? DbmsExtension.InstanceBean.class : DbmsExtension.Bean.class;
        return SqlCommonTestUtils.loadBeans(epName, clazz, isSql);
    }

    @NotNull
    public static List<URL> loadConfigUrls(@NotNull ExtensionPointName<DatabaseDriverManagerImpl.ConfigUrlBean> ep) {
        if (ep == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(1);
        }
        List<URL> list = DatabaseDriverManagerImpl.ConfigUrlBean.getUrls(SqlCommonTestUtils.loadConfigUrlBeans(ep));
        if (list == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<DatabaseDriverManagerImpl.ConfigUrlBean> loadConfigUrlBeans(@NotNull ExtensionPointName<DatabaseDriverManagerImpl.ConfigUrlBean> ep) {
        if (ep == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(3);
        }
        List list = SqlCommonTestUtils.loadBeans(ep.getName(), DatabaseDriverManagerImpl.ConfigUrlBean.class, false).toList();
        if (list == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(4);
        }
        return list;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static <T extends AbstractExtensionPointBean> JBIterable<T> loadBeans(String epName, Class<? extends T> clazz, boolean isSql) {
        class MyOrderable
        implements LoadingOrder.Orderable {
            final T bean;
            final String orderId;
            final LoadingOrder order;
            final /* synthetic */ Class val$clazz;

            MyOrderable(Element element2) {
                this.val$clazz = element2;
                this.bean = (AbstractExtensionPointBean)XmlSerializer.deserialize((Element)e, (Class)this.val$clazz);
                this.bean.setPluginDescriptor(ourDescriptor);
                this.orderId = e.getAttributeValue("id");
                this.order = LoadingOrder.readOrder((String)e.getAttributeValue("order"));
            }

            @Nullable
            public String getOrderId() {
                return this.orderId;
            }

            public LoadingOrder getOrder() {
                return this.order;
            }
        }
        String shortName = StringUtil.getShortName((String)epName);
        String descriptorPath = isSql ? "/META-INF/SqlDialects.xml" : "/META-INF/DatabaseDialects.xml";
        URL xml = DbmsExtension.class.getClassLoader().getResource(descriptorPath);
        if (xml == null) {
            throw new AssertionError((Object)("descriptor not found: " + descriptorPath));
        }
        InputStream stream = xml.openStream();
        Throwable throwable = null;
        List list = (List)JBIterable.from((Iterable)JDOMXIncluder.resolve((Element)JDOMUtil.load((InputStream)stream), (URL)xml)).flatten(e -> e.getChildren("extensions")).flatten(e -> e.getChildren()).filter(e -> e.getName().endsWith(shortName)).filter(e -> epName.equals(StringUtil.getQualifiedName((String)e.getParentElement().getAttributeValue("defaultExtensionNs"), (String)e.getName()))).map(x$0 -> new MyOrderable(x$0, clazz)).addAllTo(new ArrayList());
        LoadingOrder.sort((List)list);
        JBIterable result = JBIterable.from((Iterable)list).map(o -> o.bean).collect();
        if (result.isEmpty()) {
            throw new AssertionError((Object)(epName + " is empty in " + descriptorPath));
        }
        JBIterable jBIterable = result;
        JBIterable jBIterable2 = jBIterable;
        if (jBIterable2 == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(5);
        }
        return jBIterable2;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            {
                catch (Exception e2) {
                    throw new AssertionError("Failed to load '" + epName + "' list", e2);
                }
            }
        }
    }

    @NotNull
    public static <T> T getDialectClass(@NotNull String dialectClass, @NotNull String suffix) {
        Object object;
        if (dialectClass == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(6);
        }
        if (suffix == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(7);
        }
        String path = dialectClass.replace("Dialect", suffix);
        try {
            object = ReflectionUtil.newInstance(Class.forName(path));
        }
        catch (ClassNotFoundException e) {
            Object object2;
            String basePath = SqlCommonTestUtils.getBaseDialectClass(path);
            if (basePath == null) {
                throw new AssertionError((Object)e);
            }
            try {
                object2 = ReflectionUtil.newInstance(Class.forName(basePath));
            }
            catch (ClassNotFoundException e2) {
                throw new AssertionError((Object)e2);
            }
            if (object2 == null) {
                SqlCommonTestUtils.$$$reportNull$$$0(9);
            }
            return (T)object2;
        }
        if (object == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(8);
        }
        return (T)object;
    }

    private static String getBaseDialectClass(String path) {
        if (path.contains(".mysql.Mysql")) {
            return path.replace(".mysql.Mysql", ".mysqlbase.MysqlBase");
        }
        if (path.contains(".maria.Maria")) {
            return path.replace(".maria.Maria", ".mysqlbase.MysqlBase");
        }
        if (path.contains(".db2.Db2LUW")) {
            return path.replace(".db2.Db2LUW", ".db2.Db2Base");
        }
        if (path.contains(".db2.Db2")) {
            return path.replace(".db2.Db2", ".db2.Db2Base");
        }
        return null;
    }

    public static Map<BasicElement, SmartPsiElementPointer<SqlElement>> fillModelOnPooledThread(@NotNull Project project, DasModel model, boolean saveSources, boolean useReadOnlyPsi, String ... texts) {
        if (project == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(10);
        }
        if (texts == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(11);
        }
        Ref res2 = Ref.create();
        DbUIUtil.invokeOnPooledThreadSync(() -> DbImplUtil.performSrcOperation(project, model, ModalityState.NON_MODAL, false, () -> ReadAction.run(() -> res2.set(SqlCommonTestUtils.fillModel(project, (BasicModModel)model, saveSources, useReadOnlyPsi, texts)))));
        return (Map)res2.get();
    }

    private static Map<BasicElement, SmartPsiElementPointer<SqlElement>> fillModel(@NotNull Project project, @NotNull BasicModModel model, boolean saveSources, boolean useReadOnlyPsi, String ... texts) {
        PsiErrorElement error2;
        if (project == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(12);
        }
        if (model == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(13);
        }
        if (texts == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(14);
        }
        SqlLanguageDialect sqlDialect = DbSqlUtil.getSqlDialect(model.getDbms());
        List files = JBIterable.of((Object[])texts).map(text2 -> useReadOnlyPsi ? SqlPsiFacade.getInstance((Project)project).createROFile(sqlDialect, (CharSequence)text2) : (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)sqlDialect, (CharSequence)text2)).toList();
        if (!useReadOnlyPsi && (error2 = (PsiErrorElement)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)files)).filter(PsiErrorElement.class).first()) != null) {
            throw new AssertionError((Object)(error2.getContainingFile().getName() + ": " + error2.getErrorDescription()));
        }
        SqlModelBuilder builder = new SqlModelBuilder(project, model, new HashMap<BasicElement, SmartPsiElementPointer<SqlElement>>());
        builder.begin(saveSources);
        builder.introspect(files, 0, true, -1L);
        builder.end();
        return builder.getMapping();
    }

    @NotNull
    public static LocalDataSource createDataSourceFromSql(@NotNull Project project, @NotNull Dbms dbms, boolean saveSources, String ... texts) {
        if (project == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(15);
        }
        if (dbms == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(16);
        }
        if (texts == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(17);
        }
        LocalDataSource dataSource2 = LocalDataSource.create("test-data-source", null, null, null);
        dataSource2.setDatabaseDriver(DbImplUtil.guessDatabaseDriver(dbms));
        if (dataSource2.getDatabaseDriver() == null) {
            throw new AssertionError((Object)("driver not found for " + dbms.getName()));
        }
        dataSource2.setModel(DbSrcModelStorage.createFactory(project, dataSource2).createModel(dataSource2.getDbms()));
        DataSourceStorage.getStorage().addDataSource(dataSource2);
        SqlCommonTestUtils.fillModelOnPooledThread(project, dataSource2.getModel(), saveSources, true, texts);
        SqlCommonTestUtils.updateScopeFromModel(dataSource2);
        if (saveSources) {
            DbSrcStorageManager.getInstance(project).getStorage(dataSource2.getUniqueId(), true).flushToFs(true);
        }
        LocalDataSource localDataSource = dataSource2;
        if (localDataSource == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(18);
        }
        return localDataSource;
    }

    public static void updateScopeFromModel(LocalDataSource dataSource2) {
        dataSource2.setIntrospectionScope(TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(((BasicModel)dataSource2.getModel()).getRoot().getAllSchemas()).map(s -> TreePatternUtils.create(ObjectPaths.of(s)))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ep";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlCommonTestUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlCommonTestUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfigUrls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfigUrlBeans";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBeans";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectClass";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceFromSql";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDbmsExtensionBeans";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadConfigUrls";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadConfigUrlBeans";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDialectClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillModelOnPooledThread";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillModel";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceFromSql";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

