/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseObjectRefEditor;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableRefEditor {
    private final DeModel myModel;
    private final DeObject myContextNamespace;
    @Nullable
    private final BasicModel myTargetModel;
    private final DatabaseObjectRefEditor<BasicTable> myDelegate;
    private DeTable myStubCache;

    public DatabaseTableRefEditor(@NotNull DeModel model, @Nullable DeObject contextNamespace, @NotNull DatabaseEditorContext context) {
        if (model == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myContextNamespace = contextNamespace;
        this.myTargetModel = context.getModel();
        this.myDelegate = new DatabaseObjectRefEditor<BasicTable>(context){

            @Override
            protected Icon getIcon(@NotNull BasicTable item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                return DatabaseIcons.Table;
            }

            @Override
            protected boolean allowQualification() {
                return true;
            }

            @Override
            @NotNull
            public List<String> getQName(@NotNull BasicTable table) {
                if (table == null) {
                    1.$$$reportNull$$$0(1);
                }
                String sc = DasUtil.getSchema((DasObject)table);
                if (DatabaseTableRefEditor.this.myContextNamespace != null && !DatabaseTableRefEditor.this.myModel.getExportHelper().getContext().getNamingService().unquoteIdentifier(((DatabaseTableRefEditor)DatabaseTableRefEditor.this).myContextNamespace.name).equals(sc)) {
                    List<String> list = Arrays.asList(sc, table.getName());
                    if (list == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                List<String> list = super.getQName(table);
                if (list == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableRefEditor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableRefEditor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getQName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getQName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myDelegate.setItems((JBIterable<BasicTable>)(this.myTargetModel == null ? JBIterable.empty() : this.myTargetModel.traverser().filter(BasicTable.class).filter(DasUtil.byKind((ObjectKind)ObjectKind.TABLE))));
    }

    @NotNull
    public EditorTextField getEditor() {
        EditorTextField editorTextField2 = this.myDelegate.getEditor();
        if (editorTextField2 == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(2);
        }
        return editorTextField2;
    }

    @NotNull
    public String getName() {
        String string = this.myDelegate.getName();
        if (string == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public DeTable getObject() {
        BasicTable res2 = this.myDelegate.getObject();
        if (res2 == null) {
            return null;
        }
        return (DeTable)this.myModel.getExportHelper().exportDeep(this.myTargetModel, res2, true);
    }

    public void setObject(@Nullable DeTable obj) {
        if (obj == null) {
            this.myDelegate.setObject((String)null);
        } else if (this.getObjectOrStub((DeNamespace)ObjectUtils.tryCast((Object)obj.parent, DeNamespace.class)) != obj) {
            if (this.myContextNamespace == null || obj.parent == this.myContextNamespace || obj.parent == null) {
                this.myDelegate.setObject(obj.name);
            } else {
                this.myDelegate.setObject(Arrays.asList(obj.parent.name, obj.name));
            }
        }
    }

    @NotNull
    public DeTable getObjectOrStub(@Nullable DeNamespace parent2) {
        DeTable res2 = this.getObject();
        if (res2 == null) {
            List<String> qname = this.myDelegate.getQName();
            if (this.myStubCache == null || !DatabaseTableRefEditor.matches(this.myStubCache, qname, qname.size() - 1)) {
                this.myStubCache = DatabaseTableRefEditor.createStub(qname, parent2, this.myModel);
            }
            res2 = this.myStubCache;
        }
        DeTable deTable = res2;
        if (deTable == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(4);
        }
        return deTable;
    }

    private static boolean matches(DeObject obj, List<String> qname, int i2) {
        if (i2 < 0) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.name.equals(qname.get(i2))) {
            return false;
        }
        return DatabaseTableRefEditor.matches(obj.getParent(), qname, i2 - 1);
    }

    @NotNull
    public static DeTable createStub(@NotNull List<String> qname, @Nullable DeNamespace parent2, @NotNull DeModel model) {
        if (qname == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(5);
        }
        if (model == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(6);
        }
        parent2 = DatabaseTableRefEditor.getStubParent(qname, parent2, model);
        DeTable deTable = EditorModelUtil.setStub(new DeTable(qname.get(qname.size() - 1), parent2, model));
        if (deTable == null) {
            DatabaseTableRefEditor.$$$reportNull$$$0(7);
        }
        return deTable;
    }

    private static DeNamespace getStubParent(List<String> qname, DeNamespace parent2, DeModel model) {
        if (qname.size() < 2 || parent2 != null && parent2.name.equals(qname.get(qname.size() - 2))) {
            return parent2;
        }
        List<String> sc = qname.subList(0, qname.size() - 1);
        DeNamespace first2 = (DeNamespace)((JBTreeTraverser)model.traverser().expand(o -> o instanceof DeNamespace)).filter(DeNamespace.class).filter(n -> DatabaseTableRefEditor.matches(n, sc, sc.size() - 1)).first();
        return first2 == null ? EditorModelUtil.setStub(new DeNamespace(qname.get(qname.size() - 1), ObjectKind.SCHEMA, model)) : first2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableRefEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableRefEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectOrStub";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

