/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatabaseModifier {
    private final LocalDataSource myDataSource;
    private final DatabaseDepartment myDepartment;
    private final LoaderContext myContext;
    private final String myTitle;
    private final SearchPath mySearchPath;
    private final ErrorHandler myErrorHandler;

    protected AbstractDatabaseModifier(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull DatabaseDepartment department, @NotNull String title) {
        if (project == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(1);
        }
        if (department == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(2);
        }
        if (title == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(3);
        }
        this.myErrorHandler = new ErrorHandler();
        this.myDepartment = department;
        this.mySearchPath = searchPath;
        this.myTitle = title;
        this.myDataSource = dataSource2;
        this.myContext = new LoaderContext(project, this.myDataSource);
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myDataSource;
        if (localDataSource == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(4);
        }
        return localDataSource;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myContext.getProject();
        if (project == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public LoaderContext getContext() {
        LoaderContext loaderContext = this.myContext;
        if (loaderContext == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(6);
        }
        return loaderContext;
    }

    @NotNull
    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = this.myErrorHandler;
        if (errorHandler == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(7);
        }
        return errorHandler;
    }

    protected AsyncTask<Boolean> checkOutdated(@NotNull Iterable<BasicElement> toCheck) {
        JBIterable objects2;
        if (toCheck == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(8);
        }
        if ((objects2 = ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoots(toCheck)).expand(o -> !(o instanceof BasicNamespace))).filter(BasicElement.class).filter(o -> DBIntrospectorFactory.isOutdatedCheckSupported(this.myDataSource.getDbms(), this.myDataSource.useLegacyIntrospector(), o))).isEmpty()) {
            return AsyncTask.completed(false);
        }
        if (objects2.find(o -> o.isOutdated()) != null) {
            return AsyncTask.completed(true);
        }
        LoaderContext context = new LoaderContext(this.getProject(), this.myDataSource);
        context.setOutdatedCheck(true);
        objects2.forEach(context::include);
        return DataSourceUiUtil.performManualSyncTask(context).apply(null, x -> objects2.find(o -> o.isOutdated()) != null);
    }

    @NotNull
    public AsyncTask<?> runStatements(boolean nonModalSync) {
        if (!this.myDataSource.shouldCheckOutdated()) {
            AsyncTask<?> asyncTask = this.runStatementsInner(nonModalSync);
            if (asyncTask == null) {
                AbstractDatabaseModifier.$$$reportNull$$$0(9);
            }
            return asyncTask;
        }
        AsyncTask asyncTask = this.checkOutdated((Iterable<BasicElement>)JBIterable.from(this.myContext.getSelection()).filter(BasicElement.class)).applyAsync(AsyncUtil.getEdtExecutor(), outdated -> {
            if (outdated.booleanValue()) {
                int idx = Messages.showIdeaMessageDialog((Project)this.getProject(), (String)DatabaseBundle.message((String)"changed.in.database", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"changed.in.database.title", (Object[])new Object[0]), (String[])new String[]{DatabaseBundle.message((String)"changed.in.database.force", (Object[])new Object[0]), DatabaseBundle.message((String)"changed.in.database.synchronize", (Object[])new Object[0]), CommonBundle.getCancelButtonText()}, (int)1, (Icon)Messages.getWarningIcon(), null);
                if (idx == -1 || idx == 2) {
                    throw new ProcessCanceledException();
                }
                if (idx == 1) {
                    ApplicationManager.getApplication().invokeLater(() -> this.runSync(), ModalityState.NON_MODAL);
                    throw new ProcessCanceledException();
                }
            }
            return this.runStatementsInner(nonModalSync);
        });
        if (asyncTask == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(10);
        }
        return asyncTask;
    }

    @NotNull
    protected AsyncTask<?> runStatementsInner(boolean nonModalSync) {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator == null || !indicator.isRunning()) {
            AsyncTask asyncTask = AsyncTask.withBgIndicatorIfNeeded(AsyncTask.frame(this.myTitle), this.getProject(), null).computeAsync(null, () -> this.runStatementsInner(nonModalSync, ProgressIndicatorProvider.getGlobalProgressIndicator()));
            if (asyncTask == null) {
                AbstractDatabaseModifier.$$$reportNull$$$0(11);
            }
            return asyncTask;
        }
        AsyncTask<?> asyncTask = this.runStatementsInner(nonModalSync, indicator);
        if (asyncTask == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(12);
        }
        return asyncTask;
    }

    @NotNull
    protected AsyncTask<?> runStatementsInner(boolean nonModalSync, ProgressIndicator indicator) {
        Project project = this.getProject();
        DatabaseSessionManager.Facade facade = DatabaseSessionManager.facade(project, this.myDataSource, null, this.mySearchPath, this.myErrorHandler, this.myDepartment);
        AsyncTask<Object> requests = this.scheduleRequests(indicator, facade);
        if (!this.myContext.loadNothing()) {
            requests = requests.handle().applyAsync(AsyncUtil.getEdtExecutor(), p2 -> {
                AsyncTask<Object> res2 = AsyncTask.completed(p2.first, (Throwable)p2.second);
                if (nonModalSync) {
                    ApplicationManager.getApplication().invokeLater(() -> this.runSync(), ModalityState.NON_MODAL);
                    return res2;
                }
                assert (ProgressIndicatorProvider.getGlobalProgressIndicator() == indicator);
                return this.runSync().apply(null, result -> res2);
            });
        }
        AsyncTask asyncTask = requests.handle().apply(AsyncUtil.getEdtExecutor(), p2 -> {
            if (!this.myErrorHandler.getSummary().isEmpty()) {
                DataSourceUiUtil.showNotification(project, "", this.myErrorHandler.getSummary(), true);
            }
            if (p2.second != null || this.myErrorHandler.hasErrors()) {
                throw new ProcessCanceledException();
            }
            return p2.first;
        });
        if (asyncTask == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(13);
        }
        return asyncTask;
    }

    @NotNull
    public AsyncTask<?> scheduleRequests(@NotNull ProgressIndicator indicator, @NotNull DatabaseSessionManager.Facade facade) {
        if (indicator == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(14);
        }
        if (facade == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(15);
        }
        AsyncTask<?> asyncTask = this.getExecutor().execute(indicator, facade, this.myErrorHandler);
        if (asyncTask == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(16);
        }
        return asyncTask;
    }

    public AsyncTask<DataSourceSyncManager.SyncResult> runSync() {
        Project project = this.getProject();
        return DataSourceUiUtil.performManualSyncTask(this.myContext).whenComplete(AsyncUtil.getEdtExecutor(), (r, e) -> {
            DatabaseView view2 = DatabaseView.getDatabaseView(project);
            view2.selectElement(this.getElement());
        });
    }

    @Nullable
    private DbElement getElement() {
        ObjectPath info = AbstractDatabaseModifier.getObjectToFocus(this.myContext.getElementToFocus());
        if (info == null) {
            return null;
        }
        DbDataSource dbDataSource = DbSqlUtil.getDbDataSource(this.getProject(), this.myDataSource);
        return dbDataSource == null ? null : DbSqlUtil.findElement(dbDataSource, info);
    }

    @Nullable
    private static ObjectPath getObjectToFocus(@Nullable ObjectPath object) {
        if (object == null) {
            return null;
        }
        ObjectKind pKind = object.parent == null ? null : object.parent.kind;
        return DbImplUtil.isDataTable(pKind) ? object.parent : object;
    }

    @NotNull
    protected abstract QueryExecutor getExecutor();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/AbstractDatabaseModifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/AbstractDatabaseModifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "runStatements";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "runStatementsInner";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkOutdated";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRequests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface QueryExecutor {
        public AsyncTask<?> execute(@NotNull ProgressIndicator var1, @NotNull DatabaseSessionManager.Facade var2, @NotNull ErrorHandler var3);
    }
}

